% Copyright (C) 1996  ߷ ƻͺ   ͵

%  original:
%  New merge and pack program for SGLR
%                                Program: Aizawa (Jan.1993)
%
%  Heuristic Version. (with heuristic.pl)
%                                Program: Aizawa (Mar.1993)

mg_pack([],A-A) :- !.
mg_pack([S],[S|Next]-Next) :- !.
mg_pack([[N,A|S]|I],[[N,A|B]|O]-Next) :-
	mkbr(N,A,S,I,Btemp,O1),
	pack2(Btemp,B),
	mg_pack(O1,O-Next).

mkbr( _,_,S, [], [S], [] ):- !.
mkbr( N,A,S, I, [S|B], O ) :-
	mkbr0(N,A,I,B,O).
mkbr0( _,_, [], [], []) :- !.
mkbr0( N,A, [[N,A|B1] |I], [B1|B], O ) :-!,
	mkbr0( N,A, I, B, O ).
mkbr0( N,A, [S1|I], B, [S1|O] ) :-
	mkbr0( N,A, I, B, O ).


pack2([S],S) :- !.

pack2([[ST,[[Cat|Tree]]|Cdr]|R],X) :- !,
	mkcat(ST,Cat,Tree,Cdr,R,NewTree,I,_,_,_,_),
	(
	    I == [],!,
	    X=[ST,[[Cat|NewTree]]|Cdr]
	; 
	    X=Out/[ST,[[Cat|NewTree]]|Cdr],
	    pack2(I,Out)
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% pack_all

% pack2 Τ褦Ƭʬ pack ΤǤϤʤ
% פʬ٤Ƥ pack 롣

pack_all(T,T,T) :- !.
% Ǥ pack 줿ꤷƱΤξϤΤޤ

pack_all([[Cat1,Word]],[[Cat2,Word]],[[Cat1/Cat2,Word]]) :-
% ʻΤ߰ۤʤ
% [[ʻ̾1/ʻ̾2/.../ʻ̾n, ɽ]]
	atom(Word), !,
	(
	    atom(Cat1)
	;
	    Cat1 = _/_
	),
	(
	    atom(Cat2)
	;
	    Cat2 = _/_
	).

pack_all([[Cat1|T1]],[[Cat2|T2]],Tree) :-
% ü椬Ʊϡʬ pack
	(
	    Cat1 == Cat2, !,
	    pack_all(T1,T2,T),
	    Tree = [[Cat1|T]]
	;
	    Tree = [[Cat1|T1]]/[[Cat2|T2]]
	).

pack_all([Word1|Cdr1],[Word2|Cdr2],Tree) :-
% դü椬İʾξϡ줾 pack
	(
	    Word1 == Word2, !,
	    pack_all(Cdr1,Cdr2,Tree2),
	    Tree = [Word1|Tree2]
	;
	    Cdr1 == Cdr2, !,
	    pack_all(Word1,Word2,Tree1),
	    Tree = [Tree1|Cdr1]
	;
	    Tree = [Word1|Cdr1]/[Word2|Cdr2]
	).

pack_all(T1/[[Cat2|T2]],[[Cat3|T3]],Tree) :-
	(
	    Cat2 == Cat3, !,
	    pack_all(T2,T3,T),
	    Tree = T1/[[Cat2|T]]
	;
	    pack_all(T1,[[Cat3|T3]],T),
	    Tree = T/[[Cat2|T2]]
	).
pack_all(T1/[Word1|Cdr1],[Word2|Cdr2],Tree) :-
	(
	    Word1 == Word2, !,
	    pack_all(Cdr1,Cdr2,Tree2),
	    Tree = T1/[Word1|Tree2]
	;
	    Cdr1 == Cdr2, !,
	    pack_all(Word1,Word2,Tree1),
	    Tree = T1/[Tree1|Cdr1]
	;
	    pack_all(T1,[Word2|Cdr2],T),
	    Tree = T/[Word1|Cdr1]
	).
	
pack_all(T1,T2,T) :-
	slash_append(T1,T2,T).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ܤΰϡʬڤκ㥹(ΩǾ)
% ܤΰϡʬڤκ㥹(minimal attachment)
mkcat(_,_,Tree,_,[],Tree,[],S1,S2,L,B) :- !,
	(
	    now_option(j), !, score_of_tree(Tree,S1,S2,H,SH,B),
	    length(H,L1),
	    check_rensetsu(SH,Rensetsu),
	    L is L1-Rensetsu
	;
	    S1 is 0, S2 is 0
	).

mkcat(ST,Cat,Tree,Cdr,[[ST,[[Cat|T]]|C]|R],NewTree,I,NS1,NS2,NL,NB) :-
	Cdr == C,!,
	mkcat(ST,Cat,Tree,Cdr,R,NextTree,I,SS1,SS2,SL,SB),
	(
	    now_option(j), !, score_of_tree(T,S1,S2,H,SH,B),
	    (
		S1 < SS1,!, NewTree = T, NS1 is S1,
		(
		    now_option(depth), !,
		    NS2 is S2
		;
		    true
		),
		length(H,L1),
		check_rensetsu(SH,R1),
		NL is L1-R1,
		NB is B
	    ;
		S1 > SS1,!, NewTree = NextTree, NS1 is SS1,
		(
		    now_option(depth), !,
		    NS2 is SS2
		;
		    true
		),
		NL is SL,
		NB is SB
	    ;
		NS1 is S1, % (S1 = SS1)
		(
		    now_option(depth), !,
		    (
			S2 < SS2, !, NewTree = T, NS2 is S2
		    ;
			S2 > SS2, !, NewTree = NextTree, NS2 is SS2
		    ;
			pack_all(NextTree,T,NewTree), NS2 is S2
		    )
		;
		    now_option(min_morph), !,
		    length(H,L1),
		    check_rensetsu(SH,R1),
		    L2 is L1-R1,
		    (
			L2 < SL, !,
			NewTree = T,
			NL is L2,
			NB is B
		    ;
			L2 > SL, !,
			NewTree = NextTree,
			NL is SL,
			NB is SB
		    ;
			(
			    now_option(min_bunsetsu), !,
			    (
				B < SB, !,
				NewTree = T,
				NL is L2,
				NB is B
			    ;
				B > SB, !,
				NewTree = NextTree,
				NL is SL,
				NB is SB
			    ;
				pack_all(NextTree,T,NewTree),
				NL is SL,
				NB is SB
			    )
			;
			    pack_all(NextTree,T,NewTree),
			    NL is SL,
			    NB is SB
			)
		    )
		;
		    pack_all(NextTree,T,NewTree)
		)
	    )
	;
	    pack_all(NextTree,T,NewTree), NS1 = SS1,
	    (
		now_option(depth), !,
		NS2 = SS2
	    ;
		true
	    )
	).

mkcat(ST,Cat,Tree,Cdr,[S|R],NextTree,[S|I],S1,S2,L,B) :- !,
	mkcat(ST,Cat,Tree,Cdr,R,NextTree,I,S1,S2,L,B).

/*
mkcat(_,_,Tree,_,[],Tree,[],Score) :- !,
	score_of_tree(Tree,Score).

mkcat(ST,Cat,Tree,Cdr,[[ST,[[Cat|T]]|C]|R],NewTree,I,NewScore) :- 
	Cdr == C,!,
	mkcat(ST,Cat,Tree,Cdr,R,NextTree,I,NextScore),
	score_of_tree(T,Score),
	(
	    Score < NextScore,!,
	    NewTree = T,
	    NewScore is Score
	;
	    Score > NextScore,!,
	    NewTree = NextTree,
	    NewScore is NextScore
	;
	    NewTree = NextTree/T,
	    NewScore is Score
	).

mkcat(ST,Cat,Tree,Cdr,[S|R],NextTree,[S|I],Score) :- !,
	mkcat(ST,Cat,Tree,Cdr,R,NextTree,I,Score).
*/


check_rensetsu([H],0) :- !.
check_rensetsu([H1,H2|H],R) :-
	check_rensetsu([H2|H],R1),
	(
	    bigram(H1,H2,1.0), !,
	    R is R1+1
	;
	    R is R1
	).
%
% Heuristic program for morphLR system (newSGLR)
%                           Program: M.Aizawa(Mar.1993)
%

%score_of_tree(_,0,0) :- \+now_option(j), !.
	
score_of_tree(Tree,S1,S2):-
	flat(Tree,Flat_List),
	scoring(Flat_List,S1,S2).
% modified... by ueki   but not complete...:)
score_of_tree(Tree,S1,S2,H,SH,B) :-
%	flat(Tree,Flat_List),
	flat2(Tree,Flat_List,H,SH),
	scoring(Flat_List,_,S2,B),
	count_jiritsugo(H,S1).


scoring([],0,0):-!.
scoring([X|R],S1,S2):-
	scoring(R,RS1,RS2),
	S2 is RS2+1,
	(
	    jiritsugo(X), !, S1 is RS1+1
	;
	    !, S1 is RS1
	).
% modified... by ueki   but not complete...:)
scoring([],0,0,0) :- !.
scoring([X|R],S1,S2,B1) :-
	scoring(R,RS1,RS2,RB),
	S2 is RS2+1,
	(
	    jiritsugo(X), !, S1 is RS1+1
	;
	    !, S1 is RS1
	),
	(
	    (
		X = 'bunsetsu'
	    ;
		X = 'last_bunsetsu'
	    ), !,
	    B1 is RB+1
	;
	    B1 is RB
	).

count_jiritsugo([],0) :- !.
count_jiritsugo([X|Y],S) :-
	(
	    (
		X = 'n3'
	    ;
		X = 'sy'
	    ), !,
	    count_jiritsugo1(X,Y,S1)
	;
	    count_jiritsugo(Y,S1)
	),
	(
	    jiritsugo(X), !,
	    S is S1+1
	;
	    S is S1
	).
count_jiritsugo1(_,[],0) :- !.
count_jiritsugo1(X,[X|Y],S) :-
	count_jiritsugo1(X,Y,S).
count_jiritsugo1(X,[Y|Z],S) :-
	(
	    X = 'n3', !,
	    (
		Y = 'keta', !,
		count_jiritsugo1(X,Z,S)
	    ;
		count_jiritsugo([Y|Z],S)
	    )
	;
	    count_jiritsugo(Z,S)
	).

/*
score_of_tree(Tree,Score):-
	flat(Tree,Flat_List),
	scoring(Flat_List,Score).


scoring([],0):-!.
scoring([X|R],Score):-
	scoring(R,R_Score),
	(
	    jiritsugo(X),!,Score is R_Score +1
	;
	    !,Score is R_Score
	).
*/
	
% ʬڤեåȤˤ 
% ѥåƤϡΤΰĤФ
% (Ĥ̵)

flat(X,Y):-dflat(X,Y-[]).

dflat([],U-U) :- !.
dflat([X|Y],U-V):-
	dflat(X,U-UV),dflat(Y,UV-V).
dflat(X/Y,U):- !, dflat(Y,U).
dflat(X,[X|V]-V):-atom(X).

% ʬڤեåȤˤ
% ƱʻΥꥹȤ
flat2(X,Y,Z,SZ):-dflat2(X,Y-[],Z-[],SZ-[]).

dflat2([],U-U,W-W,V-V) :- !.
dflat2([A,[B,C]],[A,B1,C|U]-U,[A|W]-W,[B1|V]-V) :-
	atom(A), hinshi(A), atom(C), !,
	(
	    atom(B), B1 = B
	;
	    B = _/B1
	).
dflat2([A,B],[A,B|U]-U,W-W,[A|V]-V) :-
	atom(A), atom(B), !.
dflat2([X|Y1/[[YA,YB]]],[X|U]-V,[X|P]-Q,SP-SQ) :-
	atom(X), atom(YA), atom(YB), !,
	dflat2(Y1/[[YA,YB]],U-V,P-Q,SP-SQ).
dflat2([X|Y],U-V,P-Q,SP-SQ):-
	dflat2(X,U-UV,P-PQ,SP-SPQ),dflat2(Y,UV-V,PQ-Q,SPQ-SQ).
dflat2(X/Y,U,W,V) :- !, dflat2(Y,U,W,V).
dflat2(X,[X|U]-U,W-W,V-V):-atom(X).

stat_score(T1,T2,T1/T2) :-
	seg_morph([T1],M1), seg_morph([T2],M2),
	append(M1,M2,M3), write(M3), nl,
	prob(M3,P),
	write(P), nl, nl.
