% Copyright (C) 1996  ƣ    ͵

%
% client program for msLR system
%			94 May. A.Fujii
%

usage :-
	plsys(shell('less usage')).

host_check(Host) :-
	now_option(h,Host),
	(
	    Host = localhost, !,
	    HostDSV = 'hostdsv.prl $cwd'
	;
	    make_string(['xon ',Host,' hostdsv.prl ','$cwd'],HostDSV)
	),
	plsys(shell(HostDSV)),
	open('./Host',read,FP1),
	read(FP1,S1), close(FP1),
	(
	    S1 = dsv_is_running, ! % dsväƤ
	;
	    write('dsv is not running...'), nl, fail
	).

mslr :-
	(
	    host_check(Host),
	    repeat, prompt(_,'|: '), read(S),
	    (S = [], !; mslr0(Host,S), fail)
	;
	    mslr_error(host)
	).

kioku(IF) :-
	on_exception(_,open(IF,read,FP),fail),
	abolish(input_sentence),
	abolish(current_no),
	abolish(sentence_max),
	assert(current_no(0)),
	repeat, read(FP,S),
	(
	    S = end_of_file, !
	;
	    kioku1(S),
	    gc, fail
	),
	current_no(N),
	assert(sentence_max(N)),
	close(FP).

kioku1(S) :-
	retract(current_no(N)),
	N1 is N+1,
	assert(current_no(N1)),
	assert(input_sentence(N1, S)).

disp_stg(S) :-
	(
	    S = 'skip', !,
	    write('.')
	;
	    S = [], !,
	    write('x')
	;
	    write('o')
	),
	flush_output.

disp_stg0(No,Stage) :-
	(
	    No == Stage, !
	;
	    write('.'),
	    Stage1 is Stage+1,
	    disp_stg0(No,Stage1)
	).

disp_sentence :-
	abolish(current_no),
	assert(current_no(0)),
	repeat,
	disp_sentence1(State),
	(
	    State = false
	;
	    gc, fail
	).

disp_sentence1(State) :-
	retract(current_no(N)),
	(
	    now_option(debug), !,
	    (
		N == 0,
		N1 is 1
	    ;
		N1 is N+2
	    )
	;
	    N1 is N+1
	),
	assert(current_no(N1)),
	(
	    (
		input_sentence(N1, S),
		write(N1), write(' , '), write(S), nl, !,
		State = success
	    ;
		fail
	    )
	;
	    State = false
	).

disp_sentence(N) :-
	(
	    input_sentence(N, S),
	    write(N), write(' , '), write(S), nl
	;
	    fail
	).

disp_tree(No) :-
	(
	    tree_data(No, Trees, _), !,
	    fin(Trees)
	;
	    true
	).

mslr_all :-
	(
	    host_check(Host),
	    abolish(current_no),
	    assert(current_no(0)),
	    abolish(tree_data),
	    abolish(stack_data),
	    abolish(result_data),
	    repeat,
	    mslr_all1(Host, State),
	    (
		State = false
	    ;
		gc, fail
	    )
	;
	    mslr_error(host)
	).

mslr_all1(Host, State) :-
	retract(current_no(N)),
	N1 is N+1,
	assert(current_no(N1)),
	(
	    (
		input_sentence(N1, S),
		time('total',
		      mslr0(Host, S)
		    ),!,
		State = success
	    ;
		fail
	    )
	;
	    State = false
	).

xmslr(Input) :-
	(
	    number(Input), !,
	    mslr(Input),
	    xdisp_tree(Input)
	;
	    atom(Input),
	    atom_chars(Input, InputChar),
	    number_chars(Input2, InputChar), !,
	    number(Input2),
	    mslr(Input2),
	    xdisp_tree(Input2)
	;
	    atom(Input), !,
	    retract(sentence_max(N)),
	    N1 is N+1,
	    assert(sentence_max(N1)),
	    assert(input_sentence(N1,Input)),
	    mslr(N1),
	    xdisp_tree(N1)
	;
	    fail
	).

xmslr2(Input) :-
	(
	    number(Input), !,
	    mslr(Input),
	    xtrace(Input)
	;
	    atom(Input), !,
	    atom_chars(Input, InputChar),
	    number_chars(Input2, InputChar),
	    number(Input2),
	    mslr(Input2),
	    xtrace(Input2)
	;
	    atom(Input), !,
	    retract(sentence_max(N)),
	    N1 is N+1,
	    assert(sentence_max(N1)),
	    assert(input_sentence(N1,Input)),
	    mslr(N1),
	    xtrace(N1)
	;
	    fail
	).

mslr(Input) :-
	abolish(tree_data),
	abolish(stack_data),
	abolish(result_data),
	abolish(stage),
	assert(stage(1)),
	mslr1(Input),
	(
	    now_option(output), !,
	    tell('mslr_result'), told,
	    tell('bunsetsu_result'), told,
	    tell('failed_result'), told
	;
	    true
	).

mslr1(Input) :-
	(
	    Input = [], !
	;
	    Input = [Input1|InputList], !,
	    mslr1(Input1),
	    mslr1(InputList)
	;
	    number(Input), !,
	    (
		sentence_max(MAX),
		(
		    Input > MAX
		;
		    Input < 1
		), !,
		write('sentence no. '),write(Input),write(' not found'),nl,
		fail
	    ;
		host_check(Host),
		input_sentence(Input,S),
		abolish(current_no),
		assert(current_no(Input)),
		time('total',
		     mslr0(Host,S)
		    )
	    )
	;
	    atom(Input), !,
	    host_check(Host),
	    (
		now_option(read), !,
		(
		    kioku(Input),
		    mslr_all
		;
		    (
			retract(sentence_max(N))
		    ;
			N is 0
		    ),
		    N1 is N+1,
		    assert(sentence_max(N1)),
		    assert(input_sentence(N1,Input)),
		    assert(current_no(N1)),
		    mslr0(Host,Input)
		)
	    ;
		on_exception(_,open(Input,read,FP),fail),
		repeat, read(FP,S),
		(
		    S = end_of_file, !
		;
		    mslr0(Host,S), gc, fail
		),
		close(FP)
	    ;
		(
		    retract(sentence_max(N))
		;
		    N is 0
		),
		N1 is N+1,
		assert(sentence_max(N1)),
		assert(input_sentence(N1,Input)),
		mslr0(Host,Input)
	    )
	;
	    mslr_error(host)
	).

mslr0(Host,S):-
	init_forest,
	nl, write(S), nl, nl,
	time('consult',
	     (write('consulting dictionary ... '), flush_output,
	      socket_io(Host,16010,S,Proc),
	      write('done'), nl)
	    ), nl,
	Proc=(Goal,MinForest,StackList),
	time('analyze',
	     (write('analyzing sentence '), flush_output,
	      (Goal, !; true),
	       write(' done'),nl)
	    ),
	(
	    now_option(a,MaxF)
	;
	    MaxF is 1
	),
	collect_min_forest(MaxF),
	min_forest(MinForest),
	(
	    % ϼ
	    MinForest = [], !,
	    write('I cannot get any trees...'),
	    nl,
	    (
		now_option(output), !,
		tell('mslr_result'),
		write('I cannot get  any  trees...'),
		nl,
		tell('failed_result'),
		write(S), write('.'), nl,
		tell(user)
	    ;
		true
	    )
	;
	    % 쿹Ÿ
	    time('unpack',
	         (write('unpacking forest ... '), flush_output,
		  unpack_forest(MinForest,Trees,_),
		  write('done'),nl)
		),
	    (
		now_option(save), !,
		current_no(S_no),
		assert(tree_data(S_no, Trees, MinForest)),
		assert(stack_data(S_no, StackList))
	    ;
		true
	    ),
	    (
		% ڤɽ
		now_option(t), !,
		fin(Trees), !, nl
	    ;
		true
	    ),
	    (
		% ǲϤη̤ɽ
		now_option(m), !,
		time('extracting bunsetsu',
		     (write('extracting bunsetsu ... '),flush_output,
		      seg_morph(Trees,Morphs),
		      del_red(Morphs,Morphs2),
		      write('done'),nl)
		    ),
		(
		    now_option(min_bunsetsu), !,
		    check_bunsetsu(Morphs2,Morphs3)
		;
		    Morphs3 = Morphs2
		),
		(
		    now_option(one_tree), !,
		    Result = Morphs3
		;
		    now_option(b), !,
		    prob(Morphs3,Result)
		;
		    Result = Morphs3
		),
		disp_morph(Result),
		(
		    now_option(save), !,
		    assert(result_data(S_no, Result))
		;
		    true
		)
	    ;
		true
	    )
	).

mslrd(Input) :-
	abolish(tree_data),
	abolish(stack_data),
	abolish(result_data),
	number(Input), !,
	input_sentence(Input,S),
	Input2 is Input+1,
	input_sentence(Input2,DSV),
	abolish(current_no),
	assert(current_no(Input)),
	init_forest,
	nl,write(S),nl,nl,
	DSV = (Goal,MinForest,StackList),
	time('analyze',
	     (write('analyzing sentence '), flush_output,
	      (Goal, !; true),
	       write(' done'),nl)
	    ),
	collect_min_forest(1),
	min_forest(MinForest),
	(
	    MinForest = [], !,
	    write('I cannot get any trees ...'),nl
	;
	    write('unpacking forest ... '), flush_output,
	    unpack_forest(MinForest,Trees,_),
	    write('done'),nl,nl,
	    current_no(S_no),
	    assert(tree_data(S_no,Trees,MinForest)),
	    assert(stack_data(S_no,StackList)),
	    (
		now_option(t), !,
		fin(Trees), !, nl
	    ;
		true
	    ),
	    (
		now_option(m), !,
		seg_morph(Trees,Morphs),
		del_red(Morphs,Morphs2),
		(
		    now_option(min_bunsetsu), !,
		    check_bunsetsu(Morphs2,Morphs3)
		;
		    Morphs3 = Morphs2
		),
		(
		    now_option(one_tree), !,
		    Result = Morphs3
		;
		    now_option(b), !,
		    prob(Morphs3,Result)
		;
		    Result = Morphs3
		),
		disp_morph(Result),
		assert(result_data(S_no,Result))
	    ;
		true
	    )).

% å̿ط
socket_io(Host, Port, InTerm, OutTerm) :-
	socket('AF_INET', Socket),
	socket_connect(Socket, 'AF_INET'(Host, Port), Stream),
	write(Stream, InTerm),
	put(Stream, 10),
	put(Stream, 0),
	flush_output(Stream),
	read(Stream, OutTerm),!,
	close(Stream), !.

% ץط
set_option([l,X]) :-
	abolish(forest_limit),
	assert(forest_limit(X)). % Ϸ̤򤤤ĤޤǸ뤫
set_option([]) :- !.
set_option(X) :- atom(X), !, set_option1(X).
set_option([h,X]) :- atom(X), !, set_option1([h,X]).
set_option([a,X]) :- number(X), !, set_option1([a,X]).
set_option([best,X]) :- number(X), !, set_option1([best,X]).
set_option([X|Y]) :- set_option1(X), set_option(Y).
set_option1(x) :- !,
	(
	    now_option(x), !
	;
	    assert(now_option(x))
	),
	(
	    xstate(open), !
	;
	    xopen
	).
set_option1(X) :- atom(X), !,
	(
	    option(X), !,
	    (
		now_option(X), !
	    ;
		assert(now_option(X))
	    )
	;
	    write('illegal option: '), write(X), nl
	).
set_option1([X,Y]) :-
	atom(X),
	(
	    atom(Y)
	;
	    number(Y)
	), !,
	(
	    option(X,Y), !,
	    (
		now_option(X,Y), !
	    ;
		(retract(now_option(X,_)), !; true),
		assert(now_option(X,Y))
	    )
	;
	    write('illegal option: '), write([X,Y]), nl
	).

disp_option :-
	nl, \+disp_option0, !, nl.

disp_option0 :-
	(
	    now_option(X), write(X)
	;
	    now_option(X,Y), write([X,Y])
	),
	write(' '), fail.

clr_option(X) :-
	(
	    retract(now_option(X)), !
	;
	    true
	).
clr_option :-
	(
	    abolish(now_option), !
	;
	    true
	).

% ǽʥץ
option(t).		% ڤɽ
option(j).		% ΩǾˡ
option(m).		% ǤΥȤɽ
option(s).		% ʻΥ٥ޤɽ
option(b).		% پ
option(x).		% Xwindow
option(d).		% Xwindow˥åɽ
option(h,_).		% Ԥʤۥ̾
option(bunsetsu).       % ʸñ̤Ƿ̤
option(depth).          % Ǹʤ
option(min_bunsetsu).   % ƱʻʤʸǾΤΤ
option(min_bunsetsu2).
option(min_morph).      % pack Ȥ˷ǿǾΤΤ
option(one_tree).       % ڤɽ˸򣱤Ĥˤܤ
option(output).         % ̤ե˥֤
option(save).           % åʤɤ¸
option(read).		% ϥե뤫餹٤ɤ߹
option(tango).          % ʸϤʤ(s-->tango,s.)
option(a,_).
option(best,_).
%option(demo).           % ǥ
option(debug).


% ץΥǥե
:- clr_option.
:- set_option([m,j,b,[h,localhost],bunsetsu,min_bunsetsu,min_morph,one_tree,save,read,[a,1]]).

% sglrѤΥץ(ڤɽ)
:- tree.

% tcl/tk  default ǤϻѤʤ
:- assert(x_is(not_open)).

% إ
mslr_usage :-
	nl, write('Usage:'), nl,
	tab(4), write('mslr(FILE):        from FILE to STDOUT'), nl,
	tab(4), write('mslr([FILE1,FILE2,...]):'), nl,
	nl, write('Option(s):'), nl,
	tab(4), write('set_option([...])'), nl,
	tab(8), write('t: display tree(s)'), nl,
	tab(8), write('m: display morph(s)'), nl,
	tab(8), write('s: display morph(s) with "sai-hinshi"'), nl,
	tab(8), write('bunsetsu: display "bunsetsu"'), nl,
	tab(8), write('one_tree: display only one result'), nl,
	tab(8), write('output: save result in file'), nl,
	tab(8), write('j: "jiritsu-go" minimum preference'), nl,
	tab(8), write('depth: minimal attachment'), nl,
	tab(8), write('min_bunsetsu: "bunsetsu" minimum preference'), nl,
	tab(8), write('min_morph: morphology minimum preference'), nl,
	tab(8), write('b: use "bi-gram" data'), nl,
	tab(8), write('x: display on Xwindow'), nl,
	tab(8), write('d: display stack'), nl,
	tab(8), write('[h,Host]: set "dsv" host (default localhost)'), nl.

mslr_error(host) :-
	nl, write('Please set dsv host.'), nl,
	tab(4), write('| ?- set_option([h,hostname])'), nl, nl.


acc(A) :-
	retract(forest_cnt(FC)),
	forest_limit(LM), !,
	(
	    FC < LM, !, % ǽΤĤĴ٤뤫
	    FC1 is FC+1, assert(forest_cnt(FC1)),
	    (
		now_option(j), !,
		score_of_tree(A,S1,S2,H,_,B), !,
		min_score(MS1,MS2), !,
		(
		    S1 < MS1, !,
		    abolish(min_forest),
		    abolish(min_score),
		    abolish(min_bunsetsu),
		    abolish(minimum_bunsetsu),
		    assert(min_forest(A,H)),
		    assert(min_score(S1,S2)),
		    assert(min_bunsetsu(A,H,B)),
		    assert(minimum_bunsetsu(B))
		;
		    S1 = MS1, !,
		    (
			now_option(depth), !,
			(
			    S2 < MS2, !,
			    abolish(min_forest),
			    abolish(min_score),
			    assert(min_score(S1,S2)),
			    assert(min_forest(A,H))
			;
			    S2 = MS2, !,
			    (
				retract(min_forest(F,_)), !,
				append(F,[A],F1),
				assert(min_forest(F1,H))
			    ;
				assert(min_forest(A,H))
			    )
			;
			    true
			)
		    ;
			now_option(min_bunsetsu), !,
			(
			    min_bunsetsu(F,H,BMIN), !,
			    (
				B < BMIN, !,
				retract(min_forest(_,H)),
				retract(min_bunsetsu(_,H,BMIN)),
				assert(min_forest(A,H)),
				assert(min_bunsetsu(A,H,B)),
				minimum_bunsetsu(MINB),
				(
				    B < MINB, !,
				    retract(minimum_bunsetsu(_)),
				    assert(minimum_bunsetsu(B))
				;
				    true
				)
			    ;
				B = BMIN, !,
				retract(min_forest(F,H)),
				retract(min_bunsetsu(F,H,BMIN)),
				append(F,[A],F1),
				assert(min_forest(F1,H)),
				assert(min_bunsetsu(F1,H,BMIN))
			    ;
				true
			    )
			;
			    assert(min_forest(A,H)),
			    assert(min_bunsetsu(A,H,B)),
			    minimum_bunsetsu(MINB),
			    (
				B < MINB, !,
				retract(minimum_bunsetsu(_)),
				assert(minimum_bunsetsu(B))
			    ;
				true
			    )
			)
		    ;
			(
			    retract(min_forest(F,_)), !,
			    append(F,[A],F1),
			    assert(min_forest(F1,H))
			;
			    assert(min_forest(A,H))
			),
			minimum_bunsetsu(MINB),
			(
			    B < MINB, !,
			    retract(minimum_bunsetsu(_)),
			    assert(minimum_bunsetsu(B))
			;
			    true
			)
		    )
		;
		    true
		)
	    ;
		(
		    retract(min_forest(F,0)), !,
		    append(F,[A],F1),
		    assert(min_forest(F1,0)),
		    assert(min_bunsetsu(F1,0,0))
		;
		    assert(min_forest(A,0)),
		    assert(min_bunsetsu(A,0,0))
		),
		(
		    minimum_bunsetsu(0)
		;
		    retract(minimum_bunsetsu(_)),
		    assert(minimum_bunsetsu(0))
		)
	    )
	;
	    FC1 is FC+1, assert(forest_cnt(FC1))
	).

init_forest :-
	abolish(min_forest),
	abolish(min_score),
	abolish(forest_cnt),
	abolish(min_bunsetsu),
	abolish(minimum_bunsetsu),
	assert(min_forest([],_)),
	assert(min_score(10000,10000)),
	assert(forest_cnt(0)),
	assert(minimum_bunsetsu(10000)),
	(
	    forest_limit(_), !
	;
	    assert(forest_limit(100))
	).

% ʻ󤴤Ȥ min_forest 򣱤ĤˤޤȤ
collect_min_forest(A) :-
	collect_min_forest0(A,X-[],0), !,
	abolish(min_forest),
	abolish(min_bunsetsu),
	assert(min_forest(X)).

collect_min_forest0(0,X-X,_) :- !.
collect_min_forest0(A,X-Y,L) :-
	retract(minimum_bunsetsu(MINB)),
	(
	    MINB == 10000, !,
	    X = Y
	;
	    L == 3, !,
	    X = Y
	;
	    B is MINB+1,
	    assert(minimum_bunsetsu(B)),
	    collect_min_forest1(MINB,X-Y1,N),
	    (
		N == 0, !,
		L1 is L+1,
		collect_min_forest0(A,Y1-Y,L1)
	    ;
		A1 is A-1, !,
		collect_min_forest0(A1,Y1-Y,0)
	    )
	).
collect_min_forest1(B,X-Y,N) :-
	(
	    retract(min_bunsetsu(A,_,B)), !,
	    collect_min_forest1(B,X1-Y,N1),
	    append(A,X1,X),
	    N is N1+1
	;
	    X = Y,
	    N is 0
	).

