/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     grform --- change the grammar format (from niNja to ATR)
 *
 *     usage: grform garmmar_file
 *     ~~~~~
 *
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#define         max_nonterminal   2048
#include        <stdio.h>
int     num_nonterminal;
char    nonterminal[max_nonterminal][100];
char    sym[100];

main(argc, argv)
int  argc;
char *argv[];
{
    int     len,i,k, rule;
    int     k1, k2;
    int     st;
    char    buf[1024];
    char    right[100][50];
    char    fp1_name[1024], fp2_name[1024];
    FILE    *fp1, *fp2;

    if( argc < 3) {
	usage();
    }

    strcpy(fp1_name, argv[1]);
/*    strcat(fp1_name, ".cfg"); */

    strcpy(fp2_name, argv[2]);
/*    strcat(fp2_name, ".gra"); */
  
    if((fp1=fopen(fp1_name,"r"))==NULL)
	{
	    printf("file %s can't opened\n",fp1_name);
	    exit();
	}

    if((fp2=fopen(fp2_name,"w"))==NULL)
	{
	    printf("file %s can't opened\n", fp2_name);
	    exit();
	}
  
    num_nonterminal = 0;
    while(fgets(buf,1024,fp1) != NULL){
	if(buf[0] == '%' || buf[0] == 10)
	    continue;
	len = strlen(buf);
	for( i=0; i < len; i++)
	    if(buf[i] != '-')
		sym[i] = buf[i];
	    else
		break;
	sym[i] = '\0';
	install_nonterminal();
    }

    fclose(fp1);

    if((fp1=fopen(fp1_name,"r"))==NULL)
	{
	    printf("file %s can't opened\n",fp1_name);
	    exit();
	}

    st = 0;
    while(fgets(buf,1024,fp1) != NULL){

	if(buf[0] == '%' || buf[0] == 10)
	    continue;

	len = strlen(buf);
	k = 0;
	for( i = 0; i < len; i++) {
	    if(buf[i] != '-')
		sym[k++] = buf[i];
	    else
		break;
	}
	sym[k] = '\0';

	if( st == 0){
	    fprintf(fp2,"(<start> <--> (<%s>))\n", sym);
	    st = 1;
	}
	fprintf(fp2,"(<%s> <--> (", sym);
    
	for( i = k; i < len; i++)
	    if(buf[i] != '-' && buf[i] != '>')
		break;

	k = i;
	k1 = 0;
	k2 = 0;

	for(i = k; i < len; i++){
	    if(buf[i] != ',' && buf[i] != '.'){
		right[k1][k2] = buf[i];
		k2++;
	    }else if(buf[i] == '.'){
		right[k1][k2] = '\0';
		k1++;
		break;
	    }else if(buf[i] ==','){
		right[k1][k2] = '\0';
		k1++;
		k2 = 0;
	    }
	}    
	
	for( i = 0; i < k1-1; i++) {
	    strcpy(sym, right[i]);
	    if( isnonterminal() == 1)
		fprintf(fp2,"<%s> ", sym);
	    else
		fprintf(fp2,"%s ", sym);
	}
	strcpy(sym, right[k1-1]);
	if( isnonterminal() == 1)
	    fprintf(fp2,"<%s>))\n", sym);
	else
	    fprintf(fp2,"%s))\n", sym);
    }
}


int install_nonterminal()
{
    int i;
    
    for(i=0; i < num_nonterminal; i++)
      if(strcmp(sym, nonterminal[i]) == 0){
	  break;
      }

    if(i == num_nonterminal){
	strcpy(nonterminal[num_nonterminal], sym);
	num_nonterminal++;
    }
}

int isnonterminal()
{
    int i;
    
    for(i=0; i < num_nonterminal; i++)
      if(strcmp(sym, nonterminal[i]) == 0){
	  return 1;
      }
    return -1;
}

usage()
{
        fprintf(stderr, "\tgrform Input_Grammar_File Output_Grammar_File\n");
        exit(1);
}
