/* Copyright (C) 1996  º  */
/*
		* SGLR 1.1 Translator *

				1990.10.6
				H.Numazaki
*/

#include <stdio.h>
#define MAX_RULE 1000
/* #define MAX_RULE 600 */
#define MAX_STATE 1500
/* #define MAX_SYMBOL 200 */
#define MAX_SYMBOL 1000
#define MAX_CONFLICT 10
#define SYMBOL_LEN 50
#define UNDEF -1
#define TRUE 1
#define FALSE 0

static int tree_option=0;
static int rhs[MAX_RULE];
static int lhs[MAX_RULE];
static int shtbl[MAX_STATE][MAX_SYMBOL];
				/* Shift Table */
static int retbl[MAX_STATE][MAX_SYMBOL][MAX_CONFLICT];
				/* Reduce Table */
static int gotbl[MAX_STATE][MAX_SYMBOL];
				/* Goto Table */
static char top_node[SYMBOL_LEN];
				/* Top Node Symbol */
static int acc_state;		/* State Number for 'acc' entry */
static int rule_no = 0;		/* Number of Rules */
static int state_no = 0;	/* Number of States */
static int pt_sym = 0;		/* Number of Preterminal Symbol */
static int  nt_sym = 0;		/* Number of Nonterminal Symbol */
static char preterminals[MAX_SYMBOL][SYMBOL_LEN];
				/* List of Preterminal Symbols */
static char nonterminals[MAX_SYMBOL][SYMBOL_LEN];
				/* List of Nonterminal Symbols */

char *getsym();

main(argc,argv)
int argc;
char **argv;
{
	if ( argc>1 && strcmp(*(argv+1),"-t")==0 ) tree_option=1;
	init();
	reading();
/*output_reduce_table();*/
	writing();
}

init()
{
	int s, sn, c;

	for ( s = 0; s < MAX_STATE; s++ ){
	  for ( sn = 0; sn < MAX_SYMBOL; sn++ ){
	    shtbl[s][sn] = UNDEF;
	    for ( c = 0; c < MAX_CONFLICT; c++ ){
	      retbl[s][sn][c] = UNDEF;
	    }
	    gotbl[s][sn] = UNDEF;
	  }
        }
}

reading()
{
	char line[30];

	scanf( "%s" , line );
	if ( strcmp(line,"Input_file_for_Translator") != 0 ){
	  printf( "file format error 1\n" );
	  exit(0);
	}
	rule();
	scanf("%s",top_node);
	getchar();
	tbl();
}

rule()
{
	int i=0, n;
	char sym[SYMBOL_LEN];

	do {
	  i++;
	  scanf( "%s %d", sym, &n );
	  lhs[i] = nt_symno(sym);
	  rhs[i] = n;
	  getchar();
        }
	while ( getchar() != '\n' );
	rule_no = i;
	printf("%% Number of Grammar Rules = %d\n", rule_no );
}

tbl(){
	int i, s=0, sn, c;
	char sym[SYMBOL_LEN], op[SYMBOL_LEN];

	while( ( getsym(sym) != NULL )&&( strcmp( sym,"STATE" ) == 0)){
	  scanf("%d",&i); getchar();
	  if ( i != s ) {
	    printf("file format error 2\n");
	    exit(0);
	  }

	  while( getsym(sym) != NULL ){
			 /* reading action part */
	    c = 0;
	    sn = pt_symno(sym);
	    getsym(op);
	    if ( strcmp( op, "sh" ) == 0 )
              scanf( "%d", &( shtbl[s][sn] ) );
	    else if ( strcmp( op, "acc" ) == 0 )
	      acc_state = s;
	    else if ( strcmp( op, "re" ) == 0 ){
	      scanf( "%d", &( retbl[s][sn][c] ) );
/*
printf( "state: %d, symbol: %s, re %d\n",s,preterminals[sn],retbl[s][sn][c+1] );
*/
	      c++; }
	    else {
	      printf("file format error 3\n");
	      printf("%s %s\n",sym,op);
	      exit(0);
	    }
	    while ( getsym(op) != NULL ){
			/* reading conflicting entries of one state */
	      if ( strcmp( op, "re" ) == 0 )
/* { */
		scanf( "%d", &( retbl[s][sn][c] ) );
/* printf( "re %d\n",retbl[s][sn][c+1] );} */
	      else {
		printf("file format error 4\n"); exit(0);
	      }
	      c++;
	    }
	  }

	  while(( getsym(sym) ) != NULL){
				/* reading goto part of one state */
	    sn = nt_symno(sym);
	    scanf( "%d", &( gotbl[s][sn] ) );  getchar();
	  }
	  s++;
        }
	state_no = s-1;

	printf("%% Number of States = %d\n", state_no );
}

char *getsym( sym )
char *sym;
{
	char *s;
	int i = 0;

	s = sym;
	*s = getchar();
	while ( ( *s == ' ' ) || ( *s == '\t' ) )
	  *s = getchar();
	if ( ( *s == '\n' ) || ( *s == EOF ) ) {
	  *s = NULL;
	  return( NULL );
        }
	while ( ( *s != '\n' ) && ( *s != EOF )
		 && ( *s != ' ' ) && ( *s != '\t' ) ){
	  s++;
	  *s = getchar();
        }
	*s = NULL;
	return( sym );
}

pt_symno( sym )
char *sym;
{
	int i;

	for ( i = 0; i < pt_sym; i++ ){
	  if ( strcmp( preterminals[i], sym ) == 0 )
	    return( i );
        }
	strcpy( preterminals[pt_sym], sym );
	pt_sym++;
	return( pt_sym - 1 );
}

nt_symno( sym )
char *sym;
{
	int i;

	for ( i = 0; i < nt_sym; i++ ){
	  if ( strcmp( nonterminals[i], sym ) == 0 )
	    return( i );
        }
	strcpy( nonterminals[nt_sym], sym );
	nt_sym++;
	return( nt_sym - 1 );
}

writing()
{
	int p, n;
	char c;

	printf("/* Preterminal Symbols : \n");
	for ( p = 0; p < pt_sym; p++ )
	  printf( " %s ", preterminals[p] );
	printf("\n\n Nonterminal Symbols : \n");
	for ( n = 0; n < nt_sym; n++ )
	  printf( " %s ", nonterminals[n] );
	printf("\n*/\n");
	printf("top_node_symbol(%s).\n",top_node);
	action_part();
	goto_part();
/*	condition();*/
    
}

action_part()
{
  int p, s, i, n, m, ruleno;
  char c1, c2;
  int cnd[5];
  int cnd_c;
  int re1[5],re2[5];
  int re_c;

  for ( p = 0; p < pt_sym; p++ ) {
    for ( s = 0; s <= state_no; s++ ) {
      cnd_c = 0;
      re_c = 0;
      if ( shtbl[s][p] != UNDEF ) {
	if ( retbl[s][p][0] == UNDEF ) {
	  printf( "%s_(%d,S,A,[[%d,A|S]|X]-X):-!.\n",
/* shift entry */
		 preterminals[p],s,shtbl[s][p] );
	} else {
/* n is the number of conflict in the entry */
	  n = reduces( retbl[s][p] );
/* shift reduce conflict */
	  printf( "%s_(%d,S,A,[[%d,A|S]|O]-X):-!,\n\tS=[_,A0|S1],\n",
		 preterminals[p],s,shtbl[s][p],s );

	  if (n == 1) {
	    ruleno = retbl[s][p][0];
	    if (rhs[ruleno] <= 1) {
	      if (tree_option) {
		printf("\tcnd_");
	      } else {
		printf("\tcnd");
	      };
	      printf("(%d,%d,S,O0),\n",rhs[ruleno],ruleno);
	    } else {
	      if (tree_option) {
		printf("\tre_");
	      } else {
		printf("\tre");
	      };
	      printf("(S,%d,%d,O0),\n",rhs[ruleno]-1,ruleno);
	    };
	  } else {
	    for (i = 0; i < n; i++) {
	      ruleno = retbl[s][p][i];
	      if (i == 0) {
		if (tree_option) {
		  printf("\tact_t([");
		} else {
		  printf("\tact([");
		};
		if (rhs[ruleno] <= 1) {
		  printf("%d",ruleno);
		  cnd[cnd_c++] = rhs[ruleno];
		} else {
		  re1[re_c] = rhs[ruleno]-1;
		  re2[re_c++] = ruleno;
		};
	      } else {
		if (rhs[ruleno] <= 1) {
		  if (cnd_c == 0) {
		    printf("%d",ruleno);
		  } else {
		    printf(",%d",ruleno);
		  };
		  cnd[cnd_c++] = rhs[ruleno];
		} else {
		  re1[re_c] = rhs[ruleno]-1;
		  re2[re_c++] = ruleno;
		}
	      };
	    };

	    printf("],[");
	    if (cnd_c > 0) {
	      for (i = 0; i < cnd_c; i++) {
		if (i == 0) {
		  printf("%d",cnd[i]);
		} else {
		  printf(",%d",cnd[i]);
		}
	      };
	    };
	    printf("],[");
	    if (re_c > 0) {
	      for (i = 0; i < re_c; i++) {
		if (i == 0) {
		  printf("%d",re1[i]);
		} else {
		  printf(",%d",re1[i]);
		}
	      };
	      printf("],[");
	      for (i = 0; i < re_c; i++) {
		if (i == 0) {
		  printf("%d",re2[i]);
		} else {
		  printf(",%d",re2[i]);
		}
	      };
	    } else {
	      printf("],[");
	    };
	    printf("],S,S1,A0,O0),\n");
	  }
	  printf("\t%s(O0,A,O-X).\n",preterminals[p]);
	}
      } else if  ( retbl[s][p][0] != UNDEF ) {
	n = reduces( retbl[s][p] );
	if ( strcmp( preterminals[p], "$" )==0 ) {
	  printf( "'$_'(%d,S,A,D):-!,\n",s );
	} else {
	  printf( "%s_(%d,S,A,D):-!,\n",
		 preterminals[p],s );
	};
	if (n == 1) {
	  ruleno = retbl[s][p][0];
	  if (rhs[ruleno] <= 1) {
	    if (tree_option) {
	      printf("\tcnd_");
	    } else {
	      printf("\tcnd");
	    };
	    printf("(%d,%d,S,O0),\n",rhs[ruleno],ruleno);
	  } else {
	    if (tree_option) {
	      printf("\tre_");
	    } else {
	      printf("\tre");
	    };
	    printf("(S,%d,%d,O0),\n",rhs[ruleno]-1,ruleno);
	  };
	} else {
	  for ( i=0; i<n; i++ ){
	    ruleno = retbl[s][p][i];
	    if (i == 0) {
	      if (tree_option) {
		printf("\tact_t([");
	      } else {
		printf("\tact([");
	      };
	      if (rhs[ruleno] <= 1) {
		printf("%d",ruleno);
		cnd[cnd_c++] = rhs[ruleno];
	      } else {
		re1[re_c] = rhs[ruleno]-1;
		re2[re_c++] = ruleno;
	      };
	    } else {
	      if (rhs[ruleno] <= 1) {
		if (cnd_c == 0) {
		  printf("%d",ruleno);
		} else {
		  printf(",%d",ruleno);
		};
		cnd[cnd_c++] = rhs[ruleno];
	      } else {
		re1[re_c] = rhs[ruleno]-1;
		re2[re_c++] = ruleno;
	      }
	    };
	  };

	  printf("],[");
	  if (cnd_c > 0) {
	    for (i = 0; i < cnd_c; i++) {
	      if (i == 0) {
		printf("%d",cnd[i]);
	      } else {
		printf(",%d",cnd[i]);
	      }
	    };
	  };
	  printf("],[");
	  if (re_c > 0) {
	    for (i = 0; i < re_c; i++) {
	      if (i == 0) {
		printf("%d",re1[i]);
	      } else {
		printf(",%d",re1[i]);
	      }
	    };
	    printf("],[");
	    for (i = 0; i < re_c; i++) {
	    if (i == 0) {
	      printf("%d",re2[i]);
	    } else {
	      printf(",%d",re2[i]);
	    }
	  };
	  } else {
	    printf("],[");
	  };
	  printf("],S,O0),\n");
	};
	printf("\t%s(O0,A,D).\n",preterminals[p]);
      }
    }
    if ( strcmp( preterminals[p], "$" )==0 ){
/*	      printf( "'$_'(%d,[_,A|_],_,[A|X]-X):-!.\n", acc_state );*/
		
		/* sentence褿顢ҸaccϤ
		   (꤬դΤǥåˤʤ)
		*/
      printf( "'$_'(%d,[_,A|_],_,X-X):-!, acc(A).\n", acc_state );
      printf( "'$_'(_,_,_,O-O):-!.\n" );
    } else {
      printf( "%s_(_,_,_,O-O):-!.\n",preterminals[p] );
    }
    printf( "%s([],_,O-O):-!.\n",preterminals[p] );
    printf( "%s([S|I],A,O-X):-\n\tS=[N|_],\n",preterminals[p] );
    if ( strcmp( preterminals[p], "$" )==0 ) {
      printf( "	'$_'(N,S,A,O-O1),\n" );
    } else {
      printf( "	%s_(N,S,A,O-O1),\n",preterminals[p] );
    }
    printf( "	%s(I,A,O1-X).\n",preterminals[p] );
  }
}

reduces( rules )
int rules[];
{
	int i=0;

	while ( rules[i] != UNDEF ){
	  i++;
        }
	return( i );
}

goto_part()
{
	int p, s;

	for ( p = 0; p < nt_sym; p++ ) {
	  for ( s = 0; s <= state_no; s++ ){
	    if ( gotbl[s][p] != UNDEF ){
	      printf( "%s_(%d,S,A,[[%d,A|S]|X]-X):-!.\n",
			nonterminals[p],s,gotbl[s][p] );
	    }}
	    printf( "%s_(_,_,_,O-O):-!.\n",nonterminals[p] );
	    printf( "%s(B/S,A,O-X):-!,\n\tS=[N|_],\n",nonterminals[p] );
	    printf( "	%s(B,A,O-O1),\n",nonterminals[p] );
	    printf( "	%s_(N,S,A,O1-X).\n",nonterminals[p] );
	    printf( "%s(S,A,D):-\n\tS=[N|_],\n",nonterminals[p] );
	    printf( "	%s_(N,S,A,D).\n",nonterminals[p] );
        }
}

output_reduce_table()
{

	int s,sym,c;
	for ( s=0;s<MAX_STATE;s++){
	  printf( "state %d\n",s );
	  for ( sym=0;sym<MAX_SYMBOL;sym++){
	    printf( "symbol %d",sym );
	    for ( c=0;c<MAX_CONFLICT;c++ ){
	      printf( "%d",retbl[s][sym][c] );}
	    printf( "\n");}}
}	
