/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     follow.c  ---  construct 'first','last' and 'follow' tables.
 *     ~~~~~~~~       In this version, epsilon rules are not allowed.
 *
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#include <stdio.h>
#include "config.h"
#include "LR.h"

#define MAXTERMINALS	5000/*MAXALLOPHONES*/
#define EOR		(-1)

int	*Aproductions();

Ftable	*FirstTable[MAXSYMBOLS];
Ftable	*LastTable[MAXSYMBOLS];

#if  SLR
Ftable	*FollowTable[MAXSYMBOLS];
#endif

First(X, set)
int	X, **set;
{
	*set = FirstTable[X]->set;
	return(FirstTable[X]->size);
}

Last(X, set)
int X, **set;
{
	*set = LastTable[X]->set;
	return(LastTable[X]->size);
}


#if   SLR
Follow(X, set)
int	X, **set;
{
	*set = FollowTable[X]->set;
	return(FollowTable[X]->size);
}
#endif

init_Ftable()
{
	register int	i;
	Ftable	*p;
	char	*malloc();

	for(i = 0; i < MAXSYMBOLS; i++)
	  {
		if(SymbolTable[i] == NULL)
			continue;
		if((p = (Ftable *)malloc(sizeof(Ftable))) == NULL)
			fatal_error("No memory.\n");
		FirstTable[i] = p;
		FirstTable[i]->size = 0;
		FirstTable[i]->flg = 0;

		if((p = (Ftable *)malloc(sizeof(Ftable))) == NULL)
			fatal_error("No memory.\n");
		LastTable[i] = p;
		LastTable[i]->size = 0;
		LastTable[i]->flg = 0;

#if SLR
		if((p = (Ftable *)malloc(sizeof(Ftable))) == NULL)
			fatal_error("No memory.\n");
		FollowTable[i] = p;
		FollowTable[i]->size = 0;
		FollowTable[i]->flg = 0;
#endif
	}
}

ConstFirst()
{
    register int	i;
    int	H[MAXTERMINALS];

    for(i = 0; i < MAXSYMBOLS; i++)
      {
	  if(SymbolTable[i] == NULL)
	    continue;

	  if(!nonterminal(i))
	    add_symbol(FirstTable,i,i);
	  if(SymbolTable[i][1] != '_')
	    continue;

	  if(nonterminal(i))
	    MkFirst(i, H, 0);
      }

    for(i = 0; i < MAXSYMBOLS; i++)
      {
	  
	  if(SymbolTable[i] == NULL)
	    continue;

	  if(SymbolTable[i][1] == '_' || !nonterminal(i))
	    continue;
	  MkFirst(i, H, 0);
      }
}


ConstLast()
{
	register int	i;
	int	H[MAXTERMINALS];

	for(i = 0; i < MAXSYMBOLS; i++)
	{
		if(SymbolTable[i] == NULL)
			continue;

		if(!nonterminal(i))
		  add_symbol(LastTable,i,i);

		if(SymbolTable[i][1] != '_')
		  continue;
		
		if(nonterminal(i))
			MkLast(i, H, 0);
	}

	for(i = 0; i < MAXSYMBOLS; i++)
	{
		if(SymbolTable[i] == NULL)
		  continue;

		if(SymbolTable[i][1] == '_' || !nonterminal(i))
		  continue;
		
		MkLast(i, H, 0);
	}

}

#if SLR
ConstFollow()
{
    register int	i, j, k;
    int	StartSymbol = GrammarTable[0]->rhs[0];
    Rule *rp;

    add_symbol(FollowTable, StartSymbol, HashSymbol("$"));
    for(i = 1; (rp = GrammarTable[i]) != NULL; i++)
      {
	  for(j = 0; j < rp->length - 1; j++)
	    {
		if(!nonterminal(rp->rhs[j]))
		  continue;
		if(nonterminal(rp->rhs[j+1]))
		  {
		      for(k = 0; k < FirstTable[rp->rhs[j+1]]->size; k++)
			add_symbol(FollowTable, rp->rhs[j],
				   FirstTable[rp->rhs[j+1]]->set[k]);
		  }
		else
		  add_symbol(FollowTable, rp->rhs[j], rp->rhs[j+1]);
	    }
      }
    for(i = 0; i < MAXSYMBOLS; i++)
      {
	  if(SymbolTable[i] == NULL)
	    continue;
	  if(nonterminal(i))
	    MkFollow(i);
      }
}

MkFollow(X)
int	X;
{
	register int	i, j;
	int	Y;
	Rule	*rp;

	FollowTable[X]->flg = 1;
	for(i = 1; (rp = GrammarTable[i]) != NULL; i++)
	{
		if(rp->rhs[rp->length-1] != X)
		  continue;

		Y = rp->lhs;

		if(FollowTable[Y]->flg == 0)
		  MkFollow(Y);
		for(j = 0; j < FollowTable[Y]->size; j++)
		  add_symbol(FollowTable, X, FollowTable[Y]->set[j]);
	}
}
#endif

MkFirst(X, H, P)
int	X, *H, P;
{
    register int	*p, i;
    int	*rules, Y;

    if(FirstTable[X]->size)
      return;
    if((rules = Aproductions(X)) == NULL)
      return;

    if(P >= MAXTERMINALS - 1)
      fatal_error("MkFirst: MAXTERNINALS overflow.\n");
    H[P++] = X;
    for(p = rules; *p != EOR; p++)
      {
	  Y = GrammarTable[*p]->rhs[0];
		
	  if(nonterminal(Y))
	    {
		for(i = 0; i < P; i++)
		  {
		      if(H[i] == Y)
			break;
		  }
		if(i == P)
		  {
		      MkFirst(Y, H, P);
		      for(i = 0; i < FirstTable[Y]->size; i++)
			add_symbol(FirstTable, X, FirstTable[Y]->set[i]);
		  }
	    }
	  else
	    add_symbol(FirstTable, X, Y);
      }
}

MkLast(X, H, P)
int X, *H, P;
{
    register int  *p, i;
    int	*rules, Y, length;
    
    if(LastTable[X]->size)
      return;

    if((rules = Aproductions(X)) == NULL)
      return;

    if(P >= MAXTERMINALS - 1)
      fatal_error("MkLast: MAXTERNINALS overflow.\n");

    H[P++] = X;
    for(p = rules; *p != EOR; p++)
      {
	  length = GrammarTable[*p]->length;
	  Y = GrammarTable[*p]->rhs[length-1]; /* right most RHS */
	  
	  if(nonterminal(Y))
	    {
		for(i = 0; i < P; i++)
		  {
		      if(H[i] == Y)
			break;
		  }
		if(i == P)
		  {
		      MkLast(Y, H, P);
		      for(i = 0; i < LastTable[Y]->size; i++)
			add_symbol(LastTable, X, LastTable[Y]->set[i]);
		  }
	    }
	  else
	    add_symbol(LastTable, X, Y);
      }
}

add_symbol(tbl, n, symbol)
Ftable	**tbl;
int	n, symbol;
{
    register int	i;
    int	*newset;
    char	*malloc();
    
    for(i = 0; i < tbl[n]->size; i++)
      {
	  if(tbl[n]->set[i] == symbol)
	    return;
      }
    
    if((newset = (int *)malloc((tbl[n]->size + 1)*sizeof(int))) == NULL)
      fatal_error("No memory.\n");
    
    for(i = 0; i < tbl[n]->size; i++)
      newset[i] = tbl[n]->set[i];
    newset[i] = symbol;
    
    if(tbl[n]->size)
      free((char *)tbl[n]->set);
    
    tbl[n]->size += 1;
    tbl[n]->set = newset;

    shellsort(tbl[n]->set, tbl[n]->size);

}

shellsort(v, n)
int v[];
int n;
{
        int gap, i, j, temp;

	for (gap = n/2; gap > 0; gap /= 2)
	  for (i = gap; i < n; i++)
	    for (j = i-gap; j >= 0 && v[j] > v[j+gap]; j -= gap) {
	      temp = v[j];
	      v[j] = v[j+gap];
	      v[j+gap] = temp;
	    }
}

PrintFirst()
{
	PrintFtable(FirstTable);
}
PrintConnect()
{
        PrintFtable(ConnectTable);
}
PrintLast()
{
	PrintFtable(LastTable);
}


#if SLR
PrintFollow()
{
	PrintFtable(FollowTable);
}
#endif

PrintFtable(tbl)
Ftable	**tbl;
{
	register int	i;

	for(i = 0; i < MAXSYMBOLS; i++)
	{
		if(SymbolTable[i])
			_PrintFtable(tbl, i);
	}
}

_PrintFtable(tbl, n)
Ftable	**tbl;
int	n;
{
	register int	i;

	printf("%s: ", SymbolTable[n]); fflush(stdout);
	for(i = 0; i < tbl[n]->size; i++)
		printf("%s ", SymbolTable[tbl[n]->set[i]]);
	printf("\n");
}
