/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     fileio.c  ---  file I/O utility functions.
 *     ~~~~~~~~       used for reading grammar rules and LR parsing table.
 *
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#include <stdio.h>
#include <ctype.h>

#define FALSE		0
#define TRUE		1
#define LPAREN		'('
#define RPAREN		')'
#define COMMENTCHAR	';'

int	lineno = 1;

GetToken(fp, s)
FILE	*fp;
char	*s;
{
	int	c;
	char	*p;

	SkipSpace(fp);
	p = s;
	while(!isspace(c = inchar(fp)) && c != LPAREN && c != RPAREN)
	{
		if(c == EOF)
			lex_error("Unexpected EOF.\n");
		if(isupper(c))
			*p++ = tolower(c);
		else
			*p++ = c;
	}
	*p = NULL;
	ungetc(c, fp);
}

SkipTo(fp, ch)
FILE	*fp;
int	ch;
{
	register int	c;

	while((c = inchar(fp)) != ch)
	{
		if(c == EOF)
			return(EOF);
	}
	return(ch);
}

SkipSpace(fp)
FILE	*fp;
{
	int	c;

	while(isspace(c = inchar(fp)))
		;
	if(c == EOF)
		return(EOF);
	ungetc(c, fp);
	return(c);
}

PeekChar(fp)
FILE	*fp;
{
	int	c;

	if(SkipSpace(fp) == EOF)
		return(EOF);
	ungetc((c = inchar(fp)), fp);
	return(c);
}

inchar(fp)
FILE	*fp;
{
	int	c;

	if((c = getc(fp)) == COMMENTCHAR)
	{
		while((c = getc(fp)) != '\n')
			;
		c = '\n';
	}
	if(c == '\n')
		++lineno;
	return(c);
}

lex_error(fmt, args)
char	*fmt;
int	args;
{
	fprintf(stderr, "Error at line %d: ", lineno);
	_doprnt(fmt, &args, stderr);
	exit();
}
