/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     cpm.c  ---  Modify the LR table by constraint propagation(CPM)
 *     ~~~~~       
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 */

#include <stdio.h>
#include <time.h>
#ifndef NEWS
  #include <malloc.h>
#endif
#include "config.h"
#include "LR.h"

#define MAXVN		MAXSYMBOLS  /* Must be a prime number. */
#define EOR		(-1)        /* End of rules            */

long     cputime ( ) ;

cpm(max)
int max;
{
    register int    i, n, m;
    register Action *p, *q;
    int      ndel=0;
    int      state, ruleno, length, rhs;
	
    for(n = 0; n < max; n++){
	tmp[n] = (StateInfo *)malloc(sizeof(StateInfo));
	if( tmp[n] == NULL)	
	  fatal_error("Error malloc()\n");
	tmp[n]->pre_symbol = -1;
	tmp[n]->num_prestate = 0;
    }	    
    tmp[0]->pre_symbol = 0;
    tmp[0]->num_prestate = 1;

    printf("\n0. ");
    count_LR(max);

    printf("Modify LR table by CPM\n");

    for(n = 0; n < max; n++)
      {
	  if(ActionTable[n] == NULL)
	    continue;

	  for(p = ActionTable[n]; p != NULL; p = p->next)
	    {
		if(IsSHIFT(p->action)) {
		    
		    m = SHIFT(p->action);
		    
		    for(q = ActionTable[m]; q != NULL; q = q->next)
		      if(ConnectMatrix(p->input, q->input) == 0)
			DeleteAct(m,q);
		    if( ActionTable[m] == NULL)
		      DeleteAct(n,p);
		    else {
			if( tmp[m]->pre_symbol != p->input &&
			   tmp[m]->pre_symbol != -1)
			  tmp[m]->pre_symbol = -10;
			else	
			  tmp[m]->pre_symbol = p->input;
			tmp[m]->num_prestate++;
		    }
		}else if(IsGOTO(p->action)) {
		    
		    m = GOTO(p->action);

		    for(q = ActionTable[m]; q != NULL; q = q->next)
		      if(!nonterminal(q->input) &&
			 ConnectMatrix(p->input, q->input) == 0)
			DeleteAct(m,q);
		    if( ActionTable[m] == NULL){
/*
 		        printf("(%d %s go%d\n", n, SymbolTable[p->input], m);
*/			
			DeleteAct(n,p);
		    }
		    else {
			if( tmp[m]->pre_symbol != p->input &&
			   tmp[m]->pre_symbol != -1)
			  tmp[m]->pre_symbol = -10;
			else	
			  tmp[m]->pre_symbol = p->input;
			tmp[m]->num_prestate++;
		    }
		}
	    }
      }

    printf("1. ");
    count_LR(max);

    for(n=1; n < max; n++) {
	if(tmp[n]->num_prestate != 0){
	    tmp[n]->prestate =
	      (int *)malloc(tmp[n]->num_prestate * sizeof(int));
	    if(tmp[n]->prestate == NULL){
		printf("Out of memory.\n");
		exit();
	    }
	}
    }

    regulation(max);

    suc_state(max);
    pro_state(max);

    while(1) {

	ndel = 0;

	for( n = 1; n < max; n++){

	    if( tmp[n]->num_prestate == 0)
	      ActionTable[n] = NULL;

	    if(ActionTable[n] == NULL)
	      continue;

	    for( p = ActionTable[n]; p != NULL; p = p->next){

		if(IsREDUCE(p->action) &&
		   p->input != HashSymbol("$")) {

		    ruleno = REDUCE(p->action);

		  /* check the next state */

		    if( exist_next(n, p->input, ruleno) == 0) {

			DeleteAct(n,p);
			ndel++;
		    }else if(nonterminal(tmp[n]->pre_symbol)) {
		      
		      /* check the previous state */
			if( exist_ahead(n, p->input) == 0) {
			    DeleteAct(n,p);
			    ndel++;
			}
		    }
		}else if(IsSHIFT(p->action) && 
			 nonterminal(tmp[n]->pre_symbol)){

		    /* check the previous state */

		    if( exist_ahead(n, p->input) == 0) {
			DeleteAct(n,p);
			ndel++;
		    }
		}
	    }
	}
/*	count_LR(max);*/
	if(ndel == 0 && regulation(max) == 0)
	  break;
/*	else
	  printf("ndel = %d\n", ndel);*/
    }
    
    n=0;
    while(hikaku(max) != 0){
	n++;
    }

    printf("2. ");
    count_LR(max);
}

suc_state(max)
int     max;
{
    int  n;
    Action *p;
    Constate   *newstate, *r, *q;
    
    for ( n = 0; n < max; n++) {
	
	tmp[n]->sucstate = NULL;

	if( ActionTable[n] == NULL)
	  continue;
	
	for( p = ActionTable[n]; p != NULL; p = p->next){

	    if(IsREDUCE(p->action)) {
	    
		for( q = tmp[n]->sucstate; q != NULL; q = q->next) 
		  if(p->action == q->action)
		    break;
	    
		if( q == NULL) {

		    sucstate(n, p->action, &newstate);
		    
		    for( r = tmp[n]->sucstate; r != NULL; r = r->next)
		      if( r->next == NULL)
			break;
		
		    if( r == NULL)
		      tmp[n]->sucstate = newstate;
		    else
		      r->next = newstate;
		}
	    }
	}
    }
}


pro_state(max)
int     max;
{
    int  n;
    Constate   *r, *q;
    
    for ( n = 0; n < max; n++) 
      tmp[n]->prostate = NULL;

    for ( n = 0; n < max; n++) {
	
	if(tmp[n]->sucstate == NULL)
	  continue;

	if( ActionTable[n] == NULL)
	  continue;
	
	for( q = tmp[n]->sucstate; q != NULL; q = q->next) {

	    r = (Constate *)malloc(sizeof(Constate));
	    if( r == NULL) {
		printf("No memory for r!\n");
		exit();
	    }

	    r->action = q->action;
	    r->state = n;
	    r->next = tmp[q->state]->prostate;
	    tmp[q->state]->prostate = r;

	}
    }
}

int sucstate(status, action, newstate)
int        status;
int        action;
Constate   **newstate;
{
    int     i, j;
    Chain   *p, *q, *t1, *t2, *t;
    int     length;
    Action  *p1, *p2;
    Constate *r;

    length = GrammarTable[REDUCE(action)]->length;
/*
    printf("ruleno=%d length=%d\n",
	   REDUCE(action), length);
*/
    p = (Chain *) malloc(sizeof(Chain));

    if( p == NULL){
	printf("No memory for p!\n");
	exit();
    }
    p->data = status;
    p->next =  NULL;

    for( i = 0; i < length; i++) {

        t = NULL;

        for( q = p; q != NULL; q = q->next) {

	    if(tmp[q->data]->num_prestate == 0) {
		printf("q->data = %d\n", q->data);
		exit();
	    }

            for( j = 0; j < tmp[q->data]->num_prestate; j++) {

                t1  = (Chain *) malloc(sizeof(Chain));
		if( t1 == NULL){
		    printf("No memory for t1!\n");
		    exit();
		}
                t1->data = tmp[q->data]->prestate[j];
                t1->next = t;
                t = t1;
            }
        }
	for( t1 = p; t1 != NULL; t1 = t2) {
	    t2 = t1->next;
	    free(t1);
	}
        p = t;
    }

    *newstate = NULL;
    for( q = p; q != NULL; q = q->next) 
      for( p1 = ActionTable[q->data]; p1 != NULL; p1 = p1->next)
	if( p1->input == GrammarTable[REDUCE(action)]->lhs) {

	    r = (Constate *)malloc(sizeof(Constate));
	    if( r == NULL) {
		printf("No memory for r!\n");
		exit();
	    }
	    r->action = action;
	    r->state = GOTO(p1->action);
	    r->next = *newstate;
	    *newstate = r;

    }

    for( t1 = p; t1 != NULL; t1 = t2) {
	t2 = t1->next;
	free(t1);
    }
}


int exist_next(n, input, ruleno)
int      n, input;
int      ruleno;
{
    int  i, j;
    int  state;
    Constate *r;
    Action   *p;

    if(tmp[n]->sucstate == NULL)
      return (0);

    for( r = tmp[n]->sucstate; r != NULL; r = r->next) {
	if( REDUCE(r->action) == ruleno ) {
	    state = r->state;
	    for( p = ActionTable[state]; p != NULL; p = p->next) 
	      if(p->input == input) {
		  return (1);
	      }
	}
    }
    return (0);
}


int exist_ahead(n, input)
int      n, input;
{
    int  i, j;
    int  state;
    Constate *r;
    Action   *p;

    if(tmp[n]->prostate == NULL)
      return (0);

    for( r = tmp[n]->prostate; r != NULL; r = r->next) {
	state = r->state;
	for( p = ActionTable[state]; p != NULL; p = p->next) 
	  if(p->input == input &&
	     r->action == p->action ) {
	      return (1);
	  }
    }
    return(0);
}

int regulation(max)
int max;
{
    int     n, i, k;
    int     st, ndel=0;
    int     result = 0;
    Action  *p;

    /* regulation of LR table */

    while(1){

	for(n = 0; n < max ; n++)
	  tmp[n]->num_prestate = 0;
	tmp[0]->num_prestate = 1;
	
	ndel = 0;

	for(n = 0; n < max ; n++){
	    
	    if(ActionTable[n] == NULL)
	      continue;

	    k = 0;
	    for(p = ActionTable[n]; p != NULL; p = p->next){

		if( IsGOTO(p->action)){ /* goto */
		    if(ActionTable[GOTO(p->action)] == NULL){ 
			DeleteAct(n,p);
			ndel++;
			result++;
		    }else{
			st = GOTO(p->action);
			tmp[st]->prestate[tmp[st]->num_prestate++] = n;
			tmp[st]->pre_symbol = p->input;
			k++;
		    }
		}else if( IsSHIFT(p->action)){ /* shift */
		    if(ActionTable[SHIFT(p->action)] == NULL){
			DeleteAct(n,p);
			ndel++;
			result++;
		    }else{
			st = SHIFT(p->action);
			tmp[st]->prestate[tmp[st]->num_prestate++] = n;
			tmp[st]->pre_symbol = p->input;
			k++;
		    }
		}else if( IsREDUCE(p->action)){ /* reduce */
		    k++;
		}else if( IsACCEPT(p->action)){ /* accept */
		    k++;
		}
	    }
	    if(k == 0) {
		ActionTable[n] = NULL;
	    }
	}
	
	for(n = 1; n < max; n++){
	    if( ActionTable[n] == NULL)
	      continue;
	    if( tmp[n]->num_prestate == 0){
		ActionTable[n] = NULL;
		ndel++;
		result++;
	    }
	}
	if(ndel == 0 )
	    break;
    }
/*    count_LR(max);*/
    return result;
}

int hikaku(max)
int 	max;
{
    int     n, m;
    int     new[MAXSTATES];
    int     result=0;
    Action  *p1, *p2;

    for(n = 0; n < max ; n++)
      new[n] = n;

    for(n = 0; n < max ; n++){
	if(ActionTable[n] == NULL)
	  continue;
	for(m = n+1; m < max ; m++){
	    if(ActionTable[m] == NULL)
	      continue;
	    
	    p1 = ActionTable[n];
	    p2 = ActionTable[m];

	    while( p1 != NULL && p2 != NULL) {
		if ((p1->input == p2->input)
		    && (p1->action == p2->action)){
		    p1 = p1->next;
		    p2 = p2->next;
		}else {
		    break;
		}
	    }
	    
	    if(p1 == NULL && p2 == NULL){
		new[m] = n;
		printf("m=%d n=%d\n", m,n);
		ActionTable[m] = NULL;
		result++;
	    }
	}
    }
    
    for(n = 0; n < max ; n++)
      for(p1 = ActionTable[n]; p1 != NULL; p1 = p1->next) {

	  /* shift action */
		
	  if( IsSHIFT(p1->action)) {
	      p1->action = new[p1->action];
	  } 
		
	  /* goto */

	  if( IsGOTO(p1->action)) {
	      p1->action = MAXSTATES + new[p1->action - MAXSTATES];
	  } 
      }
    return result;
}
		    
DeleteAct(n, p)
int n;
Action *p;
{
    Action *q;

    if(ActionTable[n] == p) {
	ActionTable[n] = p->next;
    }else {
	q = ActionTable[n];
	while( q->next != p) {
	    q = q->next;
	}
	q->next = p->next;
    }
}


count_LR(max)
int max;
{
    Action *p;
    int    n;
    int    numshift=0, numreduce=0, numgoto=0, numstate=0;

    for(n = 0; n < max; n++)
      {
	  if(ActionTable[n] == NULL){
/*	      printf("null state= %d\n", n); */
	      continue;
	  }
	  numstate++;
	  for(p = ActionTable[n]; p != NULL; p = p->next)
	    {
		if(IsSHIFT(p->action)) 
		  numshift++;
		else if(IsREDUCE(p->action)) 
		  numreduce++;
		else if(IsGOTO(p->action)) 
		  numgoto++;
	    }
      }

    printf("state= %d  shift= %d  reduce= %d  goto= %d\n\n",
	   numstate, numshift, numreduce, numgoto);
	   
}
