/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     connect.c --- generating allophone connection matrix
 *     ~~~~~~~~~     from allophone map
 *
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#include        <stdio.h>
#include        <ctype.h>
#include        "LR.h"
#include        "config.h"


Ftable *ConnectTable[MAXSYMBOLS];
/*extern int SilTable[MAXSYMBOLS];*/

InitConnect()
{
    register int	i;
    Ftable	        *p;
    char	        *malloc();

    for(i = 0; i < MAXSYMBOLS; i++)
      {
	  if(SymbolTable[i] == NULL)
	    continue;

	  if((p = (Ftable *)malloc(sizeof(Ftable))) == NULL)
	    fatal_error("No memory.\n");
	  ConnectTable[i] = p;
	  ConnectTable[i]->size = 0;
	  ConnectTable[i]->flg = 0;
      }
}

static reigaisyori(left, right)
int left, right;
{
    if ( right == HashSymbol("$")) return (1);
    return(0);
}

ConnectMatrix(left, right)
int left, right;
{
    int i, size;

    if (ConnectTable[left] == NULL) {
      return (0);
    }
    size = ConnectTable[left]->size;
    for (i = 0; i < size; ++i)
      if (ConnectTable[left]->set[i] == right) return (1);
    return (0);
}
    

#define   MAXBUFF      2048
InstallConnect(sorted_map_file)
char *sorted_map_file;
{
    int     i, j, k, l, nt, nl, nr, len, IP;
    int     num_triphone, num_phone;
    int     left, right;
    char    temp[100];
    char    lp[10], rp[10], tri0[20], tri[20];
    char    phn[10], ac0[10];
    char    buf[MAXBUFF];
    char    triphone[MAXALLOPHONES][20], phone[MAXPHONES][10];
    char    left_phone[MAXALLOPHONES][MAXPHONES][10];
    char    right_phone[MAXALLOPHONES][MAXPHONES][10];

    FILE    *fp;

/*
    strcpy(sorted_map_file, "allophone_map");
*/

    /* fp: allophone_map file */
    
    if((fp = fopen(sorted_map_file, "r"))==NULL){
	printf("file %s can't opened\n", sorted_map_file);
	exit();
    }


    InitConnect();

    /*  construct phone and tripone */
    
    for(i = 0; i < MAXALLOPHONES; i++)
      for(j = 0; j < MAXPHONES; j++){
        strcpy(left_phone[i][j], "*");
        strcpy(right_phone[i][j], "*");
      }

    num_triphone = 0;
    num_phone = 0;

    strcpy(tri0, " ");
    strcpy(phn, " ");

    while(fgets(buf, MAXBUFF, fp) != NULL){

	if(buf[0] == ';')
	  continue;

	sscanf(buf,"%s %s",tri, temp);

	if(strcmp(tri,tri0) != 0){
	    strcpy(triphone[num_triphone], tri);
	    nt = num_triphone++;
	    nl = 0;
	    nr = 0;
	}

	strcpy(tri0, tri);

	len = strlen(temp);
	/* center phone of triphone */
	for(i = 0; i < len; i++)
	  if(temp[i] == '=')
	    break;
	  else
	    phn[i] = temp[i];
	phn[i] = '\0';
	k = i + 1;

	for(i=0; i < num_phone; i++)
	  if(strcmp(phone[i], phn) == 0)
	    break;

        if(i == num_phone)
          strcpy(phone[num_phone++],phn);


        /* left phone of triphone */
        for(i = k; i < len; i++)
          if(temp[i]=='_')
            break;
          else
            lp[i - k] = temp[i];
        lp[i - k] = '\0';
        k = i + 1;

        for(i=0; i < num_phone; i++)
          if(strcmp(phone[i], lp) == 0)
            break;
        if(i == num_phone)
          strcpy(phone[num_phone++], lp);

        /* right phone of triphone */
        for(i = k; i < len; i++)
          if(temp[i]=='\0')
            break;
          else
            rp[i - k] = temp[i];
        rp[i - k] = '\0';

        for(i=0; i < num_phone; i++)
          if(strcmp(phone[i], rp) == 0)
            break;
        if(i == num_phone)
          strcpy(phone[num_phone++], rp);
      
        /* check the left phone set of this triphone */

        IP = 1;
        for(i = 0; i < nl; i++)
          if(strcmp(left_phone[nt][i], lp) == 0){
              IP = 0;
              break;
	  }
        if(IP == 1){
            strcpy(left_phone[nt][nl],lp);
            nl ++;
	}

        /* check the right phone set of this triphone */

        IP = 1;
        for(i = 0; i < nr; i++)
          if(strcmp(right_phone[nt][i], rp) == 0){
	      IP = 0;
	      break;
          }
        if(IP == 1){
	    strcpy(right_phone[nt][nr], rp);
	    nr ++;
        }
    }
#if EXAMPLE
    strcpy(triphone[num_triphone++],"silb0");
    strcpy(triphone[num_triphone++],"sile0");
#endif
    printf("num_triphone= %d \nnum_phone= %d\n",
	   num_triphone, num_phone);

#if EXAMPLE
    /* Processing of pause */

    for( i = 0; i < num_triphone; i++){
      if(strcmp(triphone[i], "silb0") == 0){
        k = 0;
        for( j = 0; j < num_phone; j++)
          if(strcmp(phone[j],"silb0") != 0 &&
             strcmp(phone[j],"sile0") != 0){
            strcpy(right_phone[i][j],phone[k]);
            k++;
          }
      }
      if(strcmp(triphone[i], "sile0") == 0){
        k = 0;
        for( j = 0; j < num_phone; j++)
          if(strcmp(phone[j],"silb0") != 0 &&
             strcmp(phone[j],"sile0") != 0){
            strcpy(left_phone[i][j],phone[k]);
            k++;
          }
      }
    }
#endif
    
    for(i = 0; i < num_triphone; i++){
	strcpy(temp, triphone[i]);
	len = strlen(temp);
	for(k=0; k < len; k++)
	  if(!isdigit(temp[k]))
	    lp[k] = temp[k];
	  else
	    break;
	lp[k] = '\0';
      
	if (strcmp(lp,"sil") == 0) {

	    left = 0;
	    right = 0;

	    for(k = 0; k < num_phone; k++) {
		if(strcmp(left_phone[i][k], "*") == 0)
		  break;
		if(strcmp(left_phone[i][k], "sil") ==  0){
		    left = 1;
		    break;
		}
	    }

	    for(k = 0; k < num_phone; k++) {
		if(strcmp(right_phone[i][k], "*") == 0)
		  break;
		if(strcmp(right_phone[i][k], "sil") ==  0){
		    right = 1;
		    break;
		}
	    }
	}
    }

    /* generating connection matrix between adjacent triphone */
    
    for(i = 0; i < num_triphone; i++)
      for( j = 0; j < num_triphone; j++){

	  strcpy(lp,"");
	  strcpy(rp,"");
	  strcpy(temp, triphone[i]);
	  len = strlen(temp);
	  for(k=0; k < len; k++)
	    if(!isdigit(temp[k]))
	      lp[k] = temp[k];
	    else
	      break;
	  lp[k] = '\0';

	  strcpy(temp, triphone[j]);
	  len = strlen(temp);
	  for(k=0; k < len; k++)
	    if(!isdigit(temp[k]))
	      rp[k] = temp[k];
	    else
	      break;
	  rp[k] = '\0';

	  left = 0;
	  for(k = 0; k < num_phone; k++){
	      if(strcmp(left_phone[j][k], lp) == 0){
		  left = 1;
		  break;
	      }else if(strcmp(left_phone[j][k], "*") == 0)
		break;
	  }

	  right = 0;
	  for(k = 0; k < num_phone; k++){
	      if(strcmp(right_phone[i][k], rp) == 0){
		  right = 1;
		  break;
	      }else if(strcmp(right_phone[i][k],"*") == 0)
		break;
	  }

	  if(right == 1 && left == 1){
	      int lefthash, righthash;

	      lefthash = InstallSymbol(&triphone[i][0]);
	      
	      righthash = InstallSymbol(&triphone[j][0]);

	      add_symbol(ConnectTable, lefthash, righthash);
	  }
      }

    for(i = 0; i < num_phone; i++)
      for( j = 0; j < num_triphone; j++){

	  left = 0;
	  for(k = 0; k < num_phone; k++){
	      if(strcmp(left_phone[j][k], phone[i]) == 0){
		  left = 1;
		  break;
	      }else if(strcmp(left_phone[j][k], "*") == 0)
		break;
	  }

	  if( left == 1){

	      int lefthash, righthash;
	      strcpy(phn,"<_");
	      strcat(phn, phone[i]);
	      strcat(phn,">");
	      
	      lefthash = InstallSymbol(&phn[0]);

	      righthash = InstallSymbol(&triphone[j][0]);

	      add_symbol(ConnectTable, lefthash, righthash);
	  }
      }

    for(i = 0; i < num_triphone; i++)
      for( j = 0; j < num_phone; j++){

	  right = 0;
	  for(k = 0; k < num_phone; k++){
	      if(strcmp(right_phone[i][k], phone[j]) == 0){
		  right = 1;
		  break;
	      }else if(strcmp(right_phone[i][k], "*") == 0)
		break;
	  }

	  if( right == 1){

	      int lefthash, righthash;

	      strcpy(phn,"<_");
	      strcat(phn, phone[j]);
	      strcat(phn,">");
	      
	      lefthash = InstallSymbol(&triphone[i][0]);
	      righthash = InstallSymbol(&phn[0]);

	      add_symbol(ConnectTable, lefthash, righthash);
	  }
      }

    fclose(fp);
}



InstallConnect2()
{
    int  i, j, k, m=0;
    int  *left, *right;
    int  size;
    
    for(i = 0; i < MAXSYMBOLS; i++) {

	if(SymbolTable[i] == NULL)
	  continue;

	if(nonterminal(i)) { /* nonterminal */

	    size = Last(i, &left);

	    for ( j = 0; j < MAXSYMBOLS; j++) {
		if( SymbolTable[j] == NULL || nonterminal(j))
		  continue;

		for( k = 0; k < size; k++)
		    if(ConnectMatrix(left[k], j) == 1)
			break;
		if(k != size)
		    add_symbol(ConnectTable, i, j);
	    }
	}else{  /* terminal */

	    if( i == HashSymbol("$"))
	      continue;


	    for ( j = 0; j < MAXSYMBOLS; j++) {
		if( SymbolTable[j] == NULL || !nonterminal(j))
		  continue;

		size = First(j, &right);

		for( k = 0; k < size; k++)
		  if(ConnectMatrix(i, right[k]) == 1)
		    break;
		if( k != size)
		  add_symbol(ConnectTable, i, j);
	    }
	}
    }
}


#ifndef MAKE_ALLOPHONE_CONNECT
ReadConTable(connect_file)
char *connect_file;
{
    char    buf0[1024], buf[1024];
    int     left, right;
    FILE    *fp;

    /* fp: connect_matrix file */
    
    if((fp = fopen(connect_file, "r"))==NULL){
	printf("file %s can't opened\n", connect_file);
	exit();
    }

    InitConnect();

    strcpy(buf0, "*");

    while(fscanf(fp,"%s",buf) != EOF) {

	if(strcmp(buf, "*") == 0 ||
	   strcmp(buf, ":") == 0) {
	    strcpy(buf0, buf);
	    continue;
	}

	if(strcmp(buf0, "*") == 0) {
	    left = InstallSymbol(buf);
	}else if(strcmp(buf0, ":") == 0) {
	    if(strcmp(buf, "*") == 0)
	      continue;
	    else				
	      right = InstallSymbol(buf);

	    add_symbol(ConnectTable, left, right);
	}else{
	    right = InstallSymbol(buf);
	    add_symbol(ConnectTable, left, right);
	}
	strcpy(buf0, buf);
    }
}
#endif
