/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     WriteLR.c  ---  write LR parsing table to file.
 *     ~~~~~~~~~
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#include <stdio.h>
#include <ctype.h>
#include "config.h"
#include "LR.h"


WriteLR_cpm(fp,max)
int 	max;
FILE    *fp;
{
    int     n, state=0;
    int     numreduce=0, numshift=0, numgoto=0;
    int     pack[MAXSTATES];
    Action  *p;
    
    state = 0;
    for(n = 0; n < max ; n++)
	if(ActionTable[n] != NULL){
	    pack[n] = state;
	    state ++;
	}else
	    pack[n] = -1;
    
    fprintf(stderr, "[%d states]\n", state);

    for(n = 0; n < max ; n++){
	if(pack[n] != -1)
	    fprintf(fp,"(%d",pack[n]);
	for(p = ActionTable[n]; p != NULL; p = p->next){
	    
	    /* shift action */
		
	    if( IsSHIFT(p->action)) {
		fprintf(fp," (%s s%d)",
			SymbolTable[p->input],
			pack[p->action]);
		numshift++;
	    } 
		
	    /* reduce action */
	    
	    if( IsREDUCE(p->action)) {

		fprintf(fp," (%s r%d)",
			SymbolTable[p->input],
			REDUCE(p->action));
		numreduce++;
	    } 
	    
	    /* accept */
		
	    if( IsACCEPT(p->action)) {

		fprintf(fp," (%s a)",
			SymbolTable[p->input]);
	    } 
	    
	    /* goto */

	    if( IsGOTO(p->action)) {
		if(pack[GOTO(p->action)] != -1)
		    fprintf(fp," (%s g%d)",
			    SymbolTable[p->input],
			    pack[GOTO(p->action)]);
		numgoto++;
	    } 
	}
	if(pack[n] != -1)
	    fprintf(fp,")\n");
    }
}

