/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     WriteLR.c  ---  write LR parsing table to file.
 *     ~~~~~~~~~
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#include <stdio.h>
#include <ctype.h>
#include "config.h"
#include "LR.h"

WriteLR(fp, max)
int	max;
FILE	*fp;
{
	register int	n;
	register Action	*p;

	fprintf(fp, "(clr-table)\n");
	for(n = 0; n < max; n++)
	{
	    if(ActionTable[n] == NULL)
		continue;
	    fprintf(fp, "(");
	    fprintf(fp, "%d", n);
	    for(p = ActionTable[n]; p != NULL; p = p->next)
	    {
		if(IsACCEPT(p->action))
		{
		    fprintf(fp, " (%s a", SymbolTable[p->input]);
#if STOCHASTIC_LR
		    fprintf(fp, " %lf", p->prob);
#endif
		    fprintf(fp, ")");
		}
	    }

	    for(p = ActionTable[n]; p != NULL; p = p->next)
	    {
		if(IsSHIFT(p->action))
		{
		    fprintf(fp, " (%s s%d",
			SymbolTable[p->input], SHIFT(p->action));
#if STOCHASTIC_LR
		    fprintf(fp, " %lf", p->prob);
#endif
		    fprintf(fp, ")");
		}
	    }

	    for(p = ActionTable[n]; p != NULL; p = p->next)
	    {
		if(IsREDUCE(p->action))
		{
		    fprintf(fp, " (%s r%d",
			SymbolTable[p->input], REDUCE(p->action));
#if STOCHASTIC_LR
		    fprintf(fp, " %lf", p->prob);
#endif
		    fprintf(fp, ")");
		}
	    }

	    for(p = ActionTable[n]; p != NULL; p = p->next)
	    {
		if(IsGOTO(p->action))
		    fprintf(fp, " (%s g%d)",
			SymbolTable[p->input], GOTO(p->action));
	    }
	    fprintf(fp, ")\n");
	}
}
