/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     Read Grammar Rules
 *     ~~~~~~~~~~~~~~~~~~
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#include <stdio.h>
#include <ctype.h>
#include "LR.h"

#define LPAREN		'('
#define RPAREN		')'
#define LBRACE		'{'
#define RBRACE		'}'
#define STAR    	'*'
#define REWRITESYM	"<-->"
#define HALFEN  	":"
#define EOFERROR	"Unexpected EOF.\n"
#define streq(s,t)	(*(s)==*(t) && strcmp(s,t)==0)

#ifdef DEBUG
#include "LR.c"
#include "error.c"


main(argc, argv)
int	argc;
char	*argv[];
{
	FILE	*fp;

	if(argc < 2)
	{
		fprintf(stderr, "Usage: %s Grammar-file\n", argv[0]);
		exit();
	}
	if((fp = fopen(argv[1], "r")) == NULL)
		fatal_error("Cannot open %s\n", argv[1]);
	ReadRules(fp);
	fclose(fp);
	ShowVNTable();
}

#endif

ReadRules(fp)
FILE	*fp;
{
	int	c, nrules = 0, index;
	char	lhs[BUFSIZ/2], rhs[BUFSIZ], buf[BUFSIZ];
	double	freq;

	while(1)
	{
		rhs[0] = NULL;
		if(SkipTo(fp, LPAREN) == EOF)
			break;
		/*
		 * Get LHS of a grammar rule.
		 */
		GetToken(fp, lhs);
		/*
		 * Get rewriting symbol.
		 */
		GetToken(fp, buf);
		if(!streq(buf, REWRITESYM))
			lex_error("Missing or illegal rewriting symbol.\n");
		/*
		 * Get RHS of a grammar rule.
		 */
		if(PeekChar(fp) != LPAREN)
			lex_error("Missing left(open) parenthesis at RHS.\n");
		if(SkipTo(fp, LPAREN) == EOF)
			lex_error(EOFERROR);
		while(1)
		{
			GetToken(fp, buf);
			strcat(rhs, buf);
			if(PeekChar(fp) == RPAREN)
				break;
			strcat(rhs, " ");
		}
		if(SkipTo(fp, RPAREN) == EOF)
			lex_error(EOFERROR);
		if(PeekChar(fp) != RPAREN)
			lex_error("Missing rule-close parenthesis.\n");
		if(SkipTo(fp, RPAREN) == EOF)
			lex_error(EOFERROR);

		index = InstallGrammar(lhs, rhs, freq);

		InstallVN(lhs, index);

		++nrules;
	}
	return(nrules);
}



Ftable *ConnectTable[MAXSYMBOLS];
ReadConnect(fp)
FILE	*fp;
{
	int     i, j, left, right;
	char	lhs[BUFSIZ/2], rhs[BUFSIZ];
	char    *malloc();
	char    ca[2];
	Ftable  *p;


	while(1)
	{
		rhs[0] = NULL;

		/*
		 * Get LHS of a connect table.
		 */

		GetToken(fp, lhs);
		left = HashSymbol(lhs);

		if((p = (Ftable *)malloc(sizeof(Ftable))) == NULL)
		  fatal_error("No memory.\n");

		ConnectTable[left] = p;
		ConnectTable[left]->size = 0;
		ConnectTable[left]->flg = 0;

		/*
		 * Get HALFEN symbol.
		 */

		GetToken(fp, rhs);
		if(!streq(rhs, HALFEN))
		  lex_error("Missing or illegal rewriting symbol.\n");

		/*
		 * Get RHS of a connect table.
		 */

		i = 0;
		while(1)
		  {
		      GetToken(fp, rhs);

		      if(strcmp(rhs, "*") == 0)
			break;
		      
		      right = HashSymbol(rhs);
		      add_symbol(ConnectTable, left, right);
		  }

		if(SkipSpace(fp) == EOF)
		  break;
		
	}
}

