/* Copyright (C) 1996    Kenji Kita */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     Header File for LR
 *     ~~~~~~~~~~~~~~~~~~
 *     Edit by Kenji Kita.
 *       ATR Interpreting Telephony Research Laboratories.
 *       Knowledge and Database Department.
 *
 *     Edit History
 *     ~~~~~~~~~~~~
 *      23-Jun-1988, First version implemented.
 *      23-Aug-1988, Rule structure modified.
 *
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#define FALSE		0
#define TRUE		1
#define MAXSYMBOLS	9091	/* Must be a prime number. */
#define MAXPHONES	43
#define MAXALLOPHONES	2048
#define MAXGRAMMARS	10000
#define MAXSTATES       20000
#define MAXPCAT		32
#define EOS		(-1)
#define ACCEPT		(-2)
#define IsREDUCE(n)	(n >= 2*MAXSTATES && n < 3*MAXSTATES ? 1 : 0) 
#define IsSHIFT(n)	(n >= 0 && n < MAXSTATES ? 1 : 0)
#define IsGOTO(n)	(n >= MAXSTATES && n < 2*MAXSTATES ? 1 : 0)
#define IsACCEPT(n)	(n == ACCEPT ? 1 : 0)
#define REDUCE(n)	((n)-2*MAXSTATES)
#define SHIFT(n)	(n)
#define GOTO(n)		((n)-MAXSTATES)

typedef struct Rule
{
	int	length;		/* Length of RHS */
	int	lhs;
	int	*rhs;
}	Rule;

typedef struct Action
{
	int	input;
	int	action;
	struct Action	*next;
}	Action;

typedef struct Chain
{
	int	data;
	struct  Chain	*next;
}Chain;

typedef struct Constate
{
        int     action;
        int     state;
	struct  Constate    *next;
} Constate;

typedef struct StateInfo
{
        int     pre_symbol;
        int     num_prestate;
        int     *prestate;
	Constate *sucstate;
	Constate *prostate;
} StateInfo;

typedef struct _Ftable
{
	char	flg;
	int	*set;
	int	size;
} Ftable;

#ifndef LR_MAIN
extern
#endif
Rule	*GrammarTable[MAXGRAMMARS];

#ifndef LR_MAIN
extern
#endif
Action	*ActionTable[MAXSTATES];

#ifndef LR_MAIN
extern
#endif
StateInfo  *tmp[MAXSTATES];

#ifndef LR_MAIN
extern
#endif
char	*SymbolTable[MAXSYMBOLS];

#ifndef LR_MAIN
extern
#endif
Ftable *ConnectTable[MAXSYMBOLS];

#ifndef LR_MAIN
extern
#endif
int NumRules;
#ifndef LR_MAIN
extern
#endif

/*int SilTable[MAXSYMBOLS];*/





