/* Copyright (C) 1996   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 *     LR Table Handling Functions
 *     ~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

#define LR_MAIN		1

#include <stdio.h>
#include "LR.h"

init_LR()
{
	register int	i;

	if(!isprime(MAXSYMBOLS))
		fatal_error("Bad hash size.\n");
	for(i = 0; i < MAXSYMBOLS; i++)
		SymbolTable[i] = NULL;
	for(i = 0; i < MAXGRAMMARS; i++)
		GrammarTable[i] = NULL;
	for(i = 0; i < MAXSTATES; i++)
		ActionTable[i] = NULL;
}

isprime(n)
int	n;
{
	register int	i;

	for(i = 2; i < n/2; i++)
	{
		if(!(n % i))
			return(FALSE);
	}
	return(TRUE);
}

GotoState(state, lhs)
int	state, lhs;
{
	register Action	*p;
	register int	*i, n;

	for(p = ActionTable[state]; p != NULL; p = p->next)
	{
		if(p->input == lhs)
			return(GOTO(p->action));
	}
	fatal_error("Cannot find goto state. (state=%d, LHS=%s)\n",
	  state, SymbolTable[lhs]);
}

InstallGrammar(left, right, prob)
char	*left, *right;
double	prob;
{
	static int	curptr = 0;
	register int	i, *n;
	register char	*p, *q;
	char	work[64], *malloc();
	Rule	*rp;

	if(curptr > MAXGRAMMARS - 1)
		fatal_error("Grammar too large. Modify MAXGRAMMARS.\n");

	for(i = 0, p = right; *p != NULL; p++)
	{
		if(*p == ' ')
			++i;
	}
	if((rp = (Rule *)malloc(sizeof(Rule))) == NULL)
		fatal_error("No memory for cfg rule.\n");
	if((n = rp->rhs = (int *)malloc((i+2)*sizeof(int))) == NULL)
		fatal_error("No memory for cfg rule.\n");

	rp->length = i + 1;
	rp->lhs = InstallSymbol(left);
	p = right;
	q = work;
	while(1)
	{
		if(*p == ' ' || *p == NULL)
		{
			*q = NULL;
			*n++ = InstallSymbol(work);
			q = work;
		}
		else
			*q++ = *p;
		if(*p == NULL)
			break;
		++p;
	}
	*n = EOS;
	GrammarTable[curptr++] = rp;
	return(curptr-1);
}

InstallAction(state, input, action)
int	state;
char	*input;
int	action;
{
	char	*malloc();
	Action	*p, *q;

	if(state > MAXSTATES - 1)
	{
		error("LR table too large. Modify MAXSTATES. state = %d\n", state);
		return;
	}

	if((p = (Action *)malloc(sizeof(Action))) == NULL)
		fatal_error("No memory for action.\n");
	p->input = InstallSymbol(input);
	p->action = action;
	p->next = NULL;

	if(ActionTable[state] == NULL)
		ActionTable[state] = p;
	else
	{
		for(q = ActionTable[state]; q->next != NULL; q = q->next)
			;
		q->next = p;
	}
}

InstallGoto(state, input, g_state)
int	state;
char	*input;
int	g_state;
{
	InstallAction(state, input, g_state);
}

CheckGrammar()
{
	register int	i, j, *k, *l;
	int	errs = 0;

	for(i = 0; GrammarTable[i] != NULL; i++)
	{
		for(j = i + 1; GrammarTable[j] != NULL; j++)
		{
			if(GrammarTable[i]->length != GrammarTable[j]->length
			|| GrammarTable[i]->lhs != GrammarTable[j]->lhs)
				continue;
			for(k = GrammarTable[i]->rhs, l = GrammarTable[j]->rhs;
			 *k != EOS; k++, l++)
			{
				if(*k != *l)
					break;
			}
			if(*k == EOS)
			{
				++errs;
				printf("Duplicate rule: ");
				ShowGrammar(i);
				printf("\n");
			}
		}
	}
	return(errs);
}

ShowGrammarTable()
{
	register int	i;

	for(i = 0; GrammarTable[i] != NULL; i++)
	{
		printf("%d: ", i + 1);
		ShowGrammar(i);
		printf("\n");
	}
}

ShowActionTable()
{
	register int	i;

	for(i = 0; ActionTable[i] != NULL; i++)
	{
		printf("%d: ", i);
		ShowAction(i);
		printf("\n");
	}
}

ShowGrammar(n)	/* Show grammar at GrammarTable[n]. */
int	n;
{
	register int	*p;
	Rule	*rp;

	rp = GrammarTable[n];
	printf("%s --> ", SymbolTable[rp->lhs]);
	for(p = rp->rhs; *p != EOS; p++)
		printf("%s ", SymbolTable[*p]);
	fflush(stdout);
}

ShowAction(n)	/* Show action at ActionTable[n]. */
int	n;
{
	register Action	*p;
	register int	action;

	for(p = ActionTable[n]; p != NULL; p = p->next)
	{
		printf("(%s,", SymbolTable[p->input]);
		action = p->action;
		if(IsACCEPT(action))
			printf("a");
		else if(IsSHIFT(action))
			printf("s%d", SHIFT(action));
		else if(IsREDUCE(action))
			printf("r%d", REDUCE(action));
		else if(IsGOTO(action))
			printf("g%d", GOTO(action));
		else
			fatal_error("Illegal action '%d'.\n", action);
		printf(")");
	}
	fflush(stdout);
}

InstallSymbol(s)
char	*s;
{
	int	index;
	char	*p, *malloc();

	if(SymbolTable[index = HashSymbol(s)] != NULL)
		return(index);
	if((p = (char *)malloc(strlen(s)+1)) == NULL)
		fatal_error("No memory for symbol '%s'.\n", s);
	strcpy(p, s);
	SymbolTable[index] = p;
	return(index);
}

HashSymbol(s)	/* Return index of null slot or index of symbol 's'. */
char	*s;
{
	char	*p;
	int	old_index, index, n;

	for(index = 0, p = s; *p != NULL; )
		index += *p++;
    retry:
	old_index = index = index % MAXSYMBOLS;
	for(n = 0; SymbolTable[index] != NULL; ++n, index = (old_index+n*n) % MAXSYMBOLS)
	{
		if(n != 0 && index == old_index)
		{
		warning("Bad hashsize for SymbolTable. Modify hash size!!!\n");
			++index;
			goto retry;
		}
		if(strcmp(SymbolTable[index], s) == 0)
			break;
	}
	return(index);
}

