/* Copyright (C) 1996   ͵ */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/wait.h>  
#include "dsv.h"
#include "hash.h"
#include "srchdic.h"

#define SERV_TCP_PORT	16010	/* ӥݡȤΥǥե */
#define BUFSIZE		0xffff  /* ХåեΥ */

#define TRUE  1
#define FALSE 0

char *myname;

print_usage()
{
    fprintf(stderr, "Usage: %s [option(s)]\n", myname);
    fprintf(stderr, "          -a  augment information\n");
    fprintf(stderr, "          -m  display debug message\n");
    fprintf(stderr, "          -r  consult EDR (also) by reading\n");
    fprintf(stderr, "          -d  input from STDIN (output to STDOUT)\n");
    fprintf(stderr, "          -h  consult EDR by reading if all entries are j\n");
    fprintf(stderr, "          -k  search katakana as yomi\n");
    fprintf(stderr, "          -p  use paren\n");
    fprintf(stderr, "          -u  output unknown\n");
    fprintf(stderr, "          -l  check word length and output unknown if all are 1 char\n");
    fprintf(stderr, "          -s  save stack information\n");
    fprintf(stderr, "          -w  set path of Word Dictionary\n");
    fprintf(stderr, "          -H  display this message\n");
    exit(-1);
}
  
/* ե뵭һҤnХɤ */
int
readn(fd, ptr, nbytes)
    register int	fd;
    register char	*ptr;
    register int	nbytes;
{
    int		nleft, nread;

    nleft = nbytes;
    while (nleft > 0) {
	nread = read(fd, ptr, nleft);
	if (nread < 0)
	    return(nread);	/* error, return < 0 */
	else if (nread == 0)
	    break;		/* EOF */

	nleft	-= nread;
	ptr	+= nread;
    }
    return(nbytes - nleft);	/* return >= 0 */
}

/* ե뵭һҤnХȽ */

int
writen(fd, ptr, nbytes)
    register int	fd;
    register char	*ptr;
    register int	nbytes;
{
    int		nleft, nwritten;

    nleft = nbytes;
    while (nleft > 0) {
	nwritten = write(fd, ptr, nleft);
	if (nwritten <= 0)
	    return(nwritten);		/* error */

	nleft	-= nwritten;
	ptr	+= nwritten;
    }
    return(nbytes - nleft);
}

/* ե뵭һҤ'\0'ޤɤ߹ */

int
readline(fd, ptr, maxlen)
    register int	fd;
    register char	*ptr;
    register int	maxlen;
{
    int		n;
    char	c;

    for (n = 0; n < maxlen; n++) {
	if ( (read(fd, &c, 1)) == 1) {
	    if (c == '\0') break;	/* end of line? */
	    else	*ptr++ = c;
	} else
	    return(-1);			/* error */
    }
    *ptr = 0;
    return(n);
}

/* ᥤ */

DictPtr *wdpt;            /* ñ켭Υݥ */
unsigned char *bsp;   /*buf_snd[];ؤΥݥ */
int mode_msg = FALSE, mode_rd = TRUE, mode_aug = FALSE;
int mode_hiragana = TRUE, mode_katakana = TRUE;
int mode_kakko = TRUE, mode_unknown = TRUE, mode_length = TRUE;
int mode_reading = FALSE;
int mode_stack = TRUE;
int mode_info = FALSE;
  
int make_exe(char *);
int make_exe1(char *);
void init_hash_table();

main(argc, argv)
int 	argc;
char	*argv[];
{
    char *WDDICT;

    int			sockfd, newsockfd, clilen, childpid;
    struct sockaddr_in	cli_addr, serv_addr;

    int			buflen, port;
    unsigned char	buf_rcv[MAX_SENTENCE_LEN], buf_snd[BUFSIZE];
    int i, mode_dbg = FALSE;

    char *default_dic = "/export/signe/iminasi/ueki/EDR/dic/wd_sys.dic";

    myname = argv[0];
    port = SERV_TCP_PORT;
    WDDICT = NULL;
    
    /* ץν */
    for (i = 1; i < argc; i++) {
	if (argv[i][0] == '-') {
	    switch (argv[i][1]) {
	      case 'm' :
		if (argv[i][2] != '-') {
		  mode_msg = TRUE;
		} else {
		  mode_msg = FALSE;
		}
		break;
	      case 'r' :
		if (argv[i][2] != '-') {
		  mode_rd = TRUE;
		} else {
		  mode_rd = FALSE;
		}
		break;
	      case 'R':
		if (argv[i][2] != '-') {
		  mode_reading = TRUE;
		} else {
		  mode_reading = FALSE;
		}
		break;
	      case 'd' :
		if (argv[i][2] != '-') {
		  mode_dbg = TRUE;
		} else {
		  mode_dbg = FALSE;
		}
		break;
	      case 'a' :
		if (argv[i][2] != '-') {
		  mode_aug = TRUE;
		} else {
		  mode_aug = FALSE;
		}
		break;
	      case 'h' :
		if (argv[i][2] != '-') {
		  mode_hiragana = TRUE;
		} else {
		  mode_hiragana = FALSE;
		}
		break;
	      case 'k' :
		if (argv[i][2] != '-') {
		  mode_katakana = TRUE;
		} else {
		  mode_katakana = FALSE;
		}
		break;
	      case 'p' :
		if (argv[i][2] != '-') {
		  mode_kakko = TRUE;
		} else {
		  mode_kakko = FALSE;
		}
		break;
	      case 'u' :
		if (argv[i][2] != '-') {
		  mode_unknown = TRUE;
		} else {
		  mode_unknown = FALSE;
		}
		break;
	      case 'l' :
		if (argv[i][2] != '-') {
		  mode_length = TRUE;
		} else {
		  mode_length = FALSE;
		}
		break;
	      case 's' :
		mode_stack = TRUE;
		break;
	      case 'w' :
		WDDICT = default_dic;
		break;
	      case 'i' :
		if (argv[i][2] != '-') {
		  mode_info = TRUE;
		} else {
		  mode_info = FALSE;
		}
		break;
	      case 'H' :
		print_usage();
		break;
	      default:
		print_usage();
	    }
	} else {
	    print_usage();
	}
    }

/*    if (argc == 2)	port = atoi(argv[1]);*/	/* ǥݡȤ? */
/*    else		port = SERV_TCP_PORT;*/

    
    /* EDRܸñ켭Υץ*/

    if (mode_info) {
      fprintf(stderr,"open word dictionary ... ");
    }
    if (WDDICT == NULL) {
      if((WDDICT = getenv("EDR_WD_DIC")) == NULL){
	fprintf(stderr, "please set EDR_WD_DIC...\n");
	exit(2);
      }
    }

    if((wdpt = DictOpen(WDDICT)) == NULL){
	fprintf(stderr, "can't open word dictionary 'WDDICT'...\n");
	exit(2);
    }
    if (mode_info) {
      fprintf(stderr,"done\n");
    }

    if (!mode_dbg) {
      /* TCP socketΥץ */

      if (mode_info) {
	fprintf(stderr,"socket open ... ");
      }

      if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	fprintf(stderr, "%d: can't open stream socket.\n", myname);
	exit(1);
      }

      /* 륢ɥ쥹ΥХ */
	
      bzero((char *) &serv_addr, sizeof(serv_addr));
      serv_addr.sin_family	= AF_INET;
      serv_addr.sin_addr.s_addr	= htonl(INADDR_ANY);
      serv_addr.sin_port	= htons(port);

      if (bind(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0) {
	fprintf(stderr, "%s: can't bind local address.\n", myname);
	exit(1);
      }

      listen(sockfd, 5);

      if (mode_info) {
	fprintf(stderr,"done\n");
      }
    }

    if (mode_info) {
      fprintf(stderr,"initialize hash table ... ");
    }
    init_hash_table();
    if (mode_info) {
      fprintf(stderr,"done\n");

      fprintf(stderr,"\nready!\n\n");
    }

    for ( ; ; ) {

	if (mode_dbg) { /* ɸϤ */
	    if (!fgets(buf_rcv, 256, stdin)) {
		break;
	    }
	    if (buf_rcv[0] != '\n') {
	      if (mode_info) {
		fprintf(stdout, "received: %s\n", buf_rcv);
	      }
		bsp = buf_snd;
		if (make_exe(buf_rcv)) {
		  if (mode_info) {
		    fprintf(stdout, "%s", buf_snd);
		  }
		}
	    }
	} else {

	    /* 饤Ȥ³Ԥ */
	
	    clilen = sizeof(cli_addr);
	    newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
	    if (newsockfd < 0) {
		fprintf(stderr, "%s: accept error\n", myname);
		exit(1);
	    }
	    
	    /* ե */
	    
	    if ((childpid = fork()) < 0) {
		fprintf(stderr, "%s: fork error\n", myname);
		exit(1);
	    }

	    if (childpid == 0) {	/* ҥץ */
		close(sockfd);
		
		/* 饤Ȥʸbuf_rcvɤ߹ */
		buflen = readline(newsockfd, buf_rcv, BUFSIZE);
		if (buflen < 0) {
		    fprintf(stderr, "%s: read error.\n", myname);
		    exit(1);
		} else if (buflen > 0) {
		    /* 饤Ȥʸ (ǥХå) */
		  if (mode_info) {
		    fprintf(stdout, "received: %s\n", buf_rcv);
		  }

		    /* buf_rcvȤ̤buf_sndؤޤ */
		    /* ºݤˤϤǷǲϤ */
		    bsp = buf_snd;
		    make_exe((char *)buf_rcv);

		    buflen = strlen(buf_snd);
		    
		    /* stdoutbuf_sndƤ񤭽Ф */
		  if (mode_info) {
		    fprintf(stdout, "%d\n%s\n", buflen, buf_snd);
		  }

		    /* 饤Ȥbuf_sndƤ񤭽Ф */
		    if (writen(newsockfd, buf_snd, buflen) != buflen) {
			fprintf(stderr, "%s: write error.\n", myname);
			exit(1);
		    }
		}
		exit(0);	/* ｪλ */
	    } else {		/* ƥץ */
		int w;

		while (((w = wait(0)) != childpid) && (w != -1));
	    }
	    close(newsockfd);
	}

      }

    DictClose(wdpt);
}

/*
  Local Variables:
  kanji-fileio-code: 3
  End:
*/
