/* Copyright (C) 1996   ͵ */

#include <stdio.h>
#include <ctype.h>
#include "dsv.h"

#define TRUE  1
#define FALSE 0

#define HIRA2_S 0xa2
#define HIRA2_E 0xf3
#define KATA1   0xa5
#define ARABIC1   0xa3    /* ӥ 1byte  */
#define ARABIC2_0 0xb0    /* ӥ 2byte ܤϤ */
#define ARABIC2_9 0xb9    /*                          ޤ */

#define MAX_WORD_LEN 10000

int stage_can_top[MAX_SENTENCE_LEN];

extern unsigned char *bsp;
char buftmp[1024];

extern int mode_rd;
extern int mode_stack;
extern int mode_info;

int consult(char *,int,int *,int *,int *,int *,int *,int *);
int kana2hira(char *,char *);
int numbers(unsigned char *,unsigned char *);

int dakuten[MAX_SENTENCE_LEN]; /* ΰ֤¸ */

int ishira(str)
     char str[];
{
    if (strcmp("", str) <= 0 && strcmp("", str) >= 0)
      return -1;
    else
      return 0;
}


/* ΰ֤򸡽 */
dakuten_check(s)
     char *s;
{
    unsigned char *pt, work[MAX_SENTENCE_LEN], buf[2], kana[4];
    int i, j, len;

    for (i = 0; i < MAX_SENTENCE_LEN; i++) {
	dakuten[i] = 0;
    }
    pt = work;
    strcpy(pt, s),
    pt[strlen(s)] = '\0';
    for (i = 0, j = 0; *pt != '\0'; i++, j++) {
	buf[0] = *pt++;
	buf[1] = *pt++;
	buf[2] = '\0';

	if (buf[0] == KATA1 && buf[1] >= HIRA2_S && buf[1] <= HIRA2_E) {
	  len = kana2hira(buf,buf);
	};

	if (ishira(buf)) {
	  kana[len] = '\0';
	} else {
	  len = 2;
	}
	dakuten[j + 1] = dakuten[j] + len;
    }
    dakuten[j] = -1; /* ʼ */
}

int number_check(sentence)
char *sentence;
{
  unsigned char *s;
  int i;
  int len=0;
  char tmp[15];
  int arabic_len;
  char *kansuuji[] = {"", "", "", "", "",
			"", "ϻ", "", "Ȭ", ""};

  s = (unsigned char *)sentence;

  for (i = 0; s[i] != '\0'; ) {
    if ((arabic_len = numbers(&s[i],tmp)) > 0) {
      if (arabic_len > 1) {
	i += arabic_len*2;
      } else {
	strncpy(&s[i],kansuuji[s[i+1]-ARABIC2_0],2);
	i += 2;
      }
    } else if (isascii(s[i])) {
      if (s[i] != '\n') {
	len++;
      }
      i++;
    } else {
      i += 2;
      len++;
    }
  }

  return(len);
}

int make_exe(sentence)
char *sentence;
{
  int sentence_len, stage, i;
  int min_word_len;
  int last_kanji = 0;  /* Ǥ˼ƤǸδΰ */
  int last_char = 0;   /* Ǥ˼ƤǸʸΰ */
  int flag_katakana = FALSE;  /* Ǥ뤳Ȥɽե饰 */
  int flag_alphabet = FALSE;  /* alphabet Ǥ뤳Ȥɽե饰 */
  int last_j = 0;
  /* Ǥ˽졦ưȤƼƤǸʸΰ */

/*  number_check(sentence);*/

  sentence_len = strlen(sentence) / 2;

  /* stage_can_topν */
  for (i = 0; i <= sentence_len; i++) {
    stage_can_top[i] = 0;
  }

  /* Goal Program for NewSGLRκǽʬ */
  sprintf(buftmp,
	  (mode_stack)?
	  "((S0_0=[[0]],STACKLIST=[S0_0|SL1]," :
	  "(S0_0=[[0]],!,"
	  );
  strcpy(bsp, buftmp);
  bsp += strlen(buftmp);

  /* Goal Program for NewSGLR񤯥ᥤ롼 */
  for (stage = 0; stage < sentence_len; ) {
    consult(sentence, stage, &min_word_len, &last_kanji, &last_char,
	    &flag_katakana, &flag_alphabet, &last_j);

    if (min_word_len == 0 || min_word_len == MAX_WORD_LEN) {
      stage++;
      sentence += 2;
      last_kanji--;
      last_char--;
      last_j--;
    } else {
      stage += min_word_len;
      sentence += min_word_len*2;
      last_kanji -= min_word_len;
      last_char -= min_word_len;
      last_j -= min_word_len;
    }
    if (last_kanji < 0) {
      last_kanji = 0;
    };
    if (last_char < 0) {
      last_char = 0;
    };
    if (last_j < 0) {
      last_j = 0;
    };
  }

  /* Goal Program for NewSGLRκǸʬ */

  /* $פʬ */
  if (mode_stack) {
    sprintf(buftmp,
	    "$(S%d_0,[],TREE-[MINFOREST]),!,SL%d=TREE,SL%d=[S%d_0|SL%d]),MINFOREST,STACKLIST).\n",
	    stage,
	    stage + 1,
	    stage,
	    stage,
	    stage + 1);
  } else {
    sprintf(buftmp, "($(S%d_0,[],TREE-[]),!;true)).\n", stage);
  };
  strcpy(bsp, buftmp);
  bsp += strlen(buftmp);

  return(1);
}
