/* Copyright (C) 1996   ͵ */

#include <stdio.h>
#include "dsv.h"

#define HIRA1   0xa4      /* Ҥ餫ʤ1byte          */
#define HIRA2_S 0xa1      /* Ҥ餫ʤ2byteܤϤ*/
#define HIRA2_E 0xf3      /*                    ޤ*/
#define KATA1   0xa5      /* ʤ 1byte         */
/*  a5f4    a5f5    a5f6 */
#define LONG_VOWEL1 0xa1  /* ֡פ 1byte  */
#define LONG_VOWEL2 0xbc  /* ֡פ 2byte  */
#define ALPHA1   0xa3     /* alphabet  1byte  */
#define ALPHA2_S 0xc1     /* alphabet(capital)  2byte ܤϤ */
#define ALPHA2_E 0xda     /*                                ޤ */
#define ALPHA3_S 0xe1     /* alphabet(small)  2byte ܤϤ */
#define ALPHA3_E 0xfa     /*                              ޤ */
#define ARABIC1   0xa3    /* ӥ 1byte  */
#define ARABIC2_0 0xb0    /* ӥ 2byte ܤϤ */
#define ARABIC2_9 0xb9    /*                          ޤ */


/* ʸsƬʿ̾t֤ 
   s = "٤ʱ"   -->   t = "٤" */

int hira_kana2(s, t)
unsigned char *s, *t;
{
  while(*s != '\0'){
    if ((*s == HIRA1 && *(s+1) >= HIRA2_S && *(s+1) <= HIRA2_E) ||
	(*s == LONG_VOWEL1 && *(s+1) == LONG_VOWEL2)) {
      *t     = *s;
      *(t+1) = *(s+1);
      s += 2;
      t += 2;
    }else
      break;
  }

  *t = '\0';

  return 0;
}

int kata_kana2(s, t)
unsigned char *s, *t;
{
  int len = 0;

  while(*s != '\0'){
    if ((*s == KATA1 && *(s+1) >= HIRA2_S && *(s+1) <= HIRA2_E) ||
	(*s == LONG_VOWEL1 && *(s+1) == LONG_VOWEL2)) {
      *t     = *s;
      *(t+1) = *(s+1);
      s += 2;
      t += 2;
      len++;
    }else
      break;
  }

  *t = '\0';

  return(len);
}

int alphabets(s, t)
unsigned char *s, *t;
{
  int len = 0;

  while(*s != '\0'){
    if (*s == ALPHA1 &&
	((*(s+1) >= ALPHA2_S && *(s+1) <= ALPHA2_E) ||
	 (*(s+1) >= ALPHA3_S && *(s+1) <= ALPHA3_E))) {
      *t     = *s;
      *(t+1) = *(s+1);
      s += 2;
      t += 2;
      len++;
    }else
      break;
  }

  *t = '\0';

  return(len);
}

int small_alphabets(s, t)
unsigned char *s;
unsigned char **t;
{
  int len = 0;
  char tmp[MAX_SENTENCE_LEN];
  char *p;
  int i;

  p = tmp;

  while (*s != '\0') {
    if (*s == ALPHA1) {
      if (*(s+1) >= ALPHA2_S && *(s+1) <= ALPHA2_E) {
	*p = 'A' + *(s+1) - ALPHA2_S;
      } else if (*(s+1) >= ALPHA3_S && *(s+1) <= ALPHA3_E) {
	*p = 'a' + *(s+1) - ALPHA3_S;
      } else {
	break;
      }
      s += 2;
      p++;
      (*t)++;
      len++;
    } else {
      break;
    }
  }

  *p = '\0';

  strncpy(*t,tmp,len);

  return(len);
}

int numbers(s, t)
unsigned char *s, *t;
{
  int len = 0;

  while (*s != '\0') {
    if (*s == ARABIC1 && *(s+1) >= ARABIC2_0 && *(s+1) <= ARABIC2_9) {
      *t = *s;
      *(t+1) = *(s+1);
      s += 2;
      t += 2;
      len++;
    } else {
      break;
    }
  }

  *t = '\0';

  return(len);
}

int knumbers(s, t)
unsigned char *s, *t;
{
  int len = 0;

  while (*s != '\0') {
    if ((*s == 0xce && *(s+1) == 0xed) ||	/*  */
	(*s == 0xa1 && *(s+1) == 0xbb) ||	/*  */
	(*s == 0xb0 && *(s+1) == 0xec) ||	/*  */
	(*s == 0xc6 && *(s+1) == 0xf3) ||	/*  */
	(*s == 0xbb && *(s+1) == 0xb0) ||	/*  */
	(*s == 0xbb && *(s+1) == 0xcd) ||	/*  */
	(*s == 0xb8 && *(s+1) == 0xde) ||	/*  */
	(*s == 0xcf && *(s+1) == 0xbb) ||	/* ϻ */
	(*s == 0xbc && *(s+1) == 0xb7) ||	/*  */
	(*s == 0xc8 && *(s+1) == 0xac) ||	/* Ȭ */
	(*s == 0xb6 && *(s+1) == 0xe5) ||	/*  */
	(*s == 0xbd && *(s+1) == 0xbd) ||	/*  */
	(*s == 0xc9 && *(s+1) == 0xb4) ||	/* ɴ */
	(*s == 0xc0 && *(s+1) == 0xe9)) {	/*  */
      *t = *s;
      *(t+1) = *(s+1);
      s += 2;
      t += 2;
      len++;
    } else {
      break;
    }
  }

  *t = '\0';

  return(len);
}
