/* Copyright (C) 1996   ͵ */

#include <stdio.h>
#include "hash.h"

/* #define HINSI_SAI 808 */
#define HINSI_SAI 723

struct category {
  char *hinsi;
  char *hidari;
  char *migi;
  char *hinsi_sai;
  int used_or_not;
};
extern struct category cat_info[HINSI_SAI];

unsigned int hash(str,entry)
unsigned char *str;
int entry;
{
  unsigned int sum=0;

  for ( ; *str != '\0' ; str++) {
    sum = sum * 129 + *str;
  };
  sum %= entry;

  return sum;
}

void table_init()
{
  int i;

  for (i=0 ; i<HINSHI ; i++) {
    hash_table[i].first = NULL;
    hash_table[i].last = NULL;
  };
}

void make_table(hinsi,start,end)
char *hinsi;
int start,end;
{
  int i;
  struct table_list *table, *first, *last, *new;

  i = hash(hinsi,HINSHI);

  first = table = hash_table[i].first;
  last = hash_table[i].last;

  new = (struct table_list *)malloc(sizeof(struct table_list));
  strcpy(new->hinsi,hinsi);
  new->start = start;
  new->end = end;
  new->next = NULL;

  if (first == NULL) {
    hash_table[i].first = new;
  } else {
    hash_table[i].last->next = new;
  };
    
  hash_table[i].last = new;
}

void init_hash_table()
{
  int i,start;
  char buf[4];
  struct table_list *tmp;

  table_init();
  strcpy(buf,"");

  for (i=0 ; i<HINSI_SAI ; i++) {
    if (cat_info[i].used_or_not == 0) continue;

    if (strcmp(buf,cat_info[i].hinsi) != 0) {
      if (strcmp(buf,"") != 0) {
	make_table(buf,start,i);
      };
      strcpy(buf,cat_info[i].hinsi);
      start = i;
    };
    if (i == HINSI_SAI-1) {
      make_table(buf,start,i+1);
    };
  };
}

struct table_list *search_item(item)
char *item;
{
  int i;
  struct table_list *tmp;

  i = hash(item,HINSHI);
  tmp = hash_table[i].first;

  for ( ; tmp != NULL ; tmp = tmp->next) {
    if (strcmp(tmp->hinsi,item) == 0) break;
  };

  return(tmp);
}
