/* Copyright (C) 1996   ͵ */

#include <stdio.h>
#include "dsv.h"
#include "srchdic.h"

#define TRUE  1
#define FALSE 0

#define HIRA1   0xa4      /* Ҥ餫ʤ1byte          */
#define HIRA2_S 0xa2      /* Ҥ餫ʤ2byteܤϤ*/
#define HIRA2_E 0xf3      /*                    ޤ*/
#define KATA1   0xa5      /* ʤ 1byte         */
#define ARABIC1   0xa3    /* ӥ 1byte  */
#define ARABIC2_0 0xb0    /* ӥ 2byte ܤϤ */
#define ARABIC2_9 0xb9    /*                          ޤ */
#define KANJI1_1_S 0xb0   /* () 1byte ܤϤ */
#define KANJI1_1_E 0xcf   /*                            ޤ */
#define KANJI1_2_S 0xa1   /* () 2byte ܤϤ */
#define KANJI1_2_E 0xfe   /*                            ޤ */
#define KANJI1_2_E2 0xd3  /*  (1byte ܤ 0xcf ΤȤ)ޤ */
#define KANJI2_1_S 0xd0   /* () 1byte ܤϤ */
#define KANJI2_1_E 0xf4   /*                            ޤ */
#define KANJI2_2_S 0xa1   /* () 2byte ܤϤ */
#define KANJI2_2_E 0xfe   /*                            ޤ */
#define KANJI2_2_E2 0xa4  /*  (1byte ܤ 0xf4 ΤȤ)ޤ */



#define MAX_WORD_LEN 10000
#define MIN_WORD_LEN 0
   
struct word_data dic[MAX_CAN];
extern DictPtr *wdpt;
extern int mode_rd, mode_msg, mode_aug;
extern int mode_hiragana, mode_katakana;
extern int mode_kakko, mode_unknown, mode_length;
extern int mode_reading;
extern int mode_stack;
extern int mode_info;
extern int dakuten[MAX_SENTENCE_LEN];

extern char buftmp[1024];
extern char *bsp;

int unknown_word;

int consult(char *,int,int *,int *,int *,int *,int *,int *);
int hira_kana2(unsigned char *,unsigned char *);
int kana2hira(char *,char *);
int alphabets(unsigned char *,unsigned char *);
int numbers(unsigned char *,unsigned char *);
int knumbers(unsigned char *,unsigned char *);
int small_alphabets(unsigned char *, unsigned char **);
int check_dic(int,char *,char *,char *,char *,int);
int make_dic(EDRecList *,int,int,int *,int,int,int,int *,int *,int *,int,int *,int *, char *, int);
int make_exe_from_dic(int,int *,int,char *,int *);
int make_word_info(char *,int);

void is_paren(char *,int *,int *);
void is_punct(char *,int *,int *);
int search_last_kanji(unsigned char *);


/******************** consult() ********************/
int consult(sentence, stage, min_word_len, last_kanji, last_char, flag_katakana, flag_alphabet, last_j)
char *sentence;
int stage;
int *min_word_len;
int *last_kanji;
int *last_char;
int *flag_katakana;
int *flag_alphabet;
int *last_j;
{
  EDRecList *top;

  int number_of_can;

  unsigned char kana_sentence[MAX_SENTENCE_LEN];
  unsigned char kata_sentence[MAX_SENTENCE_LEN];
  unsigned char alpha_sentence[MAX_SENTENCE_LEN];
  unsigned char arabic_sentence[MAX_SENTENCE_LEN];
  unsigned char kansuuji_sentence[MAX_SENTENCE_LEN];
  unsigned char euc_sentence[MAX_SENTENCE_LEN];
  int sentence_len, i, tmp;

  int min_wl1 = 10000, min_wl2 = 10000, min_wl3 = 10000;
  /* ûñĹ(ƤӽФ¦֤) */

  int flag_record; /* ǥ쥳ɤäɤ */
  int flag_not_noun_yougen;  /* ٤ƤηǤ̾졦ѸǤʤɤ */
  int flag_lparen;  /* sentence Ƭ ֡ءʡȡ ɤ */
  int flag_rparen;  /* sentence Ƭ ס١ˡɡ ɤ */
  int flag_toten;   /* sentence Ƭ  ɤ */
  int flag_kuten;   /* sentence Ƭ  ɤ */
  int flag_unknown = FALSE;  /* unknown νϤ򤹤뤫ɤ */
  int flag_katakana_top = FALSE; /* ƬǤ뤳Ȥɽե饰 */
  int flag_alphabet_top = FALSE; /* alphabet ƬǤ뤳Ȥɽե饰 */
  int flag_j;
  /* Ǥ˼줿졦ưΰǤ뤳Ȥɽե饰 */
  int flag_koyuu = FALSE;  /* ͭ̾줬äȤ򼨤ե饰 */

  int prev_last_kanji;
  int katakana_len;
  int alphabet_len;
  int arabic_len;
  int kansuuji_len;


  unknown_word = 0;

  if (mode_info) {
    fprintf(stdout,"stage %d : %s\n",stage,sentence);
    fflush(stdout);
  }

  /* sentenceƬʿ̾ʬkana_sentenceؤ */

  hira_kana2(sentence, kana_sentence);

  if (mode_info) {
    fprintf(stdout,"  kana_sentence : %s\n",kana_sentence);
    fflush(stdout);
  }

  /* 褯狼ʤkana_sentenceκǸ˲ԤƤ */
  /* EDR ȤɽκǸϲԤǤʤȤʤǤ by ueki */
  /* ǤǤϡפǰȤϲԤʤ褦Ǥ */

  tmp = strlen(kana_sentence);
  kana_sentence[tmp] = '\n';
  kana_sentence[tmp+1] = '\0';

  /* sentence ƬΥʤʬФ */
  /* ɽʤäȤɤߤȤư */
  katakana_len = kata_kana2(sentence, kata_sentence);
  tmp = strlen(kata_sentence);
  kata_sentence[tmp] = '\n';
  kata_sentence[tmp+1] = '\0';
  if (mode_info && tmp > 0) {
    fprintf(stdout,"  kata_sentence : %s\n",kata_sentence);
    fflush(stdout);
  }
  if (!(*flag_katakana) && (katakana_len > 0)) {
    *flag_katakana = TRUE;
    flag_katakana_top = TRUE;
  } else if (*flag_katakana) {
    if (katakana_len == 0) {
      *flag_katakana = FALSE;
    } else {
      flag_katakana_top = FALSE;
    };
  };

  /* sentence Ƭ alphabet ʬФ */
  /* alphabet ɽʤäȤ̤θϿ뤿 */
  alphabet_len = alphabets(sentence, alpha_sentence);
  tmp = strlen(alpha_sentence);
  alpha_sentence[tmp] = '\n';
  alpha_sentence[tmp+1] = '\0';
  if (mode_info && tmp > 0) {
    fprintf(stdout,"  alpha_sentence : %s\n",alpha_sentence);
    fflush(stdout);
  }
  if (!(*flag_alphabet) && (alphabet_len > 0)) {
    *flag_alphabet = TRUE;
    flag_alphabet_top = TRUE;
  } else if (*flag_alphabet) {
    if (alphabet_len == 0) {
      *flag_alphabet = FALSE;
    } else {
      flag_alphabet_top = FALSE;
    };
  };

  /* sentence ƬΥӥʬФ */
  /* ģĤο˷Ǥդ餺ˤҤȤޤȤǰ */
  arabic_len = numbers(sentence, arabic_sentence);
  tmp = strlen(arabic_sentence);
  arabic_sentence[tmp] = '\0';
  if (mode_info && tmp > 0) {
    fprintf(stdout,"  arabic_sentence : %s\n",arabic_sentence);
    fflush(stdout);
  }
  /* sentence ƬδʬФ */
  /* ģĤο˷Ǥդ餺ˤҤȤޤȤǰ */
  /* 黰פߤʤñӽ̣⤢ */
  kansuuji_len = knumbers(sentence, kansuuji_sentence);
  tmp = strlen(kansuuji_sentence);
  kansuuji_sentence[tmp] = '\0';
  if (mode_info && tmp > 0) {
    fprintf(stdout,"  kansuuji_sentence : %s\n",kansuuji_sentence);
    fflush(stdout);
  }


  flag_j = (*last_j == 0)? FALSE : TRUE;

  /* ޤָФפǰˡɤߡפǰ 
     οnumber_of_canν */

  number_of_can = 0;

  is_paren(sentence,&flag_lparen,&flag_rparen);
  is_punct(sentence,&flag_toten,&flag_kuten);

  if (mode_kakko && (flag_lparen || flag_rparen)) {
    /* Ƭ̤ä dic ľϿ */
    char kakko[3];

    strncpy(kakko,sentence,2);
    kakko[2] = '\0';

    min_wl1 = 1;

    if (flag_lparen) {
      number_of_can = check_dic(1,"JPA","JLLP","JRLP",kakko,number_of_can);
    } else {
      number_of_can = check_dic(1,"JPA","JLRP","JRRP",kakko,number_of_can);
    };

    *last_kanji = 0;
  } else if (arabic_len > 0) {
    /* ƬӥäϿ */

    min_wl1 = arabic_len;

    number_of_can = check_dic(arabic_len,"JN3","JLN6","JRN8",arabic_sentence,
			      number_of_can);

    *last_kanji = 0;
  } else if (kansuuji_len > 1) {
    min_wl1 = kansuuji_len;
    number_of_can = check_dic(kansuuji_len,"JN3","JLN6","JRN8",
			      kansuuji_sentence,number_of_can);
  } else {
    /* ʳä̤˼ */
    int tmp_min_wl,tmp_max_wl;
    unsigned char buf[MAX_SENTENCE_LEN];
    unsigned char *p;

    /* Ƭʸξˤϡޤñ⼭뤿
       Ͽ */
    if (kansuuji_len == 1) {
      number_of_can = check_dic(kansuuji_len,"JN3","JLN6","JRN8",
				kansuuji_sentence,number_of_can);
    }

    strncpy((char *)buf,sentence,MAX_SENTENCE_LEN-1);
    p = buf;

    if (alphabet_len > 0) {
      small_alphabets(buf,&p);
    }

    /* Фǰ (key SRCH_PART : ʬפˤ븡) */
    top = EDsearch(wdpt, p, IDX_1, SRCH_PART);

    /* ʸɽΤޤޤǼǤ */
    flag_record = (top == NULL)? FALSE : TRUE;

    if (mode_info) {
      fprintf(stdout,"  flag_record = %d\n",flag_record);
      fflush(stdout);
    }

    prev_last_kanji = *last_kanji;

    /* ¤dic˼η̤򤷤ޤ
       number_of_canˤθο롣 */

    if (katakana_len > 1) {
      tmp_min_wl = 1;
    } else if (alphabet_len > 1) {
      tmp_min_wl = alphabet_len-1;
    } else {
      tmp_min_wl = 0;
    };
    tmp_max_wl = 0;

    /* keyno = 1 --> ФǤμ */
    number_of_can = make_dic(top, number_of_can, MIDASHI, &min_wl1, tmp_min_wl,
			     stage, FALSE, &flag_not_noun_yougen,
			     last_kanji, &tmp_max_wl,*flag_alphabet,last_j,
			     &flag_koyuu, sentence, alphabet_len);

    if (mode_unknown && !mode_katakana && flag_katakana_top &&
	(tmp_max_wl < katakana_len)) {
      kata_sentence[katakana_len*2] = '\0';
      number_of_can = check_dic(katakana_len,"JUK","JLN2","JRN2",
				kata_sentence,number_of_can);
      unknown_word = katakana_len;
      if (katakana_len > *last_char) {
	*last_char = katakana_len;
      };
      kata_sentence[katakana_len*2] = '\n';
      kata_sentence[katakana_len*2+1] = '\0';
    };
    if (mode_unknown && flag_alphabet_top && (tmp_max_wl < alphabet_len)) {
      alpha_sentence[alphabet_len*2] = '\0';
      number_of_can = check_dic(alphabet_len,"JUK","JLN2","JRN2",
				alpha_sentence,number_of_can);
      unknown_word = alphabet_len;
      if (alphabet_len > *last_char) {
	*last_char = alphabet_len;
      };
      alpha_sentence[alphabet_len*2] = '\n';
      alpha_sentence[alphabet_len*2+1] = '\0';
    };
    if (flag_toten) {
      char toten[3];

      strncpy(toten,sentence,2);
      toten[2] = '\0';
      number_of_can = check_dic(1,"JSY","JLS1","JRS1",toten,number_of_can);
      if (1 < min_wl1) {
	min_wl1 = 1;
      }
    } else if (flag_kuten) {
      char kuten[3];

      strncpy((char *)kuten,sentence,2);
      kuten[2] = '\0';
      number_of_can = check_dic(1,"JSY","JLS2","JRS2",kuten,number_of_can);
      if (strcmp(kuten,"") == 0) {
	number_of_can = check_dic(1,"JN3","JSF9","JRN8",kuten,number_of_can);
      }
      if (1 < min_wl1) {
	min_wl1 = 1;
      }
    }

    if (mode_unknown && mode_length &&
	(prev_last_kanji < 1) &&
	(*last_kanji == 1) &&
	!flag_koyuu &&
	!(strlen(kata_sentence) > 1) &&
	!(strlen(kana_sentence) > 1) &&
	!(strlen(alpha_sentence) > 1)) {
      /* sentence ƬҤ餬ʤǤ⥫ʤǤ alphabet Ǥʤ
	 ʸޤޤʤä硢ͭ̾ΰ
	 ߤʤ flag_unknown ΩƤ */
      /* ñΰȤƴޤޤƤ硢
	 ͭ̾Υȥ꡼äϽϤʤ */
      flag_unknown = TRUE;
    };

    if (mode_katakana && (strlen(kata_sentence) > 1) &&
	(tmp_max_wl < katakana_len)) {
      /* sentence Ƭʤä顢ɤߤȤƤƤߤ */
      /* ɽǥʤΰʬĤʤäΤ */
      unsigned char hiragana[MAX_SENTENCE_LEN];

      if (mode_info) {
	fprintf(stdout,"consult dictionary for katakana as reading\n");
	fflush(stdout);
      }
      top = EDsearch(wdpt, kata_sentence, IDX_2, SRCH_PART);

      /* keyno = 3 --> ʤμ */
      number_of_can =
	make_dic(top, number_of_can, KATAKANA, &min_wl3, katakana_len-1, stage,
		 flag_record, &flag_not_noun_yougen, last_kanji,
		 &tmp_max_wl, *flag_alphabet, last_j, &flag_koyuu,
		 sentence, 0);

      if (mode_unknown && flag_katakana_top && (tmp_max_wl < katakana_len)) {
	kata_sentence[katakana_len*2] = '\0';
	number_of_can = check_dic(katakana_len,"JUK","JLN2","JRN2",
				  kata_sentence,number_of_can);
	unknown_word = katakana_len;
	if (katakana_len > *last_char) {
	  *last_char = katakana_len;
	};
	kata_sentence[katakana_len*2] = '\n';
	kata_sentence[katakana_len*2+1] = '\0';
      };
    };

    if (mode_rd || mode_reading) { /* ɤߤǰ */
      /* kana_sentece԰ʳʸޤǤ顢ɤߡפǰ
	 ɤ⡢ԤʸfgetviȤϤ֤äƤtop
	 ȯƤߤ*/
      unsigned char katakana[MAX_SENTENCE_LEN];

      if ((strlen(kana_sentence) > 1) &&
	  !flag_j && (*last_j <= 1) &&
	  (!mode_hiragana || flag_not_noun_yougen || mode_reading)) {
	int tmp_min_wl;
	/* ƬҤ餬ʤǡ
	   ʸʾν졦ư˴ޤޤƤʤ
	   ưƻʤɤѸΥȥ꡼ʤä硢
	   ɤߤǰƤߤ */

	/* Ҥ餬ʤ򥫥ʤˤ */
	/* (ǤǤϡɤߤǰȤϥʤȤʤ) */
	hira2kata(kana_sentence,katakana);

	/* ɤߤǰ */

	if (mode_info) {
	  fprintf(stdout,"consult dictionary as reading\n");
	  fflush(stdout);
	}
	top = EDsearch(wdpt, katakana, IDX_2, SRCH_PART);

	/* ¤dic˼η̤򤷤ޤ
	   number_of_canˤθο롣 */

	tmp_min_wl = (mode_reading)? 0 : min_wl1;
	if (tmp_min_wl == 10000) {
	  tmp_min_wl = 1;
	}

	/* keyno = 2 --> Ҥ餬ʤμ */
	number_of_can
	  = make_dic(top, number_of_can, HIRAGANA, &min_wl2, tmp_min_wl, stage,
		     flag_record, &flag_not_noun_yougen, last_kanji,
		     &tmp_max_wl, *flag_alphabet, last_j, &flag_koyuu,
		     sentence, 0);
      }
    }

    if (flag_unknown) {
      char unknown[3];

      strncpy(unknown,sentence,2);
      unknown[2] = '\0';

      number_of_can = check_dic(1,"JUK","JLN2","JRN2",unknown,number_of_can);
      unknown_word = 1;
    };
  };


  /* stdoutˤΥơǰñο */

  if (mode_info) {
    fprintf(stdout,"number of can = %d\n", number_of_can);
    fprintf(stdout,"min_word_len %d %d %d\n",min_wl1,min_wl2,min_wl3);
  }

  if (min_wl1 < min_wl2) {
    if (min_wl1 < min_wl3) {
      *min_word_len = min_wl1;
    } else {
      *min_word_len = min_wl3;
    }
  } else {
    if (min_wl2 < min_wl3) {
      *min_word_len = min_wl2;
    } else {
      *min_word_len = min_wl3;
    };
  }

  /* dicξѤnewsglrgoal */

  make_exe_from_dic(stage, min_word_len, number_of_can,
		    sentence, last_char);

  return(*min_word_len);
}


/* ʤҤ餬ʤѴ */
int kana2hira(kana, hira)
     char *kana;
     char *hira;
{
    int i;

    for (i = 0; kana[i] != NULL; ) {
	hira[i] = kana[i] - 1;
	hira[i+1] = kana[i+1];
	i += 2;
    }
    hira[strlen(kana)] = 0;

    return(i/2);
}

/* Ҥ餬ʤ򥫥ʤѴ */
int hira2kata(hira,kata)
char *hira;
char *kata;
{
  int i;

  for (i = 0; hira[i] != '\0' ; i += 2) {
    kata[i] = hira[i] + 1;
    kata[i+1] = hira[i+1];
  };
  kata[strlen(kata)] = '\0';

  return(i/2);
}

/******************** make_dic() ********************/
int make_dic(top, number_of_can, keyno, min_word_len, wl, stage, flag_record, flag_not_noun_yougen, last_kanji, max_wl, flag_alphabet, last_j, flag_koyuu, sentence, alpha_len)
EDRecList *top;
int number_of_can;
int keyno;  /* 1 : Ф, 2 : Ҥ餬, 3 :  */
int *min_word_len;
int wl; /* Ĺñ줷ʤ */
int stage;
int flag_record;
int *flag_not_noun_yougen;
int *last_kanji;
int *max_wl;
int flag_alphabet;
int *last_j;
int *flag_koyuu;
char *sentence;
int alpha_len;
{
  struct dioslist *p;

  int word_len, head_len, yomi_len, tmp_len;
  char hidari[5], migi[5], hinshi[4];
  char head[256], yomi[256], euc_yomi[256];
  char hoge[256];

  int len, i, j, flag;

  int max_word_len = 0;
  int last_kanji_new;
  int number_of_can_old;
  int flag_arabic_number = FALSE;
  int flag_futsuumeishi = FALSE;
  /* ɤߤ̾Υȥ꡼ĤäƤ뤳Ȥɽե饰 */
  int flag_doushi = FALSE;
  /* ɤߤ(Ѱʳ)ưΥȥ꡼ĤäƤ뤳Ȥɽե饰 */
  char tmp_word[256];
  int tmp_word_len;
  char tmp_word_hidari[3][5];
  char tmp_word_migi[3][5];
  int no_of_tmp_word = 0;
  int flag_yomi_entry = FALSE;
  /* ɤߤǥȥ꡼ĤäƤ뤳Ȥɽե饰 */
  int flag_sahen = FALSE;  /* ưǤ뤳Ȥɽե饰 */
  int cur_word_len = 0;

  EDRecList *next;

  *min_word_len = MAX_WORD_LEN;
  if (keyno == MIDASHI) {
    *flag_not_noun_yougen = TRUE;
  };

  if (top == NULL) {
    return number_of_can;
  }

  if (top->dicType != 0) {
    fprintf(stderr,"illegal record type\n");
    srchFreeAll(top);
    return number_of_can;
  }

  for ( ; top ; top = next) {
    next = top->nextPtr;

    head_len = WDgetHWord(top->dictRec,head);
    head[head_len] = '\0';
    if (alpha_len > 0) {
      if (head_len < alpha_len) {
	head_len *= 2;
      } else {
	head_len = (head_len + alpha_len);
      }
      strncpy(head,sentence,head_len);
      head[head_len] = '\0';
    }

    yomi_len = WDgetRead(top->dictRec,yomi);
    yomi[yomi_len*2] = '\0';

    if (mode_info) {
      fprintf(stdout,"  word : '%s'('%s')\n",head,yomi);
      fflush(stdout);
    }

    if (keyno == MIDASHI) {
      /* ߤǤҤȤ */
      if (head_len > 1) {
	word_len = head_len / 2;
      } else {
	word_len = head_len;
      }

      if (word_len <= wl) { /* ñĹβ°ʲξ(ʤξ) */
	if (top->dictRec != NULL) {
	  free(top->dictRec);
	}
	free(top);
	continue;
      };
    } else if ((keyno == HIRAGANA) || (keyno == KATAKANA)) {
      /* ߤǤҤȤ or ʤɤߤǰȤ */
      word_len = yomi_len / 2;

      if (word_len <= wl) { /* ñĹβ°ʲξ */
	if (top->dictRec != NULL) {
	  free(top->dictRec);
	}
	free(top);
	continue;
      }
    } else {
      /* ΤȤꤢ1ˤǤ⤷Ƥޤ礦 */
      word_len = 1;
    }

    if ((keyno == HIRAGANA) && (cur_word_len != word_len)) {
      if (!flag_yomi_entry && flag_futsuumeishi && (no_of_tmp_word > 0)) {
	number_of_can = check_dic(tmp_word_len, "JN1", "JLN1", "JRN1",
				  tmp_word, number_of_can);
      };
      no_of_tmp_word = 0;
      cur_word_len = word_len;
      flag_yomi_entry = FALSE;
      flag_futsuumeishi = FALSE;
    };

    /* ûñĹ¸ */
    if (word_len < *min_word_len) {
      *min_word_len = word_len;
    };

    WDgetLAdj(top->dictRec,hidari);
    hidari[4] = '\0';
    WDgetRAdj(top->dictRec,migi);
    migi[4] = '\0';

    WDgetPOS(top->dictRec,hinshi);
    hinshi[3] = '\0';

    /* ưν */
    if (strcmp(migi,"JRV2") == 0) {
      char hira_tmp[256];

      if (hira_kana2(head, hira_tmp) > 0) {
	/* ɤߤǰҤ餬ʸä */
	flag_sahen = TRUE;
      };
    };
    if (strcmp(hinshi,"JSA") == 0) {
      strncpy(hinshi,"JN1",3);
      hinshi[3] = '\0';
    }

    if (flag_alphabet && (strcmp(hinshi,"EN1") == 0)) {
      strncpy(hinshi,"JN1",3);
      hinshi[3] = '\0';
      strncpy(hidari,"JLN1",4);
      hidari[4] = '\0';
      strncpy(migi,"JRN1",4);
      migi[4] = '\0';
    };

    if (mode_info) {
      fprintf(stdout,"  hinshi(rensetsu) : %s(%s,%s)\n",hinshi,hidari,migi);
      fflush(stdout);
    }

    if (keyno == MIDASHI) {
      number_of_can_old = number_of_can;
      number_of_can = check_dic(word_len, hinshi,
				hidari, migi, head,
				number_of_can);

      /* ĹñĹ¸ */
      if ((number_of_can != number_of_can_old) &&
	  (word_len > *max_wl)) {
	*max_wl = word_len;
      };
      /* ɽǰ硢졦ưǤäå */
      if (*flag_not_noun_yougen) {
	*flag_not_noun_yougen = ((strcmp(hinshi,"JAJ") != 0) &&
				 (strcmp(hinshi,"JAM") != 0) &&
				 (strcmp(hinshi,"JAX") != 0) &&
				 (strcmp(hinshi,"JN1") != 0) &&
				 (strcmp(hinshi,"JN2") != 0) &&
				 (strcmp(hinshi,"JN4") != 0) &&
				 (strcmp(hinshi,"JVE") != 0));
      };
      if (((strcmp(hinshi,"JJD") == 0) ||
	   (strcmp(hinshi,"JJO") == 0)) &&
	  (*last_j < word_len)) {
	*last_j = word_len;
      };
      if (strcmp(hinshi,"JN2") == 0) {
	*flag_koyuu = TRUE;
      };
    } else if (keyno == HIRAGANA) {
      char tmp[256];

      if (kata_kana2(head, tmp) > 0) {
	/* ɤߤǰΤ˥ʸä̵ */
	if (top->dictRec != NULL) {
	  free(top->dictRec);
	}
	free(top);
	continue;
      };

      kana2hira(yomi,tmp);
      if ((strcmp(hinshi,"JAJ") == 0) ||
	  (strcmp(hinshi,"JAM") == 0) ||
	  (strcmp(hinshi,"JAX") == 0) ||
	  (strcmp(hinshi,"JD1") == 0) ||
	  (strcmp(hinshi,"JD2") == 0) ||
	  (strcmp(hinshi,"JN4") == 0) ||
	  (strcmp(hinshi,"JN7") == 0) ||
	  (strcmp(hinshi,"JVE") == 0)) {
	number_of_can = check_dic(word_len, hinshi,
				  hidari, migi, tmp,
				  number_of_can);
	if (!flag_yomi_entry) {
	  flag_yomi_entry = TRUE;
	};
      } else if (strcmp(hinshi,"JN1") == 0) {
	flag_futsuumeishi = TRUE;
	strcpy(tmp_word,tmp);
	tmp_word[strlen(tmp_word)] = '\0';
	tmp_word_len = word_len;
	no_of_tmp_word++;
      };
    } else if (keyno == KATAKANA) {
      if (strcmp(hinshi,"JVE") != 0 || flag_sahen) {
	number_of_can_old = number_of_can;
	number_of_can = check_dic(word_len, hinshi,
				hidari, migi, yomi,
				number_of_can);
	if (!flag_yomi_entry) {
	  flag_yomi_entry = TRUE;
	};
	/* ĹñĹ¸ */
	if ((number_of_can != number_of_can_old) &&
	    (word_len > *max_wl)) {
	  *max_wl = word_len;
	};
      } else {
/*	int cur_no;*/
	int i;

/*	cur_no = no_of_tmp_word;*/
	flag_doushi = TRUE;
	strcpy(tmp_word,yomi);
	tmp_word[strlen(tmp_word)] = '\0';
	tmp_word_len = word_len;

	for (i = 0; i < no_of_tmp_word; i++) {
	  if (strcmp(tmp_word_hidari[i],hidari) == 0 &&
	      strcmp(tmp_word_migi[i],migi) == 0) {
	    break;
	  }
	}

	if (i == 3) {
	  if (mode_info) {
	    fprintf(stderr,"too many candidates...\n");
	  }
	  if (top->dictRec != NULL) {
	    free(top->dictRec);
	  }
	  free(top);
	  continue;
	} else if (i == no_of_tmp_word) {
	  strcpy(tmp_word_hidari[i],hidari);
	  tmp_word_hidari[i][4] = '\0';
	  strcpy(tmp_word_migi[i],migi);
	  tmp_word_migi[i][4] = '\0';
	  no_of_tmp_word++;
	}
/*	strcpy(tmp_word_hidari[cur_no],hidari);
	tmp_word_hidari[cur_no][4] = '\0';
	strcpy(tmp_word_migi[cur_no],migi);
	tmp_word_migi[cur_no][4] = '\0';
	no_of_tmp_word++;*/
      };
    };

    if (strcmp(hinshi,"JN3") == 0) {
      flag_arabic_number = is_arabic((unsigned char *)head);
    };
    /* κǸδʸܤå */
    if ((keyno == MIDASHI) &&
	(!((strcmp(hinshi,"JSY") == 0) ||
	   flag_arabic_number ||
	   (strcmp(hinshi,"EN3") == 0)))) {
      last_kanji_new = search_last_kanji((unsigned char *)head);
      if (mode_info) {
	printf("head : '%s'\n",head);
	printf("last_kanji_new = %d\n",last_kanji_new);
      }
      if (last_kanji_new > *last_kanji) {
	*last_kanji = last_kanji_new;
      };
    } else {
      last_kanji_new = 0;
      if (last_kanji_new > *last_kanji) {
	*last_kanji = last_kanji_new;
      };
    };

    if (top->dictRec != NULL) {
      free(top->dictRec);
    }
    free(top);

#ifdef DEBUG
    fprintf(stdout, 
	    "ߤ=%s =%s ʤ=%d\n",
	    head,
	    euc_yomi,
	    word_len
	    );
#endif
  }

  srchFreeAll(top);

  if ((keyno == HIRAGANA) &&
      !flag_yomi_entry && flag_futsuumeishi && (no_of_tmp_word > 0)) {
    number_of_can = check_dic(tmp_word_len, "JN1", "JLN1", "JRN1",
			      tmp_word, number_of_can);
  };
  if ((keyno == KATAKANA) &&
      !flag_yomi_entry && flag_doushi && (no_of_tmp_word > 0)) {
    int i;

    for (i=0 ; i < no_of_tmp_word ; i++) {
      number_of_can = check_dic(tmp_word_len, "JVE",
				tmp_word_hidari[i], tmp_word_migi[i],
				tmp_word, number_of_can);
    };

    number_of_can = check_dic(tmp_word_len, "JUK", "JLN2", "JRN2",
			      tmp_word, number_of_can);
    unknown_word = tmp_word_len;
  };

  return number_of_can;
}


/******************** make_exe_from_dic() ********************/
extern int stage_can_top[MAX_SENTENCE_LEN];

int make_exe_from_dic(stage, min_word_len, can, sentence, last_char)
int stage;
int *min_word_len;
int can;
char *sentence;
int *last_char;
{
    int next_stage;
    char word_info[1024];
    int i;
    int min_wl;

    min_wl = *min_word_len;

    /* ñο롼פgoal */

    if (mode_unknown && (can == 0) && (*last_char == 0)) {
      /* ⤷Ĥñ줬Ĥʤ
	 μˤޤޤƤʤä */
      char unknown[3];

      strncpy(unknown,sentence,2);
      unknown[2] = '\0';

      if (*min_word_len > 1) {
	*min_word_len = 1;
      }

      can = check_dic(1,"JUK","JLN2","JRN2",unknown,can);
      unknown_word = 1;
    };

    if (unknown_word != 0) {
      *min_word_len = 1;
    }

    if (!(*min_word_len > 0 && *min_word_len < MAX_WORD_LEN)) {
      if (stage_can_top[stage+1] > 0) {
	sprintf(buftmp,
		"S%d_%d=[],disp_stg(S%d_0),SL%d=[S%d_0|SL%d],!,",
		stage+1,stage_can_top[stage+1],stage+1,
		stage+1,stage+1,stage+2);
      } else {
	sprintf(buftmp,
		"S%d_%d=[],disp_stg('skip'),SL%d=SL%d,!,",
		stage+1,stage_can_top[stage+1],stage+1,stage+2);
      }
      strcpy(bsp,buftmp);
      bsp += strlen(buftmp);

      return(0);
    }

    if (*min_word_len > 1) {
      int min;
      int s;

      min = *min_word_len;
      s = stage+1;

      while (min > 1) {
	if (stage_can_top[s] > 0) {
	  sprintf(buftmp,
		  "S%d_%d=[],disp_stg(S%d_0),SL%d=[S%d_0|SL%d],!,",
		  s,stage_can_top[s],s,s,s+1,s,s,s+1);
	} else {
	  sprintf(buftmp,
		  "S%d_%d=[],disp_stg('skip'),SL%d=SL%d,!,",
		  s,stage_can_top[s],s,s+1,s,s+1);
	}
	strcpy(bsp,buftmp);
	bsp += strlen(buftmp);
	min--;
	s++;
      }
    }

    for (i = can - 1; i >= 0; i--) {	/* Ĺñ줫 */
	/* ñĹʬʸ(stage)Υåȥå */
	next_stage = stage + dic[i].word_len;

	if (dic[i].word_len > *last_char) {
	  *last_char = dic[i].word_len;
	};
	
	/* ɤ߸Ф */
	
	/* ޤdic[i].head_list顢ɽѤñ */
	make_word_info(word_info, i);
	
	if (mode_aug) { /* 䶯ξĤ */
	    sprintf(buftmp,
		    "%s(S%d_0,[[%s,%s],[%s,%s]],SX%d_%d-[]),!,",
		    dic[i].hinsi_sai,
		    stage,
		    dic[i].hinsi_sai,
		    word_info,
		    dic[i].hinsi_sai,
		    word_info,
		    next_stage,
		    stage_can_top[next_stage]
		    );
	} else {
	    sprintf(buftmp,
		    "%s(S%d_0,[[%s,%s]],SX%d_%d-[]),!,",
		    dic[i].hinsi_sai,
		    stage,
		    dic[i].hinsi_sai,
		    word_info,
		    next_stage,
		    stage_can_top[next_stage]
		    );
	}
	
	strcpy(bsp, buftmp);
	bsp += strlen(buftmp);
	
	/* ޡȥѥåʬ */
	sprintf(buftmp,
		"mg_pack(SX%d_%d,S%d_%d-S%d_%d),!,",
		next_stage,
		stage_can_top[next_stage],
		next_stage,
		stage_can_top[next_stage],
		next_stage,
		stage_can_top[next_stage] + 1
		);
	strcpy(bsp, buftmp);
	bsp += strlen(buftmp);
	
	/* ʸnext_stageˤΤӤƤ륹åο */
	stage_can_top[next_stage] += 1;
    }

    /* Υơνʤ */

    next_stage = stage + *min_word_len;

    if (unknown_word < 2) {
      sprintf(buftmp,
	      "S%d_%d=[],disp_stg(S%d_0),!,",
	      next_stage,
	      stage_can_top[next_stage],
	      next_stage
	      );
      if (mode_stack) {
	sprintf(buftmp,
		"S%d_%d=[],disp_stg(S%d_0),!,SL%d=[S%d_0|SL%d],!,",
		next_stage,
		stage_can_top[next_stage],
		next_stage,
		next_stage,
		next_stage,
		next_stage+1
		);
      };
    } else {
      sprintf(buftmp,
	      "S%d_%d=[],disp_stg('skip'),!,",
	      next_stage,
	      stage_can_top[next_stage]
	      );
      if (mode_stack) {
	sprintf(buftmp,
		"S%d_%d=[],disp_stg('skip'),!,SL%d=SL%d,!,",
		next_stage,
		stage_can_top[next_stage],
		next_stage,
		next_stage+1
		);
      };
    }
      
	    
    strcpy(bsp, buftmp);
    bsp += strlen(buftmp);


    return 0;
}

/******************** make_word_info() *********************/
/*        s "',,'"񤭹                       */
/***********************************************************/


int make_word_info(s, dic_no)
char *s;
int dic_no;
{
    int i;

    *s = '\'';
    s++;

    for(i = 0; i < dic[dic_no].head_list_num; i++){
	strcpy(s, dic[dic_no].head_list[i]);
	s += strlen(dic[dic_no].head_list[i]);
	*s = ',';
	s++;
    }

    *(s - 1) = '\'';
    *s = '\0';


    return 0;
}


void is_paren(str,flag_lparen,flag_rparen)
char *str;
int *flag_lparen;
int *flag_rparen;
{
  if ((strncmp(str,"",2) == 0) ||
      (strncmp(str,"",2) == 0) ||
      (strncmp(str,"",2) == 0) ||
      (strncmp(str,"",2) == 0) ||
      (strncmp(str,"",2) == 0)) {
    *flag_lparen = TRUE;
    *flag_rparen = FALSE;
  } else if ((strncmp(str,"",2) == 0) ||
	     (strncmp(str,"",2) == 0) ||
	     (strncmp(str,"",2) == 0) ||
	     (strncmp(str,"",2) == 0) ||
	     (strncmp(str,"",2) == 0)) {
    *flag_lparen = FALSE;
    *flag_rparen = TRUE;
  } else {
    *flag_lparen = FALSE;
    *flag_rparen = FALSE;
  };
}

void is_punct(str,flag_toten,flag_kuten)
char *str;
int *flag_toten;
int *flag_kuten;
{
  if ((strncmp(str,"",2) == 0) ||
      (strncmp(str,"",2) == 0)) {
    *flag_toten = TRUE;
    *flag_kuten = FALSE;
  } else if ((strncmp(str,"",2) == 0) ||
	     (strncmp(str,"",2) == 0) ||
	     (strncmp(str,"",2) == 0) ||
	     (strncmp(str,"",2) == 0)) {
    *flag_toten = FALSE;
    *flag_kuten = TRUE;
  } else {
    *flag_toten = FALSE;
    *flag_kuten = FALSE;
  };
}

int search_last_kanji(s)
unsigned char *s;
{
  int i = 0;
  int flag_kanji = FALSE;
  unsigned char *t;


  i = strlen(s);
  t = s + i - 2;
  i /= 2;

  while (i > 0) {
    if ((*t >= KANJI1_1_S && *t < KANJI1_1_E &&
	 *(t+1) >= KANJI1_2_S && *(t+1) <= KANJI1_2_E) ||
	(*t == KANJI1_1_E && *(t+1) >= KANJI1_2_S && *(t+1) <= KANJI1_2_E2) ||
	(*t >= KANJI2_1_S && *t < KANJI2_1_E &&
	 *(t+1) >= KANJI2_2_S && *(t+1) <= KANJI2_2_E) ||
	(*t == KANJI2_1_E && *(t+1) >= KANJI2_2_S && *(t+1) <= KANJI2_2_E2)) {
      return(i);
    }

    t -= 2;
    i--;
  }

  return(i);



/*
  while (*s != '\0') {
    if ((*s == HIRA1 || *s == KATA1) &&
	*(s+1) >= HIRA2_S && *(s+1) <= HIRA2_E) {
      if (!flag_kanji) {
	s += 2;
	i++;
      } else {
	return(i);
      };
    } else {
      if (!flag_kanji) {
	flag_kanji = TRUE;
      };
      s += 2;
      i++;
    };
  };

  if (flag_kanji) {
    return(i);
  } else {
    return(0);
  };
*/

}

int is_arabic(s)
unsigned char *s;
{
  if (*s == ARABIC1 && *(s+1) >= ARABIC2_0 && *(s+1) <= ARABIC2_9) {
    return TRUE;
  } else {
    return FALSE;
  };
}
