#!/usr/local/bin/wish
#======================================================================
#            Perl & Tcl/Tk visips 󥿥ե
#    Copyright (C) 1996 Takuya Nakayama <takuya-n@is.aist-nara.ac.jp>
#======================================================================
option add *background bisque
option add *activeBackground bisque2
option add *selectBackground cyan2
option add *highlightThickness 0
option add *padY 2
option add *padX 2

#----------------------------------------------------------------------
# ǡɤ߹ (Хå⡼)
#
proc batch_getdata {} {
    global TYOKOMAKA_COUNT TYOKOMAKA_MODE READ_MODE

    set READ_MODE 1
    while {![eof stdin]} {
	if {[getdata] == 0} { break }
	incr TYOKOMAKA_COUNT
	if {$TYOKOMAKA_MODE < $TYOKOMAKA_COUNT} {
	    set TYOKOMAKA_COUNT 0
	    update
	}
    }
}

#----------------------------------------------------------------------
# ǡɤ߹ (ƥåץ⡼)
#
proc step_getdata {{step -1}} {
    global TYOKOMAKA_MODE READ_MODE RETURN_STR

    if {$step == -1} {
	set step $TYOKOMAKA_MODE
    }
    set counter 0
    while {![eof stdin]} {
	puts -nonewline stdout $RETURN_STR ; flush stdout
	if {[getdata] == 0} { break }
	incr counter
	if {$step < $counter} {
	    break
	}
    }
}

#----------------------------------------------------------------------
# 󥿥ץ꥿
#
proc getdata {} {
    global TABLE_SIZE TYOKOMAKA_MODE RETURN_STR READ_MODE
    
    if {[eof stdin]} {return 0}
    gets stdin str
    if {$str == ""} {
	if {$READ_MODE == 1} {
	    puts -nonewline stdout $RETURN_STR ; flush stdout
	}
	return 1
    }
    set input [split $str " "]
    switch [lindex $input 0] {
	"size" {
	    ClearTable
	    set TABLE_SIZE [lindex $input 1]
	    MakeTable
	}
	"add" {
	    set tmp ""
	    while { ![eof stdin] } {
		gets stdin str
		# \e
		if { $str == "\\e" } {
		    break
		}
		append tmp "$str\n"
	    }
	    AddEntry [lindex $input 1] \
		[lindex $input 2] \
		[lindex $input 3] \
		[lindex $input 4] $tmp
	    gets stdin str
	    set input [split $str " "]
	    SetDtr [lindex $input 1] [lrange $input 2 end]
	}
	"setstr" {
	    for {set i 0} {$i < $TABLE_SIZE} {incr i} {
		AddEntry0 i$i $i [lindex $input [expr $i + 1]]
	    }
	}
	"clear" {
	    ClearTable
	}
	"demo" {
	    set TABLE_SIZE 3
	    MakeTable
	    AddEntry0 i0 0 "ǯ"
	    AddEntry0 i1 1 ""
	    AddEntry0 i2 2 ""
	    AddEntry 3 0 0 "̾" meisi
	    AddEntry 4 1 0 "" zyosi
	    AddEntry 5 2 0 "ư" dousi1
	    AddEntry 6 2 0 "ư" dousi2
	    AddEntry 7 0 1 "̾" meisi-ku
	    AddEntry 8 0 2 "ư" "dousi-ku 1"
	    AddEntry 9 0 2 "ư" "dousi-ku 2"
	    AddEntry 10 0 2 "ʸ" "bun-1"
	    AddEntry 11 0 2 "ʸ" "bun-2"
	    SetDtr 3 {i0}
	    SetDtr 4 {i1}
	    SetDtr 5 {i2}
	    SetDtr 6 {i2}
	    SetDtr 7 {3 4}
	    SetDtr 8 {7 5}
	    SetDtr 9 {7 6}
	    SetDtr 10 {8 }
	    SetDtr 11 {9}
	}
	"end" {
	    update
	    DataEndProc
	    return 0
	}
    }
    if {$READ_MODE == 1} {
	puts -nonewline stdout $RETURN_STR ; flush stdout
    }
    return 1
}


#----------------------------------------------------------------------
# ǡμդλ˸ƤӽФ
#
proc DataEndProc {} {
    global f

    if {[winfo exist .op]} {destroy .op}
    set mx [winfo width $f]
    set my [winfo height $f]
    set mx [expr $mx + 20]
    set my [expr $my + 20]
    .cMain configure -scrollregion "0 0 $mx $my"
}

#----------------------------------------------------------------------
# ХΥΤΥХ
#
proc BindCanvas {c} {
    bind $c <2> "$c scan mark %x %y"
    bind $c <B2-Motion> "$c scan dragto %x %y"
    bind $c <3> "ClearDispPath"
}

#----------------------------------------------------------------------
# ߡȥ꡼ɲ
#
proc AddDummyEnt {col row} {
    global EntNum
    global f
    global DISPLAY_STYLE TABLE_SIZE

    if {$DISPLAY_STYLE == 0} {
	set x [expr $col + $row]
	set entpos $EntNum(M$x)
	set colmax $TABLE_SIZE
    } else {
	set entpos $EntNum(MR$row)
	set colmax [expr $TABLE_SIZE - $row]
    }

    for {set i 0} {$i < $colmax} {incr i} {
	if {$DISPLAY_STYLE == 0} {
	    set row0 [expr $x - $i]
	} else {
	    set row0 $row
	}
	if {$row0 < 0} {
	    break
	}
	set tmp $f.c$i.r$row0.$entpos
	if {![winfo exists $tmp]} {
	    frame $tmp
	    button $tmp.name -relief flat -anchor w \
		-padx 0 -pady 0 \
		-command "DispAWinfo $i $row0 $entpos"
	    pack  $tmp.name -side left -fill both -expand yes
	    label $tmp.num -padx 0 -pady 0
	    pack $tmp.num -side right
	    pack $tmp -side bottom -fill both -expand yes
	}
    }
}

#----------------------------------------------------------------------
# ȥ꡼ɲ
#
proc AddEntry {ID col row text ditail} {
    global EntNum TABLE_SIZE SameEntNum EntName LastID
    global f
    global DitailList PosList0 PosList1 DtrList

    set DitailList($ID) "$ditail"
    set DtrList($ID) {}
    set LastID $ID
    
    # Ʊ̾Υȥ꤬
    set tmp $f.c$col.r$row.1
    set flag 0
    if {[winfo exists $tmp]} {
	set max_i $EntNum($col,$row)
	for {set i 1} {$i < $max_i} {incr i} {

	    set tmp $f.c$col.r$row.$i
	    set text2 [lindex [$tmp.name configure -text] 4]

	    if {$text == $text2} {
		set pos0 "$col $row $i"
		incr SameEntNum($pos0)
		$tmp.num configure -text $SameEntNum($pos0)
		set pos "$col $row $i $SameEntNum($pos0)"
		set PosList0($pos) $ID
		set PosList1($ID) $pos
		set EntName($ID) "$text $SameEntNum($pos0)"
		set flag 1
		break
	    }
	}
    }
    if {$flag == 1} {return}

    # Ʊ̾Υȥ꤬ʤ
    set tmp $f.c$col.r$row.$EntNum($col,$row)
    set num $EntNum($col,$row)
    set EntName($ID) "$text 1"
    if {[winfo exists $tmp]} {
	# ȥ꡼Ϥ߽Фʤ
	$tmp.name configure -text $text
	$tmp.num  configure -text "1"
	set pos0 "$col $row $EntNum($col,$row)"
	set SameEntNum($pos0) 1
	set pos "$pos0 1"
	set PosList0($pos) $ID
	set PosList1($ID) $pos
	incr EntNum($col,$row)
    } else {
	# ȥ꡼Ϥ߽Ф
	frame $tmp
	set pos0 "$col $row $EntNum($col,$row)"
	set SameEntNum($pos0) 1
	set pos "$pos0 1"
	set PosList0($pos) $ID
	set PosList1($ID) $pos
	button $tmp.name -text $text -relief flat -anchor w \
	    -padx 0 -pady 0 \
	    -command "DispAWinfo $col $row $EntNum($col,$row)"
	pack  $tmp.name -side left -fill both -expand yes
	label $tmp.num -text "1" -padx 0 -pady 0
	pack $tmp.num -side right
	pack $tmp -side bottom -fill both -expand yes
	incr EntNum($col,$row)
	set x [expr $col + $row]
	incr EntNum(M$x)
	incr EntNum(MR$row)
	AddDummyEnt $col $row
	set mx [winfo width $f]
	set my [winfo height $f]
	set mx [expr $mx + 20]
	set my [expr $my + 20]
	.cMain configure -scrollregion "0 0 $mx $my"
    }
}

#----------------------------------------------------------------------
# ȥ꡼ɲ
#
proc AddEntry0 {ID col text} {
    global f
    global EntNum PosList1 DtrList EntName

    set PosList1($ID) "$col 0 0 1"
    set DtrList($ID) {}
    set EntName($ID) $text

    $f.c$col.r0.0.name configure -text $text -relief groove
    if {$EntNum($col,0) == 0} {
	incr EntNum($col,0)
    }
}

#----------------------------------------------------------------------
# TABLE 
#
proc MakeTable {} {
    global f TABLE_SIZE EntNum DISPLAY_STYLE

    frame $f
    bind $f <3> "ClearDispPath"

    if {$DISPLAY_STYLE == 0} {
	for {set i 0} {$i < $TABLE_SIZE} {incr i} {
	    set EntNum(M$i) 0
	    set EntNum(MR$i) 0
	    frame $f.c$i
	    pack  $f.c$i -side left -anchor nw -fill x -expand yes
	    for {set j 0} {$j < [expr $TABLE_SIZE - $i]} {incr j} {
		set EntNum($i,$j) 1
		frame $f.c$i.r$j -relief raised \
		    -bd 2
		pack  $f.c$i.r$j -side bottom -fill both -expand yes -anchor w
		frame $f.c$i.r$j.0
		button $f.c$i.r$j.0.name -text " " \
		    -padx 0 -pady 0 -relief flat
		pack $f.c$i.r$j.0.name -fill both -expand yes
		pack $f.c$i.r$j.0 -side bottom -fill both -expand yes -anchor w
	    }
	}
	.cMain create window 10 10 -window $f -anchor nw
    } else {
	for {set i 0} {$i < $TABLE_SIZE} {incr i} {
	    set EntNum(M$i) 0
	    set EntNum(MR$i) 0
	    frame $f.c$i
	    pack  $f.c$i -side left -anchor sw -fill x -expand yes
	    for {set j 0} {$j < [expr $TABLE_SIZE - $i]} {incr j} {
		set EntNum($i,$j) 1
		frame $f.c$i.r$j -relief raised \
		    -bd 2
		pack  $f.c$i.r$j -side bottom -fill both -expand yes -anchor w
	    }
	    frame $f.c$i.r0.0
	    button $f.c$i.r0.0.name -relief flat -height 0 \
		-padx 0 -pady 0
	    pack $f.c$i.r0.0.name -fill both -expand yes
	    pack $f.c$i.r0.0 -side bottom -fill both -expand yes -anchor w
	}
	.cMain create window 10 10 -window $f -anchor nw
    }	
}
#----------------------------------------------------------------------
# TABLE ξõ
#
proc ClearTable {} {
    global f

    if {[winfo exist $f]} {
	destroy $f
    }
    update
}

#----------------------------------------------------------------------
# .aw.scale 
#
proc SetAWscale {leng} {
    set sldr_len [expr 100 / $leng]
    if {$sldr_len < 10} {
	set sldr_len 10
    }
    .aw.scale configure \
	-to $leng \
	-sliderlength $sldr_len
    update
}

#----------------------------------------------------------------------
# .aw ؾɽ
#
proc DispAWinfo {col row ID} {
    global f
    global CrntSel SameEntNum

    set tmp $f.c$col.r$row.$ID
    .aw.text configure -text [lindex [$tmp.name configure -text] 4]
    set CrntSel "$col $row $ID"
    SetAWscale $SameEntNum($CrntSel)

    set max_i [expr $col + $row]
    set text ""
    for {set i $col} {$i <= $max_i} {incr i} {
	append text [lindex [$f.c$i.r0.0.name configure -text] 4]
	append text " "
    }    

    .range configure -text $text

    DispPath
}

#----------------------------------------------------------------------
# ܺپɽ
#
proc GetCrntEnt {} {
    global CrntSel

    set num [.aw.val get]
    set ret "$CrntSel $num"
    
    return $ret
}

proc DispDitails {ID} {
    global f
    global DitailList PosList0 DtrList PosList1 EntName
    global DITAIL_WINDOW_WIDTH DITAIL_WINDOW_HEIGHT BG_COL_NUM_SELECT
    
    if {$ID == "current"} {
	set Key [GetCrntEnt]
	set ID $PosList0($Key)
    } else {
	set Key $PosList1($ID)
    }
    set tmp [split $Key " "]
    set col [lindex $tmp 0]
    set row [lindex $tmp 1]
    regsub -all " " $Key "_" win
    set win "p$win"

    # ˥ɥƤ
    if {[winfo exists .$win]} {
	# ɥɽ̤˻ä
	wm withdraw .$win
	wm deiconify .$win
	return
    }

    toplevel .$win

    frame .$win.menu
    label .$win.menu.name -text $EntName($ID) \
	-bg $BG_COL_NUM_SELECT
    bind .$win.menu.name <Enter> "BlinkPos $ID 1"
    bind .$win.menu.name <Leave> "BlinkPos $ID 0"
    pack .$win.menu.name -side left

    set max_i [expr $col + $row]
    set text ""
    for {set i $col} {$i <= $max_i} {incr i} {
	append text [lindex [$f.c$i.r0.0.name configure -text] 4]
	append text " "
    }    
    label .$win.menu.range -text $text
    pack .$win.menu.range -side left -fill x

    button .$win.menu.quit -text "close" -command "destroy .$win"
    pack .$win.menu.quit -side right
    pack .$win.menu -side top -fill x

    text .$win.text \
	-setgrid 0 -wrap none \
	-width $DITAIL_WINDOW_WIDTH -height $DITAIL_WINDOW_HEIGHT \
	-yscrollcommand ".$win.yscr set" \
	-xscrollcommand ".$win.xscr set"
    .$win.text insert end $DitailList($ID)

    scrollbar .$win.yscr -relief sunken -orient vertical \
	-command ".$win.text yview"
    scrollbar .$win.xscr -relief sunken -orient horizontal \
	-command ".$win.text xview"
    
    pack .$win.xscr -side bottom -fill x
    pack .$win.yscr -side right -fill y
    pack .$win.text -side left -fill both -expand yes
}


#----------------------------------------------------------------------
# ܺپ󥨥ȥѹ
#
proc ChangeAWEnt {num} {
    global CrntSel CrntEnt

    .aw.val delete 0 end; .aw.val insert 0 $num
    set CrntEnt $num
    if {[lindex $CrntSel 0] != -1} {
	DispPath
    }
    focus -force .
}

#----------------------------------------------------------------------
# ѥɽ
#
proc DispPath {} {
    global f
    global PosList0
    
    ClearDispPath
    
    set pos [GetCrntEnt]
    set ID  $PosList0($pos)

    DispPath0 $ID
}

# ѥɽκƵ롼
proc DispPath0 {ID} {
    global f
    global BG_COL_ENTRY_SELECT0 BG_COL_ENTRY_SELECT1 BG_COL_NUM_SELECT
    global DtrList PosList1 PathBuffer

    set pos $PosList1($ID)
    set col  [lindex $pos 0]
    set row  [lindex $pos 1]
    set num1 [lindex $pos 2]
    set num2 [lindex $pos 3]
    $f.c$col.r$row.$num1.name configure \
	-bg $BG_COL_ENTRY_SELECT0 \
	-activebackground $BG_COL_ENTRY_SELECT1 \
	-relief raised
    if {$num1 > 0} {
	$f.c$col.r$row.$num1.num configure \
	    -bg $BG_COL_NUM_SELECT -text $num2
    }

    lappend PathBuffer $pos

    foreach dtr $DtrList($ID) {
	if {$dtr != {}} {
	    DispPath0 $dtr
	}
    }
}

#----------------------------------------------------------------------
# ֥
#
proc BlinkPos {ID Mode} {
    global f PosList1 BG_COL_NUM_SELECT BLINK_BACKUP_COL

    set Key $PosList1($ID)

    set tmp [split $Key " "]
    set col [lindex $tmp 0]
    set row [lindex $tmp 1]
    set num [lindex $tmp 2]

    if {$Mode == 1} {
	set BLINK_BACKUP_COL \
	    [lindex [$f.c$col.r$row.$num.name configure -bg] 4]
	$f.c$col.r$row.$num.name configure -bg $BG_COL_NUM_SELECT
    } else {
	$f.c$col.r$row.$num.name configure -bg $BLINK_BACKUP_COL
    }
}

#----------------------------------------------------------------------
# ɽ
#
proc DispTree {} {
    global PosList0
    
    set pos [GetCrntEnt]
    set ID  $PosList0($pos)

    set win ".tree$ID"
    # ˥ɥƤ
    if {[winfo exists $win]} {
	# ɥɽ̤˻ä
	wm withdraw $win
	wm deiconify $win
	return
    }

    toplevel $win
    wm withdraw $win
    button $win.close -text Close -command "destroy $win"
    pack $win.close -side top -anchor e
    frame $win.f -relief sunken -relief sunken -bd 2
    pack $win.f -side top -anchor e -fill both
    update  idletasks
    DispTreeLoop $win.f $ID
    wm deiconify $win
}

# ɽκƵ롼
proc DispTreeLoop {win ID} {
    global DtrList EntName TREE_LINE_HEIGHT

    button $win.m -text $EntName($ID) \
	-command "DispDitails $ID"
    bind $win.m <Enter> "$win.m config -state active; BlinkPos $ID 1"
    bind $win.m <Leave> "BlinkPos $ID 0; $win.m config -state normal"
    pack $win.m -side top -anchor n
    canvas $win.c -width 0 -height $TREE_LINE_HEIGHT
    pack $win.c -side top -anchor n -fill x -expand yes


    set counter 0;
    foreach dtr $DtrList($ID) {
	if {$dtr != {}} {
	    set win_dtr "$win.$counter"
	    frame $win_dtr
	    pack $win_dtr -side left -anchor n -fill x -expand yes
	    DispTreeLoop $win_dtr $dtr
	    incr counter
	}
    }
    set pos [winfo width $win.c]
    $win.c configure -width $pos
    pack configure $win.c -fill none

    update  idletasks

    if {$counter == 0} {return}
    set center [expr [winfo width $win.c] / 2]
    set pos 0
    for {set i 0} {$i < $counter} {incr i} {
	set width [winfo width $win.$i]
	$win.c create line $center 0 [expr $pos + $width / 2] $TREE_LINE_HEIGHT
	set pos [expr $pos + $width]
    }
}

#----------------------------------------------------------------------
# ɽѥΥꥢ
#
proc ClearDispPath {} {
    global f
    global PathBuffer SameEntNum
    global BG_COL_ENTRY_DEFAULT0 BG_COL_ENTRY_DEFAULT1 BG_COL_NUM_DEFAULT

    foreach pos $PathBuffer {
	set col  [lindex $pos 0]
	set row  [lindex $pos 1]
	set num1 [lindex $pos 2]
	set pos0 "$col $row $num1"
	$f.c$col.r$row.$num1.name configure \
	    -bg $BG_COL_ENTRY_DEFAULT0 \
	    -activebackground $BG_COL_ENTRY_DEFAULT1
	if {$num1 > 0} {
	    $f.c$col.r$row.$num1.name configure -relief flat
	    $f.c$col.r$row.$num1.num configure \
		-bg $BG_COL_NUM_DEFAULT \
		-relief flat \
		-text $SameEntNum($pos0)
	} else {
	    $f.c$col.r$row.$num1.name configure -relief ridge
	}
    }
    set PathBuffer {}
}

#----------------------------------------------------------------------
# ҶΡɤ
#
proc SetDtr {Mother Dtrs} {
    global DtrList

    set DtrList($Mother) $Dtrs
}

#----------------------------------------------------------------------
# ѹǡ򥯥饤Ȥ֤ (interactive)
#
proc RetModDataSub {text} {
    global LastID

    set DitailList($LastID) [$text get 0.0 end]
    puts -nonewline stdout 3
    puts -nonewline stdout $DitailList($LastID)
    puts -nonewline stdout \f
    flush stdout
}
proc RetModData {} {
    global f LastID PosList1 EntName DitailList
    global BG_COL_NUM_SELECT DITAIL_WINDOW_WIDTH DITAIL_WINDOW_HEIGHT

    if {$LastID == "nul"} {return}

    set Key $PosList1($LastID)

    set tmp [split $Key " "]
    set col [lindex $tmp 0]
    set row [lindex $tmp 1]
    regsub -all " " $Key "_" win
    set win "mod_$win"

    # ˥ɥƤ
    if {[winfo exists .$win]} {
	# ɥɽ̤˻ä
	wm withdraw .$win
	wm deiconify .$win
	return
    }

    toplevel .$win

    frame .$win.menu
    label .$win.menu.name -text $EntName($LastID) \
	-bg $BG_COL_NUM_SELECT
    bind .$win.menu.name <Enter> "BlinkPos $LastID 1"
    bind .$win.menu.name <Leave> "BlinkPos $LastID 0"
    pack .$win.menu.name -side left

    set max_i [expr $col + $row]
    set text ""
    for {set i $col} {$i <= $max_i} {incr i} {
	append text [lindex [$f.c$i.r0.0.name configure -text] 4]
    }    
    label .$win.menu.range -text $text
    pack .$win.menu.range -side left -fill x

    button .$win.menu.undo -text "Undo" \
	-command ".$win.text delete 0.0 end ; .$win.text insert end {$DitailList($LastID)}"

    text .$win.text \
	-setgrid 0 -wrap none \
	-width $DITAIL_WINDOW_WIDTH -height $DITAIL_WINDOW_HEIGHT \
	-yscrollcommand ".$win.yscr set" \
	-xscrollcommand ".$win.xscr set"
    .$win.text insert end $DitailList($LastID)

    button .$win.menu.mod -text "Modify" \
	-command "RetModDataSub .$win.text ; destroy .$win"
    button .$win.menu.quit -text "Cansel" \
	-command "destroy .$win"

    pack .$win.menu.quit -side right
    pack .$win.menu.mod -side right
    pack .$win.menu.undo -side right
    pack .$win.menu -side top -fill x

    scrollbar .$win.yscr -relief sunken -orient vertical \
	-command ".$win.text yview"
    scrollbar .$win.xscr -relief sunken -orient horizontal \
	-command ".$win.text xview"
    
    pack .$win.xscr -side bottom -fill x
    pack .$win.yscr -side right -fill y
    pack .$win.text -side left -fill both -expand yes
}

#----------------------------------------------------------------------
# ѿǥե
#

# f          ... ᥤ󥦥ɥΥե졼
# EntNum     ... 1֥åΥȥ꡼¸
# SameEntNum ... Ʊ쥨ȥ¸
# PosList0   ... ɽΰ־ "col row num1 num2" -> ID
# PosList1   ... ɽΰ־ ID -> "col row num1 num2"
# DitailList ... ܺپΥꥹ
# DtrList    ... ҶΥꥹ
# MotherList ... ƾΥꥹ

# ơ֥礭
set TABLE_SIZE  0
# 򤵤Ƥ "col row num1"
set CrntSel -1
# Ĵѥ¸ѥХåե
set PathBuffer {}

# main window 礭
set MAIN_WINDOW_WIDTH  300
set MAIN_WINDOW_HEIGHT 300

# ܺپ window 礭
set DITAIL_WINDOW_WIDTH  26
set DITAIL_WINDOW_HEIGHT 10

# color
set BG_COL_ENTRY_DEFAULT0 bisque
set BG_COL_ENTRY_DEFAULT1 bisque2

set BG_COL_ENTRY_SELECT0 bisque
set BG_COL_ENTRY_SELECT1 bisque2

set BG_COL_NUM_DEFAULT bisque
set BG_COL_NUM_SELECT gold

# 󥿥ե
set RETURN_STR 1
set DISPLAY_STYLE 1

# 󥿥饯ƥ֥⡼  0 .. off, 1 .. on
set READ_MODE 1
set LastID "nul"

# 祳ޤ⡼
set TYOKOMAKA_COUNT 0
set TYOKOMAKA_MODE     0
set TYOKOMAKA_MODE_MAX 200

# ڤɽ
set TREE_LINE_HEIGHT 10

# ¾
set VERSION     "Ver 0.00"
set c_font rk16
set c_kanjifont kanji16
set char_size 16

#----------------------------------------------------------------------
# ᥤ
#

set rc_file "~/.visipsrc"
set Mode default

# 
set argvl [split $argv " "]
for {set i 0} {$i < $argc} {incr i} {
    switch -- [lindex $argvl $i] {
	-mode { # ⡼ɤλ
	    incr i; set Mode [lindex $argvl $i] }
	-initfile { # եλ
	    incr i; set rc_file [lindex $argvl $i] }
    }
}

# ꥽եɤ߹
if {[file exist $rc_file]} {
    source $rc_file
}

# ޥɥ饤ǥ⡼ɤꤵƤФͥ
if {$Mode != "default"} {
    set READ_MODE $Mode
}

# ᥤ󥭥Х
canvas .cMain \
    -width $MAIN_WINDOW_WIDTH -height $MAIN_WINDOW_HEIGHT \
    -xscrollcommand ".xscr set" \
    -yscrollcommand ".yscr set"
BindCanvas .cMain
set f .cMain.dummy

# ڥ졼ѥե졼
frame .op -relief raised -borderwidth 2

scale .op.tyokomaka -orient horizontal \
    -length 100 -from 0 -to $TYOKOMAKA_MODE_MAX \
    -width 20 \
    -showvalue 0 \
    -variable TYOKOMAKA_MODE
switch $READ_MODE {
    1 {pack .op.tyokomaka -side left}
    2 {
	button .op.next -text Next \
	    -command {puts -nonewline stdout $RETURN_STR ; flush stdout}
	pack .op.next -side left
	button .op.step -text Step -command {step_getdata}
	pack .op.step -side left
	pack .op.tyokomaka -side left
	button .op.auto -text Auto \
	    -command {set READ_MODE 1 ; puts -nonewline stdout $RETURN_STR ; flush stdout}
	pack .op.auto -side left
	button .op.del -text Delete \
	    -command {puts -nonewline stdout 2 ; flush stdout}
	pack .op.del -side left
	button .op.mod -text Modify -command {RetModData}
	pack .op.mod -side left
    }
    3 {
	button .op.next -text Next \
	    -command {step_getdata 0}
	pack .op.next -side left
	button .op.step -text Step -command {step_getdata}
	pack .op.step -side left
	pack .op.tyokomaka -side left
	button .op.auto -text Auto \
	    -command {puts -nonewline stdout $RETURN_STR ; flush stdout; batch_getdata}
	pack .op.auto -side left
    }
}
# ܺپɽѥե졼
frame .aw -relief raised -borderwidth 2

label .aw.text -width 16

entry .aw.val -width 4 -justify center -relief flat \
    -bg $BG_COL_NUM_SELECT
bind .aw.val <Return> {ChangeAWEnt [.aw.val get]}

scale .aw.scale -orient horizontal \
    -length 100 -from 1 -to 1 \
    -sliderlength 100 -width 20 \
    -showvalue 0 \
    -variable CrntEnt \
    -command {ChangeAWEnt}
button .aw.info -text "Info" -command {DispDitails current}
button .aw.tree -text "Tree" -command {DispTree}

pack .aw.text -side left -fill x
pack .aw.val -side left
pack .aw.scale -side left
pack .aw.info -side left
pack .aw.tree -side left

button .aw.quit -text "Quit" -command "destroy ."
pack .aw.quit -side right

label .range -relief sunken

scrollbar .yscr \
    -bg gray80 -activebackground gray70 \
    -orient vertical \
    -width 13 \
    -command ".cMain yview"
scrollbar .xscr \
    -bg gray80 -activebackground gray70 \
    -orient horizontal \
    -width 13 \
    -command ".cMain xview"

pack .aw -fill x
pack .range -fill x -side top
pack .op -fill x

pack .xscr -fill x -side bottom
pack .yscr -fill y -side right
pack .cMain -fill both -expand y -side right

# ǡɤ߹
# 󥿥饯ƥ֥⡼ɤλϥե륤٥ȤȤ
# Хå⡼ɤλ whileʸǥ륰ޤ魯
switch $READ_MODE {
    1 {batch_getdata}
    2 {fileevent stdin readable getdata}
    3 {getdata}
    default {batch_getdata}
}
