# fileselecter.tcl 
#  ե⥸塼
#    Copyright (C) 1996 Takuya Nakayama <takuya-n@is.aist-nara.ac.jp>
#
# $Header: /home/tatuo-y/tk/work/RCS/fileselecter.tcl,v 1.4 1996/01/30 02:04:45 tatuo-y Exp tatuo-y $
#
#  ʸ 
# 
# ɣӣ£Ρ4-274-06115-9
# ̾Tcl/Tk ץߥ (FD)
# ̾Ľ˧ɧ 
# Ǽҡ
# ڡ裱ϣ "ե" ( pp.211-235 ) 
# 

# ǽ 1996/5/18  by Tak Nakayama (takuya-n@is.aist-nara.ac.jp)
#   cd 򤷤塢褦ˤ

set DIR_LAST [pwd]

# ɥɽƥե򤹤
# w	ɥΥȥåץ٥륦åȤΥѥ
# title	ȥСʤɤɽʸ
# flag	Υե̾ɤΥե饰
proc SelectFile {w title flag} {
    global selected_file DIR_ORG DIR_LAST

    set sel_file_org $selected_file
    set DIR_ORG [pwd]
    cd $DIR_LAST
    
    # åȺ
    toplevel $w
    wm title $w $title
    frame $w.frame
    label $w.frame.dir -text "Directry:" -fg blue
    label $w.frame.pwd
    label $w.frame.file -text "FileName:" -fg blue
    entry $w.frame.fileName -relief sunken -bd 2
    listbox $w.frame.fileList -width 30 -height 20 -relief sunken \
	-yscrollcommand "$w.frame.scrollbar set"
    scrollbar $w.frame.scrollbar -orient vertical -relief sunken \
	-command "$w.frame.fileList yview"
    frame $w.click
    button $w.click.select -width 10 -text "OK" -command "selectFile $w.frame $flag"
    button $w.click.cansel -width 10 -text "CANCEL" -command "set selected_file $sel_file_org"
    pack $w.frame -side top -padx 10 -pady 10
    pack $w.frame.dir -anchor w
    pack $w.frame.pwd -anchor w
    pack $w.frame.file -anchor w
    pack $w.frame.fileName -fill x 
    pack $w.frame.scrollbar -side right -fill y
    pack $w.frame.fileList -side left -fill x -expand 1
    pack $w.click -anchor s -pady 10
    pack $w.click.select -side left
    pack $w.click.cansel

    # ꥹȥܥåå줿ȤνΥХ
    bind $w.frame.fileList <ButtonRelease-1> "showEntry $w.frame"  
    # ꥹȥܥå֥륯å줿ȤνΥХ
    bind $w.frame.fileList <Double-ButtonPress-1> "selectFile $w.frame $flag"
    # ȥReturnϤ줿ȤνΥХ
    bind $w.frame.fileName <Any-Return> "selectFile $w.frame $flag" 
    
    setFileList $w.frame ;     # եɽ

    # ꤵƤեǥեȤȤɽ
    $w.frame.fileName delete 0 end; $w.frame.fileName insert 0 $selected_file

    # ɥɽ֤η׻ɽ
    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	       - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	       - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # ֤ȥե
    set oldFocus [focus]
    grab $w
    focus $w.frame.fileName

    # ɥޥ͡㤫κؤб
    wm protocol $w WM_DELETE_WINDOW {set selected_file {}}

    # ե뤬򤵤ΤԤ
    tkwait variable selected_file

    set DIR_LAST [pwd]
    cd $DIR_ORG;

    # ե뤬򤵤줿顢ɥեִԤ򤷤
    # 򤵤줿ե֤̾
    destroy $w;  focus $oldFocus
    return $selected_file
}

# ɥɽι
# f	Ϣ륦åȤܤäƤե졼०åȤΥѥ
proc setFileList {f} {
    set pwd [pwd]; # ȥǥ쥯ȥ̾ɽ
    $f.pwd configure -text $pwd; # ٥˥ȥǥ쥯ȥΥѥɽ

    # եɽ
    # ȥȥꥹȥܥåƤΥꥢ
    $f.fileList delete 0 end; $f.fileName delete 0 end
    # եθ
    set files {..}
    catch {set files [concat $files [lsort [glob *]]]} 
    # եꥹȥܥåɽ
    foreach file $files { # ֥ǥ쥯ȥä  "/" դ 
	if [file isdirectory $file] {set file $file/}
	$f.fileList insert end $file
    }
} 

# ꤵ줿ե򤹤
# f	Ϣ륦åȤܤäƤե졼०åȤΥѥ
# flag	Υե̾ɤΥե饰
proc selectFile {f flag} {
    global selected_file
    # ꤵ줿ե̾
    set name [$f.fileName get] 
    # ǥ쥯ȥǤ뤳Ȥ򼨤ˤĤ "/" Ϥ
    if {$name  != "/"} {set name [string trimright $name "/"] }
    # ꤵ줿Τǥ쥯ȥʤ  cd ɽ򹹿
    if [file isdirectory $name] {cd $name; setFileList $f; return}
    # ꤵ줿Τ¸Υե̾Υե̾Ƥʤ
    if {[file exists $name] || $flag} {	# ѿ selected_file 
	if {[regexp {^[/\~]} $name]} {set selected_file $name
	} else {set selected_file [pwd]/$name}
	return
    }
    # ꤵ줿Τ̵ʸξˤϥȥƤ򥯥ꥢ
    $f.fileName delete 0 end
}

# ꥹȥܥå򤵤Ƥܤ򥨥ȥɽ
# f	Ϣ륦åȤܤäƤե졼०åȤΥѥ
proc showEntry f {
    set index [$f.fileList curselection]
    if {$index == ""} return
    $f.fileName delete 0 end;
    $f.fileName insert 0 [$f.fileList get $index]
}
