/*******************************************************/
/*                Utility for SAX System               */
/*                                                     */
/*  Copyright (C) 1993 Yuji Matsumoto, Yasuharu Den    */
/*                  (23 February 1993)                 */
/*  by Yuji Matsumoto (matsu@pine.kuee.kyoto-u.ac.jp)  */
/*     Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%   needs append/3 from library lists.
:- use_module(library(lists), [append/3]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Basic Predicates
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   make_phrase(+Func, +Args, -Phrase)
%   ؿ Func Ȱ Args  Phrase 롥
%
make_phrase(Func, Args, Phrase) :-
	X =.. [Func,_,_|Args],
	(   predicate_property(user:X, built_in) ->
	    concat_atoms(Func, '_u', Func1)
	;   Func1 = Func
	),
	Phrase =.. [Func1|Args], !.

%   concat_atoms(+Atom1, +Atom2, ?NewAtom)
%   ȥ Atom1, Atom2 ϢܤΤ NewAtom Ȥ롥
%
concat_atoms(Atom1, Atom2, NewAtom) :-
	name(Atom1, Name1),
	name(Atom2, Name2),
	append(Name1, Name2, Name3),
	name(Atom3, Name3),
	!, NewAtom = Atom3.

%  call_unix(+Pred)
%  unixΥޥɤƤӽФ (for both SICStus2.1 and SICStus3)
%
call_unix(P) :-
	( call(system:P)
	; unix(P)
	).
