/*******************************************************/
/*              Tree Writer-SAX Interface              */
/*                                                     */
/*         Copyright (C) 1993 Yasuharu Den             */
/*                  (19 January 1993)                  */
/*  by Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%   use treeprint module
:- use_module(library('Utility/treeprint')).

%   set treeprint flags
:- treeprint_flag(print_mode, _, flat).
:- treeprint_flag(internode_sep, _, 2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for Tree Writer
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- dynamic tree_writer_mode/1.

tree_writer_mode(on).

%   tree_writer_on
%   ڤɽǽ򥪥ˤ롥
%
tree_writer_on :-
	retract(tree_writer_mode(_)),
	assert(tree_writer_mode(on)), !.

%   tree_writer_off
%   ڤɽǽ򥪥դˤ롥
%
tree_writer_off :-
	retract(tree_writer_mode(_)),
	assert(tree_writer_mode(off)), !.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Call Delayed Extra
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   call_delayed_extra(+Dx, -Tree)
%
%   ٱ䶯 Dx  Tree 롥
%
call_delayed_extra(Dx, Tree) :- reverse_tree(Dx, Tree).

reverse_tree([], []) :- !.
reverse_tree([Extra|Children], [Node|Children1]) :- !,
	functor(Extra, Node, _),
	map_reverse_tree(Children, [], Children1).
reverse_tree(Word, [Word]).

map_reverse_tree([], Children1, Children1) :- !.
map_reverse_tree([Tree|Rest], Children1, Children2) :-
	reverse_tree(Tree, Tree1),
	map_reverse_tree(Rest, [Tree1|Children1], Children2).
