/*******************************************************/
/*               SAX User Definition File              */
/*                    Sample for SAX                   */
/*                                                     */
/*         Copyright (C) 1993 Yasuharu Den             */
/*                  (19 February 1993)                 */
/*  by Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%   load SAX system
:- use_module(library(sax)).
:- use_module(library(sax_trans)).

%   load interface programs
:- ensure_loaded(library('sax_user/extra')).
:- ensure_loaded(library('sax_user/tree_sax')).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for SAX translator
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_trans_idterm(+Type)
%   ӣإȥ󥹥졼Υ Type ꤹ롥
%
sax_trans_idterm(short).

%   sax_trans_tp_filter(+Type)
%   ӣإȥ󥹥졼ףˤ벼ͽ¬ե
%   Υ Type ꤹ롥
%
sax_trans_tp_filter(no).

%   sax_trans_block(+Use)
%   ӣإȥ󥹥졼ף block 뤫
%    Use ꤹ롥
%
sax_trans_block(no).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_input_mode(+Mode)
%   ӣإƥϥ⡼ Mode ꤹ롥
%
sax_input_mode(string).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% User defined predicate for SAX translator 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_term_expansion(+Rule, -ExpandedRule)
%   ʸˡ§ Rule  ExpandedRule ѴƤӣإȥ
%   졼ϤǥեȤǤʸˡ§Τޤޣӣإ
%   󥹥졼Ϥ롥
%
:- abolish(sax_term_expansion, 2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% User defined predicate for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_query_expansion(+Sentence, -Goal)
%   ʸ Sentence  Goal ѴơӣإȤ
%   뤹롥ǥեȤǤ sax_query_expansion_default/2
%   ˤäơΤ褦Ѵ롥
%
%     sax_query_expansion_default(
%         [john,leaves,tokyo],
%         (process([ie(np([begin(t,[])],[np(true),john]),true)],
%                  S1),
%          process([ie(vt(S1,[vt(true),leaves]),true)],
%                  S2),
%          process([ie(np(S2,[np(true),tokyo]),true)],
%                  S3),
%          fin(S3))
%                                )
%
:- abolish(sax_query_expansion, 2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Meta process for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   process(+Eu, -Su)
%   ñץȤäȥ꡼ Eu Фơ᥿
%   ܤΤ Su ȤơñץϤ
%
process([], []) :- !.
process([ie(InActive,Exs)|EuTail], Su) :-
	(   call_extra(Exs, InActive, CopyOfInActive),
	    phrase(CopyOfInActive, NewEu, EuTail)
	;   NewEu = EuTail
	),
	!, process(NewEu, Su).
process([ae(Active,Exs)|EuTail], Su) :-
	(   call_extra(Exs, Active, CopyOfActive),
	    Su = [CopyOfActive|SuTail]
	;   Su = SuTail
	),
	!, process(EuTail, SuTail).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Final process for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   fin(+Sm)
%   ǸñץȤäȥ꡼ Sm Фơ
%   ǽܤ
%
fin([]) :- !.
fin([Id|SmTail]) :- Id =.. [idend,_,[SDx]|Args], !,
	(   tree_writer_mode(off)
	;   call_delayed_extra(SDx, Tree),
	    treeprint(Tree), nl,
	    ( Args = [] ; write(Args), nl, nl )
	),
	!, fin(SmTail).
fin([_|SmTail]) :-
	fin(SmTail).
