/*******************************************************/
/*               SAX User Definition File              */
/*              Sample for SAX with VisIPS             */
/*                                                     */
/*         Copyright (C) 1993 Yasuharu Den             */
/*                    (12 March 1993)                  */
/*  by Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%   load SAX system
:- use_module(library(sax)).
:- use_module(library(sax_trans)).

%   load interface programs
:- ensure_loaded(library('sax_user/extra')).
:- ensure_loaded(library('VisIPS/visips')).
:- ensure_loaded(library('sax_user/tree_sax')).
:- ensure_loaded(library('sax_user/visips_process')).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   user defined predicate for VisIPS
write_string(Str, String) :- write_string1(Str, String).
write_string(_, _).

write_string1(Str, String) :-
	numbervars(String, 0, _),
	write(Str, String),
	!, fail.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for SAX translator
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_trans_idterm(+Type)
%   ӣإȥ󥹥졼Υ Type ꤹ롥
%
sax_trans_idterm(short).

%   sax_trans_tp_filter(+Type)
%   ӣإȥ󥹥졼ףˤ벼ͽ¬ե
%   Υ Type ꤹ롥
%
sax_trans_tp_filter(no).

%   sax_trans_block(+Use)
%   ӣإȥ󥹥졼ף block 뤫
%    Use ꤹ롥
%
sax_trans_block(no).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_input_mode(+Mode)
%   ӣإƥϥ⡼ Mode ꤹ롥
%
sax_input_mode(string).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% User defined predicate for SAX translator 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_term_expansion(+Rule, -ExpandedRule)
%   ʸˡ§ Rule  ExpandedRule ѴƤӣإȥ
%   졼Ϥ
%
%   ̤γϰ֤ɽɲä롥ٱ䶯˼̻Ҥ
%   Ͽ뤿ΰɲä롥
%
%     sax_term_expansion(
%         (sentence --> np, vp & {extra}),
%         (sentence(Pos) --> np(Pos), vp(_) & {dx(extra,_)})
%                        )
%
sax_term_expansion((:- sax_top_node_category(_,Func/Arity)),
	           (:- sax_top_node_category(_,Func/Arity1))) :- !,
	Arity1 is Arity + 1.
sax_term_expansion((Head --> Body & Dx), (Head1 --> Body1 & Dx1)) :- !,
	put_extra_arg(Head, Head1, ExtraArg),
	put_extra_arg_body(Body, Body1, ExtraArg),
	put_extra_arg_delayed_extra(Dx, Dx1).
sax_term_expansion((Head --> Body), (Head1 --> Body1 & Dx1)) :-
	put_extra_arg(Head, Head1, ExtraArg),
	put_extra_arg_body(Body, Body1, ExtraArg),
	put_extra_arg_delayed_extra(true, Dx1).

%   put_extra_arg(+Term, -NewTerm, +ExtraArg)
%
put_extra_arg(Term, NewTerm, ExtraArg) :-
	Term =.. [Func|Args],
	NewTerm =.. [Func,ExtraArg|Args].

%   put_extra_arg_delayed_extra(+Dx, -NewDx)
%
put_extra_arg_delayed_extra({G}, {dx(G,_)}) :- !.
put_extra_arg_delayed_extra(G,   {dx(G,_)}).

%   put_extra_arg_body(+Body, -NewBody, ?ExtraArg)
%
put_extra_arg_body(((Body1,Body2),Body), NewBody, ExtraArg) :- !,
	put_extra_arg_body((Body1,(Body2,Body)), NewBody, ExtraArg).
put_extra_arg_body(((Body1;Body2),Body), (NewBody1;NewBody2), ExtraArg) :- !,
	put_extra_arg_body((Body1,Body), NewBody1, ExtraArg),
	!, put_extra_arg_body((Body2,Body), NewBody2, ExtraArg).
put_extra_arg_body(({Extra},Body), ({Extra},NewBody), ExtraArg) :- !,
	put_extra_arg_body(Body, NewBody, ExtraArg).
put_extra_arg_body(([],Body), NewBody, ExtraArg) :- !,
	put_extra_arg_body(Body, NewBody, ExtraArg).
put_extra_arg_body(([Word|Words],Body), ([NewWord],NewBody), ExtraArg) :- !,
	put_extra_arg(Word, NewWord, ExtraArg),
	!, put_extra_arg_body((Words,Body), NewBody, _).
put_extra_arg_body((NTerm,Body), (NewNTerm,NewBody), ExtraArg) :- !,
	put_extra_arg(NTerm, NewNTerm, ExtraArg),
	!, put_extra_arg_body(Body, NewBody, _).
put_extra_arg_body((Body1;Body2), (NewBody1;NewBody2), ExtraArg) :- !,
	put_extra_arg_body(Body1, NewBody1, ExtraArg),
	!, put_extra_arg_body(Body2, NewBody2, ExtraArg).
put_extra_arg_body({Extra}, {Extra}, _) :- !.
put_extra_arg_body([], [], _) :- !.
put_extra_arg_body([Word], [NewWord], ExtraArg) :- !,
	put_extra_arg(Word, NewWord, ExtraArg).
put_extra_arg_body([Word|Words], ([NewWord],NewBody), ExtraArg) :- !,
	put_extra_arg(Word, NewWord, ExtraArg),
	!, put_extra_arg_body(Words, NewBody, _).
put_extra_arg_body(NTerm, NewNTerm, ExtraArg) :-
	put_extra_arg(NTerm, NewNTerm, ExtraArg).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% User defined predicate for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_query_expansion(+Sentence, -Goal)
%   ʸ Sentence  Goal ѴơӣإȤ
%   뤹롥
%
%   ̤νλ̻֡ҤΥ󥿡 process ΰɲ
%   롥ٱ䶯˼̻ҤϿ뤿ΰɲä롥
%
%     sax_query_expansion(
%         [john,leaves,tokyo],
%         (visips_start_client,
%          visips_initialize([john,leaves,tokyo],sentence),
%          process([ie(np([begin(t,[])],[np(dx(true,_ID0)),john],
%                         0),true)],1,S1),
%          process([ie(vt(S1,[vt(dx(true,_ID1)),leaves],
%                         1),true)],2,S2),
%          process([ie(np(S2,[np(dx(true,_ID2)),tokyo],
%                         2),true)],3,S3),
%          fin(S3),
%          visips_finish,
%          visips_kill_client)
%                        )
%
sax_query_expansion(Sentence, Goal) :-
	sax_top_node_category(STerm/_), !,
	Goal = (visips_start_client,
	        visips_initialize(Sentence,STerm),
		Rest),
	make_sax_goal_extra_arg(Sentence, [begin(t,[])], 0,
	        Rest, (visips_finish,visips_kill_client)).
sax_query_expansion(_, true) :-
	format(user_error, 'Top node category not exists!!~n', []).

%   make_sax_goal_extra_arg(+Sentence, +Sj, +J, -Goal, +Tail)
%
make_sax_goal_extra_arg([], Sm, _, (fin(Sm),Tail), Tail) :- !.
make_sax_goal_extra_arg([Wordj|Rest], Sj_1, J_1,
            (process(Ej,J,Sj),Goal), Tail) :-
	sax_make_phrase(Wordj, [Sj_1,J_1], WordGoal),
	(   phrase(WordGoal, Ej)
	;   sax_make_phrase('UNKNOWN',
	            [Sj_1,['UNKNOWN'(dx(true,_)),Wordj],J_1],
	            InActive),
	    Ej = [ie(InActive,true)]
	),
        J is J_1 + 1,
	!, make_sax_goal_extra_arg(Rest, Sj, J, Goal, Tail).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Final process for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   fin(+Sm)
%   ǸñץȤäȥ꡼ Sm Фơ
%   ǽܤ
%
%   ڤϤ롥
%
fin([]) :- !.
fin([Id|SmTail]) :- Id =.. [idend,_,[SDx],_To|Args], !,
	(   tree_writer_mode(off)
	;   call_delayed_extra(SDx, Tree),
	    treeprint(Tree), nl,
	    ( Args = [] ; write(Args), nl, nl )
	),
	!, fin(SmTail).
fin([_|SmTail]) :-
	fin(SmTail).
