/********************************************************/
/*               SAX User Definition File               */
/*  Sample for SAX with VisIPS and Unification Grammar  */
/*                                                      */
/*         Copyright (C) 1995 Yasuharu Den              */
/*                  (30 January 1995)                   */
/*  by Yasuharu Den (den@itl.atr.co.jp)                 */
/*  ATR Interpreting Telecommunications Research Labs.  */
/********************************************************/

%   load SAX system
:- use_module(library(sax)).
:- use_module(library(sax_trans)).

%   load interface programs
:- ensure_loaded(library('sax_user/extra')).
:- ensure_loaded(library('sax_user/unify_sax')).
:- ensure_loaded(library('VisIPS/visips')).
:- ensure_loaded(library('sax_user/tree_sax')).
:- ensure_loaded(library('sax_user/visips_process')).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   user defined predicate for VisIPS
write_string(Str, [FS]) :- fprint(Str, FS).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for SAX translator
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_trans_idterm(+Type)
%   ӣإȥ󥹥졼Υ Type ꤹ롥
%
sax_trans_idterm(short).

%   sax_trans_tp_filter(+Type)
%   ӣإȥ󥹥졼ףˤ벼ͽ¬ե
%   Υ Type ꤹ롥
%
sax_trans_tp_filter(no).

%   sax_trans_block(+Use)
%   ӣإȥ󥹥졼ף block 뤫
%    Use ꤹ롥
%
sax_trans_block(no).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_input_mode(+Mode)
%   ӣإƥϥ⡼ Mode ꤹ롥
%
sax_input_mode(string).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% User defined predicate for SAX translator 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_term_expansion(+Rule, -ExpandedRule)
%   ʸˡ§ Rule  ExpandedRule ѴƤӣإȥ
%   졼Ϥ
%
%   䶯˽񤫤줿¤ñ첽ץ
%   Ѵ롥
%   ̤γϰ֤ɽɲä롥ٱ䶯˼̻Ҥ
%   Ͽ뤿ΰɲä롥
%
%     sax_term_expansion(
%         (v(Mother) --> v(Head),
%                        n(Comp),
%                        {Head@cat@head   = Mother@cat@head},
%                        {Head@cat@subcat = [Comp|Mother@cat@subcat]},
%                        {Head@cont = Mother@cont}
%                        & {extra}),
%         (v(Pos,Mother) --> v(Pos,Head),
%                            n(_,Comp),
%                            {unify(f(_#[cat:_#[head:A,subcat:B],cont:C],
%                                     _#[cat:_#[head:A,subcat:[D|B]],cont:C],
%                                     D),
%                                   f(_Mother,Head,Comp),
%                                   f(Mother,_Head,_Comp))}
%                            & {dx(extra,_)})
%                        )
%
sax_term_expansion((:- sax_top_node_category(_,Func/Arity)),
	           (:- sax_top_node_category(_,Func/Arity1))) :- !,
	Arity1 is Arity + 1.
sax_term_expansion((Head --> Body & Dx), (Head1 --> Body1 & Dx1)) :- !,
	Head =.. [F,X],
	Head1 =.. [F,ExtraArg,X1],
	get_fs_body(Body, Vars),
	trans_unify_extra_arg_body(Body, Body1,
	        [(X,_)|Vars], [(_,X1,_)|_], ExtraArg),
	put_extra_arg_delayed_extra(Dx, Dx1).
sax_term_expansion((Head --> Body), (Head1 --> Body1 & Dx1)) :-
	Head =.. [F,X],
	Head1 =.. [F,ExtraArg,X1],
	get_fs_body(Body, Vars),
	trans_unify_extra_arg_body(Body, Body1,
	        [(X,_)|Vars], [(_,X1,_)|_], ExtraArg),
	put_extra_arg_delayed_extra(true, Dx1).

%   put_extra_arg_delayed_extra(+Dx, -NewDx)
%
put_extra_arg_delayed_extra({G}, {dx(G,_)}) :- !.
put_extra_arg_delayed_extra(G,   {dx(G,_)}).

%   get_fs_body(+Body, -Vars)
%
get_fs_body(((Body1,Body2),Body), Vars) :- !,
	get_fs_body((Body1,(Body2,Body)), Vars).
get_fs_body(((Body1;Body2),Body), Vars) :- !,
	get_fs_body((Body1,(Body2,Body)), Vars).
get_fs_body(({_},Body), Vars) :- !,
	get_fs_body(Body, Vars).
get_fs_body(([],Body), Vars) :- !,
	get_fs_body(Body, Vars).
get_fs_body(([_|_],Body), Vars) :- !,
	get_fs_body(Body, Vars).
get_fs_body((NTerm,Body), [(X,_)|Vars]) :- !,
	NTerm =.. [_,X],
	get_fs_body(Body, Vars).
get_fs_body((Body1;Body2), Vars) :- !,
	get_fs_body((Body1,Body2), Vars).
get_fs_body({_}, []) :- !.
get_fs_body([], []) :- !.
get_fs_body([_|_], []) :- !.
get_fs_body(NTerm, [(X,_)]) :-
	NTerm =.. [_,X].

%   trans_unify_extra_arg_body(+Body, -NewBody, +Vars, -NewVars, +ExtraArg)
%
trans_unify_extra_arg_body(((Body1,Body2),Body), NewBody,
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_body((Body1,(Body2,Body)), NewBody,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_body(((Body1;Body2),Body), (NewBody1;NewBody2),
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_body((Body1,Body), NewBody1,
	        Vars, NewVars, ExtraArg),
	!, trans_unify_extra_arg_body((Body2,Body), NewBody2,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_body(([],Body), NewBody,
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_body(Body, NewBody,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_body((Term,Body), NewBody,
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_extra(Body, Term, [], NewBody,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_body((Body1;Body2), (NewBody1;NewBody2),
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_body(Body1, NewBody1,
	        Vars, NewVars, ExtraArg),
	!, trans_unify_extra_arg_body(Body2, NewBody2,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_body([], [], Vars, Vars, _) :- !.
trans_unify_extra_arg_body(Term, NewTerm, Vars, Vars, ExtraArg) :-
	trans_unify_extra_arg(Term, NewTerm, Vars, ExtraArg).

%   trans_unify_extra_arg_extra(+Body, +Term, +Exs, -NewBody,
%           +Vars, -NewVars, +ExtraArg)
%
trans_unify_extra_arg_extra(((Body1,Body2),Body), Term, Exs, NewBody,
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_extra((Body1,(Body2,Body)), Term, Exs, NewBody,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_extra(((Body1;Body2),Body), Term, Exs, (NewBody1;NewBody2),
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_extra((Body1,Body), Term, Exs, NewBody1,
	        Vars, NewVars, ExtraArg),
	!, trans_unify_extra_arg_extra((Body2,Body), Term, Exs, NewBody2,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_extra(({Extra},Body), Term, Exs, NewBody,
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_extra(Body, Term, [Extra|Exs], NewBody,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_extra((Body1;Body2), Term, Exs, (NewBody1;NewBody2),
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_extra_arg_extra(Body1, Term, Exs, NewBody1,
	        Vars, NewVars, ExtraArg),
	!, trans_unify_extra_arg_extra(Body2, Term, Exs, NewBody2,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_extra({Extra}, Term, Exs, NewBody,
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_feq_extra_arg(Term, [Extra|Exs], NewBody,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_extra([], Term, Exs, NewBody,
	        Vars, NewVars, ExtraArg) :- !,
	trans_unify_feq_extra_arg(Term, Exs, NewBody,
	        Vars, NewVars, ExtraArg).
trans_unify_extra_arg_extra(Body, Term, Exs, (NewBody1,NewBody),
	        Vars, NewVars, ExtraArg) :-
	trans_unify_feq_extra_arg(Term, Exs, NewBody1,
	        Vars, NVars, ExtraArg),
	!, trans_unify_extra_arg_body(Body, NewBody, NVars, NewVars, _).

%   trans_unify_feq_extra_arg(+Term, +Exs, -NewBody,
%           +Vars, -NewVars, +ExtraArg)
%
trans_unify_feq_extra_arg(Term, Exs, NewBody, Vars, NewVars, ExtraArg) :-
	trans_unify_extra_arg(Term, NewTerm, Vars, ExtraArg),
	trans_feq(Exs, NewTerm, NewBody, Vars, NewVars).

trans_unify_extra_arg([Word], [NewWord], _, ExtraArg) :- !,
	NewWord =.. [Word,ExtraArg].
trans_unify_extra_arg([Word|Words], ([NewWord],NewBody), Vars, ExtraArg) :- !,
	NewWord =.. [Word,ExtraArg],
	trans_unify_extra_arg(Words, NewBody, Vars, _).
trans_unify_extra_arg(NTerm, NewNTerm, Vars, ExtraArg) :-
	NTerm =.. [F,X],
	NewNTerm =.. [F,ExtraArg,X1],
	assoc_VAR(Vars, X, X1).

trans_feq([], Term, Term, Vars, Vars) :- !.
trans_feq(Exs, Term, (Term,NewExs), Vars, NewVars) :-
	feq2unify(Exs, NewExs, Vars, NewVars).

assoc_VAR([(X1,V,_)|_], X, V) :- X == X1, !.
assoc_VAR([_|Rest], X, V) :- assoc_VAR(Rest, X, V).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% User defined predicate for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_query_expansion(+Sentence, -Goal)
%   ʸ Sentence  Goal ѴơӣإȤ
%   뤹롥
%
%   ̤νλ̻֡ҤΥ󥿡 process ΰɲ
%   롥ٱ䶯˼̻ҤϿ뤿ΰɲä롥
%   ӣإΤ call_residue/2 򤫤롥
%
%     sax_query_expansion(
%         [john,leaves,tokyo],
%         call_residue(
%             (visips_start_client,
%              visips_initialize([john,leaves,tokyo],sentence),
%              process([ie(np([begin(t,[])],[np(dx(true,_ID0)),john],
%                             0),true)],1,S1),
%              process([ie(vt(S1,[vt(dx(true,_ID1)),leaves],
%                             1),true)],2,S2),
%              process([ie(np(S2,[np(dx(true,_ID2)),tokyo],
%                             2),true)],3,S3),
%              fin(S3),
%              visips_finish,
%              visips_kill_client),
%             _)
%                        )
%
sax_query_expansion(Sentence, call_residue(Goal,_)) :-
	sax_top_node_category(STerm/_), !,
	Goal = (visips_start_client,
	        visips_initialize(Sentence,STerm),
		Rest),
	make_sax_goal_extra_arg(Sentence, [begin(t,[])], 0,
	        Rest, (visips_finish,visips_kill_client)).
sax_query_expansion(_, true) :-
	format(user_error, 'Top node category not exists!!~n', []).

%   make_sax_goal_extra_arg(+Sentence, +Sj, +J, -Goal, +Tail)
%
make_sax_goal_extra_arg([], Sm, _, (fin(Sm),Tail), Tail) :- !.
make_sax_goal_extra_arg([Wordj|Rest], Sj_1, J_1,
            (process(Ej,J,Sj),Goal), Tail) :-
	sax_make_phrase(Wordj, [Sj_1,J_1], WordGoal),
	(   phrase(WordGoal, Ej)
	;   sax_make_phrase('UNKNOWN',
	            [Sj_1,['UNKNOWN'(dx(true,_)),Wordj],J_1],
	            InActive),
	    Ej = [ie(InActive,true)]
	),
        J is J_1 + 1,
	!, make_sax_goal_extra_arg(Rest, Sj, J, Goal, Tail).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Final process for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   fin(+Sm)
%   ǸñץȤäȥ꡼ Sm Фơ
%   ǽܤ
%
fin([]) :- !.
fin([Id|SmTail]) :- Id =.. [idend,_,[SDx],_To,FS], !,
	(   tree_writer_mode(off)
	;   call_delayed_extra(SDx, Tree),
	    treeprint(Tree), nl,
	    fprint(FS), nl
	),
	!, fin(SmTail).
fin([_|SmTail]) :-
	fin(SmTail).
