/*******************************************************/
/*               SAX User Definition File              */
/*              Sample for SAX with JUMAN              */
/*                                                     */
/*         Copyright (C) 1993 Yasuharu Den             */
/*                   (19 February 1993)                */
/*  by Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%   load SAX system
:- use_module(library(sax)).
:- use_module(library(sax_trans)).

%   load interface programs
:- ensure_loaded(library('sax_user/extra')).
:- ensure_loaded(library('sax_user/juman_sax')).
:- ensure_loaded(library('sax_user/tree_sax')).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for SAX translator
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_trans_idterm(+Type)
%   ӣإȥ󥹥졼Υ Type ꤹ롥
%
sax_trans_idterm(short).

%   sax_trans_tp_filter(+Type)
%   ӣإȥ󥹥졼ףˤ벼ͽ¬ե
%   Υ Type ꤹ롥
%
sax_trans_tp_filter(no).

%   sax_trans_block(+Use)
%   ӣإȥ󥹥졼ף block 뤫
%    Use ꤹ롥
%
sax_trans_block(no).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Flag for input mode
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_input_mode(+Mode)
%   ӣإƥϥ⡼ Mode ꤹ롥
%
sax_input_mode(jstring).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% User defined predicate for SAX translator 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_term_expansion(+Rule, -ExpandedRule)
%   ʸˡ§ Rule  ExpandedRule ѴƤӣإȥ
%   졼ϤǥեȤǤʸˡ§Τޤޣӣإ
%   󥹥졼Ϥ롥
%
:- abolish(sax_term_expansion, 2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% User defined predicate for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_query_expansion(+Sentence, -Goal)
%   ʸ Sentence  Goal ѴơӣإȤ
%   뤹롥
%
%   ʸ JUMAN ˤäƷǲϤη̤ӣ
%   Ѵ롥
%
%     sax_query_expansion(
%         "ޤǤޤ",
%         (process([ie(ư([begin(t,[])],[ư(true),]),true)],
%                  S1),
%          process([ie(̾([begin(t,[])],[̾(true),]),true)],
%                  S2),
%          process([ie(Ҹ³(S1,[Ҹ³(true),ޤ]),true),
%                   ie(ʽ(S2,[ʽ(true),]),true)],
%                  S3),
%          process([ie(ư(S3,[ư(true),ޤ]),true),
%                   ie(̾(S3,[̾(true),ޤ]),true)],
%                  S4),
%          fin(S4))
%                        )
%
sax_query_expansion(Sentence, Goal) :-
	call_juman(Sentence, MorphList),
	juman2lattice(MorphList, Lattice),
	make_sax_goal_from_lattice(Lattice, [0-[begin(t,[])]], Goal).

%   make_sax_goal_from_lattice(+Lattice, +Assoc, -Goal)
%
make_sax_goal_from_lattice([_-MListm], Assoc,
	        (process(Em,Sm),fin(Sm))) :- !,
	make_sax_process_from_morphs(MListm, Assoc, _, Em, Sm).
make_sax_goal_from_lattice([_-MListj|Rest], Assoc,
	        (process(Ej,Sj),Goal)) :-
	make_sax_process_from_morphs(MListj, Assoc, Assoc1, Ej, Sj),
	!, make_sax_goal_from_lattice(Rest, Assoc1, Goal).

%   make_sax_process_from_morphs(+MListj, +Assoc, -NewAssoc, -Ej, +Sj)
%
make_sax_process_from_morphs([], Assoc, Assoc, [], _) :- !.
make_sax_process_from_morphs([Morphj|Rest], Assoc, [ID-Sj|Assoc1],
	        [ie(InActive,true)|EjTail], Sj) :-
        juman:get_ID(Morphj, ID),
	juman:get_preIDL(Morphj, [PreID|_]),
	get_key_assoc(Assoc, PreID, Ej_1),
	getMorphInf(Morphj, NTerm, Word, Args),
	Dx =.. [NTerm,true],
	sax_make_phrase(NTerm, [Ej_1,[Dx,Word]|Args], InActive),
	!, make_sax_process_from_morphs(Rest, Assoc, Assoc1, EjTail, Sj).

get_key_assoc([K-V|_], K, Value) :- !, Value = V.
get_key_assoc([_|Rest], K, Value) :- get_key_assoc(Rest, K, Value).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Meta process for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   process(+Eu, -Su)
%   ñץȤäȥ꡼ Eu Фơ᥿
%   ܤΤ Su ȤơñץϤ
%
process([], []) :- !.
process([ie(InActive,Exs)|EuTail], Su) :- !,
	(   call_extra(Exs, InActive, CopyOfInActive),
	    phrase(CopyOfInActive, NewEu, EuTail)
	;   NewEu = EuTail
	),
	!, process(NewEu, Su).
process([ae(Active,Exs)|EuTail], Su) :-
	(   call_extra(Exs, Active, CopyOfActive),
	    Su = [CopyOfActive|SuTail]
	;   Su = SuTail
	),
	!, process(EuTail, SuTail).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Final process for SAX system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   fin(+Sm)
%   ǸñץȤäȥ꡼ Sm Фơ
%   ǽܤ
%
%   ڤϤ롥
%
fin([]) :- !.
fin([Id|SmTail]) :- Id =.. [idend,_,[SDx]|Args], !,
	(   tree_writer_mode(off)
	;   call_delayed_extra(SDx, Tree),
	    treeprint(Tree), nl,
	    ( Args = [] ; write(Args), nl, nl )
	),
	!, fin(SmTail).
fin([_|SmTail]) :-
	fin(SmTail).
