/*******************************************************/
/*          Utility for Extra Term Evaluation          */
/*                                                     */
/*         Copyright (C) 1993 Yasuharu Den             */
/*                   (18 March 1993)                   */
/*  by Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%   call_extra(+Exs, +Edge, -CopyOfEdge)
%    Edge Ƥ¸ʤ 䶯 Exs ¹Ԥ롥
%   CopyOfEdge 䶯μ¹Ըθ̤ơ
%
call_extra(Exs, Edge, CopyOfEdge) :- ground(Exs), !,
	call(Exs),
	CopyOfEdge = Edge, !.
call_extra(Exs, lexicon(List,Edge), CopyOfLexicon) :- !,
	Edge =.. [Func,InS,Dx|Args],
	findall(f(Args,List), call(Exs), [f(CopyOfArgs,CopyOfList)]),
	CopyOfEdge =.. [Func,InS,Dx|CopyOfArgs],
	CopyOfLexicon = lexicon(CopyOfList,CopyOfEdge), !.
call_extra(Exs, Edge, CopyOfEdge) :-
	Edge =.. [Func,InS,Dx|Args],
	findall(Args, call(Exs), [CopyOfArgs]),
	CopyOfEdge =.. [Func,InS,Dx|CopyOfArgs], !.

%   findall_extra(+Exs, +Goal, -CopyOfGoal)
%    Goal Ƥ¸ʤ 䶯 Exs ¹Ԥ롥
%   CopyOfGoal 䶯μ¹Ըθ̤Ƥ¤٤롥
%
findall_extra(Exs, Goal, CopyOfGoal) :- ground(Exs), !,
	call(Exs),
	CopyOfGoal = Goal.
findall_extra(Exs, lexicon(List,Goal), CopyOfGoal) :- !,
	Goal =.. [Func,InS,Dx|Args],
	findall(f(Args,List), call(Exs), ListOfCopyOfF),
	f_goal(ListOfCopyOfF, Func, InS, Dx, CopyOfGoal).
findall_extra(Exs, Goal, CopyOfGoal) :-
	Goal =.. [Func,InS,Dx|Args],
	findall(Args, call(Exs), ListOfCopyOfArgs),
	goal(ListOfCopyOfArgs, Func, InS, Dx, CopyOfGoal).

f_goal([f(Args,List)], Func, InS, Dx, lexicon(List,Goal)) :- !,
	Goal =.. [Func,InS,Dx|Args].
f_goal([f(Args,List)|Rest], Func, InS, Dx, (lexicon(List,Goal),Rest1)) :-
	Goal =.. [Func,InS,Dx|Args],
	f_goal(Rest, Func, InS, Dx, Rest1).

goal([Args], Func, InS, Dx, Goal) :- !,
	Goal =.. [Func,InS,Dx|Args].
goal([Args|Rest], Func, InS, Dx, (Goal,Rest1)) :-
	Goal =.. [Func,InS,Dx|Args],
	goal(Rest, Func, InS, Dx, Rest1).

