/*******************************************************/
/*              Utility for SAX Translator             */
/*                                                     */
/*  Copyright (C) 1993 Yuji Matsumoto, Yasuharu Den    */
/*                  (23 February 1993)                 */
/*  by Yuji Matsumoto (matsu@pine.kuee.kyoto-u.ac.jp)  */
/*     Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%   needs append/3 from library lists.
:- use_module(library(lists), [append/3]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Basic Predicates
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   make_phrase(+Func, +Args, -Phrase)
%   ؿ Func Ȱ Args  Phrase 롥
%
make_phrase(Func, Args, Phrase) :-
	X =.. [Func,_,_|Args],
	(   predicate_property(user:X, built_in) ->
	    concat_atoms(Func, '_u', Func1)
	;   Func1 = Func
	),
	Phrase =.. [Func1|Args], !.

%   concat_atoms(+Atom1, +Atom2, ?NewAtom)
%   ȥ Atom1, Atom2 ϢܤΤ NewAtom Ȥ롥
%
concat_atoms(Atom1, Atom2, NewAtom) :-
	name(Atom1, Name1),
	name(Atom2, Name2),
	append(Name1, Name2, Name3),
	name(Atom3, Name3),
	!, NewAtom = Atom3.

%   equiv(+Term1, +Term2)
%    Term1, Term2 ɤĴ٤롥
%
equiv(Term1, Term2) :- \+ \+ equiv1(Term1, Term2).

equiv1(Term1, Term2) :-
	numbervars(Term1, 0, N),
	numbervars(Term2, 0, N),
	!, Term1 = Term2.

%   gensym(+Name, ?Symbol)
%   Name ǤϤޤˡʥܥ Symbol 롥
%
:- dynamic symbol/2.

gensym(Name, Symbol) :-
	(   retract(symbol(Name,N))
	;   N = 0
	),
	N1 is N + 1,
	asserta(symbol(Name,N1)),
	concat_atoms(Name, N, Symbol), !.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Print Clause
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   print_clause(+Clause)
%   print_clause(+OutStream, +Clause)
%    Clause  OutStream 񤹤롥
%
print_clause(Clause) :- portray_clause(Clause).
print_clause(OutStr, Clause) :- portray_clause(OutStr, Clause).

%   print_quoted(+Clause)
%   print_quoted(+OutStream, +Clause)
%    Clause  OutStream ˤΤޤ޽Ϥ롥
%
print_quoted(Clause) :-
	writeq(Clause), write('.'), nl.
print_quoted(OutStr, Clause) :-
	writeq(OutStr, Clause), write(OutStr, '.'), nl(OutStr).
