/*******************************************************/
/*                      SAX System                     */
/*                                                     */
/*  Copyright (C) 1994 Yasuharu Den, Yuji Matsumoto    */
/*                   (23 February 1993)                */
/*  by Yuji Matsumoto (matsu@pine.kuee.kyoto-u.ac.jp)  */
/*     Yasuharu Den   (den@forest.kuee.kyoto-u.ac.jp)  */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*                                                     */
/*  MODIFIED         (15 April 1994)                   */
/*  by Yasuharu Den (den@itl.atr.co.jp)                */
/*  ATR Interpreting Telecommunications Research Labs. */
/*******************************************************/

:- module(sax, [
	sax_make_phrase/3,
	sax/0,
	sax/2,
	sax/1
	       ]).

:- ensure_loaded([input,jinput,runtime,sax_utils]).

% Version of this system
ver('SAX System 2.0 #1: Fri Apr 15 1994').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SAX Make Phrase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax_make_phrase(+Func, +Args, -Phrase)
%   ؿ Func Ȱ Args ӣع Phrase 롥
%
sax_make_phrase(Func, Args, Phrase) :- make_phrase(Func, Args, Phrase).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SAX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   sax
%   sax(+InFile, +OutFile)
%   InFile ɤʸʸϤ̤ OutFile ˽񤯡
%
sax :- sax(user, user).

sax(InFile, OutFile) :-
	ver(Version),
	format(user_error, '~w~n', [Version]),
	(   InFile = user -> InStr = user_input
	;   open(InFile, read, InStr)
	),
	(   OutFile = user -> OutStr = user_output
	;   open(OutFile, write, OutStr)
	),
	current_input(SaveInput),
	current_output(SaveOutput),
	set_input(InStr),
	set_output(OutStr), !,
	sax1,
	close(InStr),
	close(OutStr),
	set_input(SaveInput),
	set_output(SaveOutput), !.

sax1 :-
	repeat,
	(   user:sax_input_mode(string) -> input_string(Sentence)
	;   user:sax_input_mode(jstring) -> input_jstring(Sentence)
	;   read(Sentence)
	),
	(   Sentence = end_of_file
	;
	    sax(Sentence),
	    fail
	).

%   sax(+Sentence)
%   ʸ Sentence ʸϤ롥
%
sax(Sentence) :-
	(   user:sax_query_expansion(Sentence, Goal)
	;   sax_query_expansion_default(Sentence, Goal)
	),
	runtime(user:Goal), !.

%   sax_query_expansion_default(+Sentence, -Goal)
%   ʸ Sentence 򥴡 Goal Ѵ롥
%
sax_query_expansion_default(Sentence, Goal) :-
	make_sax_goal_default(Sentence, [begin(t,[])], Goal).

make_sax_goal_default([], InS, fin(InS)) :- !.
make_sax_goal_default([Word|Rest], InS,
	        (process(WordS,OutS),Goal)) :-
        make_phrase(Word, [InS], WordGoal),
	(   phrase(user:WordGoal, WordS)
	;   make_phrase('UNKNOWN', [InS,['UNKNOWN'(true),Word]],
	            InActive),
	    WordS = [ie(InActive,true)]
	),
	!, make_sax_goal_default(Rest, OutS, Goal).
