/*******************************************************/
/*                       Runtime                       */
/*                                                     */
/*         Copyright (C) 1992  Yuji Matsumoto          */
/*                  (14 December 1992)                 */
/*  by Yuji Matsumoto (matsu@pine.kuee.kyoto-u.ac.jp)  */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Runtime
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   runtime(+Goal)
%    Goal ¹Ԥ¹Ի֤ɽ롥
%
runtime(Goal) :-
	statistics(runtime, [Rn_base,_]),
	statistics(garbage_collection, [_,_,Gc_base]),
	statistics(stack_shifts, [_,_,Ss_base]),
	(   call(Goal)
	;   format('failed~n', [])
	),
	statistics(runtime, [Rn_end,_]),
	statistics(garbage_collection, [_,_,Gc_end]),
	statistics(stack_shifts, [_,_,Ss_end]),
	Gc_time is Gc_end - Gc_base,
	Ss_time is Ss_end - Ss_base,
	Rn_time is Rn_end - Rn_base - Gc_time - Ss_time,
	nl,
	format('execution time (CPU time) = ~d msec.~n', [Rn_time]),
	format('garbage collection time   = ~d msec.~n', [Gc_time]),
	format('stack shifting time       = ~d msec.~n', [Ss_time]),
	nl, !.
