/*******************************************************/
/*              Input Routine for English              */
/*                                                     */ 
/*  Copyright (C) 1994 Yasuharu Den, Yuji Matsumoto    */
/*                  (28 December 1992)                 */
/*  by Yuji Matsumoto (matsu@pine.kuee.kyoto-u.ac.jp)  */
/*     Yasuharu Den   (den@forest.kuee.kyoto-u.ac.jp)  */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*                                                     */
/*  MODIFIED         (15 April 1994)                   */
/*  by Yasuharu Den (den@itl.atr.co.jp)                */
/*  ATR Interpreting Telecommunications Research Labs. */
/*******************************************************/

%   input_string(-List)
%   ʸɤ߹ List Ѵ롥
%
input_string(List) :-
	get(C),
	C \== -1,
	!, words(C, List).
input_string(end_of_file).

words(C, Tail) :- space(C), !,
	get0(C1),
	words(C1, Tail).
words(C, [S|Tail]) :- symbol(C), !,
	name(S, [C]),
	get0(C1),
	words(C1, Tail).
words(C, [Word|Tail]) :- letter(C), !,
	word(C, C1, Name),
	name(Word, Name),
	!, words(C1, Tail).
words(_, []).

word(L, C1, [L|Tail]) :-
	get0(C),
	(   letter(C) -> word(C, C1, Tail)
	;   C1 = C, Tail = []
	).

%   Charactor Types
space(9).   %  9 = "\t"
space(32).  % 32 = " "

symbol(C) :- C >= 33, C =< 47.
symbol(C) :- C >= 58, C =< 64.
symbol(C) :- C >= 91, C =< 96.
symbol(C) :- C >= 123, C =< 126.

letter(C) :- C >= 48, C =< 57.
letter(C) :- C >= 65, C =< 90.
letter(C) :- C >= 97, C =< 122.
letter(C) :- C >= 128.
