/********************************************************/
/*                   VisIPS Interface                   */
/*                                                      */
/*                   (12 March 1993)                    */
/*  by Yasuharu Den    (den@forest.kuee.kyoto-u.ac.jp)  */
/*  Dept. of Electrical Engineering, Kyoto University   */
/********************************************************/

% for Tk-VisIPS  by Tak Nakayama (18 May 1996)

:- module(visips, [
	visips_debug/0,
	visips_nodebug/0,
	visips_debugging/1,
	visips_display/1,
	visips_option/2,
	visips_option/3,
	visips_start_server/0,
	visips_kill_server/0,
	visips_restart_server/0,
	visips_start_client/0,
	visips_kill_client/0,
	visips_initialize/2,
	visips_finish/0,
	call_visips_write/3
	       ]).

:- use_module(library(charsio), [read_from_chars/2]).

:- ensure_loaded([socket,utils]).

%   set VisIPS default server address and program
%
visips_default_server_host('violet.aist-nara.ac.jp').
visips_default_server_port(Port) :-
	(
	    '$visips_version'(tk) ->
	    Port = 16022
	;
	    ( '$visips_mode'(batch) ->
	      Port = 16020
	    ; Port = 16025
	    )
	).
visips_default_batch_server_path('~nltools/visips/Server/visips_server').
visips_default_inter_server_path('~nltools/visips/Inter/visips_server').
visips_default_tk_server_path('~nltools/TkVisIPS/tk-visips-server').
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% VisIPS Option Aliases
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   visips_debug
%
visips_debug :- visips_option(debugging, _, on).

%   visips_nodebug
%
visips_nodebug :- visips_option(debugging, _, off).

%   visips_debugging(?Status)
%
visips_debugging(Status) :- visips_option(debugging, Status).

%   visips_display(+Display)
%
visips_display(Display) :- visips_option(display, _, Display).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% VisIPS Options
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- dynamic
	'$visips_debugging'/1,
	'$visips_display'/1,
	'$visips_delete_orphans'/1,
	'$visips_mode'/1,
	'$visips_version'/1.

'$visips_debugging'(on).           % on/off
'$visips_display'('unix:0.0').     % DISPLAY
'$visips_delete_orphans'(off).     % on/off
'$visips_mode'(batch).             % batch/interactive
'$visips_version'(tk).            % ꥸʥ/Tk

%   visips_option(+Option, ?Old)
%   visips_option(+Option, ?Old, +New)
%   VisIPS ץ Option θߤ Old 򿷤 New
%   ѹ롥
%
visips_option(Option, Old) :- visips_option(Option, Old, Old), !.

visips_option(Option, Old, New) :-
	( var(New) -> Old == New ; true ),
	visips_option1(Option, Old, New), !.

visips_option1(debugging, Old, New) :-
	retract('$visips_debugging'(Old)),
	asserta('$visips_debugging'(New)).
visips_option1(display, Old, New) :-
	retract('$visips_display'(Old)),
	asserta('$visips_display'(New)).
visips_option1(delete_orphans, Old, New) :-
	retract('$visips_delete_orphans'(Old)),
	asserta('$visips_delete_orphans'(New)).
visips_option1(mode, Old, New) :-
	retract('$visips_mode'(Old)),
	asserta('$visips_mode'(New)).
visips_option1(version, Old, New) :-
	retract('$visips_version'(Old)),
	asserta('$visips_version'(New)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Start and Kill VisIPS Server
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   visips_start_server
%   VisIPS С򥹥Ȥ롥
%
visips_start_server :-
	(   user:visips_server_host(Host)
	;   visips_default_server_host(Host)
	),
	(   user:visips_server_port(Port)
	;   visips_default_server_port(Port)
	),
	(   user:visips_server_path(Path)
	;   ('$visips_version'(tk) ->
	     visips_default_tk_server_path(Path)
	    ;
		('$visips_mode'(batch) ->
		 visips_default_batch_server_path(Path)
		;   visips_default_inter_server_path(Path)
		)
	    )
	), !,
	visips_server_program(Host, Port, Path, Command),
	call_unix(shell(Command)), !.

visips_server_program(local, Port, Path, Command) :- !,
	all_concat_atoms(['(',Path,' -inet ',Port,'&)'], Command).
visips_server_program(Host, Port, Path, Command) :- current_host(Host), !,
	all_concat_atoms(['(',Path,' -inet ',Port,'&)'], Command).
visips_server_program(Host, Port, Path, Command) :-
	all_concat_atoms(['(rsh ',Host,' ',Path,' -inet ',Port,'&)'], Command).

%   visips_kill_server
%   VisIPS С򥭥뤹롥
%
visips_kill_server :-
	(   user:visips_server_host(Host)
	;   visips_default_server_host(Host)
	),
	(   user:visips_server_port(Port)
	;   visips_default_server_port(Port)
	), !,
	socket_open(Host, Port, Str),
	write(Str, visips_server_kill),
	socket_flush_output(Str),
	socket_close(Str), !.

%   visips_restart_server
%   VisIPS СƵư
%
visips_restart_server :-
    visips_kill_server,
    visips_start_server.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Start and Kill VisIPS Client
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- dynamic visips_stream/1.

%   visips_start_client
%   VisIPS 饤Ȥ򥹥Ȥ롥
%
visips_start_client :- visips_debugging(off), !.
visips_start_client :- visips_stream(Str), !,
	format(user_error,
	        'VisIPS client already started with ~w~n', [Str]).
visips_start_client :-
	(   user:visips_server_host(Host)
	;   visips_default_server_host(Host)
	),
	(   user:visips_server_port(Port)
	;   visips_default_server_port(Port)
	), 
	(   user:visips_client_startup_file(File)
	;   File = '~/.visipsrc'
	),
	absolute_file_name(File, InitFile),
	!,
	socket_open(Host, Port, Str),
	write(Str, 'visips_client_start'),
	('$visips_version'(tk) ->
	 write(Str, ' '),
	 write(Str, InitFile),
	 write(Str, ' '),
	 ('$visips_mode'(batch) ->
	  write(Str, 'batch')
	 ;
	  write(Str, 'inter')
	 )
	;true
	),
	socket_flush_output(Str),
	assert(visips_stream(Str)), !.

%   visips_kill_client
%   VisIPS 饤Ȥä
%
visips_kill_client :- visips_debugging(off), !.
visips_kill_client :-
	( visips_option(mode, batch) ->
	  retract(sax_trans:symbol('',_))   % batchǤפˤʤ
	; []
	),
	retract(visips_stream(Str)),
	socket_close(Str), !.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% VisIPS Data Handling
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   visips_initialize(+Sentence, +TopNode)
%   VisIPS ˽ǡȤơ
%
%       ǥץ쥤   Display
%       ʸñ N
%       ñ1          Word1
%       ñ2          Word2
%       ...
%       ñN          WordN
%       ȥåץΡ̾ TopNode
%       ץ     Option
%
%   롥
%
visips_initialize(_, _) :- visips_debugging(off), !.
visips_initialize(Sentence, TopNode) :-
	visips_stream(Str),
	visips_option(display, Display),
	make_visips_option(Option),
	length(Sentence, N),
	write_VisIPS(Str, i),
	write_VisIPS(Str, Display),
	write_VisIPS(Str, N),
	write_list_VisIPS(Str, Sentence),
	write_VisIPS(Str, TopNode),
	write_VisIPS(Str, Option), !.

%   visips_finish
%   VisIPS ʸνλιޤ롥
%
visips_finish :- visips_debugging(off), !.
visips_finish :-
	visips_stream(Str),
	write_VisIPS(Str, f), !.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Send Edge Data to VisIPS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   call_visips_write(+Data, -NewData, +To)
%   ̤Υǡ Data  VisIPS ϤTo ϸ̤νλ֡
%
call_visips_write(InActive, InActive, _) :- visips_debugging(off), !.
call_visips_write(InActive, NewInActive, To) :-
	InActive =.. [Func,InS,[Dx|Dxs],From|Args],
	Length is To - From,
	Pos is From + 1,
	( make_children(Dxs, Children) ; Children = [] ),
	visips_stream(Str),
	length(Children, N),
	write_VisIPS(Str, w),
	write_VisIPS(Str, Pos),
	write_VisIPS(Str, Length),
	write_VisIPS(Str, Func),
	write_string_VisIPS(Str, Args),
	write_VisIPS(Str, N),
	write_list_VisIPS(Str, Children), !,
      ( visips_option(mode, batch) ->
	sax_trans:gensym('',ID),  % Batch server IDμƳ
	popupID(Dx, ID),          % 褦ѹСΣԤϾä
	NewInActive = InActive
      ; socket_read_term(Str, ID),
	popupID(Dx, ID),
	socket_read_term(Str, Res),
%        format(user_output, 'result is ~w~n', [Res]),
	( Res = 3 ->
          socket_read_term(Str, NewArgs),
	  NewInActive =.. [Func,InS,[Dx|Dxs],From|NewArgs]
	; Res = 2 -> !,fail
	; NewInActive = InActive
	)
      ).

make_children([], []) :- !.
make_children([[Dx|_]|Rest], [ID|Children]) :-
	popupID(Dx, ID),
	!, make_children(Rest, Children).

popupID(Dx, ID) :- arg(1, Dx, dx(_,ID)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% VisIPS I/O Premitives
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   write_VisIPS(+Stream, +Term)
%   ȥ꡼ Stream ˹ Term Ϥ롥
%
write_VisIPS(Str, Term) :-
	write(Str, Term),
	socket_flush_output(Str).

map_write_VisIPS([], _) :- !.
map_write_VisIPS([Term|Rest], Str) :-
	write_VisIPS(Str, Term),
	!, map_write_VisIPS(Rest, Str).

%   write_list_VisIPS(+Stream, +List)
%   ȥ꡼ Stream ˥ꥹ List Ϥ롥
%
write_list_VisIPS(Str, List) :- map_write_VisIPS(List, Str).

%   write_string_VisIPS(+Stream, +String)
%   ȥ꡼ Stream ʸ String Ϥ롥
%
%   String ϥ桼Ҹ write_string/2 ˤäơStream
%   롥ǥեȤǤ String  Prolog ιȤƤ
%   Τޤ Stream 롥
%
write_string_VisIPS(Str, String) :- user:write_string(Str, String), !,
	socket_flush_output(Str).
write_string_VisIPS(Str, String) :- write_VisIPS(Str, String).

%
%   socket_read_term(+Stream, +Term)
%
socket_read_term(Stream, Term) :-
        socket_read_string(Stream, String, [0'.,10]), !,
        read_from_chars(String, Term).

socket_read_string(Stream, String, Tail) :-
        get0(Stream, C),
        socket_read_string(C, String, Tail, Stream).

socket_read_string(C, Tail, Tail, _) :- eos(C), !.
socket_read_string(C, [C1|String], Tail, Stream) :-
        fix_code(C, C1),
        get0(Stream, C2),
        socket_read_string(C2, String, Tail, Stream).

% ɤ
fix_code(C, C1) :- C < 0, !, C1 is C + 256.
fix_code(C, C).

% ǡν
eos(0).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% VisIPS Utility
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% List of VisIPS Options
visips_option_list([
	delete_orphans-on
		   ]).

%   make_visips_option(-Option)
%   VisIPS ץθߤӥåѴ Option 
%   Ȥ롥
%
make_visips_option(Option) :-
	visips_option_list(List),
	make_visips_option(List, 2'1, 2'0, Option).

make_visips_option([], _, Option, Option) :- !.
make_visips_option([K-V|Rest], Bit, Option, Option2) :-
	(   visips_option(K, V) -> Option1 is Option \/ Bit
	;   Option1 = Option
	),
	Bit1 is Bit << 1,
	!, make_visips_option(Rest, Bit1, Option1, Option2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% set DISPLAY Variable from C module
%%%                      by osamu imaichi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
foreign_file('lib.o', [get_display]).
foreign(get_display, c, getenv_display([-string])).
:- load_foreign_files(['lib.o'], ['-lc']).
:- 
	getenv_display(X),	
	visips_display(X).
