/*********************************************************/
/*                        Utility                        */
/*                                                       */
/*  Copyright (C) 1992  Takehito Utsuro,Yasuharu Den     */
/*                   (22 December 1992)                  */
/*  by Takehito Utsuro (utsuro@pine.kuee.kyoto-u.ac.jp)  */
/*     Yasuharu Den    (den@forest.kuee.kyoto-u.ac.jp)   */
/*   Dept. of Electrical Engineering, Kyoto University   */
/*********************************************************/

%  Needs append/3 from library lists.
:- use_module(library(lists), [append/3]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Basic Predicates
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   all_concat_atoms(+List, ?NewAtom)
%   ꥹ List ʤΥȥ򤹤٤ϢܤΤ NewAtom
%   Ȥ롥
%
all_concat_atoms([Atom], NewAtom) :- !, NewAtom = Atom.
all_concat_atoms(List, NewAtom) :-
	all_concat_atoms1(List, Name),
	name(Atom, Name),
	!, NewAtom = Atom.

all_concat_atoms1([], []) :- !.
all_concat_atoms1([Atom1|Rest], Name) :-
	name(Atom1, Name1),
	append(Name1, Name2, Name),
	!, all_concat_atoms1(Rest, Name2).

%  call_unix(+Pred)
%  unixΥޥɤƤӽФ (for both SICStus2.1 and SICStus3)
%
call_unix(P) :-
	( call(system:P)
	; unix(P)
	).
