/*******************************************************/
/*                  Socket I/O Routine                 */
/*                                                     */ 
/*                  (22 December 1992)                 */
/*  by Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

%  Needs append/3 from library lists.
:- use_module(library(lists), [append/3]).

:- prolog_flag(version,PVer),
	name('SICStus 2.1',SICStus21),
	name(PVer,CPVer),
	( append(SICStus21,_,CPVer)
	; use_module(library(sockets))
	).

%   socket_open(+Host, +Address, -Stream)
%   ۥ Host Υɥ쥹 Address ΥåȤ򥪡ץ󤷡
%   Υȥ꡼ Stream Ȥ롥
%
socket_open(local, Address, Str) :- !,
	socket('AF_UNIX', Socket),
	socket_connect(Socket, 'AF_UNIX'(Address), Str).
socket_open(Host, Address, Str) :-
	socket('AF_INET', Socket),
	socket_connect(Socket, 'AF_INET'(Host,Address), Str).

%   socket_close(+Stream)
%   åȡȥ꡼ Stream 򥯥롥
%
socket_close(Str) :- close(Str).

%   socket_flush_output(+Stream)
%   åȡȥ꡼ Stream եå夹롥
%
socket_flush_output(Str) :- put(Str, 0), flush_output(Str).
