/*******************************************************/
/*                    UG-SAX Interface                 */
/*                                                     */
/*          Copyright (C) 1993 Yasuharu Den            */
/*                   (26 January 1993)                 */
/*  by Yasuharu Den (den@forest.kuee.kyoto-u.ac.jp)    */
/*  Dept. of Electrical Engineering, Kyoto University  */
/*******************************************************/

/* eval_term/2 is changed in order to handle TFS       */
/*                   by Takuya Nakayama (20 Nov. 1995) */

%   use funify module
%:- use_module(library('Utility/tfunify')).
:- use_module('tfunify').

%   use fprint module
%:- use_module(library('Utility/tfprint')).
:- use_module('tfprint').

%   needs same_length/2 and append/3 from library lists.
:- use_module(library(lists), [same_length/2,append/3]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Convert Feature Equations into Feature Unification
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:- op(500, yfx, @).

%   feq2unify(+Exs, -NewExs, +Vars, -NewVars)
%   꼰ǵҤ줿䶯 Exs ¤ñ첽ץ
%    NewExs Ѵ롥Vars ¤ɽѿΥꥹ
%   ȤǡΤ Exs ǻȤ줿ΤϿѿ֤
%    NewVars Ȥ롥
%
%   <Feature Equation> ::= <Path Expression>=<Path Expression>
%   <Path Expression> ::= <Path Expression>@<Path Expression> | <Term>
%   <Term> ::= a term, which may include <Feature Equation>'s as its arguments
%
feq2unify(Exs, NewExs, Vars, NewVars) :-
	mark_vars(Exs, Vars),
	c_vars(Vars, CVars, LVars),
	copy_term(f(CVars,Exs), f(CopyOfCVars,CopyOfExs)),
	eval_eqs(CopyOfExs, RestExs),
	term_vars(RestExs, RestVars),
	copy_term(f(RestVars,RestExs), f(CopyOfRestVars,CopyOfRestExs)),
	make_unify(CopyOfCVars, RestVars, LVars, RVars, CopyOfRestVars, S),
	copy_vars(Vars, RVars, NewVars),
	put_extras(CopyOfRestExs, {S}, NewExs), !.

%   mark_vars(+Term, +Vars)
%
mark_vars(X, Vars) :- var(X), !,
	check_used_VAR(Vars, X).
mark_vars(X, Vars) :-
	functor(X, _, N),
	loop_mark_vars(0, N, X, Vars).

loop_mark_vars(N, N, _, _) :- !.
loop_mark_vars(M, N, X, Vars) :-
	M1 is M + 1,
        arg(M1, X, A),
        mark_vars(A, Vars),
        !, loop_mark_vars(M1, N, X, Vars).

check_used_VAR([], _) :- !.
check_used_VAR([(X1,_,YN)|_], X) :- X == X1, !, YN = yes.
check_used_VAR([_|Rest], X) :- check_used_VAR(Rest, X).

%   c_vars(+Vars, -CVars, -LVars)
%
c_vars([], [], []) :- !.
c_vars([(X,X1,YN)|Rest], CVars, LVars) :- YN == yes, !,
	CVars = [X|CVars1],
	LVars = [X1|LVars1],
	c_vars(Rest, CVars1, LVars1).
c_vars([_|Rest], CVars, LVars) :-
	c_vars(Rest, CVars, LVars).

%   copy_vars(+Vars, +RVars, -NewVars)
%
copy_vars([], [], []) :- !.
copy_vars([(X,_,YN)|Rest], RVars, NewVars) :- YN == yes, !,
	RVars = [X1|RVars1],
	NewVars = [(X,X1,_)|NewVars1],
	copy_vars(Rest, RVars1, NewVars1).
copy_vars([V|Rest], RVars, [V|NewVars]) :-
	copy_vars(Rest, RVars, NewVars).

%   term_vars(+Term, -Vars)
%
term_vars(Term, Vars) :- term_vars(Term, [], Vars), !.

term_vars(X, Vars, NewVars) :- var(X), !,
	add_VAR(Vars, X, NewVars).
term_vars(X, Vars, NewVars) :-
	functor(X, _, N),
	loop_term_vars(0, N, X, Vars, NewVars).

loop_term_vars(N, N, _, Vars, Vars) :- !.
loop_term_vars(M, N, X, Vars, NewVars) :-
        M1 is M + 1,
        arg(M1, X, A),
        term_vars(A, Vars, NVars),
        !, loop_term_vars(M1, N, X, NVars, NewVars).

add_VAR([], X, [X]) :- !.
add_VAR(Vars, X, Vars) :- Vars = [X1|_], X == X1, !.
add_VAR([A|Rest], X, [A|Rest1]) :- add_VAR(Rest, X, Rest1).

%   put_extras(+Exs, +First, -Goal)
%
put_extras([], First, First) :- !.
put_extras([Extra|Rest], First, (First,Goal)) :-
	put_extras(Rest, {Extra}, Goal).

%   make_unify(+Vars1, +RestVars1, +Vars2, -Vars3, +RestVars3, -S)
%
make_unify(X1, X2, Y1, Z1, Z2, S) :-
	same_length(Y1, Z1),
	same_length(Y2, Z2),
	append(X1, X2, X),
	append(Y1, Y2, Y),
	append(Z1, Z2, Z),
	freduce_term(X, W),
	(   W = [WW], Y = [YY], Z = [ZZ]
	;   WW =.. [f|W], YY =.. [f|Y], ZZ =.. [f|Z]
	),
	S = unify(WW,YY,ZZ), !.

%   eval_eqs(+Exs, -RestOfExs)
%
eval_eqs([], []) :- !.
eval_eqs([X=Y|Rest], Exs) :-
	eval_term(X, X1),
	eval_term(Y, Y1),
	funify(X1, Y1),
	!, eval_eqs(Rest, Exs).
eval_eqs([X|Rest], [X1|Rest1]) :-
	eval_term(X, X1),
	!, eval_eqs(Rest, Rest1).

eval_term(X, Y) :- var(X), !, Y = X.
eval_term(X@A, Y) :- !,
	eval_term(X, X1),
	(nonvar(A), A = Type/A0 ->
	   eval_term(A0, A1),
	   eval_path_exp(Type, X1, A1, Y)
	;
	   eval_term(A, A1),
	   eval_path_exp(X1, A1, Y)
	).
	   
eval_term(X, Y) :-
        functor(X, F, N),
        functor(Y, F, N),
        loop_eval_term(0, N, X, Y).

loop_eval_term(N, N, _, _) :- !.
loop_eval_term(M, N, X, Y) :-
        M1 is M + 1,
        arg(M1, X, A),
        arg(M1, Y, B),
        eval_term(A, B),
        !, loop_eval_term(M1, N, X, Y).

eval_path_exp(X, L, V) :- atomic(L), !,	funify(X, _#[L:V]).
eval_path_exp(Type, X, L, V) :- atomic(L), !, funify(X, _#Type/[L:V]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Feature Unification
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   unify(+Term1, +Term2, -Term3)
%   ¤ Term1, Term2 ñ첽η̤ Term3 Ȥ
%   롥ΤȤ Term1 ˲롥
%
%   Term1 򻲾Ȥ٤˺¤ʤΤǡ˲
%   ⹽ʤ
%
unify(X, Y, Z) :- funify1(X, Y, Z).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Constraint
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   constr(+Goal)
%    Goal ˤʤäȤ¹Ԥ롥
%
constr(G) :- when(ground(G),call(G)).
