%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
%
%           tree.pl
%
%       Display trees the parser generated.
%
%       $Id: tree.pl,v 1.2 1993/12/16 07:51:33 imai Exp imai $
%
%       $Log: tree.pl,v $
% Revision 1.2  1993/12/16  07:51:33  imai
% Bug fix. (syntax error)
%
% Revision 1.1  1993/11/30  11:33:34  imai
% Initial revision
%
%
%

:- dynamic word_counter/1.

display_trees(N,Stream) :- !,
	N1 is N+1,
	display_trees1(N1,1,Stream).

display_trees1(N,N,_) :- !.
display_trees1(N,N0,Stream) :- !,
	tree(N0,Tree),
	write(Stream,N0),write(Stream,':'),
%	reset_word_counter,
	display_tree(Tree,Stream),
	N1 is N0+1,
	display_trees1(N,N1,Stream),
	!.

display_tree(Tree,Stream) :-
	nl(Stream),
	display_tree1(0,[],Tree,Stream),
%	display_tree1(0,[],Tree,Stream,0,_),
	nl(Stream).

display_tree1(_,_,[],_).
%display_tree1(_,_,[],_,_,_).
display_tree1(Sibling,Indent,[Car|[Cadr|Cddr]],Stream) :-
%display_tree1(Sibling,Indent,[Car|[Cadr|Cddr]],Stream,N0,N) :-
	display_nonterminal_symbol(Indent,Car,Stream),
	(Indent=[],
	 I1=[]
	;
	 Indent=[_|I0],
	 (Sibling=0,
	  I1=[0|I0]
	 ;
	  Sibling=1,
	  I1=[1|I0])),
	(Cddr=[],
	 display_tree1(0,[2|I1],Cadr,Stream)
%	 display_tree1(0,[2|I1],Cadr,Stream,N0,N1)
	;
	 display_tree1(1,[2|I1],Cadr,Stream)),
%	 display_tree1(1,[2|I1],Cadr,Stream,N0,N1)),
	display_tree2([2|I1],Cddr,Stream).
%	display_tree2([2|I1],Cddr,Stream,N1,N).
display_tree1(_,Indent,Sym,Stream) :-
%display_tree1(_,Indent,Sym,Stream,N0,N) :-
	display_terminal_symbol(Indent,Sym,Stream).
%	display_terminal_symbol(Indent,Sym,Stream,N0,N).

display_tree2(_,[],_).
%display_tree2(_,[],_,_,_).
display_tree2(Indent,[Child|Childs],Stream) :-
%display_tree2(Indent,[Child|Childs],Stream,N0,N) :-
	(Childs=[],
	 display_tree1(0,Indent,Child,Stream)
%	 display_tree1(0,Indent,Child,Stream,N0,N1)
	;
	 display_tree1(1,Indent,Child,Stream)),
%	 display_tree1(1,Indent,Child,Stream,N0,N1)),
	display_tree2(Indent,Childs,Stream).
%	display_tree2(Indent,Childs,Stream,N1,N).

display_nonterminal_symbol(Indent,Sym,Stream) :-
	indent(Indent,Stream),
	write(Stream,Sym),
	nl(Stream).
display_terminal_symbol(Indent,Sym,Stream) :-
%display_terminal_symbol(Indent,Sym,Stream,N0,N) :-
	indent(Indent,Stream),
	write(Stream,'['),
	write(Stream,Sym),
%	write(Stream,': "'),
%	get_a_word(Word),
%	write(Stream,Word),
	write(Stream,']'),
	nl(Stream).



indent([],_).
indent([F|T],Stream) :-
	indent(T,Stream),
	(F=0,
	 tab(Stream,4)
	;
	 F=1,
	 write(Stream,'|'),
	 tab(Stream,3)
	;
	 F=2,
	 write(Stream,'+---')).

%
nth_list(N,List,Atom) :- !,
	N>=0,
	nth_list1(N,List,Atom).

%
nth_list1(0,[Atom|_],Atom) :- !.
nth_list1(N,[_|List],Atom) :- !,
	N1 is N-1,
	nth_list1(N1,List,Atom).

%
get_a_word(Word) :- !,
	word_counter(N),
	sentence(S),
	nth_list(N,S,Word),
	word_counter_inc.

%
word_counter_inc :- !,
	word_counter(N),
	N1 is N+1,
	abolish(word_counter/1),
	assertz(word_counter(N1)).

%
reset_word_counter :- !,
	abolish(word_counter/1),
	assertz(word_counter(0)).
