%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
%
% use backtracking.
list_length([],0):-!.
list_length([_|Tail],Length):-
	list_length(Tail,Length_1),!,
	Length is Length_1+1.

%symbol '[]' is not arrowed.
divide_last_symbol((Head,Tail),Body,Last):-!,
	divide_last_symbol(Tail,Body1,Last),
	((Body1==[],!,Body=Head);
	 Body=(Head,Body1)).
divide_last_symbol(Last,[],Last):-!.

paren_to_list((Head,Tail),[Head|Tail0]):-!,
	paren_to_list(Tail,Tail0).
paren_to_list(Atom,[Atom]):-!.

paren_to_list_and_divide_last_symbol((Head,Tail),[Head|Tail0],Last):-!,
	paren_to_list_and_divide_last_symbol(Tail,Tail0,Last).
paren_to_list_and_divide_last_symbol(Atom,[],Atom):-!.

% if lookahead is variable, substitute next.
double_list_is_lookahead_var([],[],_,[]):-!.
double_list_is_lookahead_var([(RHS,Lookahead,Number)|Tail],[],Next,
	               [(RHS,Lookahead,Number)|Tail_processed]):-!,
        is_lookahead_var(Lookahead,Next),
	double_list_is_lookahead_var(Tail,[],Next,Tail_processed).
double_list_is_lookahead_var(Expands1,[(RHS,Lookahead,Number)|Tail],Next,
	               [(RHS,Lookahead,Number)|Tail_processed]):-!,
        is_lookahead_var(Lookahead,Next),
	double_list_is_lookahead_var(Expands1,Tail,Next,Tail_processed).

list_is_lookahead_var([],_,[]):-!.
list_is_lookahead_var([(RHS,Lookahead,Number)|Tail_no_next],Next,
	                   [(RHS,Lookahead,Number)|Tail]):-
	is_lookahead_var(Lookahead,Next),
	list_is_lookahead_var(Tail_no_next,Next,Tail).

is_lookahead_var(Lookahead,Next):-
	var(Lookahead),!,Lookahead=Next.
is_lookahead_var(_,_):-!.

get_first_and_next_both([],[],[]):-!.
get_first_and_next_both([Expand|Expands],
	                [(Symbol,Next)|Tail1],[Symbol|Tail2]):-
        first_and_next(Expand,Symbol,Next),
	get_first_and_next_both(Expands,Tail1,Tail2).
get_first_and_next_both([_|Expands],Tail1,Tail2):-!,
	get_first_and_next_both(Expands,Tail1,Tail2).

get_first_and_next([],[]):-!.
get_first_and_next([Expand|Expands],[(Symbol,Next)|Tail]):-
        first_and_next(Expand,Symbol,Next),
        get_first_and_next(Expands,Tail).
get_first_and_next([_|Expands],Tail):-!,
        get_first_and_next(Expands,Tail).

first_and_next((RHS,Lookahead,_),Symbol,Next):-
	((RHS=[Symbol],Next=Lookahead);RHS=[Symbol,Next|_]),
	\+ is_terminal(Symbol),!.

% get first non terminal symbols.
get_first([],[]):-!.
get_first([([Symbol|_],_,_)|Expands],[Symbol|Tail]):-
	\+ is_terminal(Symbol),!,
	get_first(Expands,Tail).
get_first([_|Expands],Tail):-!,
	get_first(Expands,Tail).

% get first terminal symbols.
get_first_terminals([],[]):-!.
get_first_terminals([([Symbol|_],_,_)|Expands],[Symbol|Tail]):-
	is_terminal(Symbol),!,
	get_first_terminals(Expands,Tail).
get_first_terminals([_|Expands],Tail):-!,
	get_first_terminals(Expands,Tail).

% eat symbol
eat_symbol(_,[],[],[]):-!.
% eatable
eat_symbol(Symbol,[([Symbol|Rest],Lookahead,Number)|Tail0],
	          [(Rest,Lookahead,Number)|Eatens],Tail1):-!,
        eat_symbol(Symbol,Tail0,Eatens,Tail1).
% leftovers..
eat_symbol(Symbol,[Head|Tail0],Eatens,[Head|Tail1]):-!,
	eat_symbol(Symbol,Tail0,Eatens,Tail1).

% from "The Craft of Prolog"
flatten(Tree,List):-
	flatten(Tree,List,[]).
flatten([],List0,List):-!,
	List0 = List.
flatten([Head|Tail],List0,List):-
	flatten(Head,List0,List1),
	flatten(Tail,List1,List).
flatten(Other,[Other|List],List).
