%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
%
%
% This program is the main routine for constructing LR table.
%
%     By Thanaruk THEERAMUNKONG, Hiroki IMAI
%        Manabu OKUMURA        , Susumu KUNIFUJI
%     @ CopyLeft 1996
%

:- unknown(_,fail).
:- dynamic wait/0.
:- dynamic use_dictionary/0.

start:-
	write('*******************************'),nl,
	write('*  Welcome to R-LRPar system  *'),nl,
	write('*                beta version *'),nl,
	write('*******************************'),nl,
        write('Do you want to indicate the filename of the sentences ? (y/n)'),nl,
        write('(Default is sent_file.re)'),nl,
	abolish(input_sentence),
        read(Answer),
	( (Answer = 'y' ; Answer = 'Y') ->
	   write('Please input the filename of sentences you would like to analyse'),nl,
           read(SFileName);
           SFileName = 'sent_file.re' ),
	consult(SFileName),
	getcommand(i).

getcommand(q) :- !.
getcommand(_) :-
	format("~nCommand (h: help) > ",[]),
	read(Command),
	interpret(Command),
	getcommand(Command).

interpret(q) :- !.
interpret(h) :-
	format("~n",[]),
	format("  h      - help~n",[]),
	format("  c      - change sentence set~n",[]),
	format("  l      - list sentences~n",[]),
	format("  l(N,M) - list Nth-Mth sentences~n",[]),
	format("  N      - Using Nth sentence~n",[]),
	format("  q      - quit~n~n",[]).
interpret(c) :-
	write('Input filename of the sentence set (c=cancel)> '),
	read(SentSet),
	( SentSet = 'c' -> true;
	                  abolish(input_sentence),
		          consult(SentSet) ).
	
interpret(l) :-
	bagof([N,S],input_sentence(N,S),LSen),
	list_sentence(LSen).
interpret(l(Min,Max)) :-
	bagof([N,S],(input_sentence(N,S),Min=<N,N=<Max),LSen),
	list_sentence(LSen).

interpret(A) :-
	input_sentence(A,SenLen),
	getsent(SenLen,Sentence),
	clean_node,
	assert_null(Sentence,Sentence1),
	time(parse(Sentence1,Keys_and_NOT),Time),
	write(Keys_and_NOT),nl,
	divide_key_and_number(Keys_and_NOT,Keys,N),
	write_ntrees(N,user_output),
	(extract,
	 extract_tree(Keys,user_output),
	 (disptree,
	  display_trees(N,user_output)
	 ;
	  disptcl,
	  reconsult('calltcl.pl'),
	  send_input_sentence,
	  send_input_translated,
	  repeat,
  	  tk_do_one_event(19),
	  (wait -> fail
	  ;
	   true)
	 ;
	  true)
	;
	 true),
	write('Parsing Time: '),write(Time),write(' (ms)'),nl.

getsent([],[]) :- !.
getsent([[_W,C]|SenLen],[C|Sentence]) :-
	getsent(SenLen,Sentence).

list_sentence([]) :- !.
list_sentence([[N,S]|LSen]) :-
	format("~p: ",[N]),
	list_a_sentence(S),
	format("~n",[]),
	list_sentence(LSen).

list_a_sentence([]) :- !.
list_a_sentence([[W,C]|S]) :-
	format("~p(~p) ",[W,C]),
	list_a_sentence(S).

assert_null([],OSentence) :- !,OSentence=[null].
assert_null([S|Sentence],OSentence) :-
	OSentence=[S|Sentence1],
	assert_null(Sentence,Sentence1).

parse(Sentence,Key_NOT) :-
	EF = n,    % Error Flag
	parse(Sentence,EF,n,[(0-[]-0)],Key_NOT,0,
	      [node([]),shift([]),error([0,0]),errorinfo([]),-1,nn(0),en(0)],NR2),
%	format("NR1 = ~p~n",[NR2]),
	true.

:- ensure_loaded([parseinterf,time,'print_tree',parser,util,extract,'record_info','error_handling',tree,'retrieve-E',flags]).
:- ensure_loaded(['tmp.entry','tmp.cnd']).
:- abolish(wait/0),assert(wait).
