%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
% CFG only
clean_all:-
	\+ (recorded(_,_,Key),erase(Key),fail).

:-dynamic record_state/5.

maketable_change_form(Infile,Start_symbol):-
	clean_all,
	change_form(Infile,Start_symbol).

maketable_main(Outfile,Start_symbol):-
	list_expand([([Start_symbol],null,0)],Expand),
	asserta((record_state([([Start_symbol],null,0)],0,S,S,[]):-!)),
	tell(Outfile),!,
        maketable0([(0,_,Expand)],1,_),
	told.

maketable0([],State_number,State_number).
maketable0([(State_number,_,Expands)|Rest],
           State_number0,New_state_number):-
        maketable1(State_number,Expands,
                   State_number0,State_number1,New_states),!,
        maketable0(Rest,State_number1,State_number2),!,
        maketable0(New_states,State_number2,New_state_number).

maketable1(_,[],End_state_number,End_state_number,[]):-!.
maketable1(State_number,
	   [([],Lookahead,Rule_number)|Tail],
	   State_number0,State_number1,New_states):-!,
	first(Lookahead,First_symbols),
	record_reduce(First_symbols,State_number,Rule_number),!,
	maketable1(State_number,Tail,State_number0,State_number1,New_states).
maketable1(Original_state_number,
	   [([Symbol|Rest],Lookahead,Number)|Tail0],
	   State_number0,State_number2,New_states):-
% goto
	((is_non_terminal(Symbol),!,
	  eat_symbol(Symbol,Tail0,Eatens,Tail1),
	  sort([(Rest,Lookahead,Number)|Eatens],Eatens1),
	  record_state(Eatens1,
		       Next_state_number,State_number0,State_number1,
		       New_state1),
	  record_goto(Symbol,Original_state_number,_,Next_state_number));
% shift
	 (is_terminal(Symbol),!,
	  eat_symbol(Symbol,Tail0,Eatens,Tail1),
	  sort([(Rest,Lookahead,Number)|Eatens],Eatens1),
	  record_state(Eatens1,
		       Next_state_number,State_number0,State_number1,
		       New_state1),
	  record_shift(Symbol,Original_state_number,Next_state_number));
% start symbol
	 (New_state1=[],
	  State_number1=State_number0,
	  Tail1=Tail0)),!,
	maketable1(Original_state_number,
	           Tail1,
		   State_number1,State_number2,New_states2),
	append(New_state1,New_states2,New_states).

% record state, and if state is new state, bring it next.
record_state(Eatens,State_number0,State_number0,State_number1,
	     [(State_number0,_,Expand)]):-!,
	State_number1 is State_number0+1,
	asserta((record_state(Eatens,State_number0,S,S,[]):-!)),
	list_expand(Eatens,Expand).
