%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
%
%               parser.pl
%
%       Define shift and reduce actions.
%
%       $Id: parser.pl,v 1.4 1993/12/16 07:36:53 imai Exp imai $
%
%       $Log: parser.pl,v $
% Revision 1.4  1993/12/16  07:36:53  imai
% Changed GSS storage from 'recordz/3' to 'assertz/1'.
%
% Revision 1.3  1993/11/19  09:29:26  imai
% Modifing 'merge_node0/2' enables it to deal with a node of the
% initial state.
%
% Revision 1.2  1993/11/08  11:11:52  imai
% Modified a form of a shift stack structure.
% Added 'record_reduce_info/1' to 're0/4'.
%
%
% primitive parts for dealing with graph structured stack(GSS).
%
% data flow: list of node
%
% (recorded/merged)Node = state -
%                         (list of (key_to_parent,num_of_tree),
%                          position,
%                          list of reduce_path,
%                          'nt')
%
% (recorded/merged)Node = state -
%                         (list of (key_to_parent,num_of_tree),
%                          position,
%                          'pt')
%
% (not merged)node = state -
%                    ((key_to_parent,num_of_tree),
%                     position,
%                     list of reduce_path,
%                     'nt')
%
% (not merged)node = state -
%                    ((key_to_parent,num_of_tree),
%                     position,
%                     'pt')
%
% reduce_path = list of key_to_parent
% in the form of ('s1]s2]s3]' -> '[s1,s2,s3]')
%
% Node = [_,Info,_].
% alias: list_of_reduce_path/reduce_paths
% alias: list_of_%1/%1s

%:- ensure_loaded(['~nakajima/src/prolog/append']).

:- dynamic counter/2.
:- dynamic node/2.

clean_node:-
	abolish(node/2),
	abolish(error_info/7),
	abolish(shift_info),abolish(reduce_info),abolish(result_info),
	abolish(stack_top_at_error),abolish(errors),
	abolish(tree),abolish(result_info),
	abolish(ntrees),
	abolish(checked_most_right_pos),
	assert(tree([])),assert(ntrees(0)),
	asserta(errors(0)),
	asserta(checked_most_right_pos(-1)),
	reset_counter.

% push node by 'recordz' and return Key.
%push(Node,Pointer):-
%	node_counter(X),
%	limit_of_node(Limit),
%	!,X < Limit,
%	assertz(node(X,Node)),
%	Pointer=X,
%	inc.

%push(Node,Pointer):-
%	counter(node,X),
%	limit_of_node(Limit),
%	!,X < Limit,
%	assertz(node(X,Node)),
%	Pointer=X,
%	inc(node).

%push(Node,Pointer,NN1,NN2,NR1,NR2):-
%	assertz(node(X,Node)),
push(Node,Pointer,NR1,NR2):-
	NR1=[node(L),S,E,EI,LM,nn(NN1),en(EN)],
	NN2 is NN1+1,
	NR2=[node([[NN1,Node]|L]),S,E,EI,LM,nn(NN2),en(EN)],
	assertz(node(NN1,Node)),
	Pointer=NN1.

%
put_word_in_node(S-(P,Pos,Re,Sym)-E,S-(P,Pos,Re,Sym)-E) :- !.
put_word_in_node(0-[]-E,0-[]-E) :- !.
put_word_in_node(S-(P,Pos,Sym)-E,S-(P,Pos,[Sym,Word])-E) :- !,
	Pos1 is Pos-1,
	sentence(Sent),
	nth_list(Pos1,Sent,Word).

% increment a node counter.
inc(Counter) :-
	counter(Counter,N0),
	N1 is N0+1,
	retract(counter(Counter,N0)),
	assert(counter(Counter,N1)).

% reset a node counter.
reset_counter :-
	abolish(counter/2),
	assert(counter(node,0)),
	assert(counter(error,0)).

% merge node
%  (merge by state only)

merge_node(List,Merged):-
	!,
%	keysort(List,Sorted),
%	merge_node0(Sorted,Merged).
	merge_node0(List,Merged).

merge_node0([],Merged):- !, Merged = [].
% merge non_terminal.
merge_node0([State-((Key_to_parent,NOT),Position,
	     List_of_reduce_path0,Category,EP)-Errors|Tail0],Merged) :-
	!,
	merge_node_by_state_nt(State,EP,Errors,Tail0,
	                       List_of_parent1,List_of_reduce_path1,Tail1),
	append(List_of_reduce_path0,List_of_reduce_path1,
	       List_of_reduce_path),!,
	merge_node0(Tail1,Tail),
	Merged=[State-([(Key_to_parent,NOT)|List_of_parent1],
	            Position,List_of_reduce_path,Category,EP)-Errors|Tail].

% merge pre_terminal.
merge_node0([State-((Key_to_parent,NOT),Pos,Category,EP)-Errors|Tail0],
	     Merged) :-
	!,
	merge_node_by_state_pt(State,EP,Errors,Tail0,List_of_parent1,Tail1),!,
	merge_node0(Tail1,Tail),
	Merged=[State-([(Key_to_parent,NOT)|List_of_parent1],Pos,
	        Category,EP)-Errors|Tail].

% 
merge_node0([0-[]-E|Tail0],Merged) :- !,
	merge_node0(Tail0,Tail),
	Merged=[0-[]-E|Tail].

merge_node_by_state_nt(State,EP,Errors,
                    [State-(Parent,_,List_of_reduce_path0,_,EP)-Errors|Tail0],
		    List_of_parent2,List_of_reduce_path,Tail):-
	append(List_of_reduce_path0,List_of_reduce_path1,List_of_reduce_path),
	!,merge_node_by_state_nt(State,EP,Errors,Tail0,
	                         List_of_parent,List_of_reduce_path1,Tail),
	List_of_parent2=[Parent|List_of_parent].
merge_node_by_state_nt(State,EP,Errors,[T|Tail0],
		     List_of_parent,List_of_reduce_path,Tail):-
	!,
	Tail=[T|Tail1],
	merge_node_by_state_nt(State,EP,Errors,Tail0,
			       List_of_parent,List_of_reduce_path,Tail1).
merge_node_by_state_nt(_,_,_,[],List_of_parent,List_of_reduce_path,Tail):-
	!, List_of_parent = [], List_of_reduce_path = [], Tail = [].

merge_node_by_state_pt(State,EP,Errors,[State-(Parent,_,_,EP)-Errors|Tail0],
		       List_of_parent2,Tail):-
	!,
	merge_node_by_state_pt(State,EP,Errors,Tail0,List_of_parent,Tail),
	List_of_parent2=[Parent|List_of_parent].
merge_node_by_state_pt(State,EP,Errors,[T|Tail0],List_of_parent,Tail):-
	!,
	Tail=[T|Tail1],
	merge_node_by_state_pt(State,EP,Errors,Tail0,List_of_parent,Tail1).
merge_node_by_state_pt(_,_,_,[],List_of_parent,Tail):-
	!, List_of_parent = [], Tail = [].


% pop node by Keys of 'record' and reduce path
% return Keys to parent node and reduce path(list of keys to nodes)
% in the form of ('s1]s2]s3]' -> '[s1,s2,s3]')
pop(Times,Key_to_parent,List_of_key_and_reduce_paths,NR):-!,
	pop1(Times,[1,[Key_to_parent]],Reduce_paths0,NR),
	keysort(Reduce_paths0,Reduce_paths1),
	merge_reduce_path(Reduce_paths1,List_of_key_and_reduce_paths).

merge_reduce_path([],LKP):- !,LKP=[].
merge_reduce_path([Key-(NOT0,Reduce_path)|Tail0],LKP):- !,
	merge_reduce_path0(Key,Tail0,Reduce_paths,Tail,NOT1),!,
	NOT is NOT0+NOT1,
	merge_reduce_path(Tail,Tail_merged),
	LKP=[(Key,[Reduce_path|Reduce_paths],NOT)|Tail_merged].

%merge_reduce_path0(_,[],[],[]):-!.
merge_reduce_path0(_,[],Reduce_paths,OTail,NOT):-
	!, Reduce_paths=[], OTail=[], NOT=0.
merge_reduce_path0(Key,[Key-(NOT0,Reduce_path)|Tail0],
	           Reduce_paths,Tail,NOT):-!,
	merge_reduce_path0(Key,Tail0,Tail_merged,Tail,NOT1),
	NOT is NOT0+NOT1,
	Reduce_paths=[Reduce_path|Tail_merged].
merge_reduce_path0(Key,[T|Tail0],Reduce_paths,OTail,NOT):-
	OTail = [T|Tail],
	merge_reduce_path0(Key,Tail0,Reduce_paths,Tail,NOT).
%merge_reduce_path0(_,Tail,Reduce_paths,OTail,NOT):-
%	!, Reduce_paths=[], OTail=Tail, NOT=0.

% pop1(Times,List_of_late_reduce_path,List_of_reduce_path)
% in the form of ('s1]s2]s3]' -> '[s1,s2,s3]')
pop1(1,Paths0,Paths,NR):-!,
	pop3(Paths0,Paths,NR).
pop1(Times,Paths0,Paths,NR):-
	pop2(Paths0,Paths1,NR),
	Times1 is Times-1,!,
	pop1(Times1,Paths1,Paths,NR).

% it is not optimized at all  ;_;
pop2([],[],_NR):-!.
pop2([NOT0,Path|Tail],Paths,NR):-
	Path=[Parent0|_],
%	node(Parent0,_-(Parents,_)-_),!,
	node(Parent0,_-(Parents,_)-_,NR),!,
	pop2(Tail,Paths0,NR),
	append_head1(Path,Parents,Paths0,Paths,NOT0).

pop3([],[],_NR):-!.
pop3([NOT0,Path|Tail],Paths,NR):-
	Path=[Parent0|_],
%	node(Parent0,_-(Parents,_)-_),!,
	node(Parent0,_-(Parents,_)-_,NR),!,
	pop3(Tail,Paths0,NR),
	append_head2(Path,Parents,Paths0,Paths,NOT0).

append_head1(_,[],Paths,OPaths,_):- !,OPaths=Paths.
append_head1(Path,[(Key,NOT1)|Tail0],Paths0,OTail,NOT0):-!,
	NOT is NOT0*NOT1,
	OTail=[NOT,[Key|Path]|Tail],
	append_head1(Path,Tail0,Paths0,Tail,NOT0).

append_head2(_,[],Paths,OPaths,_):-!,OPaths=Paths.
append_head2(Path,[(Key,NOT1)|Tail0],Paths0,OTail,NOT0):-!,
	NOT is NOT0*NOT1,
	OTail=[Key-(NOT,[Key|Path])|Tail],
	append_head2(Path,Tail0,Paths0,Tail,NOT0).

% reduce and goto(in cnd)
re(Rule_number,Times,Errors,Key_to_category,EP,New_nodes,Position,NR):-
	pop(Times,Key_to_category,Keypath_and_NOT,NR),!,
	re0(Rule_number,Errors,Keypath_and_NOT,Position,EP,New_nodes,NR).

re0(_,_,[],_,_,NewNodes,_NR):-!,NewNodes=[].
re0(Rule_number,Errors,[(Key,Reduce_paths0,NOT)|Tail]
	,Position,EP,ONewNodes,NR):-
%	node(Key,State-_-_),
	node(Key,State-_-_,NR),
	ONewNodes=[New_node|New_nodes],
	cnd(Rule_number,State,(Key,NOT),
	    Reduce_paths0,Position,Errors,EP,New_node),!,
	re0(Rule_number,Errors,Tail,Position,EP,New_nodes,NR).

% 'n-argument' append
append_n([],List):-!,List=[].
append_n([List1,List2],List):-!,
	append(List1,List2,List).
append_n([Head|Tail],List):-!,
	append_n(Tail,List0),
	append(Head,List0,List).

%
%extract_number(([(_,NUM)],_,_,_),NUM) :- !.
extract_number((L,_,_,_),NUM) :- 
	extract_number(L,0,NUM).

extract_number([],INUM,ONUM) :- ONUM = INUM.
extract_number([(_,NUM)|Res],INUM,ONUM) :- 
	INUM1 is NUM+INUM,
	extract_number(Res,INUM1,ONUM).


%
divide_key_and_number([],[],0) :- !.
divide_key_and_number([(Key,NUM0)|Tail],[Key|Keys],NUM) :- !,
	divide_key_and_number(Tail,Keys,NUM1),
	NUM is NUM0+NUM1.

node(Key,State,[node(N)|_NR]) :-
	node1(Key,State,N).

node1(Key,State,NR) :-
	NR = [[Key,State]|_Res],!.
node1(Key,State,[_N|NR]) :-
	node1(Key,State,NR).
