%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
% make inner expression

:- dynamic rule/2.

record_terminal(Terminal):-
	\+ is_terminal(Terminal),assertz(is_terminal(Terminal)).
record_terminal(_):-!.
	
record_non_terminal(Non_terminal):-
	\+ is_non_terminal(Non_terminal),
	\+ is_start_symbol(Non_terminal),
	assertz(is_non_terminal(Non_terminal)).
record_non_terminal(_):-!.

record_non_terminal_symbols_as_terminal([]):-!.
record_non_terminal_symbols_as_terminal([Symbol|Symbols]):-
	\+ is_non_terminal(Symbol),
	\+ is_start_symbol(Symbol),
	\+ is_terminal(Symbol),
	assertz(is_terminal(Symbol)),
	record_non_terminal_symbols_as_terminal(Symbols).
record_non_terminal_symbols_as_terminal([_|Symbols]):-
	record_non_terminal_symbols_as_terminal(Symbols).

change_form(Filename,Start_symbol):-
	abolish(is_terminal,1),
	abolish(is_non_terminal,1),
	abolish(is_start_symbol,1),
	assertz(is_terminal(null)),
	assertz(is_start_symbol(Start_symbol)),
	((var(Filename),Filename0=user_input);
	  Filename0=Filename),
	see(Filename0),
	change_form1(1,Symbols1),
	sort(Symbols1,Symbols2),
	record_non_terminal_symbols_as_terminal(Symbols2),
	seen.

change_form1(N,Symbols):-
	 read(A),
	 ((A==end_of_file,Symbols=[]);
	 (((A=(LHS-->RHS),N1 is N+1,
	    ((LHS=(L1,L2,L3),change3(L1,L2,L3,RHS,N,Symbols1));
	     (LHS=(L1,L2),change2(L1,L2,RHS,N,Symbols1));
	     change1(LHS,RHS,N,Symbols1)));
	   (write(user_output,'erroneous input:'),write(user_output,A),nl,
	    N1=N,Symbols1=[])),
	  change_form1(N1,Symbols2),
	  append(Symbols1,Symbols2,Symbols))).

% rule 'A'->a,'B'
change1(LHS,RHS,N,RHS0):-
	paren_to_list(RHS,RHS0),
	record_non_terminal(LHS),
	assertz((rule(LHS,[_,N,RHS0]))).

% rule a,'A'->a,a,'A'
change2(L1,L2,(L1,Rewriting_part),N,Rewriting_part0):-
% ask whether this rule is a,'A'->a,a,'A'.
	write(user_output,L1),
	write(user_output,' is terminal, and '),
	write(user_output,L2),
	write(user_output,' is non terminal?(y/n) '),
	read(user_input,y),
	paren_to_list(Rewriting_part,Rewriting_part0),
	record_terminal(L1),
	record_non_terminal(L2),
	assertz((rule(L2,[L1,_,N,Rewriting_part0]))).

% rule 'A',b->a,'A',b
change2(L1,L2,RHS,N,Rewriting_part):-
	paren_to_list_and_divide_last_symbol(RHS,Rewriting_part,L2),
	record_terminal(L2),
	record_non_terminal(L1),
	assertz((rule(L1,[L2,N,Rewriting_part]))).

% rule a,'A',b->a,a,'A',b
change3(L1,L2,L3,(L1,Cdr_of_RHS),N,Rewriting_part):-
	paren_to_list_and_divide_last_symbol(Cdr_of_RHS,Rewriting_part,L3),
	record_terminal(L1),
	record_terminal(L3),
	record_non_terminal(L2),
	assertz((rule(L2,[L1,L3,N,Rewriting_part]))).
