/**********************************************************************/
/*                                                                    */
/*    PROGRAM OF UNIX_Look.C                                          */
/*                                                                    */
/*      Copyright (c) 1996  Fumio Mizoguchi                           */
/*                                                                    */
/**********************************************************************/
#include <stdio.h> 
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define NUMBER 2
#define PAI 3.141592

/***** FUNCTION PROTOTYPE *****/
void UNIX_Look(unsigned char*, int, int);
void putint(char data[],int da); 
void change_image_data(unsigned char r[][], unsigned char*, int, int);

/***** EXTERNALDATA *****/
int add = 0;

/*****  UNIX_Look FUNCTION ************************************************/
void UNIX_Look(unsigned char *image_data, 
	    int image_width, int image_height)
{
    /***** INTERNALDATA *****/
    FILE *fp;
    int fd;
    int err;
    unsigned char c;
    unsigned char data[512],send_data[512];
    unsigned char r[image_height][image_width];
    unsigned char q[2][255];           
    int s[255];
    int as[100];
    int label = 0;
    int neolabel = 0;
    int i,j,k,l;
    int ki = 120;
    int ni = 200;
    int hyouji = 50;
    int kakusa;
    int sho,swh;
    int start,end;
    typedef long clock_t;
    
    int obj[NUMBER];          /* Object Size  */
    int objn[NUMBER];         /* Object Number  */
    int objl[NUMBER][20];     /* Object Label    */
    int objx[NUMBER][20];     /* Object X */
    int objy[NUMBER][20];     /* Object Y */
    int objk[NUMBER][20];     /* Object Degree */
    int dx[50][2][2];         /* Object domain X */
    int dy[50][2][2];         /* Object domain Y */
    int tanx,tany;
    double objtan;
    double gx,gy;
    int VX, VY;
    double ermin,ermax;
    int sx1,sx2,sx3,sx4;
    
    /***** PROCESS *****/
    VX = image_width;
    VY = image_height;
    
    memcpy(r, image_data, image_width*image_height);

    /********  set up *********/
    gx = 500.0/103.0;  
    gy = 500.0/103.0;
    
    obj[0] = 740;  /* Size of Box */
    obj[1] = 80;  /* Size of Block */


    objn[0] = 0;
    objn[1] = 0;
    label = 0;
    neolabel = 0;
    objn[0] = 0;
    objn[1] = 0;
    
    for(j=0;j<VY;j++){
	for(i=0;i<VX;i++){
	    if(r[j][i] < ki+1) r[j][i] = 0;
	    else r[j][i] = ni;
	}   
    }
    
    /***** Clear noisu *****/
    for(j=0;j<VY;j++){
	for(i=0;i<VX;i++){
	    if(r[j][i] == 0){
		if(j>0 && r[j-1][i] > ki) r[j-1][i] = 10;
		if(i>0 && r[j][i-1] > ki) r[j][i-1] = 10;
		if(j<VY-1 && r[j+1][i] > ki) r[j+1][i] = 10;
		if(i<VX-1 && r[j][i+1] > ki) r[j][i+1] = 10;
		if(j>0 && i>0 && r[j-1][i-1] > ki) r[j-1][i-1] = 10;
		if(j>0 && i<VX-1 && r[j-1][i+1] > ki) r[j-1][i+1] = 10;
		if(j<VY-1 && i>0 && r[j+1][i-1] > ki) r[j+1][i-1] = 10;
		if(j<VY-1 && i<VX-1 && r[j+1][i+1] > ki) r[j+1][i+1] = 10;
	    }
	}
    }
    for(j=0;j<VY;j++){
	for(i=0;i<VX;i++){
	    if(r[j][i] == ni){
		if(j>0 && r[j-1][i] < ki+1) r[j-1][i] = ni-1;
		if(i>0 && r[j][i-1] < ki+1) r[j][i-1] = ni-1;
		if(j<VY-1 && r[j+1][i] < ki+1) r[j+1][i] = ni-1;
		if(i<VX-1 && r[j][i+1] < ki+1) r[j][i+1] = ni-1;
		if(j>0 && i>0 && r[j-1][i-1] < ki+1) r[j-1][i-1] = ni-1;
		if(j>0 && i<VX-1 && r[j-1][i+1] < ki+1) r[j-1][i+1] = ni-1;
		if(j<VY-1 && i>0 && r[j+1][i-1] < ki+1) r[j+1][i-1] = ni-1;
		if(j<VY-1 && i<VX-1 && r[j+1][i+1] < ki+1) r[j+1][i+1] = ni-1;
	    }
	}
    }   

    /***** Mark Label *****/
    for(j=0; j<VY; j++){
	for(i=0; i<VX; i++){
	    
	    if (r[j][i] > ki) {
		if((i>0) && (r[j][i-1] > 0)) {
		    r[j][i] = r[j][i-1];
		    s[r[j][i-1]] ++;
		    if(j>0 && r[j-1][i] != 0 && (r[j-1][i] != r[j][i])){  
			q[0][r[j][i]] = q[0][r[j-1][i]];    
		    }
		}
		else{
		    if((j>0) && (r[j-1][i] > 0)){
			r[j][i] = r[j-1][i];
		       s[r[j-1][i]] ++;
		    }
		    else{
			if((r[j][i+1] > ki) || (r[j+1][i] > ki)) {
			    label ++;
			    r[j][i] = label;
			    q[0][label] = label;
			    s[r[j][i]] = 1;
			}
			else r[j][i] = 0;
		    }
		}
	    }
	    else r[j][i] = 0;
	}
    }
    
    
    /***** Check Label *****/
    for(i=1; i<label+1; i++){
	if(q[0][i] == i){  
	    neolabel++;
	    as[neolabel] = s[i];
	    q[1][i] = neolabel;
	}
	else{
	    q[1][i] = q[1][q[0][i]];
	    as[q[1][i]] += s[i];
	}
    }
    for(i=1; i<neolabel+1; i++){
	dx[i][0][0] = 9999;
	dx[i][1][0] = 0;
	dy[i][0][1] = 9999;
	dy[i][1][1] = 0;
    }
    for(j=0; j<VY; j++){
	for(i=0; i<VX; i++){
	    if(r[j][i] != 0){
		r[j][i] = q[1][r[j][i]];
		if(dx[r[j][i]][0][0] > i) 
		  dx[r[j][i]][0][0] = i, dx[r[j][i]][0][1] = j;
		if(dx[r[j][i]][1][0] < i) 
		  dx[r[j][i]][1][0] = i, dx[r[j][i]][1][1] = j;
		if(dy[r[j][i]][0][1] > j) 
		  dy[r[j][i]][0][0] = i, dy[r[j][i]][0][1] = j;
		if(dy[r[j][i]][1][1] < j) 
		  dy[r[j][i]][1][0] = i, dy[r[j][i]][1][1] = j;
	    }
	}
    }
    
    /***** SEARCH Box & Block size *****/
    for(i=1; i<neolabel+1; i++){
	if(obj[0]*0.7 < as[i] && as[i] < obj[0]*1.3){
	    objl[0][objn[0]] = i;
	    objn[0] ++;
	    /*printf("size box %d\n",as[i]);*/

	}
	else if(obj[1]*0.6 < as[i] && as[i] < obj[1]*1.7){
	    objl[1][objn[1]] = i;
	    objn[1] ++;
	    printf("size block %d, num = %d\n",as[i],objl[1][objn[1]-1]);
	}
	else as[i] = 0;
    }
    
    
    for(k=0; k<NUMBER; k++){
	for(l=0; l<objn[k]; l++){
	    sho = (int)(((sqrt((double)(obj[k])))/2.8)*
	      ((sqrt((double)(obj[k])))/2.8));
	    printf("sho = %d\n",sho);
	    if((dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])*
	       (dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])+
	       (dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])*
	       (dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])<=sho||
	       (dx[objl[k][l]][0][0]-dy[objl[k][l]][1][0])*
	       (dx[objl[k][l]][0][0]-dy[objl[k][l]][1][0])+
	       (dx[objl[k][l]][0][1]-dy[objl[k][l]][1][1])*
	       (dx[objl[k][l]][0][1]-dy[objl[k][l]][1][1])<=sho||
	       (dx[objl[k][l]][1][0]-dy[objl[k][l]][0][0])*
	       (dx[objl[k][l]][1][0]-dy[objl[k][l]][0][0])+
	       (dx[objl[k][l]][1][1]-dy[objl[k][l]][0][1])*
	       (dx[objl[k][l]][1][1]-dy[objl[k][l]][0][1])<=sho||
	       (dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0])*
	       (dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0])+
	       (dx[objl[k][l]][1][1]-dy[objl[k][l]][1][1])*
	       (dx[objl[k][l]][1][1]-dy[objl[k][l]][1][1])<=sho){
		dx[objl[k][l]][0][1]=dy[objl[k][l]][0][1];   
		dx[objl[k][l]][1][1]=dy[objl[k][l]][1][1];
		dy[objl[k][l]][0][0]=dx[objl[k][l]][1][0];
		dy[objl[k][l]][1][0]=dx[objl[k][l]][0][0];
	    }
	    objx[k][l] = (int)((double)(dy[objl[k][l]][0][0]+
					dy[objl[k][l]][1][0])*gx/2.0);
	    objy[k][l] = (int)((double)(dx[objl[k][l]][0][1]+
					dx[objl[k][l]][1][1])*gy/2.0);
	    if((tanx = dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0]) != 0){
		tany =  dy[objl[k][l]][1][1]-dx[objl[k][l]][1][1];  
		objtan = ((double)(tany)*gy)/((double)(tanx)*gx);
		objk[k][l] = (int)(atan(objtan)*180/PAI);
	    }
	    else objk[k][l] = 0;
	}
    }   
    data[0] = '\0';
    
    for(k=0; k<NUMBER; k++){
	if(k == 1) {
	    ermax = 1.6; ermin = 0.05;
	}
	else {
	    ermax = 1.8; ermin = 0.5;
	}
	for(l=0; l<objn[k]; l++){
	    printf("(%d, %d)\n",dx[objl[k][l]][0][0],dx[objl[k][l]][0][1]);
	    printf("(%d, %d)\n",dx[objl[k][l]][1][0],dx[objl[k][l]][1][1]);
	    printf("(%d, %d)\n",dy[objl[k][l]][0][0],dy[objl[k][l]][0][1]);
	    printf("(%d, %d)\n",dy[objl[k][l]][1][0],dy[objl[k][l]][1][1]);
	    

	    sx1 = (dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])*
	      (dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])+
                (dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])*
		  (dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1]);
            printf("%d, %d , sx1 = %d,   \n",k,l,sx1); 

	    sx2 = (dx[objl[k][l]][1][0]-dy[objl[k][l]][0][0])*
	      (dx[objl[k][l]][1][0]-dy[objl[k][l]][0][0])+
                (dx[objl[k][l]][1][1]-dy[objl[k][l]][0][1])*
		  (dx[objl[k][l]][1][1]-dy[objl[k][l]][0][1]);
            printf("%d, %d , sx2 = %d,   \n",k,l,sx2); 

	    sx3 = (dx[objl[k][l]][0][0]-dy[objl[k][l]][1][0])*
	      (dx[objl[k][l]][0][0]-dy[objl[k][l]][1][0])+
                (dx[objl[k][l]][0][1]-dy[objl[k][l]][1][1])*
		  (dx[objl[k][l]][0][1]-dy[objl[k][l]][1][1]);
            printf("%d, %d , sx3 = %d,   \n",k,l,sx3); 

	    sx4 = (dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0])*
	      (dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0])+
                (dx[objl[k][l]][1][1]-dy[objl[k][l]][1][1])*
		  (dx[objl[k][l]][1][1]-dy[objl[k][l]][1][1]);
            printf("%d, %d , sx4 = %d,   \n",k,l,sx4); 

	    /*if ((dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])*
		(dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])+
		(dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])*
		(dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1]) > obj[k]*ermin &&
		(dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])*
		(dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])+
		(dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])*
		(dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1]) < obj[k]*ermax){*/
	    
	    if(sx1 > obj[k]*ermin && sx2 > obj[k]*ermin &&
	       sx3 > obj[k]*ermin && sx4 > obj[k]*ermin &&
	       sx1 < obj[k]*ermax && sx2 < obj[k]*ermax &&
	       sx3 < obj[k]*ermax && sx4 < obj[k]*ermax){
		putint(data,k);                
		putint(data,objx[k][l]);                
		putint(data,objy[k][l]*-1);                
		putint(data,objk[k][l]);                
		/*
		   printf("b&b=%d,num=%d,x=%d,y=%d,katamuki=%d\n", 
		   k,objl[k][l],objx[k][l],objy[k][l],objk[k][l]);
		   */
	    }
	}
    }
    send_data[0] = '\0';
    add ++;
    putint(send_data,add);
    /* putint(send_data,end-start); */
    strcat(send_data,data);
    
    send_data[strlen(send_data)-1] = ':';
    strcat(send_data,"\0");

    fd = creat("data",0666);
    /*fp = fopen("data", "a");*/
    printf("data = %s, %d\n",send_data,i);
    printf("LABEL NUMBER = %d\n",label);
    /*fprintf(fp, "%s", send_data);*/
    write(fd,send_data,strlen(send_data)+1);
    close(fd);
    
    /*fclose(fp);*/

    
    memcpy(image_data, r, image_width*image_height);
}
/***** END OF UNIX_Look FUNCTION *****************************************/


/***** PUTINT FUNCTION ************************************************/
void putint(char data[],int da)
{
    char atom[10];
   
    itostr(atom,da);
    strcat(data,atom);
    strcat(data,",");
}
/***** END OF PUTINT FUNCTION *****************************************/


/***** CHANGE_IMAGE_DATA FUNCTION *************************************/
void change_image_data(unsigned char r[][], unsigned char *image_data,
		       int image_width, int image_height)

{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    memcpy(r,image_data, image_width*image_height);
}
/***** END OF CHANGE_IMAGE_DATA FUNCTION ******************************/
