/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <pvm3.h>
#include <stdio.h>
#include <signal.h>
#include <klic/basic.h>
#include <klic/rmon.h>

#define MAXNUM    256

main(argc,argv)
     int argc; char **argv;
{
  int i,j,mytid,histid,bufsize,msgtag,info,buf_id,n,disp_nodes;
  long nodes, ibuf[MAXNUM*5], s_times, i_times, gc_times, sm_times, rm_times;
  long t_s_times[MAXNUM], t_i_times[MAXNUM], t_gc_times[MAXNUM], t_sm_times[MAXNUM], t_rm_times[MAXNUM];
  double d_bs_times, d_i_times, d_gc_times, d_sm_times, d_rm_times;
  long prof_tag;

  if (argc == 1) {
      disp_nodes = 20;
  } else {
      disp_nodes = atoi(argv[1]);
  }

  mytid = pvm_mytid();
  fprintf(stderr, "Rmonitor Tid is %x\n", mytid);

  for (;;) {
      buf_id = pvm_recv(-1,-1);
      if (buf_id < 0 ){
	  fprintf(stderr, "Error in pvm_recv\n");
      }
      info = pvm_bufinfo(buf_id,&bufsize,&msgtag,&histid);
      if (info < 0 ){
	  fprintf(stderr, "Error in pvm_bufinfo\n");
      }

      pvm_upklong(&prof_tag, 1, 1);
      switch(prof_tag){
	case SHOEN_START_TAG:
	  fprintf(stdout, "\033[2J\033[H");
	  fprintf(stdout, "NODE: idle   gc send recv busy\n");
	  for (j = 0; j < disp_nodes; j++) {
	      fprintf(stdout, "%4d:  100    0    0    0    0\n",j);
	  }	  
	  fprintf(stdout, "\nRmonitor Tid is %x\n", mytid);
	  fflush(stdout);
	  for(i=0;i<MAXNUM;i++){
	      t_s_times[i] = 0;
	      t_i_times[i] = 0;
	      t_gc_times[i]= 0;
	      t_sm_times[i]= 0;
	      t_rm_times[i]= 0;
	  }
	  break;

	case SHOEN_OUTPUT_PROF_TAG:

	  pvm_upklong(&nodes, 1, 1);
	  if(nodes > disp_nodes){
	      fprintf(stderr, "Please restart : rmon_server %d\n", nodes);
	      exit();
	  }

	  pvm_upklong(ibuf, nodes*5, 1);

	  fprintf(stdout, "\033[2J\033[H");
	  fprintf(stdout, "NODE: idle   gc send recv busy\n");
	  n = 0;

	  for (j = 0; j<nodes; j++) {
	      s_times = ibuf[n];    t_s_times[j]+=s_times;
	      i_times = ibuf[n+1];  t_i_times[j]+=i_times;
	      gc_times = ibuf[n+2]; t_gc_times[j]+=gc_times;
	      sm_times = ibuf[n+3]; t_sm_times[j]+=sm_times;
	      rm_times = ibuf[n+4]; t_rm_times[j]+=rm_times;

	      d_i_times = 100*(double)i_times/(double)s_times,
	      d_gc_times = 100*(double)gc_times/(double)s_times,
	      d_sm_times = 100*(double)sm_times/(double)s_times, 
	      d_rm_times = 100*(double)rm_times/(double)s_times,
	      d_bs_times = 100*((double)s_times-((double)i_times+(double)sm_times+(double)rm_times+(double)gc_times))/(double)s_times;
	      
/*	      fprintf(stdout, "%4d:%5d%5d%5d%5d%5d\n",*/
	      fprintf(stdout, "%4d:%5.1f%5.1f%5.1f%5.1f%5.1f\n",
		      j, d_i_times, d_gc_times, d_sm_times, d_rm_times, d_bs_times);
/*		  100*i_times/s_times,
		  100*gc_times/s_times,
		  100*sm_times/s_times, 
		  100*rm_times/s_times,
		  100*(s_times-(i_times+sm_times+rm_times+gc_times))/s_times);*/
	      n+=5;
	  }

	  for(j = nodes ; j < disp_nodes ;j++){
	      fprintf(stdout, "%4d:  100    0    0    0    0\n",j);
	  }
	  fprintf(stdout, "\nRmonitor Tid is %x\n", mytid);
	  fflush(stdout);
	  break;

	case SHOEN_TERMINATE_TAG:
	  fprintf(stdout, "\033[2J\033[H");
	  fprintf(stdout, "******* TOTAL STATISTICS *******\n");
	  fprintf(stdout, "NODE: idle   gc send recv busy\n");
	  for (j = 0; j<nodes; j++) {	      
	      d_i_times = 100*(double)t_i_times[j]/(double)t_s_times[j],
	      d_gc_times = 100*(double)t_gc_times[j]/(double)t_s_times[j],
	      d_sm_times = 100*(double)t_sm_times[j]/(double)t_s_times[j], 
	      d_rm_times = 100*(double)t_rm_times[j]/(double)t_s_times[j],
	      d_bs_times = 100*((double)t_s_times[j]-((double)t_i_times[j]+(double)t_sm_times[j]+(double)t_rm_times[j]+(double)t_gc_times[j]))/(double)t_s_times[j];

	      fprintf(stdout, "%4d:%5.1f%5.1f%5.1f%5.1f%5.1f\n",
		      j, d_i_times, d_gc_times, d_sm_times, d_rm_times, d_bs_times);
/*		  (double)(100*t_i_times[j]/t_s_times[j]),
		  (double)(100*t_gc_times[j]/t_s_times[j]),
		  (double)(100*t_sm_times[j]/t_s_times[j]), 
		  (double)(100*t_rm_times[j]/t_s_times[j]),
		  (double)(100*(t_s_times[j]-(t_i_times[j]+t_sm_times[j]+t_rm_times[j]+t_gc_times[j]))/t_s_times[j]));*/
	  }
	  for(j = nodes ; j < disp_nodes ;j++){
	      fprintf(stdout, "%4d:  100    0    0    0    0\n",j);
	  }
	  fprintf(stdout, "\nRmonitor Tid is %x\n", mytid);
	  fflush(stdout);
	  break;

	default:
	  fprintf(stderr, "rmon_server invalid msg from shoen\n");
	  exit();
	  break;
      }
  }
}
