/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define PORT 4000

int open_pg(pe_num, server_name, montype)
  int pe_num;
  char *server_name,
       *montype;
{
  int sock;
  struct protoent *proto;
  struct hostent *server;
  struct sockaddr_in this, to;

  struct { short s_1, s_2, s_3, s_4, s_5; } msg;
  int len;
  char optval = 1;

  this.sin_family = AF_INET;
  this.sin_port = 0;
  this.sin_addr.s_addr = 0;

  server = gethostbyname(server_name);
  to.sin_family = AF_INET;
  to.sin_port = PORT;

  to.sin_addr.s_net = server->h_addr[0];
  to.sin_addr.s_host = server->h_addr[1];
  to.sin_addr.s_lh = server->h_addr[2];
  to.sin_addr.s_impno = server->h_addr[3];

  proto = getprotobyname("tcp");
  if((sock = socket(AF_INET, SOCK_STREAM, proto->p_proto))<0) {
    perror("open_pg: socket");
    exit(1);
  }

  len = sizeof(struct sockaddr_in);
  if(bind(sock, (struct sockaddr *)&this, len)<0) {
    perror("open_pg: bind");
    exit(1);
  }
  if(connect(sock, (struct sockaddr *)&to, len)<0) {
    perror("open_pg: connect");
    exit(1);
  }

  setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, &optval, 1);
  setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &optval, 1);

  send(sock, montype, 2, 0);

  msg.s_1 = msg.s_4 = 1;
  msg.s_2 = msg.s_3 = pe_num;
  msg.s_5 = 0;
  send(sock, (char *)&msg, 10, 0);

  return sock;
}

int send_pg(sock, table, table_len)
  int sock;
  char *table;
  int table_len;
{
  struct { char u_1, u_2; } msg;

  msg.u_1 = 0;
  msg.u_2 = 2;
  send(sock, (char *)&msg, 2, 0);

  return send(sock, table, table_len, 0);
}

int close_pg(sock)
  int sock;
{
  return close(sock);
}

struct rtimes {
  unsigned int itime, nitime;
  unsigned short gct;
};

struct atimes {
  unsigned short compt, sendt, rect, gct, idlet;
};


main(argc,argv)
  int argc; char *argv[];
{
  char montype[2], *hostname, msgbuf[256], *outbuf;
  int  sock, ssize, i, outbufl;
  short  procs, procc, skip;
  union msglbuf {
    char  msg[10];
    union rmon {
      struct rtimes rtimes;
      struct atimes atimes;
    } rmon;
  } msglbuf;

  montype[0] = 0;
  switch (argc) {
  case 2:
    procs = (short)16;
    montype[1] = 0;
    hostname = argv[1];
    break;
  case 3:
    procs = (short)atoi(argv[2]);
    hostname = argv[1];
    montype[1] = 0;
    break;
  case 4:
    procs = (short)atoi(argv[2]);
    hostname = argv[1];
    if (0 == strcmp(argv[3],"rmonitor")) montype[1] = 0;
    else if (0 == strcmp(argv[3],"pmeter")) montype[1] = 1;
    else if (0 == strcmp(argv[3],"amonitor")) montype[1] = 2;
    else if (0 == strcmp(argv[3],"hmeter")) montype[1] = 3;
    else {
      fprintf(stderr,"usage:\n rmon servername [#pe [montype]] \n");
      exit(1);
    }
    break;
  default:
    fprintf(stderr,"usage:\n rmon servername [#pe [montype]] \n");
    exit(1);
  }

  if (0 == strlen(hostname)) {
    fprintf(stderr, "illegal server name \n");
    exit(1);
  }
      
  sock = open_pg(procs, hostname, montype);

  outbuf = (char *) malloc(procs*10);

  outbufl = 0;  procc = 0; skip = 0;

  ((msglbuf.rmon).atimes).compt = ((msglbuf.rmon).atimes).sendt = 
    ((msglbuf.rmon).atimes).rect = ((msglbuf.rmon).atimes).gct =
                             ((msglbuf.rmon).atimes).idlet = 0;

  while ( gets(msgbuf) &&
	 (ssize = strlen(msgbuf)) && msgbuf[ssize-1] ) {
    msgbuf[ssize] = 'e';
    for (i = 0; msgbuf[i] == ' '; i++) ;
    msgbuf[ssize] = 0;

    if (msgbuf[i] >= '0' && msgbuf[i] <= '9') {
      if (!skip) {
	unsigned int usr, sys, wt, idl;
	procc++;
	sscanf(msgbuf,"%*d%*d%*d%*d%*d%*d%*d%*d%*d%*d%*d%*d%d%d%d%d",
	       &usr, &sys, &wt, &idl);

	if (montype[1] == 2 ) {
	  ((msglbuf.rmon).atimes).compt += usr + sys;
	  ((msglbuf.rmon).atimes).idlet += wt + idl;
	} else {
	  ((msglbuf.rmon).rtimes).nitime = usr + sys;
	  ((msglbuf.rmon).rtimes).itime  = wt + idl;
	  ((msglbuf.rmon).rtimes).gct = 0;

	  for (i = 0; i < 10; i++, outbufl++) {
	    outbuf[outbufl] = msglbuf.msg[i];
	  }
	}
	if (procc >= procs) {
	  skip = 1;
	  if (montype[1] == 2) {
	      unsigned short compt = msglbuf.rmon.atimes.compt;
	      unsigned short idlet = msglbuf.rmon.atimes.idlet;
	      unsigned int totalt = compt + idlet;

	      msglbuf.rmon.atimes.compt = compt * 100 / totalt;
	      msglbuf.rmon.atimes.idlet = idlet * 100 / totalt;
	    send_pg(sock, msglbuf.msg, 8);
	  } else {
	    send_pg(sock, outbuf, outbufl);
	  }
	}
      }
    } else {
      skip = 0;  outbufl = 0;  procc = 0;
      ((msglbuf.rmon).atimes).compt = ((msglbuf.rmon).atimes).idlet = 0;
    }
  }

  close_pg(sock);
}

	

