/************************************************************************
 * playmidi.h  --  defines and structures for use by playmidi package
 *
 * This code was written by by Nathan Laredo (laredo@gnu.ai.mit.edu)
 * Source code may be freely distributed in unmodified form.
 *************************************************************************
 * If you have more than one midi device, this forces the first */
#define FORCE_EXT_DEV	0
/* change this if you notice performance problems,  128 bytes by default */
#define SEQUENCERBLOCKSIZE 128
/* Default mask for percussion instruments.  Channels 16 and 10 = 0x8200 */
#define PERCUSSION	0x8200
/* IF YOU WANT TO TRY OUT THE SEQUENCER2 CODE, DEFINE THIS */
#undef USE_SEQUENCER2
#define MAX_CARDS	5
/* Set default fm playback mode, 0=sb, 1=opl/3 */
#define FM_DEFAULT_MODE	0
/* this is where patches are searched for first */
#define PATCH_PATH1	"/usr/local/lib/Plib"
/* if not found above, the following path will be searched */
#define PATCH_PATH2	"/dos/ultrasnd/midi"
/* where to find fm patch libraries */
#define O3MELODIC	"/etc/std.o3"
#define O3DRUMS		"/etc/drums.o3"
#define SBMELODIC	"/etc/std.sb"
#define SBDRUMS		"/etc/drums.sb"
#define ISPERC(x)	(perc & (1 << x))
#define ISGUS(x)	(play_gus & (1 << x))
#define ISFM(x)		(play_sb & (1 << x))
#define ISMIDI(x)	(play_ext & (1 << x))

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#define PLAYMIDI
#include "midifile.h"

struct mididata {
    unsigned int etime;		/* event time */
    unsigned int cmd;		/* midi command */
    unsigned int arg1;		/* argument 1 */
    unsigned int arg2;		/* argument 2 */
    unsigned char *data;	/* data */
};
