/*
 * server_impl.h -- client/server interface (implementation)
 *
 * Copyright (C) 1997,1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: server_impl.h,v 1.1 1998-03-15 22:52:45+09 satoshi Exp $

#ifndef _SERVER_IMPL_H_
#define _SERVER_IMPL_H_

#include "server.h"
#include "shmem.h"

#define MAXCLIENT 64

/*
 * client/server interface (implementation)
 */
class Server_Impl : public Server {
private:
  unsigned short port;
  int ls;		// listen socket
  int fd[MAXCLIENT];

public:
//  FileList* filelist;

public:
  Server_Impl(const char* argv0);
  ~Server_Impl();

  void select(bool wait);
  void talk(int client_num);
};

extern bool server_exist(void);

#endif /* !_SERVER_IMPL_H_ */
