/*
 * server.h -- client/server interface
 *
 * Copyright (C) 1997,1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: server.h,v 1.5 1998-03-25 08:32:50+09 satoshi Exp $

#ifndef _SERVER_H_
#define _SERVER_H_

#include "shmem.h"

/*
 * client/server interface
 */
class Server {
private:
  int sock;

public:
  bool is_server;
  CRegister* creg;
//  FileList* filelist;

public:
  Server(const char* argv0);
  ~Server();

protected:
  bool send(const char* msg);
  const char* recv(void);

public:
  unsigned long add(const char* filename, const char** options);
  bool play(void);
  bool stop(void);
  bool pause(void);
  bool unpause(void);
  bool prev(void);
  bool next(void);
  bool skew(double x);
  bool fadeout(void);
  bool jump(unsigned bar, unsigned step);
  bool clear(void);
  bool quit(void);
  bool parameter(char n, int x);
  bool instrument(int n);
  char** getList(void);
};

extern bool server_exist(void);

#endif /* !_SERVER_H_ */
