/*
//	Mag.h -- MAG format image handling
//
//		created    in 3/2/1993
//		revised    in 2/12/1994
*/

/*
 * rewritten by Satoshi KURAMOCHI 1996,1997
 * $Id: magfile.h,v 1.3 1997-12-20 20:09:44+09 satoshi Exp $
 */
#ifndef	_MAGFILE_H_
#define	_MAGFILE_H_

#include <stdio.h>
#include <string.h>

/*
//	defs.h -- $B4pK\E*$JDj5A$HA4%U%!%$%k6&DL$JItJ,(B
//
//		created    in 2/11/1994
*/

/* modified by S.Kuramochi  1996,1997 */

/* 1. Define a bitwidth of each integer correctly according to your system. */
typedef	short int	int16;
typedef long int 	int32;
typedef unsigned int 	uint32;

/* Ok. That's all. (maybe) */

#define	error(Message) \
    fprintf( stderr, "%s: " Message "\n", Program, File )

struct MagHeader {
    char	Head;
    char	Machine;
    char	MachineDependence;
    char	ScreenMode;
    int16	Left;
    int16   	Top;
    int16   	Right;
    int16   	Bottom;
    uint32      FlagAOffset;
    uint32      FlagBOffset;
    uint32      FlagBSize;
    uint32      PixelOffset;
    uint32      PixelSize;
};

class MagFile {
private:
  const char* Program;
  char* File;
  char* name;
  FILE* fp;
  static const unsigned char BitField[8];
  int MaxColorGuaranteed;
  int DoubleLine;
  char *FlagA, *FlagB, *Flag;
  static const int OriginalDX[16];
  static const int OriginalDY[16];
  char *FlagBuffer;
  int MaxColor;

public:
  MagHeader header;
  int32 width, height, size;
  unsigned char *Red, *Green, *Blue;
  unsigned char *Screen;

  MagFile(const char* name_) : Program("MagFile"), File(NULL), name(NULL),
  fp(NULL), width(0), height(0), size(0), Red(NULL), Green(NULL), Blue(NULL),
  Screen(NULL) {
    Red = new unsigned char[256+4];
    Green = new unsigned char[256+4];
    Blue = new unsigned char[256+4];
    if(name_ != NULL) {
      name = new char[strlen(name_)+1];
      strcpy(name, name_);
      File = name;
    }
  }

  ~MagFile() {
//  delete[] Screen;
    delete[] Blue;
    delete[] Green;
    delete[] Red;
    delete[] name;
  }

  unsigned char* allocateScreen(int32 width_, int32 height_) {
    width = width_;
    height = height_;
    size = width*height;
    return (Screen = new unsigned char[size+256]);
  }

  void load(void);
//void save(void);

private:
  void readHeader(void);
  int16 readWord(void);
  uint32 readDWord(void);
  void decode(char *FlagA, char *FlagB);
  void decode256(char *FlagA, char *FlagB);
#if 0
  void writeWord(int16 c);
  void writeDWord(uint32 c);
  void writeImage(char *FlagA, char *FlagB);
  void writeImage256(char *FlagA, char *FlagB);
#endif
};

#endif /* !_MAGFILE_H_ */
