/*
 * instrument.cc -- definition of instrument names
 *
 * Copyright (C) 1995-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: instrument.cc,v 1.3 1998-02-13 07:37:01+09 satoshi Exp $
#include <stdio.h>

typedef struct {
  char pc;
  char cc00;
  const char* name;
} Inst;

const char* inst_sc88_pro[128][128];
const char* inst_sc88_88[128][128];
const char* inst_sc88_55[128][128];
const char* drum_sc88_pro[128];
const char* drum_sc88_88[128];
const char* drum_sc88_55[128];
const char* efx_sc88_pro[128][128];

const char* inst_xg[128][128];
const char* inst_mu100[128][128];
const char* sfx_xg[128];
const char* drum_sfx_xg[128];
const char* drum_xg[128];

//const char* inst_korg[128][128];


void init_inst_name(void)
{
  int prg, bnk;
  for(prg = 0; prg < 128; prg++) {
    for(bnk = 0; bnk < 128; bnk++) {
      inst_sc88_pro[prg][bnk] = NULL;
      inst_sc88_88[prg][bnk] = NULL;
      inst_sc88_55[prg][bnk] = NULL;
      efx_sc88_pro[prg][bnk] = NULL;
      inst_xg[prg][bnk] = NULL;
      inst_mu100[prg][bnk] = NULL;
//      inst_korg[prg][bnk] = NULL;
    }
    inst_sc88_pro[prg][64] = "User Inst";
    inst_sc88_pro[prg][65] = "User Inst";
    inst_sc88_88[prg][64] = "User Inst";
    inst_sc88_88[prg][65] = "User Inst";
    drum_sc88_pro[prg] = NULL;
    drum_sc88_88[prg] = NULL;
    drum_sc88_55[prg] = NULL;
    sfx_xg[prg] = NULL;
    drum_sfx_xg[prg] = NULL;
    drum_xg[prg] = NULL;
  }

/*
 * 88Pro MAP
 */
inst_sc88_pro[  0][ 0] = "Piano 1";
inst_sc88_pro[  0][ 8] = "Piano 1w";
inst_sc88_pro[  0][16] = "European Pf";
inst_sc88_pro[  0][24] = "Piano + Str.";
inst_sc88_pro[  1][ 0] = "Piano 2";
inst_sc88_pro[  1][ 8] = "Piano 2w";
inst_sc88_pro[  1][16] = "Dance Piano";
inst_sc88_pro[  2][ 0] = "Piano 3";
inst_sc88_pro[  2][ 1] = "EG+Rhodes 1";
inst_sc88_pro[  2][ 2] = "EG+Rhodes 2";
inst_sc88_pro[  2][ 8] = "Piano 3w";
inst_sc88_pro[  3][ 0] = "Honky-tonk";
inst_sc88_pro[  3][ 8] = "Honky-tonk 2";
inst_sc88_pro[  4][ 0] = "E.Piano 1";
inst_sc88_pro[  4][ 8] = "St.Soft EP";
inst_sc88_pro[  4][ 9] = "Cho. E.Piano";
inst_sc88_pro[  4][10] = "SilentRhodes";
inst_sc88_pro[  4][16] = "FM+SA EP";
inst_sc88_pro[  4][17] = "Dist E.Piano";
inst_sc88_pro[  4][24] = "Wurly";
inst_sc88_pro[  4][25] = "Hard Rhodes";
inst_sc88_pro[  4][26] = "MellowRhodes";
inst_sc88_pro[  5][ 0] = "E.Piano 2";
inst_sc88_pro[  5][ 8] = "Detuned EP 2";
inst_sc88_pro[  5][16] = "St.FM EP";
inst_sc88_pro[  5][24] = "Hard FM EP";
inst_sc88_pro[  6][ 0] = "Harpsichord";
inst_sc88_pro[  6][ 1] = "Harpsichord2";
inst_sc88_pro[  6][ 8] = "Coupled Hps.";
inst_sc88_pro[  6][16] = "Harpsi.w";
inst_sc88_pro[  6][24] = "Harpsi.o";
inst_sc88_pro[  6][32] = "Synth Harpsi";
inst_sc88_pro[  7][ 0] = "Clav.";
inst_sc88_pro[  7][ 8] = "Comp Clav.";
inst_sc88_pro[  7][16] = "Reso Clav.";
inst_sc88_pro[  7][24] = "Clav.o";
inst_sc88_pro[  7][32] = "Analog Clav.";
inst_sc88_pro[  7][33] = "JP8 Clav. 1";
inst_sc88_pro[  7][35] = "JP8 Clav. 2";
inst_sc88_pro[  8][ 0] = "Celesta";
inst_sc88_pro[  8][ 1] = "Pop Celesta";
inst_sc88_pro[  9][ 0] = "Glockenspiel";
inst_sc88_pro[ 10][ 0] = "Music Box";
inst_sc88_pro[ 11][ 0] = "Vibraphone";
inst_sc88_pro[ 11][ 1] = "Pop Vibe.";
inst_sc88_pro[ 11][ 8] = "Vibraphone w";
inst_sc88_pro[ 11][ 9] = "Vibraphones";
inst_sc88_pro[ 12][ 0] = "Marimba";
inst_sc88_pro[ 12][ 8] = "Marimba w";
inst_sc88_pro[ 12][16] = "Barafon";
inst_sc88_pro[ 12][17] = "Barafon 2";
inst_sc88_pro[ 12][24] = "Log drum";
inst_sc88_pro[ 13][ 0] = "Xylophone";
inst_sc88_pro[ 14][ 0] = "Tubular-bell";
inst_sc88_pro[ 14][ 8] = "Church Bell";
inst_sc88_pro[ 14][ 9] = "Carillon";
inst_sc88_pro[ 15][ 0] = "Santur";
inst_sc88_pro[ 15][ 1] = "Santur 2";
inst_sc88_pro[ 15][ 8] = "Cimbalom";
inst_sc88_pro[ 15][16] = "Zither 1";
inst_sc88_pro[ 15][17] = "Zither 2";
inst_sc88_pro[ 15][24] = "Dulcimer";
inst_sc88_pro[ 16][ 0] = "Organ 1";
inst_sc88_pro[ 16][ 1] = "Organ 101";
inst_sc88_pro[ 16][ 8] = "Trem. Organ";
inst_sc88_pro[ 16][ 9] = "Organ o";
inst_sc88_pro[ 16][16] = "60's Organ 1";
inst_sc88_pro[ 16][17] = "60's Organ 2";
inst_sc88_pro[ 16][18] = "60's Organ 3";
inst_sc88_pro[ 16][19] = "Farf Organ";
inst_sc88_pro[ 16][24] = "Cheese Organ";
inst_sc88_pro[ 16][25] = "D-50 Organ";
inst_sc88_pro[ 16][26] = "JUNO Organ";
inst_sc88_pro[ 16][27] = "Hybrid Organ";
inst_sc88_pro[ 16][28] = "VS Organ";
inst_sc88_pro[ 16][29] = "Digi Church";
inst_sc88_pro[ 16][32] = "70's E.Organ";
inst_sc88_pro[ 16][33] = "Even Bar";
inst_sc88_pro[ 16][40] = "Organ Bass";
inst_sc88_pro[ 16][48] = "5th Organ";
inst_sc88_pro[ 17][ 0] = "Organ 2";
inst_sc88_pro[ 17][ 1] = "Jazz Organ";
inst_sc88_pro[ 17][ 2] = "E.Organ 16+2";
inst_sc88_pro[ 17][ 8] = "Chorus Or.2";
inst_sc88_pro[ 17][ 9] = "Octave Organ";
inst_sc88_pro[ 17][32] = "Perc. Organ";
inst_sc88_pro[ 18][ 0] = "Organ 3";
inst_sc88_pro[ 18][ 8] = "Rotary Org.";
inst_sc88_pro[ 18][16] = "Rotary Org.S";
inst_sc88_pro[ 18][17] = "Rock Organ 1";
inst_sc88_pro[ 18][18] = "Rock Organ 2";
inst_sc88_pro[ 18][24] = "Rotary Org.F";
inst_sc88_pro[ 19][ 0] = "Church Org.1";
inst_sc88_pro[ 19][ 8] = "Church Org.2";
inst_sc88_pro[ 19][16] = "Church Org.3";
inst_sc88_pro[ 19][24] = "Organ Flute";
inst_sc88_pro[ 19][32] = "Trem.Flute";
inst_sc88_pro[ 19][33] = "Theater Org.";
inst_sc88_pro[ 20][ 0] = "Reed Organ";
inst_sc88_pro[ 20][ 8] = "Wind Organ";
inst_sc88_pro[ 21][ 0] = "Accordion Fr";
inst_sc88_pro[ 21][ 8] = "Accordion It";
inst_sc88_pro[ 21][ 9] = "Dist. Accord";
inst_sc88_pro[ 21][16] = "Cho. Accord";
inst_sc88_pro[ 21][24] = "Hard Accord";
inst_sc88_pro[ 21][25] = "Soft Accord";
inst_sc88_pro[ 22][ 0] = "Harmonica";
inst_sc88_pro[ 22][ 1] = "Harmonica 2";
inst_sc88_pro[ 23][ 0] = "Bandoneon";
inst_sc88_pro[ 23][ 8] = "Bandoneon 2";
inst_sc88_pro[ 23][16] = "Bandoneon 3";
inst_sc88_pro[ 24][ 0] = "Nylon-str.Gt";
inst_sc88_pro[ 24][ 8] = "Ukulele";
inst_sc88_pro[ 24][16] = "Nylon Gt.o";
inst_sc88_pro[ 24][24] = "Velo Harmnix";
inst_sc88_pro[ 24][32] = "Nylon Gt.2";
inst_sc88_pro[ 24][40] = "Lequint Gt.";
inst_sc88_pro[ 25][ 0] = "Steel-str.Gt";
inst_sc88_pro[ 25][ 8] = "12-str.Gt";
inst_sc88_pro[ 25][ 9] = "Nylon+Steel";
inst_sc88_pro[ 25][16] = "Mandolin";
inst_sc88_pro[ 25][17] = "Mandolin 2";
inst_sc88_pro[ 25][18] = "MandolinTrem";
inst_sc88_pro[ 25][32] = "Steel Gt.2";
inst_sc88_pro[ 26][ 0] = "Jazz Gt.";
inst_sc88_pro[ 26][ 1] = "Mellow Gt.";
inst_sc88_pro[ 26][ 8] = "Pedal Steel";
inst_sc88_pro[ 27][ 0] = "Clean Gt.";
inst_sc88_pro[ 27][ 1] = "Clean Half";
inst_sc88_pro[ 27][ 2] = "Open Hard 1";
inst_sc88_pro[ 27][ 3] = "Open Hard 2";
inst_sc88_pro[ 27][ 4] = "JC Clean Gt.";
inst_sc88_pro[ 27][ 8] = "Chorus Gt.";
inst_sc88_pro[ 27][ 9] = "JC Chorus Gt";
inst_sc88_pro[ 27][16] = "TC FrontPick";
inst_sc88_pro[ 27][17] = "TC Rear Pick";
inst_sc88_pro[ 27][18] = "TC Clean ff";
inst_sc88_pro[ 27][19] = "TC Clean 2:";
inst_sc88_pro[ 28][ 0] = "Muted Gt.";
inst_sc88_pro[ 28][ 1] = "Muted Dis.Gt";
inst_sc88_pro[ 28][ 2] = "TC Muted Gt.";
inst_sc88_pro[ 28][ 8] = "Funk Pop";
inst_sc88_pro[ 28][16] = "Funk Gt.2";
inst_sc88_pro[ 29][ 0] = "Overdrive Gt";
inst_sc88_pro[ 29][ 1] = "Overdrive 2";
inst_sc88_pro[ 29][ 2] = "Overdrive 3";
inst_sc88_pro[ 29][ 3] = "More Drive";
inst_sc88_pro[ 29][ 8] = "LP OverDrvGt";
inst_sc88_pro[ 29][ 9] = "LP OverDrv:";
inst_sc88_pro[ 30][ 0] = "DistortionGt";
inst_sc88_pro[ 30][ 1] = "Dist. Gt2 :";
inst_sc88_pro[ 30][ 2] = "Dazed Guitar";
inst_sc88_pro[ 30][ 3] = "Distortion:";
inst_sc88_pro[ 30][ 4] = "Dist.Fast :";
inst_sc88_pro[ 30][ 8] = "Feedback Gt.";
inst_sc88_pro[ 30][ 9] = "Feedback Gt2";
inst_sc88_pro[ 30][16] = "Power Guitar";
inst_sc88_pro[ 30][17] = "Power Gt.2";
inst_sc88_pro[ 30][18] = "5th Dist.";
inst_sc88_pro[ 30][24] = "Rock Rhythm";
inst_sc88_pro[ 30][25] = "Rock Rhythm2";
inst_sc88_pro[ 31][ 0] = "Gt.Harmonics";
inst_sc88_pro[ 31][ 8] = "Gt. Feedback";
inst_sc88_pro[ 31][ 9] = "Gt.Feedback2";
inst_sc88_pro[ 31][16] = "Ac.Gt.Harmnx";
inst_sc88_pro[ 31][24] = "E.Bass Harm.";
inst_sc88_pro[ 32][ 0] = "Acoustic Bs.";
inst_sc88_pro[ 32][ 1] = "Rockabilly";
inst_sc88_pro[ 32][ 8] = "Wild A.Bass";
inst_sc88_pro[ 32][16] = "Bass + OHH";
inst_sc88_pro[ 33][ 0] = "Fingered Bs.";
inst_sc88_pro[ 33][ 1] = "Fingered Bs2";
inst_sc88_pro[ 33][ 2] = "Jazz Bass";
inst_sc88_pro[ 33][ 3] = "Jazz Bass 2";
inst_sc88_pro[ 33][ 4] = "Rock Bass";
inst_sc88_pro[ 33][ 8] = "ChorusJazzBs";
inst_sc88_pro[ 33][16] = "F.Bass/Harm.";
inst_sc88_pro[ 34][ 0] = "Picked Bass";
inst_sc88_pro[ 34][ 1] = "Picked Bass2";
inst_sc88_pro[ 34][ 2] = "Picked Bass3";
inst_sc88_pro[ 34][ 3] = "Picked Bass4";
inst_sc88_pro[ 34][ 8] = "Muted PickBs";
inst_sc88_pro[ 34][16] = "P.Bass/Harm.";
inst_sc88_pro[ 35][ 0] = "Fretless Bs.";
inst_sc88_pro[ 35][ 1] = "Fretless Bs2";
inst_sc88_pro[ 35][ 2] = "Fretless Bs3";
inst_sc88_pro[ 35][ 3] = "Fretless Bs4";
inst_sc88_pro[ 35][ 4] = "Syn Fretless";
inst_sc88_pro[ 35][ 5] = "Mr.Smooth";
inst_sc88_pro[ 35][ 8] = "Wood+FlessBs";
inst_sc88_pro[ 36][ 0] = "Slap Bass 1";
inst_sc88_pro[ 36][ 1] = "Slap Pop";
inst_sc88_pro[ 36][ 8] = "Reso Slap";
inst_sc88_pro[ 36][ 9] = "Unison Slap";
inst_sc88_pro[ 37][ 0] = "Slap Bass 2";
inst_sc88_pro[ 37][ 8] = "FM Slap";
inst_sc88_pro[ 38][ 0] = "Synth Bass 1";
inst_sc88_pro[ 38][ 1] = "SynthBass101";
inst_sc88_pro[ 38][ 2] = "CS Bass";
inst_sc88_pro[ 38][ 3] = "JP-4 Bass";
inst_sc88_pro[ 38][ 4] = "JP-8 Bass";
inst_sc88_pro[ 38][ 5] = "P5 Bass";
inst_sc88_pro[ 38][ 6] = "JPMG Bass";
inst_sc88_pro[ 38][ 8] = "Acid Bass";
inst_sc88_pro[ 38][ 9] = "TB303 Bass";
inst_sc88_pro[ 38][10] = "Tekno Bass";
inst_sc88_pro[ 38][11] = "TB303 Bass 2";
inst_sc88_pro[ 38][12] = "Kicked TB303";
inst_sc88_pro[ 38][13] = "TB303 Saw Bs";
inst_sc88_pro[ 38][14] = "Rubber303 Bs";
inst_sc88_pro[ 38][15] = "Reso 303 Bs";
inst_sc88_pro[ 38][16] = "Reso SH Bass";
inst_sc88_pro[ 38][17] = "TB303 Sqr Bs";
inst_sc88_pro[ 38][18] = "TB303 DistBs";
inst_sc88_pro[ 38][24] = "Arpeggio Bs";
inst_sc88_pro[ 39][ 0] = "Synth Bass 2";
inst_sc88_pro[ 39][ 1] = "SynthBass201";
inst_sc88_pro[ 39][ 2] = "Modular Bass";
inst_sc88_pro[ 39][ 3] = "Seq Bass";
inst_sc88_pro[ 39][ 4] = "MG Bass";
inst_sc88_pro[ 39][ 5] = "Mg Oct Bass1";
inst_sc88_pro[ 39][ 6] = "MG Oct Bass2";
inst_sc88_pro[ 39][ 7] = "MG Blip Bs:";
inst_sc88_pro[ 39][ 8] = "Beef FM Bass";
inst_sc88_pro[ 39][ 9] = "Dly Bass";
inst_sc88_pro[ 39][10] = "X Wire Bass";
inst_sc88_pro[ 39][11] = "WireStr Bass";
inst_sc88_pro[ 39][12] = "Blip Bass :";
inst_sc88_pro[ 39][13] = "RubberBass 1";
inst_sc88_pro[ 39][16] = "RubberBass 2";
inst_sc88_pro[ 39][17] = "SH101 Bass 1";
inst_sc88_pro[ 39][18] = "SH101 Bass 2";
inst_sc88_pro[ 39][19] = "Smooth Bass";
inst_sc88_pro[ 39][20] = "SH101 Bass 3";
inst_sc88_pro[ 39][21] = "Spike Bass";
inst_sc88_pro[ 39][22] = "House Bass:";
inst_sc88_pro[ 39][23] = "KG Bass";
inst_sc88_pro[ 39][24] = "Sync Bass";
inst_sc88_pro[ 39][25] = "MG 5th Bass";
inst_sc88_pro[ 39][26] = "RND Bass";
inst_sc88_pro[ 39][27] = "WowMG Bass";
inst_sc88_pro[ 39][28] = "Bubble Bass";
inst_sc88_pro[ 40][ 0] = "Violin    :";
inst_sc88_pro[ 40][ 1] = "Violin Atk:";
inst_sc88_pro[ 40][ 8] = "Slow Violin";
inst_sc88_pro[ 41][ 0] = "Viola     :";
inst_sc88_pro[ 41][ 1] = "Viola Atk.:";
inst_sc88_pro[ 42][ 0] = "Cello     :";
inst_sc88_pro[ 42][ 1] = "Cello Atk.:";
inst_sc88_pro[ 43][ 0] = "Contrabass";
inst_sc88_pro[ 44][ 0] = "Tremolo Str";
inst_sc88_pro[ 44][ 8] = "Slow Tremolo";
inst_sc88_pro[ 44][ 9] = "Suspense Str";
inst_sc88_pro[ 45][ 0] = "PizzicatoStr";
inst_sc88_pro[ 45][ 1] = "Vcs&Cbs Pizz";
inst_sc88_pro[ 45][ 2] = "Chamber Pizz";
inst_sc88_pro[ 45][ 3] = "St.Pizzicato";
inst_sc88_pro[ 45][ 8] = "Solo Pizz.";
inst_sc88_pro[ 45][16] = "Solo Spic.";
inst_sc88_pro[ 46][ 0] = "Harp";
inst_sc88_pro[ 46][16] = "Synth Harp";
inst_sc88_pro[ 47][ 0] = "Timpani";
inst_sc88_pro[ 48][ 0] = "Strings   :";
inst_sc88_pro[ 48][ 1] = "Bright Str:";
inst_sc88_pro[ 48][ 2] = "ChamberStr:";
inst_sc88_pro[ 48][ 3] = "Cello sect.";
inst_sc88_pro[ 48][ 8] = "Orchestra";
inst_sc88_pro[ 48][ 9] = "Orchestra 2";
inst_sc88_pro[ 48][10] = "Tremolo Orch";
inst_sc88_pro[ 48][11] = "Choir Str.";
inst_sc88_pro[ 48][12] = "Strings+Horn";
inst_sc88_pro[ 48][16] = "St. Strings";
inst_sc88_pro[ 48][24] = "Velo Strings";
inst_sc88_pro[ 48][32] = "Oct Strings1";
inst_sc88_pro[ 48][33] = "Oct Strings2";
inst_sc88_pro[ 49][ 0] = "Slow Strings";
inst_sc88_pro[ 49][ 1] = "SlowStrings2";
inst_sc88_pro[ 49][ 8] = "Legato Str.";
inst_sc88_pro[ 49][ 9] = "Warm Strings";
inst_sc88_pro[ 49][10] = "St.Slow Str.";
inst_sc88_pro[ 50][ 0] = "Syn.Strings1";
inst_sc88_pro[ 50][ 1] = "OB Strings";
inst_sc88_pro[ 50][ 2] = "StackStrings";
inst_sc88_pro[ 50][ 3] = "JP Strings";
inst_sc88_pro[ 50][ 8] = "Syn.Strings3";
inst_sc88_pro[ 50][ 9] = "Syn.Strings4";
inst_sc88_pro[ 50][16] = "High Strings";
inst_sc88_pro[ 50][17] = "Hybrid Str.";
inst_sc88_pro[ 50][24] = "Tron Strings";
inst_sc88_pro[ 50][25] = "Noiz Strings";
inst_sc88_pro[ 51][ 0] = "Syn.Strings2";
inst_sc88_pro[ 51][ 1] = "Syn.Strings5";
inst_sc88_pro[ 51][ 2] = "JUNO Strings";
inst_sc88_pro[ 51][ 8] = "Air Strings";
inst_sc88_pro[ 52][ 0] = "Choir Aahs";
inst_sc88_pro[ 52][ 8] = "St.ChoirAahs";
inst_sc88_pro[ 52][ 9] = "Melted Choir";
inst_sc88_pro[ 52][10] = "Church Choir";
inst_sc88_pro[ 52][16] = "Choir Hahs";
inst_sc88_pro[ 52][24] = "Chorus Lahs";
inst_sc88_pro[ 52][32] = "Chorus Aahs";
inst_sc88_pro[ 52][33] = "Male Aah+Str";
inst_sc88_pro[ 53][ 0] = "Voice Oohs";
inst_sc88_pro[ 53][ 8] = "Voice Dahs";
inst_sc88_pro[ 54][ 0] = "SynVox";
inst_sc88_pro[ 54][ 8] = "Syn.Voice";
inst_sc88_pro[ 54][ 9] = "Silent Night";
inst_sc88_pro[ 54][16] = "VP330 Choir";
inst_sc88_pro[ 54][17] = "Vinyl Choir";
inst_sc88_pro[ 55][ 0] = "OrchestraHit";
inst_sc88_pro[ 55][ 8] = "Impact Hit";
inst_sc88_pro[ 55][ 9] = "Philly Hit";
inst_sc88_pro[ 55][10] = "Double Hit";
inst_sc88_pro[ 55][11] = "Perc. Hit";
inst_sc88_pro[ 55][12] = "Shock Wave";
inst_sc88_pro[ 55][16] = "Lo Fi Rave";
inst_sc88_pro[ 55][17] = "Techno Hit";
inst_sc88_pro[ 55][18] = "Dist. Hit";
inst_sc88_pro[ 55][19] = "Bam Hit";
inst_sc88_pro[ 55][20] = "Bit Hit";
inst_sc88_pro[ 55][21] = "Bim Hit";
inst_sc88_pro[ 55][22] = "Technorg Hit";
inst_sc88_pro[ 55][23] = "Rave Hit";
inst_sc88_pro[ 55][24] = "Strings Hit";
inst_sc88_pro[ 55][25] = "Stack Hit";
inst_sc88_pro[ 56][ 0] = "Trumpet";
inst_sc88_pro[ 56][ 1] = "Trumpet 2";
inst_sc88_pro[ 56][ 2] = "Trumpet   :";
inst_sc88_pro[ 56][ 8] = "Flugel Horn";
inst_sc88_pro[ 56][16] = "4th Trumpets";
inst_sc88_pro[ 56][24] = "Bright Tp.";
inst_sc88_pro[ 56][25] = "Warm Tp.";
inst_sc88_pro[ 56][32] = "Syn. Trumpet";
inst_sc88_pro[ 57][ 0] = "Trombone";
inst_sc88_pro[ 57][ 1] = "Trombone 2";
inst_sc88_pro[ 57][ 2] = "Twin bones";
inst_sc88_pro[ 57][ 8] = "Bs. Trombone";
inst_sc88_pro[ 58][ 0] = "Tuba";
inst_sc88_pro[ 58][ 1] = "Tuba 2";
inst_sc88_pro[ 59][ 0] = "MutedTrumpet";
inst_sc88_pro[ 59][ 8] = "Muted Horns";
inst_sc88_pro[ 60][ 0] = "French Horns";
inst_sc88_pro[ 60][ 1] = "Fr.Horn 2";
inst_sc88_pro[ 60][ 2] = "Horn + Orche";
inst_sc88_pro[ 60][ 3] = "Wide FreHrns";
inst_sc88_pro[ 60][ 8] = "F.Hrn Slow:";
inst_sc88_pro[ 60][ 9] = "Dual Horns";
inst_sc88_pro[ 60][16] = "Synth Horn";
inst_sc88_pro[ 60][24] = "F.Horn Rip";
inst_sc88_pro[ 61][ 0] = "Brass 1";
inst_sc88_pro[ 61][ 1] = "Brass ff";
inst_sc88_pro[ 61][ 2] = "Bones Sect.";
inst_sc88_pro[ 61][ 8] = "Brass 2";
inst_sc88_pro[ 61][ 9] = "Brass 3";
inst_sc88_pro[ 61][10] = "Brass sfz";
inst_sc88_pro[ 61][16] = "Brass Fall";
inst_sc88_pro[ 61][17] = "Trumpet Fall";
inst_sc88_pro[ 61][24] = "Octave Brass";
inst_sc88_pro[ 61][25] = "Brass + Reed";
inst_sc88_pro[ 62][ 0] = "Synth Brass1";
inst_sc88_pro[ 62][ 1] = "JUNO Brass";
inst_sc88_pro[ 62][ 2] = "Stack Brass";
inst_sc88_pro[ 62][ 3] = "SH-5 Brass";
inst_sc88_pro[ 62][ 4] = "MKS Brass";
inst_sc88_pro[ 62][ 8] = "Pro Brass";
inst_sc88_pro[ 62][ 9] = "P5 Brass";
inst_sc88_pro[ 62][16] = "Oct SynBrass";
inst_sc88_pro[ 62][17] = "Hybrid Brass";
inst_sc88_pro[ 63][ 0] = "Synth Brass2";
inst_sc88_pro[ 63][ 1] = "Soft Brass";
inst_sc88_pro[ 63][ 2] = "Warm Brass";
inst_sc88_pro[ 63][ 8] = "SynBrass sfz";
inst_sc88_pro[ 63][ 9] = "OB Brass";
inst_sc88_pro[ 63][10] = "Reso Brass";
inst_sc88_pro[ 63][16] = "Velo Brass 1";
inst_sc88_pro[ 63][17] = "Transbrass";
inst_sc88_pro[ 64][ 0] = "Soprano Sax";
inst_sc88_pro[ 64][ 8] = "Soprano Exp.";
inst_sc88_pro[ 65][ 0] = "Alto Sax";
inst_sc88_pro[ 65][ 8] = "AltoSax Exp.";
inst_sc88_pro[ 65][ 9] = "Grow Sax";
inst_sc88_pro[ 65][16] = "AltoSax + Tp";
inst_sc88_pro[ 66][ 0] = "Tenor Sax";
inst_sc88_pro[ 66][ 1] = "Tenor Sax :";
inst_sc88_pro[ 66][ 8] = "BreathyTn.:";
inst_sc88_pro[ 66][ 9] = "St.Tenor Sax";
inst_sc88_pro[ 67][ 0] = "Baritone Sax";
inst_sc88_pro[ 67][ 1] = "Bari. Sax :";
inst_sc88_pro[ 68][ 0] = "Oboe";
inst_sc88_pro[ 68][ 8] = "Oboe Exp.";
inst_sc88_pro[ 68][16] = "Multi Reed";
inst_sc88_pro[ 69][ 0] = "English Horn";
inst_sc88_pro[ 70][ 0] = "Bassoon";
inst_sc88_pro[ 71][ 0] = "Clarinet";
inst_sc88_pro[ 71][ 8] = "Bs Clarinet";
inst_sc88_pro[ 71][16] = "Multi Wind";
inst_sc88_pro[ 72][ 0] = "Piccolo";
inst_sc88_pro[ 72][ 1] = "Piccolo   :";
inst_sc88_pro[ 72][ 8] = "Nay";
inst_sc88_pro[ 72][ 9] = "Nay Tremolo";
inst_sc88_pro[ 72][16] = "Di";
inst_sc88_pro[ 73][ 0] = "Flute";
inst_sc88_pro[ 73][ 1] = "Flute 2   :";
inst_sc88_pro[ 73][ 2] = "Flute Exp.";
inst_sc88_pro[ 73][ 3] = "Flt Travelso";
inst_sc88_pro[ 73][ 8] = "Flute + Vln";
inst_sc88_pro[ 73][16] = "Tron Flute";
inst_sc88_pro[ 74][ 0] = "Recorder";
inst_sc88_pro[ 75][ 0] = "Pan Flute";
inst_sc88_pro[ 75][ 8] = "Kawala";
inst_sc88_pro[ 75][16] = "Zampona";
inst_sc88_pro[ 75][17] = "Zampona Atk";
inst_sc88_pro[ 76][ 0] = "Bottle Blow";
inst_sc88_pro[ 77][ 0] = "Shakuhachi";
inst_sc88_pro[ 77][ 1] = "Shakuhachi:";
inst_sc88_pro[ 78][ 0] = "Whistle";
inst_sc88_pro[ 78][ 1] = "Whistle 2";
inst_sc88_pro[ 79][ 0] = "Ocarina";
inst_sc88_pro[ 80][ 0] = "Square Wave";
inst_sc88_pro[ 80][ 1] = "MG Square";
inst_sc88_pro[ 80][ 2] = "Hollow Mini";
inst_sc88_pro[ 80][ 3] = "Mellow FM";
inst_sc88_pro[ 80][ 4] = "CC Solo";
inst_sc88_pro[ 80][ 5] = "Shmoog";
inst_sc88_pro[ 80][ 6] = "LM Square";
inst_sc88_pro[ 80][ 8] = "2600 Sine";
inst_sc88_pro[ 80][ 9] = "Sine Lead";
inst_sc88_pro[ 80][10] = "KG Lead";
inst_sc88_pro[ 80][16] = "P5 Square";
inst_sc88_pro[ 80][17] = "OB Square";
inst_sc88_pro[ 80][18] = "JP-8 Square";
inst_sc88_pro[ 80][24] = "Pulse Lead";
inst_sc88_pro[ 80][25] = "JP8 PulseLd1";
inst_sc88_pro[ 80][26] = "JP8 PulseLd2";
inst_sc88_pro[ 80][27] = "MG Reso. Pls";
inst_sc88_pro[ 81][ 0] = "Saw Wave";
inst_sc88_pro[ 81][ 1] = "OB2 Saw";
inst_sc88_pro[ 81][ 2] = "Pulse Saw";
inst_sc88_pro[ 81][ 3] = "Feline GR";
inst_sc88_pro[ 81][ 4] = "Big Lead";
inst_sc88_pro[ 81][ 5] = "Velo Lead";
inst_sc88_pro[ 81][ 6] = "GR-300";
inst_sc88_pro[ 81][ 7] = "LA Saw";
inst_sc88_pro[ 81][ 8] = "Doctor Solo";
inst_sc88_pro[ 81][ 9] = "Fat Saw Lead";
inst_sc88_pro[ 81][11] = "D-50 Fat Saw";
inst_sc88_pro[ 81][16] = "Waspy Synth";
inst_sc88_pro[ 81][17] = "PM Lead";
inst_sc88_pro[ 81][18] = "CS Saw Lead";
inst_sc88_pro[ 81][24] = "MG Saw 1";
inst_sc88_pro[ 81][25] = "MG Saw 2";
inst_sc88_pro[ 81][26] = "OB Saw 1";
inst_sc88_pro[ 81][27] = "OB Saw 2";
inst_sc88_pro[ 81][28] = "D-50 Saw";
inst_sc88_pro[ 81][29] = "SH-101 Saw";
inst_sc88_pro[ 81][30] = "CS Saw";
inst_sc88_pro[ 81][31] = "MG Saw Lead";
inst_sc88_pro[ 81][32] = "OB Saw Lead";
inst_sc88_pro[ 81][33] = "P5 Saw Lead";
inst_sc88_pro[ 81][34] = "MG unison";
inst_sc88_pro[ 81][35] = "Oct Saw Lead";
inst_sc88_pro[ 81][40] = "SequenceSaw1";
inst_sc88_pro[ 81][41] = "SequenceSaw2";
inst_sc88_pro[ 81][42] = "Reso Saw";
inst_sc88_pro[ 81][43] = "Cheese Saw 1";
inst_sc88_pro[ 81][44] = "Cheese Saw 2";
inst_sc88_pro[ 81][45] = "Rhythmic Saw";
inst_sc88_pro[ 82][ 0] = "Syn.Calliope";
inst_sc88_pro[ 82][ 1] = "Vent Synth";
inst_sc88_pro[ 82][ 2] = "Pure PanLead";
inst_sc88_pro[ 83][ 0] = "Chiffer Lead";
inst_sc88_pro[ 83][ 1] = "TB Lead";
inst_sc88_pro[ 83][ 8] = "Mad Lead";
inst_sc88_pro[ 84][ 0] = "Charang";
inst_sc88_pro[ 84][ 8] = "Dist.Lead";
inst_sc88_pro[ 84][ 9] = "Acid Guitar1";
inst_sc88_pro[ 84][10] = "Acid Guitar2";
inst_sc88_pro[ 84][16] = "P5 Sync Lead";
inst_sc88_pro[ 84][17] = "Fat SyncLead";
inst_sc88_pro[ 84][18] = "Rock Lead";
inst_sc88_pro[ 84][19] = "5th DecaSync";
inst_sc88_pro[ 84][20] = "Dirty Sync";
inst_sc88_pro[ 84][24] = "JUNO Sub Osc";
inst_sc88_pro[ 85][ 0] = "Solo Vox";
inst_sc88_pro[ 85][ 8] = "Vox Lead";
inst_sc88_pro[ 85][ 9] = "LFO Vox";
inst_sc88_pro[ 86][ 0] = "5th Saw Wave";
inst_sc88_pro[ 86][ 1] = "Big Fives";
inst_sc88_pro[ 86][ 2] = "5th Lead";
inst_sc88_pro[ 86][ 3] = "5th Ana.Clav";
inst_sc88_pro[ 86][ 8] = "4th Lead";
inst_sc88_pro[ 87][ 0] = "Bass & Lead";
inst_sc88_pro[ 87][ 1] = "Big & Raw";
inst_sc88_pro[ 87][ 2] = "Fat & Perky";
inst_sc88_pro[ 87][ 3] = "JUNO Rave";
inst_sc88_pro[ 87][ 4] = "JP8 BsLead 1";
inst_sc88_pro[ 87][ 5] = "JP8 BsLead 2";
inst_sc88_pro[ 87][ 6] = "SH-5 Bs.Lead";
inst_sc88_pro[ 88][ 0] = "Fantasia";
inst_sc88_pro[ 88][ 1] = "Fantasia 2";
inst_sc88_pro[ 88][ 2] = "New Age Pad";
inst_sc88_pro[ 88][ 3] = "Bell Heaven";
inst_sc88_pro[ 89][ 0] = "Warm Pad";
inst_sc88_pro[ 89][ 1] = "Thick Matrix";
inst_sc88_pro[ 89][ 2] = "Horn Pad";
inst_sc88_pro[ 89][ 3] = "Rotary Strng";
inst_sc88_pro[ 89][ 4] = "OB Soft Pad";
inst_sc88_pro[ 89][ 8] = "Octave Pad";
inst_sc88_pro[ 89][ 9] = "Stack Pad";
inst_sc88_pro[ 90][ 0] = "Polysynth";
inst_sc88_pro[ 90][ 1] = "80's PolySyn";
inst_sc88_pro[ 90][ 2] = "Polysynth 2";
inst_sc88_pro[ 90][ 3] = "Poly King";
inst_sc88_pro[ 90][ 8] = "Power Stack";
inst_sc88_pro[ 90][ 9] = "Octave Stack";
inst_sc88_pro[ 90][10] = "Reso Stack";
inst_sc88_pro[ 90][11] = "Techno Stack";
inst_sc88_pro[ 91][ 0] = "Space Voice";
inst_sc88_pro[ 91][ 1] = "Heaven II";
inst_sc88_pro[ 91][ 2] = "SC Heaven";
inst_sc88_pro[ 91][ 8] = "Cosmic Voice";
inst_sc88_pro[ 91][ 9] = "Auh Vox";
inst_sc88_pro[ 91][10] = "AuhAuh";
inst_sc88_pro[ 91][11] = "Vocorderman";
inst_sc88_pro[ 92][ 0] = "Bowed Glass";
inst_sc88_pro[ 92][ 1] = "SoftBellPad";
inst_sc88_pro[ 92][ 2] = "JP8 Sqr Pad";
inst_sc88_pro[ 92][ 3] = "7thBelPad";
inst_sc88_pro[ 93][ 0] = "Metal Pad";
inst_sc88_pro[ 93][ 1] = "Tine Pad";
inst_sc88_pro[ 93][ 2] = "Panner Pad";
inst_sc88_pro[ 94][ 0] = "Halo Pad";
inst_sc88_pro[ 94][ 1] = "Vox Pad";
inst_sc88_pro[ 94][ 2] = "Vox Sweep";
inst_sc88_pro[ 94][ 8] = "Horror Pad";
inst_sc88_pro[ 95][ 0] = "Sweep Pad";
inst_sc88_pro[ 95][ 1] = "Polar Pad";
inst_sc88_pro[ 95][ 8] = "Converge";
inst_sc88_pro[ 95][ 9] = "Shwimmer";
inst_sc88_pro[ 95][10] = "Celestial Pd";
inst_sc88_pro[ 95][11] = "Bag Sweep";
inst_sc88_pro[ 96][ 0] = "Ice Rain";
inst_sc88_pro[ 96][ 1] = "Harmo Rain";
inst_sc88_pro[ 96][ 2] = "African wood";
inst_sc88_pro[ 96][ 3] = "Anklung Pad";
inst_sc88_pro[ 96][ 4] = "Rattle Pad";
inst_sc88_pro[ 96][ 8] = "Clavi Pad";
inst_sc88_pro[ 97][ 0] = "Soundtrack";
inst_sc88_pro[ 97][ 1] = "Ancestral";
inst_sc88_pro[ 97][ 2] = "Prologue";
inst_sc88_pro[ 97][ 3] = "Prologue 2";
inst_sc88_pro[ 97][ 4] = "Hols Strings";
inst_sc88_pro[ 97][ 8] = "Rave";
inst_sc88_pro[ 98][ 0] = "Crystal";
inst_sc88_pro[ 98][ 1] = "Syn Mallet";
inst_sc88_pro[ 98][ 2] = "Soft Crystal";
inst_sc88_pro[ 98][ 3] = "Round Glock";
inst_sc88_pro[ 98][ 4] = "Loud Glock";
inst_sc88_pro[ 98][ 5] = "GlockenChime";
inst_sc88_pro[ 98][ 6] = "Clear Bells";
inst_sc88_pro[ 98][ 7] = "ChristmasBel";
inst_sc88_pro[ 98][ 8] = "Vibra Bells";
inst_sc88_pro[ 98][ 9] = "Digi Bells";
inst_sc88_pro[ 98][10] = "Music Bell";
inst_sc88_pro[ 98][11] = "Analog Bell";
inst_sc88_pro[ 98][16] = "Choral Bells";
inst_sc88_pro[ 98][17] = "Air Bells";
inst_sc88_pro[ 98][18] = "Bell Harp";
inst_sc88_pro[ 98][19] = "Gamelimba";
inst_sc88_pro[ 98][20] = "JUNO Bell";
inst_sc88_pro[ 99][ 0] = "Atmosphere";
inst_sc88_pro[ 99][ 1] = "Warm Atmos";
inst_sc88_pro[ 99][ 2] = "Nylon Harp";
inst_sc88_pro[ 99][ 3] = "Harpvox";
inst_sc88_pro[ 99][ 4] = "HollowReleas";
inst_sc88_pro[ 99][ 5] = "Nylon+Rhodes";
inst_sc88_pro[ 99][ 6] = "Ambient Pad";
inst_sc88_pro[ 99][ 7] = "Invisible";
inst_sc88_pro[ 99][ 8] = "Pulsey Key";
inst_sc88_pro[ 99][ 9] = "Noise Piano";
inst_sc88_pro[100][ 0] = "Brightness";
inst_sc88_pro[100][ 1] = "Shining Star";
inst_sc88_pro[100][ 2] = "OB Stab";
inst_sc88_pro[100][ 8] = "Org Bell";
inst_sc88_pro[101][ 0] = "Goblin";
inst_sc88_pro[101][ 1] = "Goblinson";
inst_sc88_pro[101][ 2] = "50's Sci-Fi";
inst_sc88_pro[101][ 3] = "Abduction";
inst_sc88_pro[101][ 4] = "Auhbient";
inst_sc88_pro[101][ 5] = "LFO Pad";
inst_sc88_pro[101][ 6] = "Random Str";
inst_sc88_pro[101][ 7] = "Random Pad";
inst_sc88_pro[101][ 8] = "LowBirds Pad";
inst_sc88_pro[101][ 9] = "Falling Down";
inst_sc88_pro[101][10] = "LFO RAVE";
inst_sc88_pro[101][11] = "LFO Horror";
inst_sc88_pro[101][12] = "LFO Techno";
inst_sc88_pro[101][13] = "Alternative";
inst_sc88_pro[101][14] = "UFO FX";
inst_sc88_pro[101][15] = "Gargle Man";
inst_sc88_pro[101][16] = "Sweep FX";
inst_sc88_pro[102][ 0] = "Echo Drops";
inst_sc88_pro[102][ 1] = "Echo Bell";
inst_sc88_pro[102][ 2] = "Echo Pan";
inst_sc88_pro[102][ 3] = "Echo Pan 2";
inst_sc88_pro[102][ 4] = "Big Panner";
inst_sc88_pro[102][ 5] = "Reso Panner";
inst_sc88_pro[102][ 6] = "Water Piano";
inst_sc88_pro[102][ 8] = "Pan Sequence";
inst_sc88_pro[102][ 9] = "Aqua";
inst_sc88_pro[103][ 0] = "Star Theme";
inst_sc88_pro[103][ 1] = "Star Theme 2";
inst_sc88_pro[103][ 8] = "Dream Pad";
inst_sc88_pro[103][ 9] = "Silky Pad";
inst_sc88_pro[103][16] = "New Century";
inst_sc88_pro[103][17] = "7th Atmos.";
inst_sc88_pro[103][18] = "Galaxy Way";
inst_sc88_pro[104][ 0] = "Sitar";
inst_sc88_pro[104][ 1] = "Sitar 2";
inst_sc88_pro[104][ 2] = "Detune Sitar";
inst_sc88_pro[104][ 3] = "Sitar 3";
inst_sc88_pro[104][ 8] = "Tambra";
inst_sc88_pro[104][16] = "Tamboura";
inst_sc88_pro[105][ 0] = "Banjo";
inst_sc88_pro[105][ 1] = "Muted Banjo";
inst_sc88_pro[105][ 8] = "Rabab";
inst_sc88_pro[105][ 9] = "San Xian";
inst_sc88_pro[105][16] = "Gopichant";
inst_sc88_pro[105][24] = "Oud";
inst_sc88_pro[105][28] = "Oud+Strings";
inst_sc88_pro[105][32] = "Pi Pa";
inst_sc88_pro[106][ 0] = "Shamisen";
inst_sc88_pro[106][ 1] = "Tsugaru";
inst_sc88_pro[106][ 8] = "Syn Shamisen";
inst_sc88_pro[107][ 0] = "Koto";
inst_sc88_pro[107][ 1] = "Gu Zheng";
inst_sc88_pro[107][ 8] = "Taisho Koto";
inst_sc88_pro[107][16] = "Kanoon";
inst_sc88_pro[107][19] = "Kanoon+Choir";
inst_sc88_pro[107][24] = "Oct Harp";
inst_sc88_pro[108][ 0] = "Kalimba";
inst_sc88_pro[108][ 8] = "Sanza";
inst_sc88_pro[109][ 0] = "Bagpipe";
inst_sc88_pro[109][ 8] = "Didgeridoo";
inst_sc88_pro[110][ 0] = "Fiddle";
inst_sc88_pro[110][ 8] = "Er Hu";
inst_sc88_pro[110][ 9] = "Gao Hu";
inst_sc88_pro[111][ 0] = "Shanai";
inst_sc88_pro[111][ 1] = "Shanai 2";
inst_sc88_pro[111][ 8] = "Pungi";
inst_sc88_pro[111][16] = "Hichiriki";
inst_sc88_pro[111][24] = "Mizmar";
inst_sc88_pro[111][32] = "Suona 1";
inst_sc88_pro[111][33] = "Suona 2";
inst_sc88_pro[112][ 0] = "Tinkle Bell";
inst_sc88_pro[112][ 8] = "Bonang";
inst_sc88_pro[112][ 9] = "Gender";
inst_sc88_pro[112][10] = "Gamelan Gong";
inst_sc88_pro[112][11] = "St.Gamelan";
inst_sc88_pro[112][12] = "Jang Gu";
inst_sc88_pro[112][16] = "RAMA Cymbal";
inst_sc88_pro[113][ 0] = "Agogo";
inst_sc88_pro[113][ 8] = "Atarigane";
inst_sc88_pro[113][16] = "Tambourine";
inst_sc88_pro[114][ 0] = "Steel Drums";
inst_sc88_pro[114][ 1] = "Island Mlt";
inst_sc88_pro[115][ 0] = "Woodblock";
inst_sc88_pro[115][ 8] = "Castanets";
inst_sc88_pro[115][16] = "Angklung";
inst_sc88_pro[115][17] = "Angkl Rhythm";
inst_sc88_pro[115][24] = "Finger Snaps";
inst_sc88_pro[115][32] = "909 HandClap";
inst_sc88_pro[116][ 0] = "Taiko";
inst_sc88_pro[116][ 1] = "Small Taiko";
inst_sc88_pro[116][ 8] = "Concert BD";
inst_sc88_pro[116][16] = "Jungle BD";
inst_sc88_pro[116][17] = "Techno BD";
inst_sc88_pro[116][18] = "Bounce";
inst_sc88_pro[117][ 0] = "Melo. Tom 1";
inst_sc88_pro[117][ 1] = "Real Tom";
inst_sc88_pro[117][ 8] = "Melo. Tom 2";
inst_sc88_pro[117][ 9] = "Rock Tom";
inst_sc88_pro[117][16] = "Rash SD";
inst_sc88_pro[117][17] = "House SD";
inst_sc88_pro[117][18] = "Jungle SD";
inst_sc88_pro[117][19] = "909 SD";
inst_sc88_pro[118][ 0] = "Synth Drum";
inst_sc88_pro[118][ 8] = "808 Tom";
inst_sc88_pro[118][ 9] = "Elec Perc";
inst_sc88_pro[118][10] = "Sine Perc.";
inst_sc88_pro[118][11] = "606 Tom";
inst_sc88_pro[118][12] = "909 Tom";
inst_sc88_pro[119][ 0] = "Reverse Cym.";
inst_sc88_pro[119][ 1] = "Reverse Cym2";
inst_sc88_pro[119][ 2] = "Reverse Cym3";
inst_sc88_pro[119][ 8] = "Rev.Snare 1";
inst_sc88_pro[119][ 9] = "Rev.Snare 2";
inst_sc88_pro[119][16] = "Rev.Kick 1";
inst_sc88_pro[119][17] = "Rev.ConBD";
inst_sc88_pro[119][24] = "Rev.Tom 1";
inst_sc88_pro[119][25] = "Rev.Tom 2";
inst_sc88_pro[120][ 0] = "Gt.FretNoise";
inst_sc88_pro[120][ 1] = "Gt.Cut Noise";
inst_sc88_pro[120][ 2] = "String Slap";
inst_sc88_pro[120][ 3] = "Gt.CutNoise2";
inst_sc88_pro[120][ 4] = "Dist.CutNoiz";
inst_sc88_pro[120][ 5] = "Bass Slide";
inst_sc88_pro[120][ 6] = "Pick Scrape";
inst_sc88_pro[120][ 8] = "Gt. FX Menu";
inst_sc88_pro[120][ 9] = "Bartok Pizz.";
inst_sc88_pro[120][10] = "Guitar Slap";
inst_sc88_pro[120][11] = "Chord Stroke";
inst_sc88_pro[120][12] = "Biwa Stroke";
inst_sc88_pro[120][13] = "Biwa Tremolo";
inst_sc88_pro[121][ 0] = "Breath Noise";
inst_sc88_pro[121][ 1] = "Fl.Key Click";
inst_sc88_pro[122][ 0] = "Seashore";
inst_sc88_pro[122][ 1] = "Rain";
inst_sc88_pro[122][ 2] = "Thunder";
inst_sc88_pro[122][ 3] = "Wind";
inst_sc88_pro[122][ 4] = "Stream";
inst_sc88_pro[122][ 5] = "Bubble";
inst_sc88_pro[122][ 6] = "Wind 2";
inst_sc88_pro[122][16] = "Pink Noise";
inst_sc88_pro[122][17] = "White Noise";
inst_sc88_pro[123][ 0] = "Bird";
inst_sc88_pro[123][ 1] = "Dog";
inst_sc88_pro[123][ 2] = "Horse-Gallop";
inst_sc88_pro[123][ 3] = "Bird 2";
inst_sc88_pro[123][ 4] = "Kitty";
inst_sc88_pro[123][ 5] = "Growl";
inst_sc88_pro[124][ 0] = "Telephone 1";
inst_sc88_pro[124][ 1] = "Telephone 2";
inst_sc88_pro[124][ 2] = "DoorCreaking";
inst_sc88_pro[124][ 3] = "Door";
inst_sc88_pro[124][ 4] = "Scratch";
inst_sc88_pro[124][ 5] = "Wind Chimes";
inst_sc88_pro[124][ 7] = "Scratch 2";
inst_sc88_pro[124][ 8] = "ScratchKey";
inst_sc88_pro[124][ 9] = "TapeRewind";
inst_sc88_pro[124][10] = "Phono Noise";
inst_sc88_pro[124][11] = "MC-500 Beep";
inst_sc88_pro[125][ 0] = "Helicopter";
inst_sc88_pro[125][ 1] = "Car-Engine";
inst_sc88_pro[125][ 2] = "Car-Stop";
inst_sc88_pro[125][ 3] = "Car-Pass";
inst_sc88_pro[125][ 4] = "Car-Crash";
inst_sc88_pro[125][ 5] = "Siren";
inst_sc88_pro[125][ 6] = "Train";
inst_sc88_pro[125][ 7] = "Jetplane";
inst_sc88_pro[125][ 8] = "Starship";
inst_sc88_pro[125][ 9] = "Burst Noise";
inst_sc88_pro[125][10] = "Calculating";
inst_sc88_pro[125][11] = "Perc. Bang";
inst_sc88_pro[126][ 0] = "Applause";
inst_sc88_pro[126][ 1] = "Laughing";
inst_sc88_pro[126][ 2] = "Screaming";
inst_sc88_pro[126][ 3] = "Punch";
inst_sc88_pro[126][ 4] = "Heart Beat";
inst_sc88_pro[126][ 5] = "Footsteps";
inst_sc88_pro[126][ 6] = "Applause 2";
inst_sc88_pro[126][ 7] = "Small Club";
inst_sc88_pro[126][ 8] = "ApplauseWave";
inst_sc88_pro[126][16] = "Voice One";
inst_sc88_pro[126][17] = "Voice Two";
inst_sc88_pro[126][18] = "Voice Three";
inst_sc88_pro[126][19] = "Voice Tah";
inst_sc88_pro[126][20] = "Voice Whey";
inst_sc88_pro[127][ 0] = "Gun Shot";
inst_sc88_pro[127][ 1] = "Machine Gun";
inst_sc88_pro[127][ 2] = "Lasergun";
inst_sc88_pro[127][ 3] = "Explosion";
inst_sc88_pro[127][ 4] = "Eruption";
inst_sc88_pro[127][ 5] = "Big Shot";

/*
 * 88 MAP
 */
inst_sc88_88[  1-1][ 0] = "Piano 1";
inst_sc88_88[  1-1][ 8] = "Piano 1w";
inst_sc88_88[  1-1][16] = "Piano 1d";
inst_sc88_88[  2-1][ 0] = "Piano 2";
inst_sc88_88[  2-1][ 8] = "Piano 2w";
inst_sc88_88[  3-1][ 0] = "Piano 3";
inst_sc88_88[  3-1][ 1] = "EG+Rhodes 1";
inst_sc88_88[  3-1][ 2] = "EG+Rhodes 2";
inst_sc88_88[  3-1][ 8] = "Piano 3w";
inst_sc88_88[  4-1][ 0] = "Honky-tonk";
inst_sc88_88[  4-1][ 8] = "Old Upright";
inst_sc88_88[  5-1][ 0] = "E.Piano 1";
inst_sc88_88[  5-1][ 8] = "St.Soft EP";
inst_sc88_88[  5-1][16] = "FM+SA EP";
inst_sc88_88[  5-1][24] = "60's E.Piano";
inst_sc88_88[  5-1][25] = "Hard Rhodes";
inst_sc88_88[  5-1][26] = "MellowRhodes";
inst_sc88_88[  6-1][ 0] = "E.Piano 2";
inst_sc88_88[  6-1][ 8] = "Detuned EP 2";
inst_sc88_88[  6-1][16] = "St.FM EP";
inst_sc88_88[  6-1][24] = "Hard FM EP";
inst_sc88_88[  7-1][ 0] = "Harpsichord";
inst_sc88_88[  7-1][ 8] = "Coupled Hps.";
inst_sc88_88[  7-1][16] = "Harpsi.w";
inst_sc88_88[  7-1][24] = "Harpsi.o";
inst_sc88_88[  8-1][ 0] = "Clav.";
inst_sc88_88[  9-1][ 0] = "Celesta";
inst_sc88_88[ 10-1][ 0] = "Glockenspiel";
inst_sc88_88[ 11-1][ 0] = "Music Box";
inst_sc88_88[ 12-1][ 0] = "Vibraphone";
inst_sc88_88[ 12-1][ 1] = "Hard Vibe";
inst_sc88_88[ 12-1][ 8] = "Vib.w";
inst_sc88_88[ 13-1][ 0] = "Marimba";
inst_sc88_88[ 13-1][ 8] = "Marimba w";
inst_sc88_88[ 13-1][16] = "Barafon";
inst_sc88_88[ 13-1][17] = "Barafon 2";
inst_sc88_88[ 13-1][24] = "Log drum";
inst_sc88_88[ 14-1][ 0] = "Xylophone";
inst_sc88_88[ 15-1][ 0] = "Tubular-bell";
inst_sc88_88[ 15-1][ 8] = "Church Bell";
inst_sc88_88[ 15-1][ 9] = "Carillon";
inst_sc88_88[ 16-1][ 0] = "Santur";
inst_sc88_88[ 16-1][ 1] = "Santur 2";
inst_sc88_88[ 16-1][ 8] = "Cimbalom";
inst_sc88_88[ 17-1][ 0] = "Organ 1";
inst_sc88_88[ 17-1][ 1] = "Organ 101";
inst_sc88_88[ 17-1][ 8] = "Detuned Or.1";
inst_sc88_88[ 17-1][ 9] = "Organ 109";
inst_sc88_88[ 17-1][16] = "60's Organ 1";
inst_sc88_88[ 17-1][17] = "60's Organ 2";
inst_sc88_88[ 17-1][18] = "60's Organ 3";
inst_sc88_88[ 17-1][24] = "Cheese Organ";
inst_sc88_88[ 17-1][32] = "Organ 4";
inst_sc88_88[ 17-1][33] = "Even Bar";
inst_sc88_88[ 17-1][40] = "Organ Bass";
inst_sc88_88[ 18-1][ 0] = "Organ 2";
inst_sc88_88[ 18-1][ 1] = "Organ 201";
inst_sc88_88[ 18-1][ 8] = "Detuned Or.2";
inst_sc88_88[ 18-1][32] = "Organ 5";
inst_sc88_88[ 19-1][ 0] = "Organ 3";
inst_sc88_88[ 19-1][ 8] = "Rotary Org.";
inst_sc88_88[ 19-1][16] = "Rotary Org.S";
inst_sc88_88[ 19-1][24] = "Rotary Org.F";
inst_sc88_88[ 20-1][ 0] = "Church Org.1";
inst_sc88_88[ 20-1][ 8] = "Church Org.2";
inst_sc88_88[ 20-1][16] = "Church Org.3";
inst_sc88_88[ 20-1][24] = "Organ Flute";
inst_sc88_88[ 20-1][32] = "Trem.Flute";
inst_sc88_88[ 21-1][ 0] = "Reed Organ";
inst_sc88_88[ 22-1][ 0] = "Accordion Fr";
inst_sc88_88[ 22-1][ 8] = "Accordion It";
inst_sc88_88[ 23-1][ 0] = "Harmonica";
inst_sc88_88[ 23-1][ 1] = "Harmonica 2";
inst_sc88_88[ 24-1][ 0] = "Bandoneon";
inst_sc88_88[ 25-1][ 0] = "Nylon-str.Gt";
inst_sc88_88[ 25-1][ 8] = "Ukulele";
inst_sc88_88[ 25-1][16] = "Nylon Gt.o";
inst_sc88_88[ 25-1][24] = "Velo Harmnix";
inst_sc88_88[ 25-1][32] = "Nylon Gt.2";
inst_sc88_88[ 25-1][40] = "Lequint Gt.";
inst_sc88_88[ 26-1][ 0] = "Steel-str.Gt";
inst_sc88_88[ 26-1][ 8] = "12-str.Gt";
inst_sc88_88[ 26-1][ 9] = "Nylon+Steel";
inst_sc88_88[ 26-1][16] = "Mandolin";
inst_sc88_88[ 26-1][32] = "Steel Gt.2";
inst_sc88_88[ 27-1][ 0] = "Jazz Gt.";
inst_sc88_88[ 27-1][ 1] = "Mellow Gt.";
inst_sc88_88[ 27-1][ 8] = "Pedal Steel";
inst_sc88_88[ 28-1][ 0] = "Clean Gt.";
inst_sc88_88[ 28-1][ 8] = "Chorus Gt.";
inst_sc88_88[ 29-1][ 0] = "Muted Gt.";
inst_sc88_88[ 29-1][ 1] = "Muted Dis.Gt";
inst_sc88_88[ 29-1][ 8] = "Funk Pop";
inst_sc88_88[ 29-1][16] = "Funk Gt.2";
inst_sc88_88[ 30-1][ 0] = "Overdrive Gt";
inst_sc88_88[ 31-1][ 0] = "DistortionGt";
inst_sc88_88[ 31-1][ 1] = "Dist. Gt2";
inst_sc88_88[ 31-1][ 2] = "Dazed Guitar";
inst_sc88_88[ 31-1][ 8] = "Feedback Gt.";
inst_sc88_88[ 31-1][ 9] = "Feedback Gt2";
inst_sc88_88[ 31-1][16] = "Power Guitar";
inst_sc88_88[ 31-1][17] = "Power Gt.2";
inst_sc88_88[ 31-1][18] = "5th Dist.";
inst_sc88_88[ 31-1][24] = "Rock Rhythm";
inst_sc88_88[ 31-1][25] = "Rock Rhythm2";
inst_sc88_88[ 32-1][ 0] = "Gt.Harmonics";
inst_sc88_88[ 32-1][ 8] = "Gt. Feedback";
inst_sc88_88[ 32-1][16] = "Ac.Gt.Harmnx";
inst_sc88_88[ 33-1][ 0] = "Acoustic Bs.";
inst_sc88_88[ 34-1][ 0] = "Fingered Bs.";
inst_sc88_88[ 34-1][ 1] = "Fingered Bs2";
inst_sc88_88[ 34-1][ 2] = "Jazz Bass";
inst_sc88_88[ 35-1][ 0] = "Picked Bass";
inst_sc88_88[ 35-1][ 8] = "Mute PickBs.";
inst_sc88_88[ 36-1][ 0] = "Fretless Bs.";
inst_sc88_88[ 36-1][ 1] = "Fretless Bs2";
inst_sc88_88[ 36-1][ 2] = "Fretless Bs3";
inst_sc88_88[ 36-1][ 3] = "Fretless Bs4";
inst_sc88_88[ 36-1][ 4] = "Syn Fretless";
inst_sc88_88[ 36-1][ 5] = "Mr.Smooth";
inst_sc88_88[ 37-1][ 0] = "Slap Bass 1";
inst_sc88_88[ 37-1][ 8] = "Reso Slap";
inst_sc88_88[ 38-1][ 0] = "Slap Bass 2";
inst_sc88_88[ 39-1][ 0] = "Synth Bass 1";
inst_sc88_88[ 39-1][ 1] = "SynthBass101";
inst_sc88_88[ 39-1][ 8] = "Acid Bass";
inst_sc88_88[ 39-1][ 9] = "TB303 Bass";
inst_sc88_88[ 39-1][10] = "Tekno Bass";
inst_sc88_88[ 39-1][16] = "Reso SH Bass";
inst_sc88_88[ 40-1][ 0] = "Synth Bass 2";
inst_sc88_88[ 40-1][ 1] = "SynthBass201";
inst_sc88_88[ 40-1][ 2] = "Modular Bass";
inst_sc88_88[ 40-1][ 3] = "Seq Bass";
inst_sc88_88[ 40-1][ 8] = "Beef FM Bass";
inst_sc88_88[ 40-1][ 9] = "X Wire Bass";
inst_sc88_88[ 40-1][16] = "Rubber Bass";
inst_sc88_88[ 40-1][17] = "SH101 Bass 1";
inst_sc88_88[ 40-1][18] = "SH101 Bass 2";
inst_sc88_88[ 40-1][19] = "Smooth Bass";
inst_sc88_88[ 41-1][ 0] = "Violin";
inst_sc88_88[ 41-1][ 8] = "Slow Violin";
inst_sc88_88[ 42-1][ 0] = "Viola";
inst_sc88_88[ 43-1][ 0] = "Cello";
inst_sc88_88[ 44-1][ 0] = "Contrabass";
inst_sc88_88[ 45-1][ 0] = "Tremolo Str";
inst_sc88_88[ 45-1][ 8] = "Slow Tremolo";
inst_sc88_88[ 45-1][ 9] = "Suspense Str";
inst_sc88_88[ 46-1][ 0] = "PizzicatoStr";
inst_sc88_88[ 47-1][ 0] = "Harp";
inst_sc88_88[ 48-1][ 0] = "Timpani";
inst_sc88_88[ 49-1][ 0] = "Strings";
inst_sc88_88[ 49-1][ 1] = "Strings 2";
inst_sc88_88[ 49-1][ 8] = "Orchestra";
inst_sc88_88[ 49-1][ 9] = "Orchestra 2";
inst_sc88_88[ 49-1][10] = "Tremolo Orch";
inst_sc88_88[ 49-1][11] = "Choir Str.";
inst_sc88_88[ 49-1][16] = "St.Strings";
inst_sc88_88[ 49-1][24] = "Velo Strings";
inst_sc88_88[ 50-1][ 0] = "Slow Strings";
inst_sc88_88[ 50-1][ 1] = "SlowStrings2";
inst_sc88_88[ 50-1][ 8] = "Legato Str.";
inst_sc88_88[ 50-1][ 9] = "Warm Strings";
inst_sc88_88[ 50-1][10] = "St.Slow Str.";
inst_sc88_88[ 51-1][ 0] = "Syn.Strings1";
inst_sc88_88[ 51-1][ 1] = "OB Strings";
inst_sc88_88[ 51-1][ 8] = "Syn.Strings3";
inst_sc88_88[ 52-1][ 0] = "Syn.Strings2";
inst_sc88_88[ 53-1][ 0] = "Choir Aahs";
inst_sc88_88[ 53-1][ 8] = "St.Choir";
inst_sc88_88[ 53-1][ 9] = "Mello Choir";
inst_sc88_88[ 53-1][32] = "Choir Aahs 2";
inst_sc88_88[ 54-1][ 0] = "Voice Oohs";
inst_sc88_88[ 55-1][ 0] = "SynVox";
inst_sc88_88[ 55-1][ 8] = "Syn.Voice";
inst_sc88_88[ 56-1][ 0] = "OrchestraHit";
inst_sc88_88[ 56-1][ 8] = "Impact Hit";
inst_sc88_88[ 56-1][ 9] = "Philly Hit";
inst_sc88_88[ 56-1][10] = "Double Hit";
inst_sc88_88[ 56-1][16] = "Lo Fi Rave";
inst_sc88_88[ 57-1][ 0] = "Trumpet";
inst_sc88_88[ 57-1][ 1] = "Trumpet 2";
inst_sc88_88[ 57-1][ 8] = "Flugel Horn";
inst_sc88_88[ 57-1][24] = "Bright Tp.";
inst_sc88_88[ 57-1][25] = "Warm Tp.";
inst_sc88_88[ 58-1][ 0] = "Trombone";
inst_sc88_88[ 58-1][ 1] = "Trombone 2";
inst_sc88_88[ 59-1][ 0] = "Tuba";
inst_sc88_88[ 59-1][ 1] = "Tuba 2";
inst_sc88_88[ 60-1][ 0] = "MutedTrumpet";
inst_sc88_88[ 61-1][ 0] = "French Horns";
inst_sc88_88[ 61-1][ 1] = "Fr.Horn 2";
inst_sc88_88[ 61-1][ 8] = "Fr.Horn Solo";
inst_sc88_88[ 61-1][16] = "Horn Orch";
inst_sc88_88[ 62-1][ 0] = "Brass 1";
inst_sc88_88[ 62-1][ 8] = "Brass 2";
inst_sc88_88[ 62-1][16] = "Brass Fall";
inst_sc88_88[ 63-1][ 0] = "Synth Brass1";
inst_sc88_88[ 63-1][ 1] = "Poly Brass";
inst_sc88_88[ 63-1][ 8] = "Synth Brass3";
inst_sc88_88[ 63-1][ 9] = "Quack Brass";
inst_sc88_88[ 63-1][16] = "Octave Brass";
inst_sc88_88[ 64-1][ 0] = "Synth Brass2";
inst_sc88_88[ 64-1][ 1] = "Soft Brass";
inst_sc88_88[ 64-1][ 8] = "Synth Brass4";
inst_sc88_88[ 64-1][16] = "Velo Brass 1";
inst_sc88_88[ 64-1][17] = "Velo Brass 2";
inst_sc88_88[ 65-1][ 0] = "Soprano Sax";
inst_sc88_88[ 66-1][ 0] = "Alto Sax";
inst_sc88_88[ 66-1][ 8] = "Hyper Alto";
inst_sc88_88[ 67-1][ 0] = "Tenor Sax";
inst_sc88_88[ 67-1][ 8] = "BreathyTenor";
inst_sc88_88[ 68-1][ 0] = "Baritone Sax";
inst_sc88_88[ 69-1][ 0] = "Oboe";
inst_sc88_88[ 70-1][ 0] = "English Horn";
inst_sc88_88[ 71-1][ 0] = "Bassoon";
inst_sc88_88[ 72-1][ 0] = "Clarinet";
inst_sc88_88[ 72-1][ 8] = "Bs Clarinet";
inst_sc88_88[ 73-1][ 0] = "Piccolo";
inst_sc88_88[ 74-1][ 0] = "Flute";
inst_sc88_88[ 75-1][ 0] = "Recorder";
inst_sc88_88[ 76-1][ 0] = "Pan Flute";
inst_sc88_88[ 76-1][ 8] = "Kawala";
inst_sc88_88[ 77-1][ 0] = "Bottle Blow";
inst_sc88_88[ 78-1][ 0] = "Shakuhachi";
inst_sc88_88[ 79-1][ 0] = "Whistle";
inst_sc88_88[ 80-1][ 0] = "Ocarina";
inst_sc88_88[ 81-1][ 0] = "Square Wave";
inst_sc88_88[ 81-1][ 1] = "Square";
inst_sc88_88[ 81-1][ 2] = "Hollow Mini";
inst_sc88_88[ 81-1][ 3] = "Mellow FM";
inst_sc88_88[ 81-1][ 4] = "CC Solo";
inst_sc88_88[ 81-1][ 5] = "Shmoog";
inst_sc88_88[ 81-1][ 6] = "LM Square";
inst_sc88_88[ 81-1][ 8] = "Sine Wave";
inst_sc88_88[ 82-1][ 0] = "Saw Wave";
inst_sc88_88[ 82-1][ 1] = "Saw";
inst_sc88_88[ 82-1][ 2] = "Pulse Saw";
inst_sc88_88[ 82-1][ 3] = "Feline GR";
inst_sc88_88[ 82-1][ 4] = "Big Lead";
inst_sc88_88[ 82-1][ 5] = "Velo Lead";
inst_sc88_88[ 82-1][ 6] = "GR-300";
inst_sc88_88[ 82-1][ 7] = "LA Saw";
inst_sc88_88[ 82-1][ 8] = "Doctor Solo";
inst_sc88_88[ 82-1][16] = "Waspy Synth";
inst_sc88_88[ 83-1][ 0] = "Syn.Calliope";
inst_sc88_88[ 83-1][ 1] = "Vent Synth";
inst_sc88_88[ 83-1][ 2] = "Pure PanLead";
inst_sc88_88[ 84-1][ 0] = "Chiffer Lead";
inst_sc88_88[ 85-1][ 0] = "Charang";
inst_sc88_88[ 85-1][ 8] = "Dist.Lead";
inst_sc88_88[ 86-1][ 0] = "Solo Vox";
inst_sc88_88[ 87-1][ 0] = "5th Saw Wave";
inst_sc88_88[ 87-1][ 1] = "Big Fives";
inst_sc88_88[ 88-1][ 0] = "Bass & Lead";
inst_sc88_88[ 88-1][ 1] = "Big & Raw";
inst_sc88_88[ 88-1][ 2] = "Fat & Perky";
inst_sc88_88[ 89-1][ 0] = "Fantasia";
inst_sc88_88[ 89-1][ 1] = "Fantasia 2";
inst_sc88_88[ 90-1][ 0] = "Warm Pad";
inst_sc88_88[ 90-1][ 1] = "Thick Pad";
inst_sc88_88[ 90-1][ 2] = "Horn Pad";
inst_sc88_88[ 90-1][ 3] = "Rotary Strng";
inst_sc88_88[ 90-1][ 4] = "Soft Pad";
inst_sc88_88[ 91-1][ 0] = "Polysynth";
inst_sc88_88[ 91-1][ 1] = "80's PolySyn";
inst_sc88_88[ 92-1][ 0] = "Space Voice";
inst_sc88_88[ 92-1][ 1] = "Heaven II";
inst_sc88_88[ 93-1][ 0] = "Bowed Glass";
inst_sc88_88[ 94-1][ 0] = "Metal Pad";
inst_sc88_88[ 94-1][ 1] = "Tine Pad";
inst_sc88_88[ 94-1][ 2] = "Panner Pad";
inst_sc88_88[ 95-1][ 0] = "Halo Pad";
inst_sc88_88[ 96-1][ 0] = "Sweep Pad";
inst_sc88_88[ 96-1][ 1] = "Polar Pad";
inst_sc88_88[ 96-1][ 8] = "Converge";
inst_sc88_88[ 96-1][ 9] = "Shwimmer";
inst_sc88_88[ 96-1][10] = "Celestial Pd";
inst_sc88_88[ 97-1][ 0] = "Ice Rain";
inst_sc88_88[ 97-1][ 1] = "Harmo Rain";
inst_sc88_88[ 97-1][ 2] = "African wood";
inst_sc88_88[ 97-1][ 8] = "Clavi Pad";
inst_sc88_88[ 98-1][ 0] = "Soundtrack";
inst_sc88_88[ 98-1][ 1] = "Ancestral";
inst_sc88_88[ 98-1][ 2] = "Prologue";
inst_sc88_88[ 98-1][ 8] = "Rave";
inst_sc88_88[ 99-1][ 0] = "Crystal";
inst_sc88_88[ 99-1][ 1] = "Syn Mallet";
inst_sc88_88[ 99-1][ 2] = "Soft Crystal";
inst_sc88_88[ 99-1][ 3] = "Round Glock";
inst_sc88_88[ 99-1][ 4] = "Loud Glock";
inst_sc88_88[ 99-1][ 5] = "GlockenChime";
inst_sc88_88[ 99-1][ 6] = "Clear Bells";
inst_sc88_88[ 99-1][ 7] = "ChristmasBel";
inst_sc88_88[ 99-1][ 8] = "Vibra Bells";
inst_sc88_88[ 99-1][ 9] = "Digi Bells";
inst_sc88_88[ 99-1][16] = "Choral Bells";
inst_sc88_88[ 99-1][17] = "Air Bells";
inst_sc88_88[ 99-1][18] = "Bell Harp";
inst_sc88_88[ 99-1][19] = "Gamelimba";
inst_sc88_88[100-1][ 0] = "Atmosphere";
inst_sc88_88[100-1][ 1] = "Warm Atmos";
inst_sc88_88[100-1][ 2] = "Nylon Harp";
inst_sc88_88[100-1][ 3] = "Harpvox";
inst_sc88_88[100-1][ 4] = "HollowReleas";
inst_sc88_88[100-1][ 5] = "Nylon+Rhodes";
inst_sc88_88[100-1][ 6] = "Ambient Pad";
inst_sc88_88[101-1][ 0] = "Brightness";
inst_sc88_88[102-1][ 0] = "Goblin";
inst_sc88_88[102-1][ 1] = "Goblinson";
inst_sc88_88[102-1][ 2] = "50's Sci-Fi";
inst_sc88_88[103-1][ 0] = "Echo Drops";
inst_sc88_88[103-1][ 1] = "Echo Bell";
inst_sc88_88[103-1][ 2] = "Echo Pan";
inst_sc88_88[103-1][ 3] = "Echo Pan 2";
inst_sc88_88[103-1][ 4] = "Big Panner";
inst_sc88_88[103-1][ 5] = "Reso Panner";
inst_sc88_88[103-1][ 6] = "Water Piano";
inst_sc88_88[104-1][ 0] = "Star Theme";
inst_sc88_88[104-1][ 1] = "Star Theme 2";
inst_sc88_88[105-1][ 0] = "Sitar";
inst_sc88_88[105-1][ 1] = "Sitar 2";
inst_sc88_88[105-1][ 2] = "Detune Sitar";
inst_sc88_88[105-1][ 8] = "Tambra";
inst_sc88_88[105-1][16] = "Tamboura";
inst_sc88_88[106-1][ 0] = "Banjo";
inst_sc88_88[106-1][ 1] = "Muted Banjo";
inst_sc88_88[106-1][ 8] = "Rabab";
inst_sc88_88[106-1][16] = "Gopichant";
inst_sc88_88[106-1][24] = "Oud";
inst_sc88_88[107-1][ 0] = "Shamisen";
inst_sc88_88[107-1][ 1] = "Tsugaru";
inst_sc88_88[108-1][ 0] = "Koto";
inst_sc88_88[108-1][ 8] = "Taisho Koto";
inst_sc88_88[108-1][16] = "Kanoon";
inst_sc88_88[109-1][ 0] = "Kalimba";
inst_sc88_88[110-1][ 0] = "Bagpipe";
inst_sc88_88[111-1][ 0] = "Fiddle";
inst_sc88_88[112-1][ 0] = "Shanai";
inst_sc88_88[112-1][ 1] = "Shanai 2";
inst_sc88_88[112-1][ 8] = "Pungi";
inst_sc88_88[112-1][16] = "Hichiriki";
inst_sc88_88[113-1][ 0] = "Tinkle Bell";
inst_sc88_88[113-1][ 8] = "Bonang";
inst_sc88_88[113-1][ 9] = "Gender";
inst_sc88_88[113-1][10] = "Gamelan Gong";
inst_sc88_88[113-1][11] = "St.Gamelan";
inst_sc88_88[113-1][16] = "RAMA Cymbal";
inst_sc88_88[114-1][ 0] = "Agogo";
inst_sc88_88[114-1][ 8] = "Atarigane";
inst_sc88_88[115-1][ 0] = "Steel Drums";
inst_sc88_88[116-1][ 0] = "Woodblock";
inst_sc88_88[116-1][ 8] = "Castanets";
inst_sc88_88[117-1][ 0] = "Taiko";
inst_sc88_88[117-1][ 8] = "Concert BD";
inst_sc88_88[118-1][ 0] = "Melo. Tom 1";
inst_sc88_88[118-1][ 1] = "Real Tom";
inst_sc88_88[118-1][ 8] = "Melo. Tom 2";
inst_sc88_88[118-1][ 9] = "Rock Tom";
inst_sc88_88[119-1][ 0] = "Synth Drum";
inst_sc88_88[119-1][ 8] = "808 Tom";
inst_sc88_88[119-1][ 9] = "Elec Perc";
inst_sc88_88[120-1][ 0] = "Reverse Cym.";
inst_sc88_88[120-1][ 1] = "Reverse Cym2";
inst_sc88_88[120-1][ 8] = "Rev.Snare 1";
inst_sc88_88[120-1][ 9] = "Rev.Snare 2";
inst_sc88_88[120-1][16] = "Rev.Kick 1";
inst_sc88_88[120-1][17] = "Rev.ConBD";
inst_sc88_88[120-1][24] = "Rev.Tom 1";
inst_sc88_88[120-1][25] = "Rev.Tom 2";
inst_sc88_88[121-1][ 0] = "Gt.FretNoise";
inst_sc88_88[121-1][ 1] = "Gt.Cut Noise";
inst_sc88_88[121-1][ 2] = "String Slap";
inst_sc88_88[121-1][ 3] = "Gt.CutNoise2";
inst_sc88_88[121-1][ 4] = "Dist.CutNoiz";
inst_sc88_88[121-1][ 5] = "Bass Slide";
inst_sc88_88[121-1][ 6] = "Pick Scrape";
inst_sc88_88[122-1][ 0] = "Breath Noise";
inst_sc88_88[122-1][ 1] = "Fl.Key Click";
inst_sc88_88[123-1][ 0] = "Seashore";
inst_sc88_88[123-1][ 1] = "Rain";
inst_sc88_88[123-1][ 2] = "Thunder";
inst_sc88_88[123-1][ 3] = "Wind";
inst_sc88_88[123-1][ 4] = "Stream";
inst_sc88_88[123-1][ 5] = "Bubble";
inst_sc88_88[124-1][ 0] = "Bird";
inst_sc88_88[124-1][ 1] = "Dog";
inst_sc88_88[124-1][ 2] = "Horse-Gallop";
inst_sc88_88[124-1][ 3] = "Bird 2";
inst_sc88_88[124-1][ 4] = "Kitty";
inst_sc88_88[124-1][ 5] = "Growl";
inst_sc88_88[125-1][ 0] = "Telephone 1";
inst_sc88_88[125-1][ 1] = "Telephone 2";
inst_sc88_88[125-1][ 2] = "DoorCreaking";
inst_sc88_88[125-1][ 3] = "Door";
inst_sc88_88[125-1][ 4] = "Scratch";
inst_sc88_88[125-1][ 5] = "Wind Chimes";
inst_sc88_88[125-1][ 7] = "Scratch 2";
inst_sc88_88[126-1][ 0] = "Helicopter";
inst_sc88_88[126-1][ 1] = "Car-Engine";
inst_sc88_88[126-1][ 2] = "Car-Stop";
inst_sc88_88[126-1][ 3] = "Car-Pass";
inst_sc88_88[126-1][ 4] = "Car-Crash";
inst_sc88_88[126-1][ 5] = "Siren";
inst_sc88_88[126-1][ 6] = "Train";
inst_sc88_88[126-1][ 7] = "Jetplane";
inst_sc88_88[126-1][ 8] = "Starship";
inst_sc88_88[126-1][ 9] = "Burst Noise";
inst_sc88_88[127-1][ 0] = "Applause";
inst_sc88_88[127-1][ 1] = "Laughing";
inst_sc88_88[127-1][ 2] = "Screaming";
inst_sc88_88[127-1][ 3] = "Punch";
inst_sc88_88[127-1][ 4] = "Heart Beat";
inst_sc88_88[127-1][ 5] = "Footsteps";
inst_sc88_88[127-1][ 6] = "Applause 2";
inst_sc88_88[128-1][ 0] = "Gun Shot";
inst_sc88_88[128-1][ 1] = "Machine Gun";
inst_sc88_88[128-1][ 2] = "Lasergun";
inst_sc88_88[128-1][ 3] = "Explosion";

/*
 * 55 MAP
 */
inst_sc88_55[  0][  0] = "Piano 1";
inst_sc88_55[  0][  8] = "Piano 1w";
inst_sc88_55[  0][ 16] = "Piano 1d";
inst_sc88_55[  0][126] = "Piano 2";
inst_sc88_55[  0][127] = "Acou Piano1";
inst_sc88_55[  1][  0] = "Piano 2";
inst_sc88_55[  1][  8] = "Piano 2w";
inst_sc88_55[  1][126] = "Piano 2";
inst_sc88_55[  1][127] = "Acou Piano2";
inst_sc88_55[  2][  0] = "Piano 3";
inst_sc88_55[  2][  8] = "Piano 3w";
inst_sc88_55[  2][126] = "Piano 2";
inst_sc88_55[  2][127] = "Acou Piano3";
inst_sc88_55[  3][  0] = "Honky-tonk";
inst_sc88_55[  3][  8] = "HonkyTonk w";
inst_sc88_55[  3][126] = "Honky-tonk";
inst_sc88_55[  3][127] = "Elec Piano1";
inst_sc88_55[  4][  0] = "E.Piano 1";
inst_sc88_55[  4][  8] = "Detuned EP1";
inst_sc88_55[  4][ 16] = "E.Piano 1v";
inst_sc88_55[  4][ 24] = "60s E.Piano";
inst_sc88_55[  4][126] = "Piano 1";
inst_sc88_55[  4][127] = "Elec Piano2";
inst_sc88_55[  5][  0] = "E.Piano 2";
inst_sc88_55[  5][  8] = "Detuned EP2";
inst_sc88_55[  5][ 16] = "E.Piano 2v";
inst_sc88_55[  5][126] = "Piano 2";
inst_sc88_55[  5][127] = "Elec Piano3";
inst_sc88_55[  6][  0] = "Harpsichord";
inst_sc88_55[  6][  8] = "Coupled Hps";
inst_sc88_55[  6][ 16] = "Harpsi.w";
inst_sc88_55[  6][ 24] = "Harpsi.o";
inst_sc88_55[  6][126] = "Piano 2";
inst_sc88_55[  6][127] = "Elec Piano4";
inst_sc88_55[  7][  0] = "Clav.";
inst_sc88_55[  7][126] = "E.Piano 1";
inst_sc88_55[  7][127] = "Honkytonk";
inst_sc88_55[  8][  0] = "Celesta";
inst_sc88_55[  8][126] = "Detuned EP1";
inst_sc88_55[  8][127] = "Elec Org 1";
inst_sc88_55[  9][  0] = "Glockenspl";
inst_sc88_55[  9][126] = "E.Piano 2";
inst_sc88_55[  9][127] = "Elec Org 2";
inst_sc88_55[ 10][  0] = "Music Box";
inst_sc88_55[ 10][126] = "Steel Gt.";
inst_sc88_55[ 10][127] = "Elec Org 3";
inst_sc88_55[ 11][  0] = "Vibraphone";
inst_sc88_55[ 11][  8] = "Vib.w";
inst_sc88_55[ 11][126] = "Steel Gt.";
inst_sc88_55[ 11][127] = "Elec Org 4";
inst_sc88_55[ 12][  0] = "Marimba";
inst_sc88_55[ 12][  8] = "Marimba w";
inst_sc88_55[ 12][126] = "12-str.Gt";
inst_sc88_55[ 12][127] = "Pipe Org 1";
inst_sc88_55[ 13][  0] = "Xylophone";
inst_sc88_55[ 13][126] = "Funk Gt.";
inst_sc88_55[ 13][127] = "Pipe Org 2";
inst_sc88_55[ 14][  0] = "Tubularbell";
inst_sc88_55[ 14][  8] = "Church Bell";
inst_sc88_55[ 14][  9] = "Carillon";
inst_sc88_55[ 14][126] = "Muted Gt.";
inst_sc88_55[ 14][127] = "Pipe Org 3";
inst_sc88_55[ 15][  0] = "Santur";
inst_sc88_55[ 15][126] = "Slap Bass 1";
inst_sc88_55[ 15][127] = "Accordion";
inst_sc88_55[ 16][  0] = "Organ 1";
inst_sc88_55[ 16][  8] = "Detuned Or1";
inst_sc88_55[ 16][ 16] = "60's Organ1";
inst_sc88_55[ 16][ 32] = "Organ 4";
inst_sc88_55[ 16][126] = "Slap Bass 1";
inst_sc88_55[ 16][127] = "Harpsi 1";
inst_sc88_55[ 17][  0] = "Organ 2";
inst_sc88_55[ 17][  8] = "Detuned Or2";
inst_sc88_55[ 17][ 32] = "Organ 5";
inst_sc88_55[ 17][126] = "Slap Bass 1";
inst_sc88_55[ 17][127] = "Harpsi 2";
inst_sc88_55[ 18][  0] = "Organ 3";
inst_sc88_55[ 18][126] = "Slap Bass 1";
inst_sc88_55[ 18][127] = "Harpsi 3";
inst_sc88_55[ 19][  0] = "Church Org1";
inst_sc88_55[ 19][  8] = "Church Org2";
inst_sc88_55[ 19][ 16] = "Church Org3";
inst_sc88_55[ 19][126] = "Slap Bass 2";
inst_sc88_55[ 19][127] = "Clavi 1";
inst_sc88_55[ 20][  0] = "Reed Organ";
inst_sc88_55[ 20][126] = "Slap Bass 2";
inst_sc88_55[ 20][127] = "Clavi 2";
inst_sc88_55[ 21][  0] = "Accordion F";
inst_sc88_55[ 21][  8] = "Accordion I";
inst_sc88_55[ 21][126] = "Slap Bass 2";
inst_sc88_55[ 21][127] = "Clavi 3";
inst_sc88_55[ 22][  0] = "Harmonica";
inst_sc88_55[ 22][126] = "Slap Bass 2";
inst_sc88_55[ 22][127] = "Celesta 1";
inst_sc88_55[ 23][  0] = "Bandoneon";
inst_sc88_55[ 23][126] = "Fingered Bs";
inst_sc88_55[ 23][127] = "Celesta 2";
inst_sc88_55[ 24][  0] = "Nylon Gt.";
inst_sc88_55[ 24][  8] = "Ukulele";
inst_sc88_55[ 24][ 16] = "Nylon Gt.o";
inst_sc88_55[ 24][ 32] = "Nylon Gt.2";
inst_sc88_55[ 24][126] = "Fingered Bs";
inst_sc88_55[ 24][127] = "Syn Brass 1";
inst_sc88_55[ 25][  0] = "Steel Gt.";
inst_sc88_55[ 25][  8] = "12-str.Gt";
inst_sc88_55[ 25][ 16] = "Mandolin";
inst_sc88_55[ 25][126] = "Picked Bass";
inst_sc88_55[ 25][127] = "Syn Brass 2";
inst_sc88_55[ 26][  0] = "Jazz Gt.";
inst_sc88_55[ 26][  8] = "Hawaiian Gt";
inst_sc88_55[ 26][126] = "Picked Bass";
inst_sc88_55[ 26][127] = "Syn Brass 3";
inst_sc88_55[ 27][  0] = "Clean Gt.";
inst_sc88_55[ 27][  8] = "Chorus Gt.";
inst_sc88_55[ 27][126] = "Fretless Bs";
inst_sc88_55[ 27][127] = "Syn Brass 4";
inst_sc88_55[ 28][  0] = "Muted Gt.";
inst_sc88_55[ 28][  8] = "Funk Gt.";
inst_sc88_55[ 28][ 16] = "Funk Gt.2";
inst_sc88_55[ 28][126] = "Acoustic Bs";
inst_sc88_55[ 28][127] = "Syn Bass 1";
inst_sc88_55[ 29][  0] = "OverdriveGt";
inst_sc88_55[ 29][126] = "Choir Aahs";
inst_sc88_55[ 29][127] = "Syn Bass 2";
inst_sc88_55[ 30][  0] = "Dist.Gt.";
inst_sc88_55[ 30][  8] = "Feedback Gt";
inst_sc88_55[ 30][126] = "Choir Aahs";
inst_sc88_55[ 30][127] = "Syn Bass 3";
inst_sc88_55[ 31][  0] = "Gt.Harmonix";
inst_sc88_55[ 31][  8] = "Gt.Feedback";
inst_sc88_55[ 31][126] = "Choir Aahs";
inst_sc88_55[ 31][127] = "Syn Bass 4";
inst_sc88_55[ 32][  0] = "Acoustic Bs";
inst_sc88_55[ 32][126] = "Choir Aahs";
inst_sc88_55[ 32][127] = "Fantasy";
inst_sc88_55[ 33][  0] = "Fingered Bs";
inst_sc88_55[ 33][126] = "SlowStrings";
inst_sc88_55[ 33][127] = "Harmo Pan";
inst_sc88_55[ 34][  0] = "Picked Bass";
inst_sc88_55[ 34][126] = "Strings";
inst_sc88_55[ 34][127] = "Chorale";
inst_sc88_55[ 35][  0] = "Fretless Bs";
inst_sc88_55[ 35][126] = "SynStrings3";
inst_sc88_55[ 35][127] = "Glasses";
inst_sc88_55[ 36][  0] = "Slap Bass 1";
inst_sc88_55[ 36][126] = "SynStrings3";
inst_sc88_55[ 36][127] = "Soundtrack";
inst_sc88_55[ 37][  0] = "Slap Bass 2";
inst_sc88_55[ 37][126] = "Organ 1";
inst_sc88_55[ 37][127] = "Atmosphere";
inst_sc88_55[ 38][  0] = "Syn.Bass 1";
inst_sc88_55[ 38][  1] = "Syn.Bass101";
inst_sc88_55[ 38][  8] = "Syn.Bass 3";
inst_sc88_55[ 38][126] = "Organ 1";
inst_sc88_55[ 38][127] = "Warm Bell";
inst_sc88_55[ 39][  0] = "Syn.Bass 2";
inst_sc88_55[ 39][  8] = "Syn.Bass 4";
inst_sc88_55[ 39][ 16] = "Rubber Bass";
inst_sc88_55[ 39][126] = "Organ 1";
inst_sc88_55[ 39][127] = "Funny Vox";
inst_sc88_55[ 40][  0] = "Violin";
inst_sc88_55[ 40][  8] = "Slow Violin";
inst_sc88_55[ 40][126] = "Organ 2";
inst_sc88_55[ 40][127] = "Echo Bell";
inst_sc88_55[ 41][  0] = "Viola";
inst_sc88_55[ 41][126] = "Organ 1";
inst_sc88_55[ 41][127] = "Ice Rain";
inst_sc88_55[ 42][  0] = "Cello";
inst_sc88_55[ 42][126] = "Organ 1";
inst_sc88_55[ 42][127] = "Oboe 2001";
inst_sc88_55[ 43][  0] = "Contrabass";
inst_sc88_55[ 43][126] = "Organ 2";
inst_sc88_55[ 43][127] = "Echo Pan";
inst_sc88_55[ 44][  0] = "Tremolo Str";
inst_sc88_55[ 44][126] = "Organ 2";
inst_sc88_55[ 44][127] = "Doctor Solo";
inst_sc88_55[ 45][  0] = "Pizzicato";
inst_sc88_55[ 45][126] = "Organ 2";
inst_sc88_55[ 45][127] = "School Daze";
inst_sc88_55[ 46][  0] = "Harp";
inst_sc88_55[ 46][126] = "Trumpet";
inst_sc88_55[ 46][127] = "Bellsinger";
inst_sc88_55[ 47][  0] = "Timpani";
inst_sc88_55[ 47][126] = "Trumpet";
inst_sc88_55[ 47][127] = "Square Wave";
inst_sc88_55[ 48][  0] = "Strings";
inst_sc88_55[ 48][  8] = "Orchestra";
inst_sc88_55[ 48][126] = "Trombone";
inst_sc88_55[ 48][127] = "Str Sect 1";
inst_sc88_55[ 49][  0] = "SlowStrings";
inst_sc88_55[ 49][126] = "Trombone";
inst_sc88_55[ 49][127] = "Str Sect 2";
inst_sc88_55[ 50][  0] = "SynStrings1";
inst_sc88_55[ 50][  8] = "SynStrings3";
inst_sc88_55[ 50][126] = "Trombone";
inst_sc88_55[ 50][127] = "Str Sect 3";
inst_sc88_55[ 51][  0] = "SynStrings2";
inst_sc88_55[ 51][126] = "Trombone";
inst_sc88_55[ 51][127] = "Pizzicato";
inst_sc88_55[ 52][  0] = "Choir Aahs";
inst_sc88_55[ 52][ 32] = "Choir Aahs2";
inst_sc88_55[ 52][126] = "Trombone";
inst_sc88_55[ 52][127] = "Violin 1";
inst_sc88_55[ 53][  0] = "Voice Oohs";
inst_sc88_55[ 53][126] = "Trombone";
inst_sc88_55[ 53][127] = "Violin 2";
inst_sc88_55[ 54][  0] = "SynVox";
inst_sc88_55[ 54][126] = "Alto Sax";
inst_sc88_55[ 54][127] = "Cello 1";
inst_sc88_55[ 55][  0] = "Orchest.Hit";
inst_sc88_55[ 55][126] = "Tenor Sax";
inst_sc88_55[ 55][127] = "Cello 2";
inst_sc88_55[ 56][  0] = "Trumpet";
inst_sc88_55[ 56][126] = "BaritoneSax";
inst_sc88_55[ 56][127] = "Contrabass";
inst_sc88_55[ 57][  0] = "Trombone";
inst_sc88_55[ 57][  1] = "Trombone 2";
inst_sc88_55[ 57][126] = "Alto Sax";
inst_sc88_55[ 57][127] = "Harp 1";
inst_sc88_55[ 58][  0] = "Tuba";
inst_sc88_55[ 58][126] = "Brass 1";
inst_sc88_55[ 58][127] = "Harp 2";
inst_sc88_55[ 59][  0] = "MuteTrumpet";
inst_sc88_55[ 59][126] = "Brass 1";
inst_sc88_55[ 59][127] = "Guitar 1";
inst_sc88_55[ 60][  0] = "French Horn";
inst_sc88_55[ 60][  1] = "Fr.Horn 2";
inst_sc88_55[ 60][126] = "Brass 2";
inst_sc88_55[ 60][127] = "Guitar 2";
inst_sc88_55[ 61][  0] = "Brass 1";
inst_sc88_55[ 61][  8] = "Brass 2";
inst_sc88_55[ 61][126] = "Brass 2";
inst_sc88_55[ 61][127] = "Elec Gtr 1";
inst_sc88_55[ 62][  0] = "Syn.Brass 1";
inst_sc88_55[ 62][  8] = "Syn.Brass 3";
inst_sc88_55[ 62][ 16] = "Analog Brs1";
inst_sc88_55[ 62][126] = "Brass 1";
inst_sc88_55[ 62][127] = "Elec Gtr 2";
inst_sc88_55[ 63][  0] = "Syn.Brass 2";
inst_sc88_55[ 63][  8] = "Syn.Brass 4";
inst_sc88_55[ 63][ 16] = "Analog Brs2";
inst_sc88_55[ 63][126] = "Orchest.Hit";
inst_sc88_55[ 63][127] = "Sitar";
inst_sc88_55[ 64][  0] = "Soprano Sax";
inst_sc88_55[ 64][127] = "Acou Bass 1";
inst_sc88_55[ 65][  0] = "Alto Sax";
inst_sc88_55[ 65][127] = "Acou Bass 2";
inst_sc88_55[ 66][  0] = "Tenor Sax";
inst_sc88_55[ 66][127] = "Elec Bass 1";
inst_sc88_55[ 67][  0] = "BaritoneSax";
inst_sc88_55[ 67][127] = "Elec Bass 2";
inst_sc88_55[ 68][  0] = "Oboe";
inst_sc88_55[ 68][127] = "Slap Bass 1";
inst_sc88_55[ 69][  0] = "EnglishHorn";
inst_sc88_55[ 69][127] = "Slap Bass 2";
inst_sc88_55[ 70][  0] = "Bassoon";
inst_sc88_55[ 70][127] = "Fretless 1";
inst_sc88_55[ 71][  0] = "Clarinet";
inst_sc88_55[ 71][127] = "Fretless 2";
inst_sc88_55[ 72][  0] = "Piccolo";
inst_sc88_55[ 72][127] = "Flute 1";
inst_sc88_55[ 73][  0] = "Flute";
inst_sc88_55[ 73][127] = "Flute 2";
inst_sc88_55[ 74][  0] = "Recorder";
inst_sc88_55[ 74][127] = "Piccolo 1";
inst_sc88_55[ 75][  0] = "Pan Flute";
inst_sc88_55[ 75][127] = "Piccolo 2";
inst_sc88_55[ 76][  0] = "Bottle Blow";
inst_sc88_55[ 76][127] = "Recorder";
inst_sc88_55[ 77][  0] = "Shakuhachi";
inst_sc88_55[ 77][127] = "Pan Pipes";
inst_sc88_55[ 78][  0] = "Whistle";
inst_sc88_55[ 78][127] = "Sax 1";
inst_sc88_55[ 79][  0] = "Ocarina";
inst_sc88_55[ 79][127] = "Sax 2";
inst_sc88_55[ 80][  0] = "Square Wave";
inst_sc88_55[ 80][  1] = "Square";
inst_sc88_55[ 80][  8] = "Sine Wave";
inst_sc88_55[ 80][127] = "Sax 3";
inst_sc88_55[ 81][  0] = "Saw Wave";
inst_sc88_55[ 81][  1] = "Saw";
inst_sc88_55[ 81][  8] = "Doctor Solo";
inst_sc88_55[ 81][127] = "Sax 4";
inst_sc88_55[ 82][  0] = "SynCalliope";
inst_sc88_55[ 82][127] = "Clarinet 1";
inst_sc88_55[ 83][  0] = "ChifferLead";
inst_sc88_55[ 83][127] = "Clarinet 2";
inst_sc88_55[ 84][  0] = "Charang";
inst_sc88_55[ 84][127] = "Oboe";
inst_sc88_55[ 85][  0] = "Solo Vox";
inst_sc88_55[ 85][127] = "Engl Horn";
inst_sc88_55[ 86][  0] = "5th Saw";
inst_sc88_55[ 86][127] = "Bassoon";
inst_sc88_55[ 87][  0] = "Bass & Lead";
inst_sc88_55[ 87][127] = "Harmonica";
inst_sc88_55[ 88][  0] = "Fantasia";
inst_sc88_55[ 88][127] = "Trumpet 1";
inst_sc88_55[ 89][  0] = "Warm Pad";
inst_sc88_55[ 89][127] = "Trumpet 2";
inst_sc88_55[ 90][  0] = "Polysynth";
inst_sc88_55[ 90][127] = "Trombone 1";
inst_sc88_55[ 91][  0] = "Space Voice";
inst_sc88_55[ 91][127] = "Trombone 2";
inst_sc88_55[ 92][  0] = "Bowed Glass";
inst_sc88_55[ 92][127] = "Fr Horn 1";
inst_sc88_55[ 93][  0] = "Metal Pad";
inst_sc88_55[ 93][127] = "Fr Horn 2";
inst_sc88_55[ 94][  0] = "Halo Pad";
inst_sc88_55[ 94][127] = "Tuba";
inst_sc88_55[ 95][  0] = "Sweep Pad";
inst_sc88_55[ 95][127] = "Brs Sect 1";
inst_sc88_55[ 96][  0] = "Ice Rain";
inst_sc88_55[ 96][127] = "Brs Sect 2";
inst_sc88_55[ 97][  0] = "Soundtrack";
inst_sc88_55[ 97][127] = "Vibe 1";
inst_sc88_55[ 98][  0] = "Crystal";
inst_sc88_55[ 98][  1] = "Syn Mallet";
inst_sc88_55[ 98][127] = "Vibe 2";
inst_sc88_55[ 99][  0] = "Atmosphere";
inst_sc88_55[ 99][127] = "Syn Mallet";
inst_sc88_55[100][  0] = "Brightness";
inst_sc88_55[100][127] = "Windbell";
inst_sc88_55[101][  0] = "Goblin";
inst_sc88_55[101][127] = "Glock";
inst_sc88_55[102][  0] = "Echo Drops";
inst_sc88_55[102][  1] = "Echo Bell";
inst_sc88_55[102][  2] = "Echo Pan";
inst_sc88_55[102][127] = "Tube Bell";
inst_sc88_55[103][  0] = "Star Theme";
inst_sc88_55[103][127] = "Xylophone";
inst_sc88_55[104][  0] = "Sitar";
inst_sc88_55[104][  1] = "Sitar 2";
inst_sc88_55[104][127] = "Marimba";
inst_sc88_55[105][  0] = "Banjo";
inst_sc88_55[105][127] = "Koto";
inst_sc88_55[106][  0] = "Shamisen";
inst_sc88_55[106][127] = "Sho";
inst_sc88_55[107][  0] = "Koto";
inst_sc88_55[107][  8] = "Taisho Koto";
inst_sc88_55[107][127] = "Shakuhachi";
inst_sc88_55[108][  0] = "Kalimba";
inst_sc88_55[108][127] = "Whistle 1";
inst_sc88_55[109][  0] = "Bagpipe";
inst_sc88_55[109][127] = "Whistle 2";
inst_sc88_55[110][  0] = "Fiddle";
inst_sc88_55[110][127] = "Bottleblow";
inst_sc88_55[111][  0] = "Shanai";
inst_sc88_55[111][127] = "Breathpipe";
inst_sc88_55[112][  0] = "Tinkle Bell";
inst_sc88_55[112][127] = "Timpani";
inst_sc88_55[113][  0] = "Agogo";
inst_sc88_55[113][127] = "Melodic Tom";
inst_sc88_55[114][  0] = "Steel Drums";
inst_sc88_55[114][127] = "Deep Snare";
inst_sc88_55[115][  0] = "Woodblock";
inst_sc88_55[115][  8] = "Castanets";
inst_sc88_55[115][127] = "Elec Perc 1";
inst_sc88_55[116][  0] = "Taiko";
inst_sc88_55[116][  8] = "Concert BD";
inst_sc88_55[116][127] = "Elec Perc 2";
inst_sc88_55[117][  0] = "Melo. Tom 1";
inst_sc88_55[117][  8] = "Melo. Tom 2";
inst_sc88_55[117][127] = "Taiko";
inst_sc88_55[118][  0] = "Synth Drum";
inst_sc88_55[118][  8] = "808 Tom";
inst_sc88_55[118][  9] = "Elec Perc";
inst_sc88_55[118][127] = "Taiko Rim";
inst_sc88_55[119][  0] = "Reverse Cym";
inst_sc88_55[119][127] = "Cymbal";
inst_sc88_55[120][  0] = "Gt.FretNoiz";
inst_sc88_55[120][  1] = "Gt.CutNoise";
inst_sc88_55[120][  2] = "String Slap";
inst_sc88_55[120][127] = "Castanets";
inst_sc88_55[121][  0] = "BreathNoise";
inst_sc88_55[121][  1] = "Fl.KeyClick";
inst_sc88_55[121][127] = "Triangle";
inst_sc88_55[122][  0] = "Seashore";
inst_sc88_55[122][  1] = "Rain";
inst_sc88_55[122][  2] = "Thunder";
inst_sc88_55[122][  3] = "Wind";
inst_sc88_55[122][  4] = "Stream";
inst_sc88_55[122][  5] = "Bubble";
inst_sc88_55[122][127] = "Orche Hit";
inst_sc88_55[123][  0] = "Bird";
inst_sc88_55[123][  1] = "Dog";
inst_sc88_55[123][  2] = "HorseGallop";
inst_sc88_55[123][  3] = "Bird 2";
inst_sc88_55[123][127] = "Telephone";
inst_sc88_55[124][  0] = "Telephone 1";
inst_sc88_55[124][  1] = "Telephone 2";
inst_sc88_55[124][  2] = "Creaking";
inst_sc88_55[124][  3] = "Door";
inst_sc88_55[124][  4] = "Scratch";
inst_sc88_55[124][  5] = "Wind Chimes";
inst_sc88_55[124][127] = "Bird Tweet";
inst_sc88_55[125][  0] = "Helicopter";
inst_sc88_55[125][  1] = "Car-Engine";
inst_sc88_55[125][  2] = "Car-Stop";
inst_sc88_55[125][  3] = "Car-Pass";
inst_sc88_55[125][  4] = "Car-Crash";
inst_sc88_55[125][  5] = "Siren";
inst_sc88_55[125][  6] = "Train";
inst_sc88_55[125][  7] = "Jetplane";
inst_sc88_55[125][  8] = "Starship";
inst_sc88_55[125][  9] = "Burst Noise";
inst_sc88_55[125][127] = "OneNote Jam";
inst_sc88_55[126][  0] = "Applause";
inst_sc88_55[126][  1] = "Laughing";
inst_sc88_55[126][  2] = "Screaming";
inst_sc88_55[126][  3] = "Punch";
inst_sc88_55[126][  4] = "Heart Beat";
inst_sc88_55[126][  5] = "Footsteps";
inst_sc88_55[126][127] = "Water Bell";
inst_sc88_55[127][  0] = "Gun Shot";
inst_sc88_55[127][  1] = "Machine Gun";
inst_sc88_55[127][  2] = "Lasergun";
inst_sc88_55[127][  3] = "Explosion";
inst_sc88_55[127][127] = "Jungle Tune";

/*
 * Drum Set
 */

/*
 * 88Pro MAP
 */
drum_sc88_pro[ 0] = "STANDARD 1";
drum_sc88_pro[ 1] = "STANDARD 2";
drum_sc88_pro[ 2] = "STANDARD 3";
drum_sc88_pro[ 8] = "ROOM";
drum_sc88_pro[ 9] = "HIP HOP";
drum_sc88_pro[10] = "JUNGLE";
drum_sc88_pro[11] = "TECHNO";
drum_sc88_pro[16] = "POWER";
drum_sc88_pro[24] = "ELECTRONIC";
drum_sc88_pro[25] = "TR-808";
drum_sc88_pro[26] = "DANCE";
drum_sc88_pro[27] = "CR-78";
drum_sc88_pro[28] = "TR-606";
drum_sc88_pro[29] = "TR-707";
drum_sc88_pro[30] = "TR-909";
drum_sc88_pro[32] = "JAZZ";
drum_sc88_pro[40] = "BRUSH";
drum_sc88_pro[48] = "ORCHESTRA";
drum_sc88_pro[49] = "ETHNIC";
drum_sc88_pro[50] = "KICK & SNARE";
drum_sc88_pro[52] = "ASIA";
drum_sc88_pro[53] = "CYMBAL&CLAPS";
drum_sc88_pro[56] = "SFX";
drum_sc88_pro[57] = "RHYTHM FX";
drum_sc88_pro[58] = "RHYTHM FX 2";
drum_sc88_pro[64] = "USER DRUM 1";	// USER DRUM SET #65
drum_sc88_pro[65] = "USER DRUM 2";	// USER DRUM SET #66

/*
 * 88 MAP
 */
drum_sc88_88[  1-1] = "STANDARD 1";
drum_sc88_88[  2-1] = "STANDARD 2";
drum_sc88_88[  9-1] = "ROOM";
drum_sc88_88[ 17-1] = "POWER";
drum_sc88_88[ 25-1] = "ELECTRONIC";
drum_sc88_88[ 26-1] = "TR-808/909";
drum_sc88_88[ 27-1] = "DANCE";
drum_sc88_88[ 33-1] = "JAZZ";
drum_sc88_88[ 41-1] = "BRUSH";
drum_sc88_88[ 49-1] = "ORCHESTRA";
drum_sc88_88[ 50-1] = "ETHNIC";
drum_sc88_88[ 51-1] = "KICK&SNARE";
drum_sc88_88[ 57-1] = "SFX";
drum_sc88_88[ 58-1] = "RHYTHM FX";
drum_sc88_88[ 65-1] = "USER DRUM 1";	// USER DRUM SET #65
drum_sc88_88[ 66-1] = "USER DRUM 2";	// USER DRUM SET #66

/*
 * 55 MAP
 */
drum_sc88_55[  1-1] = "STANDARD";
drum_sc88_55[  9-1] = "ROOM";
drum_sc88_55[ 17-1] = "POWER";
drum_sc88_55[ 25-1] = "ELECTRONIC";
drum_sc88_55[ 26-1] = "TR-808";
drum_sc88_55[ 33-1] = "JAZZ";
drum_sc88_55[ 41-1] = "BRUSH";
drum_sc88_55[ 49-1] = "ORCHESTRA";
drum_sc88_55[ 57-1] = "SFX";
drum_sc88_55[128-1] = "CM-64/32L";

/*
 * EFX
 */
efx_sc88_pro[  0][  0] = "Thru";
efx_sc88_pro[  1][  0] = "Stereo-EQ";
efx_sc88_pro[  1][  1] = "Spectrum";
efx_sc88_pro[  1][  2] = "Enhancer";
efx_sc88_pro[  1][  3] = "Humanizer";
efx_sc88_pro[  1][ 16] = "Overdrive";
efx_sc88_pro[  1][ 17] = "Distortion";
efx_sc88_pro[  1][ 32] = "Phaser";
efx_sc88_pro[  1][ 33] = "Auto Wah";
efx_sc88_pro[  1][ 34] = "Rotary";
efx_sc88_pro[  1][ 35] = "StereoFlanger";
efx_sc88_pro[  1][ 36] = "Step Flanger";
efx_sc88_pro[  1][ 37] = "Tremolo";
efx_sc88_pro[  1][ 38] = "Auto Pan";
efx_sc88_pro[  1][ 48] = "Compressor";
efx_sc88_pro[  1][ 49] = "Limiter";
efx_sc88_pro[  1][ 64] = "Hexa Chorus";
efx_sc88_pro[  1][ 65] = "TremoloChorus";
efx_sc88_pro[  1][ 66] = "Stereo Chorus";
efx_sc88_pro[  1][ 67] = "Space D";
efx_sc88_pro[  1][ 68] = "3D Chorus";
efx_sc88_pro[  1][ 80] = "Stereo Delay";
efx_sc88_pro[  1][ 81] = "Mod Delay";
efx_sc88_pro[  1][ 82] = "3 Tap Delay";
efx_sc88_pro[  1][ 83] = "4 Tap Delay";
efx_sc88_pro[  1][ 84] = "Tm Ctrl Delay";
efx_sc88_pro[  1][ 85] = "Reverb";
efx_sc88_pro[  1][ 86] = "Gate Reverb";
efx_sc88_pro[  1][ 87] = "3D Delay";
efx_sc88_pro[  1][ 96] = "2PitchShifter";
efx_sc88_pro[  1][ 97] = "Fb P.Shifter";
efx_sc88_pro[  1][112] = "3D Auto";
efx_sc88_pro[  1][113] = "3D Manual";
efx_sc88_pro[  1][114] = "Lo-Fi 1";
efx_sc88_pro[  1][115] = "Lo-Fi 2";
efx_sc88_pro[  2][  0] = "OD -> Chorus";
efx_sc88_pro[  2][  1] = "OD -> Flanger";
efx_sc88_pro[  2][  2] = "OD -> Delay";
efx_sc88_pro[  2][  3] = "DS -> Chorus";
efx_sc88_pro[  2][  4] = "DS -> Flanger";
efx_sc88_pro[  2][  5] = "DS -> Delay";
efx_sc88_pro[  2][  6] = "EH -> Chorus";
efx_sc88_pro[  2][  7] = "EH -> Flanger";
efx_sc88_pro[  2][  8] = "EH -> Delay";
efx_sc88_pro[  2][  9] = "Cho -> Delay";
efx_sc88_pro[  2][ 10] = "FL -> Delay";
efx_sc88_pro[  2][ 11] = "Cho-> Flanger";
efx_sc88_pro[  3][  0] = "Rotary Multi";
efx_sc88_pro[  4][  0] = "GTR Multi 1";
efx_sc88_pro[  4][  1] = "GTR Multi 2";
efx_sc88_pro[  4][  2] = "GTR Multi 3";
efx_sc88_pro[  4][  3] = "CleanGtMulti1";
efx_sc88_pro[  4][  4] = "CleanGtMulti2";
efx_sc88_pro[  4][  5] = "Bass Multi";
efx_sc88_pro[  4][  6] = "Rhodes Multi";
efx_sc88_pro[  5][  0] = "KeyboardMulti";
efx_sc88_pro[ 17][  0] = "Cho / Delay";
efx_sc88_pro[ 17][  1] = "FL / Delay";
efx_sc88_pro[ 17][  2] = "Cho / Flanger";
efx_sc88_pro[ 17][  3] = "OD1 / OD2";
efx_sc88_pro[ 17][  4] = "OD / Rotary";
efx_sc88_pro[ 17][  5] = "OD / Phaser";
efx_sc88_pro[ 17][  6] = "OD / AutoWah";
efx_sc88_pro[ 17][  7] = "PH / Rotary";
efx_sc88_pro[ 17][  8] = "PH / AutoWah";

/*
 * XG (MU50, MU80, MU90, MU100)
 */
inst_xg[  1-1][  0] = "Grand Piano";
//inst_xg[  1-1][  0] = "Grand Piano #";	// 100
inst_xg[  1-1][  1] = "Grand Piano KSP";
inst_xg[  1-1][ 18] = "Mello Gr Piano";
inst_xg[  1-1][ 40] = "Piano Str";
inst_xg[  1-1][ 41] = "Dream";
inst_xg[  1-1][ 64] = "Con Grand";	// 100?
inst_xg[  1-1][ 65] = "Con Grand KSP";	// 100?
inst_xg[  1-1][ 66] = "Dbl Con Grand";	// 100?
inst_xg[  1-1][ 67] = "MIDI Grand1";	// 100?
inst_xg[  1-1][ 68] = "MIDI Grand2";	// 100?
inst_xg[  2-1][  0] = "Bright Piano";
//inst_xg[  2-1][  0] = "Bright Piano #";	// 100
inst_xg[  2-1][  1] = "BrightPiano KSP";
inst_xg[  2-1][  3] = "St Brite Piano";	// 100?
inst_xg[  2-1][ 20] = "ResoBritePiano";	// 100?
inst_xg[  2-1][ 32] = "DtndBritePiano";	// 100?
inst_xg[  2-1][ 40] = "Sy Pad Piano";	// 100?
inst_xg[  2-1][ 64] = "Br Con Grand";	// 100?
inst_xg[  2-1][ 65] = "BrConGrand KSP";	// 100?
inst_xg[  2-1][ 66] = "MIDI Grand3";	// 100?
inst_xg[  2-1][ 67] = "MIDI Grand4";	// 100?
inst_xg[  2-1][ 68] = "Old Piano";	// 100?
inst_xg[  3-1][  0] = "E.Grand";
inst_xg[  3-1][  1] = "El.Gr.PianoKSP";
inst_xg[  3-1][ 32] = "Detuned CP80";
inst_xg[  3-1][ 35] = "Synth CP";	// 100?
inst_xg[  3-1][ 40] = "El. Gr. Piano1";
//inst_xg[  3-1][ 40] = "Layer CP1";	// 100?
inst_xg[  3-1][ 41] = "El. Gr. Piano2";
//inst_xg[  3-1][ 41] = "Layer CP2";	// 100?
inst_xg[  4-1][  0] = "Honky Tonk";
inst_xg[  4-1][  1] = "Honky Tonk KSP";
inst_xg[  5-1][  0] = "E. Piano 1";
//inst_xg[  5-1][  0] = "E.Piano 1 #";	// 100
inst_xg[  5-1][  1] = "El.Piano 1 KSP";
inst_xg[  5-1][ 18] = "Mellow EP 1";
inst_xg[  5-1][ 32] = "Chorus EP 1";
inst_xg[  5-1][ 40] = "Hard El. Piano";
inst_xg[  5-1][ 45] = "VX El. Piano1";
inst_xg[  5-1][ 64] = "60s El. Piano";
inst_xg[  5-1][ 65] = "Old EP";		// 100?
inst_xg[  5-1][ 66] = "Tribecca";	// 100?
inst_xg[  5-1][ 67] = "Diploid 1";	// 100?
inst_xg[  5-1][ 68] = "Flops";		// 100?
inst_xg[  5-1][ 69] = "Soho";		// 100?
inst_xg[  5-1][ 70] = "Flops Detuned";	// 100?
inst_xg[  5-1][ 71] = "Diploid 2";	// 100?
inst_xg[  5-1][ 72] = "Brooklyn";	// 100?
inst_xg[  5-1][ 73] = "Diploid 3";	// 100?
inst_xg[  5-1][ 74] = "Phunky DX";	// 100?
inst_xg[  5-1][ 75] = "Nasal DX";	// 100?
inst_xg[  5-1][ 76] = "Nasal DX Dt";	// 100?
inst_xg[  5-1][ 77] = "Din";		// 100?
inst_xg[  6-1][  0] = "E. Piano 2";
//inst_xg[  6-1][  0] = "E.Piano 2 #";	// 100
inst_xg[  6-1][  1] = "El.Piano 2 KSP";
inst_xg[  6-1][ 12] = "Chorus EP Decay";// 100?
inst_xg[  6-1][ 32] = "Chorus EP 2";
inst_xg[  6-1][ 33] = "DX Hard";
inst_xg[  6-1][ 34] = "DX Legend";
inst_xg[  6-1][ 40] = "DX Phase";
inst_xg[  6-1][ 41] = "DX + Analog";
inst_xg[  6-1][ 42] = "DX Koto EP";
inst_xg[  6-1][ 45] = "VX El. Piano2";
inst_xg[  6-1][ 48] = "Chorus EP KSP";	// 100?
inst_xg[  6-1][ 52] = "DX Mallet";	// 100?
inst_xg[  6-1][ 64] = "Shirakawa";	// 100?
inst_xg[  6-1][ 65] = "Old EP Tn";	// 100?
inst_xg[  6-1][ 66] = "Flips";		// 100?
inst_xg[  6-1][ 67] = "Flips Detuned";	// 100?
inst_xg[  6-1][ 68] = "Flicks";		// 100?
inst_xg[  6-1][ 69] = "Flicks Detuned";	// 100?
inst_xg[  6-1][ 70] = "Bright DX";	// 100?
inst_xg[  6-1][ 71] = "Brite DX Dtd";	// 100?
inst_xg[  6-1][ 72] = "Kitayama";	// 100?
inst_xg[  6-1][ 73] = "Turnpike 1";	// 100?
inst_xg[  6-1][ 74] = "Turnpike 2";	// 100?
inst_xg[  6-1][ 75] = "Ceritos";	// 100?
inst_xg[  6-1][ 76] = "Sunset";		// 100?
inst_xg[  6-1][ 77] = "Soft DX";	// 100?
inst_xg[  6-1][ 78] = "Reso DX";	// 100?
inst_xg[  6-1][ 79] = "Piercing DX";	// 100?
inst_xg[  6-1][ 80] = "Shvrng DX";	// 100?
inst_xg[  6-1][ 81] = "Shvrng DX +";	// 100?
inst_xg[  6-1][ 82] = "Rattling DX";	// 100?
inst_xg[  6-1][ 83] = "Rattling DX +";	// 100?
inst_xg[  6-1][ 84] = "Tinker DX";	// 100?
inst_xg[  6-1][ 85] = "Tinker DX +";	// 100?
inst_xg[  7-1][  0] = "Harpsichord";
inst_xg[  7-1][  1] = "Harpsi. KSP";
inst_xg[  7-1][ 25] = "Harpsichord 2";
inst_xg[  7-1][ 35] = "Harpsichord 3";
inst_xg[  7-1][ 40] = "El. Harpsi.";	// 100?
inst_xg[  7-1][ 64] = "Syn. Harpsi.";	// 100?
inst_xg[  8-1][  0] = "Clavichord";
//inst_xg[  8-1][  0] = "Clavichord #";	// 100
inst_xg[  8-1][  1] = "Clavi. KSP";
inst_xg[  8-1][ 27] = "Clavi. Wah";
inst_xg[  8-1][ 40] = "Cosmic Clavi.";	// 100? ???
inst_xg[  8-1][ 64] = "Pulse Clavi.";
inst_xg[  8-1][ 65] = "Pierce Clavi.";
inst_xg[  8-1][ 66] = "Clear Clavi.";	// 100?
inst_xg[  8-1][ 67] = "Sweep Clavi.";	// 100?
inst_xg[  8-1][ 68] = "Syn Clavi.";	// 100?
inst_xg[  8-1][ 69] = "Spruce Clavi.";	// 100? ???
inst_xg[  8-1][ 70] = "Gtr Clavi.";	// 100?
inst_xg[  8-1][ 71] = "Hardy Plk";	// 100? ???
inst_xg[  8-1][ 72] = "Hardy Plk +";	// 100? ???
inst_xg[  8-1][ 73] = "FM Clav Db";	// 100? ???
inst_xg[  9-1][  0] = "Celesta";
inst_xg[  9-1][ 64] = "FM Celesta";	// 100?
inst_xg[ 10-1][  0] = "Glockenspiel";
inst_xg[ 11-1][  0] = "Music Box";
inst_xg[ 11-1][ 64] = "Orgel";
inst_xg[ 11-1][ 65] = "Small Orgel";	// 100?
inst_xg[ 12-1][  0] = "Vibes";
inst_xg[ 12-1][  1] = "Vibes KSP";
inst_xg[ 12-1][ 45] = "Hard Vibe";
inst_xg[ 13-1][  0] = "Marimba";
inst_xg[ 13-1][  1] = "Marimba KSP";
inst_xg[ 13-1][ 64] = "Sine Marimba";
inst_xg[ 13-1][ 96] = "Balafon";		//
inst_xg[ 13-1][ 97] = "Balafon 2";
inst_xg[ 13-1][ 98] = "Log Drum";
inst_xg[ 14-1][  0] = "Xylophon";
inst_xg[ 15-1][  0] = "Tubular Bell";
inst_xg[ 15-1][ 96] = "Church Bell";
inst_xg[ 15-1][ 97] = "Carillon";
inst_xg[ 16-1][  0] = "Dulcimer";
inst_xg[ 16-1][ 35] = "Dhlcimer 2";
inst_xg[ 16-1][ 96] = "Cimbalom";
inst_xg[ 16-1][ 97] = "Santur";
inst_xg[ 17-1][  0] = "DrawbarOrgan";
//inst_xg[ 17-1][  0] = "DrawbarOrgan #";	// 100
inst_xg[ 17-1][  3] = "St. Draw Org";	// 100?
inst_xg[ 17-1][ 32] = "Det. Draw Org";
inst_xg[ 17-1][ 33] = "60s Draw Org.1";
inst_xg[ 17-1][ 34] = "60s Draw Org.2";
inst_xg[ 17-1][ 35] = "70s Draw Org.1";
inst_xg[ 17-1][ 36] = "Draw Organ 2";
inst_xg[ 17-1][ 37] = "60s Dr Org.3";
inst_xg[ 17-1][ 38] = "Even Bar";
inst_xg[ 17-1][ 40] = "\"16+2\"\"2/3\"";
inst_xg[ 17-1][ 64] = "Organ Bass";
inst_xg[ 17-1][ 65] = "70s Dr Org.2";
inst_xg[ 17-1][ 66] = "Cheese Organ";
inst_xg[ 17-1][ 67] = "Draw Organ 3";
inst_xg[ 17-1][ 68] = "Stadium Org";	// 100? ???
inst_xg[ 17-1][ 69] = "Stadium Org 2";	// 100?
inst_xg[ 17-1][ 70] = "Gospel Org";	// 100?
inst_xg[ 17-1][ 71] = "Clk Gospel Org";	// 100?
inst_xg[ 17-1][ 72] = "Chapel Organ";	// 100?
inst_xg[ 17-1][ 73] = "Dim Chorus";	// 100? ???
inst_xg[ 17-1][ 74] = "Dawn";		// 100?
inst_xg[ 17-1][ 75] = "Mellorgn";	// 100? ???
inst_xg[ 17-1][ 76] = "Fuzzorgn";	// 100? ???
inst_xg[ 17-1][ 77] = "FMO";		// 100? ???
inst_xg[ 18-1][  0] = "Perc. Organ";
//inst_xg[ 18-1][  0] = "Perc. Organ #";	// 100
inst_xg[ 18-1][ 24] = "70s Perc.Org";
inst_xg[ 18-1][ 32] = "Det. Perc.Org";
inst_xg[ 18-1][ 33] = "Lite Organ";
inst_xg[ 18-1][ 37] = "Perc. Org. 2";
inst_xg[ 18-1][ 64] = "Jazz Organ";	// 100?
inst_xg[ 18-1][ 65] = "Warm Jazz Org";	// 100?
inst_xg[ 18-1][ 66] = "Click Organ";	// 100?
inst_xg[ 18-1][ 67] = "Grace";		// 100?
inst_xg[ 18-1][ 68] = "Crn Grace";	// 100? ???
inst_xg[ 18-1][ 69] = "Dim Click";	// 100?
inst_xg[ 18-1][ 70] = "Dusk";		// 100?
inst_xg[ 18-1][ 71] = "FM Click";	// 100?
inst_xg[ 18-1][ 72] = "Spoony";		// 100?
inst_xg[ 18-1][ 73] = "Spr Rotary";	// 100?
inst_xg[ 18-1][ 74] = "LoFi Organ";	// 100?
inst_xg[ 18-1][ 75] = "Beep Organ";	// 100?
inst_xg[ 18-1][ 76] = "Belief";		// 100?
inst_xg[ 18-1][ 77] = "Snap Organ";	// 100?
inst_xg[ 19-1][  0] = "Rock Organ";
//inst_xg[ 19-1][  0] = "Rock Organ #";	// 100
inst_xg[ 19-1][ 64] = "Rotary Organ";
inst_xg[ 19-1][ 65] = "Slow Rotary";
inst_xg[ 19-1][ 66] = "Fast Rotary";
inst_xg[ 19-1][ 67] = "Glacial Rotary";	// 100? ???
inst_xg[ 20-1][  0] = "Church Organ";
inst_xg[ 20-1][ 32] = "Church Org. 3";
inst_xg[ 20-1][ 35] = "Church Org. 2";
inst_xg[ 20-1][ 40] = "Notre Dame";
inst_xg[ 20-1][ 64] = "Organ Flute";	// 100?
inst_xg[ 20-1][ 65] = "Trem. Org. Fl";
inst_xg[ 21-1][  0] = "Reed Organ";
inst_xg[ 21-1][ 32] = "Reed Organ Det";	// 100?
inst_xg[ 21-1][ 40] = "Puff Organ";
inst_xg[ 21-1][ 64] = "Syn Reed Dk";	// 100? ???
inst_xg[ 22-1][  0] = "Accordion";
inst_xg[ 22-1][ 32] = "Accordion It";
inst_xg[ 23-1][  0] = "Harmonica";
inst_xg[ 23-1][ 32] = "Harmonica 2";
inst_xg[ 24-1][  0] = "Tango Accord";
//inst_xg[ 24-1][  0] = "Tango Accord #";	// 100
inst_xg[ 24-1][ 64] = "Tango Accord 2";
inst_xg[ 24-1][ 65] = "Tight Accord";	// 100?
inst_xg[ 24-1][ 66] = "Tight Accord D";	// 100? ???
inst_xg[ 25-1][  0] = "Nylon Guitar";
//inst_xg[ 25-1][  0] = "Nylon Guitar #";	// 100
inst_xg[ 25-1][ 16] = "Nylon Gt. 2";
inst_xg[ 25-1][ 25] = "Nylon Gt. 3";
inst_xg[ 25-1][ 32] = "Nylon Gt. Dt";	// 100?
inst_xg[ 25-1][ 40] = "Wayside";	// 100?
inst_xg[ 25-1][ 43] = "Velo Gt.Harm";
inst_xg[ 25-1][ 64] = "Es Guitar";	// 100? ???
inst_xg[ 25-1][ 65] = "Es Gtr Hard";	// 100? ???
inst_xg[ 25-1][ 66] = "Es Gtr Mellow";	// 100? ???
inst_xg[ 25-1][ 67] = "Es Gtr Decay";	// 100? ???
inst_xg[ 25-1][ 96] = "Ukulele";
inst_xg[ 26-1][  0] = "Steel Guitar";
//inst_xg[ 26-1][  0] = "Steel Guitar #";	// 100
inst_xg[ 26-1][ 16] = "Steel Gt. 2";
inst_xg[ 26-1][ 32] = "Steel Gt. Dt";	// 100?
inst_xg[ 26-1][ 35] = "12-str.Gt.";
inst_xg[ 26-1][ 40] = "Nylon&Steel";
inst_xg[ 26-1][ 41] = "Steel&Body";
inst_xg[ 26-1][ 64] = "Nashville";	// 100?
inst_xg[ 26-1][ 65] = "Nashville R";	// 100?
inst_xg[ 26-1][ 66] = "Nashville 12";	// 100?
inst_xg[ 26-1][ 96] = "Mandolin";
inst_xg[ 26-1][ 96] = "Mandolin Ens";	// 100? ???
inst_xg[ 27-1][  0] = "Jazz Guitar";
//inst_xg[ 27-1][  0] = "Jazz Guitar #";	// 100
inst_xg[ 27-1][ 18] = "Mellow Guitar";
inst_xg[ 27-1][ 32] = "Jazz Amp";
inst_xg[ 27-1][ 64] = "Super Jazz M";	// 100? ???
inst_xg[ 27-1][ 65] = "Super Jazz B";	// 100? ???
inst_xg[ 27-1][ 66] = "Super Jazz D";	// 100? ???
inst_xg[ 27-1][ 67] = "Super Jazz R";	// 100? ???
inst_xg[ 27-1][ 68] = "DX Jazz Gtr";	// 100?
inst_xg[ 27-1][ 69] = "DX Jazz Gtr D";	// 100? ???
inst_xg[ 27-1][ 70] = "Pulse Jazz";	// 100?
inst_xg[ 27-1][ 71] = "Roughcast N";	// 100? ???
inst_xg[ 27-1][ 72] = "Roughcast M";	// 100? ???
inst_xg[ 27-1][ 96] = "Pedal Steel";	//
inst_xg[ 28-1][  0] = "Clean Gtr";
inst_xg[ 28-1][ 32] = "Chorus Gtr";
inst_xg[ 28-1][ 33] = "Chorus Gtr Lt";	// 100? ???
inst_xg[ 28-1][ 64] = "Clean Gtr 2";	// *
inst_xg[ 28-1][ 65] = "Mid T. Gtr";	// 100? ???
inst_xg[ 28-1][ 66] = "Mid T. Gtr St";	// 100? ???
inst_xg[ 28-1][ 67] = "Nasal Gtr";	// 100?
inst_xg[ 28-1][ 68] = "Nasal Gtr St";	// 100?
inst_xg[ 28-1][ 69] = "Hammer M";	// 100? ???
inst_xg[ 28-1][ 70] = "Hammer B";	// 100? ???
inst_xg[ 28-1][ 71] = "Hammer D";	// 100? ???
inst_xg[ 28-1][ 72] = "Hammer St";	// 100?
inst_xg[ 28-1][ 73] = "FM Cho Gtr";	// 100?
inst_xg[ 28-1][ 74] = "FM Cho Gtr St";	// 100?
inst_xg[ 28-1][ 75] = "Pesky Gtr";	// 100?
inst_xg[ 28-1][ 76] = "Clavi Gtr";	// 100?
inst_xg[ 29-1][  0] = "Muted Gtr";
//inst_xg[ 29-1][  0] = "Muted Gtr #";	// 100
inst_xg[ 29-1][ 40] = "Funky Gtr 1";
inst_xg[ 29-1][ 41] = "Muted Stl Gt";
inst_xg[ 29-1][ 43] = "Funky Gtr 2";
inst_xg[ 29-1][ 45] = "Jazz Man";
inst_xg[ 29-1][ 64] = "Wrench";		// 100?
inst_xg[ 29-1][ 65] = "Wrench Hv";	// 100? ???
inst_xg[ 29-1][ 66] = "Wrench Dbl";	// 100?
inst_xg[ 29-1][ 67] = "Tin";		// 100?
inst_xg[ 29-1][ 96] = "Muted Dst Gt";	//
inst_xg[ 30-1][  0] = "Overdrive";
//inst_xg[ 30-1][  0] = "Overdrive #";	// 100
inst_xg[ 30-1][ 32] = "Odrv Gtr Dt";	// 100?
inst_xg[ 30-1][ 40] = "Parallel";	// 100?
inst_xg[ 30-1][ 43] = "Guitar Pinch";
inst_xg[ 30-1][ 64] = "Manhattan M";	// 100? ???
inst_xg[ 30-1][ 65] = "Manhattan B";	// 100? ???
inst_xg[ 30-1][ 66] = "Manhattan D";	// 100? ???
inst_xg[ 30-1][ 67] = "Manhattan P";	// 100? ???
inst_xg[ 31-1][  0] = "Dist. Guitar";
//inst_xg[ 31-1][  0] = "Dist. Guitar #";	// 100
inst_xg[ 31-1][ 12] = "Dist. Rythm Gt";	// *
inst_xg[ 31-1][ 24] = "Dist. Gtr 2";	// *
inst_xg[ 31-1][ 35] = "Dist. Gtr 3";	// *
inst_xg[ 31-1][ 36] = "Power Gtr 2";	// *
inst_xg[ 31-1][ 37] = "Power Gtr 1";	// *
//inst_xg[ 31-1][ 38] = "Dist.5th Gtr";	// *
inst_xg[ 31-1][ 38] = "Dist. 5ths";	// 100?
inst_xg[ 31-1][ 40] = "Feedback Gtr";
inst_xg[ 31-1][ 41] = "Feedback Gtr 2";
inst_xg[ 31-1][ 42] = "Twin Dist";	// 100?
inst_xg[ 31-1][ 43] = "Rock Rythm 2";	// *
//inst_xg[ 31-1][ 45] = "Rock Rythm";	// *
inst_xg[ 31-1][ 45] = "Rock Rythm 1";	// 100?
inst_xg[ 31-1][ 64] = "Bite";		// 100?
inst_xg[ 31-1][ 65] = "Bite Reso";	// 100?
inst_xg[ 31-1][ 66] = "Bite Dtd";	// 100?
inst_xg[ 31-1][ 67] = "Bite +";		// 100?
inst_xg[ 31-1][ 68] = "Burnout";	// 100?
inst_xg[ 31-1][ 69] = "Bombay";		// 100?
inst_xg[ 31-1][ 70] = "Bombay S";	// 100?
inst_xg[ 31-1][ 71] = "Jaipur";		// 100?
inst_xg[ 32-1][  0] = "Guitar harmo";
inst_xg[ 32-1][ 64] = "Acou. Harmo";	// *
inst_xg[ 32-1][ 65] = "Gtr Feedback";
inst_xg[ 32-1][ 66] = "Gtr Harmo 2";
inst_xg[ 32-1][ 67] = "Shimla";		// 100? ???
inst_xg[ 33-1][  0] = "AcousticBass";
//inst_xg[ 33-1][  0] = "AcousticBass #";	// 100
inst_xg[ 33-1][ 40] = "Jazz Rythm";
inst_xg[ 33-1][ 41] = "Pick Aco Bass";	// 100?
inst_xg[ 33-1][ 43] = "Blink Bass";	// 100?
inst_xg[ 33-1][ 45] = "VX Upright";
inst_xg[ 33-1][ 64] = "Boston";		// 100?
inst_xg[ 33-1][ 65] = "Boston Brt";	// 100? ???
inst_xg[ 33-1][ 66] = "Coolth";		// 100?
inst_xg[ 33-1][ 67] = "Coolth B";	// 100? ???
inst_xg[ 33-1][ 96] = "Walk Syn Bass";	// 100?
inst_xg[ 33-1][ 97] = "Dim & Cool";	// 100?
inst_xg[ 34-1][  0] = "Finger Bass";
//inst_xg[ 34-1][  0] = "Finger Bass #";	// 100
inst_xg[ 34-1][ 18] = "Finger Dark";
inst_xg[ 34-1][ 27] = "Flange Bass";
inst_xg[ 34-1][ 32] = "Finger Bass Dt";	// 100?
inst_xg[ 34-1][ 40] = "Bass & Dist.EG";
inst_xg[ 34-1][ 43] = "Finger Slap";
inst_xg[ 34-1][ 45] = "Finger Bass 2";
//inst_xg[ 34-1][ 64] = "Jazz Bass";	// *
inst_xg[ 34-1][ 64] = "Jazzy Bass";	// 100?
//inst_xg[ 34-1][ 65] = "Mod Alem";	// ???
inst_xg[ 34-1][ 65] = "Mod. Bass";	// 100?
inst_xg[ 34-1][ 66] = "Chase";		// 100?
inst_xg[ 34-1][ 67] = "Chase Reso";	// 100?
inst_xg[ 34-1][ 68] = "Blue Bass";	// 100?
inst_xg[ 35-1][  0] = "Pick Bass";
inst_xg[ 35-1][ 28] = "Mute Pick Bass";
inst_xg[ 35-1][ 40] = "Pk Ba & Mt Gt";	// 100?
inst_xg[ 35-1][ 64] = "Hard Pick";	// 100?
inst_xg[ 35-1][ 65] = "Hard Pick Reso";	// 100?
inst_xg[ 35-1][ 66] = "Pick Bass +";	// 100?
inst_xg[ 36-1][  0] = "Fretless";
//inst_xg[ 36-1][  0] = "Fretless #";	// 100
inst_xg[ 36-1][ 32] = "Fretless 2";
inst_xg[ 36-1][ 33] = "Fretless 3";
inst_xg[ 36-1][ 34] = "Fretless 4";
inst_xg[ 36-1][ 64] = "Power Fretless";	// 100?
inst_xg[ 36-1][ 65] = "Power Frtles R";	// 100?
inst_xg[ 36-1][ 66] = "Talking Bass";	// 100?
inst_xg[ 36-1][ 67] = "Noise Fretless";	// 100?
inst_xg[ 36-1][ 96] = "Syn Fretless";
//inst_xg[ 36-1][ 97] = "Smooth";
inst_xg[ 36-1][ 97] = "Smooth Fretles";	// 100?
inst_xg[ 37-1][  0] = "Slap Bass 1";
//inst_xg[ 37-1][  0] = "Slap Bass 1#";	// 100
inst_xg[ 37-1][ 21] = "Cosmic Slap";	// 100?
inst_xg[ 37-1][ 27] = "Reso Slap";
inst_xg[ 37-1][ 32] = "Punch Thm";	// ???
inst_xg[ 37-1][ 64] = "Slapper";	// 100?
inst_xg[ 37-1][ 65] = "Thum & Slap";	// 100? ???
inst_xg[ 37-1][ 66] = "Glitzy Slap";	// 100?
inst_xg[ 37-1][ 67] = "FM Slap";	// 100?
inst_xg[ 37-1][ 68] = "FM Slap Dtd";	// 100?
inst_xg[ 38-1][  0] = "Slap Bass 2";
//inst_xg[ 38-1][  0] = "Slap Bass 2#";	// 100
inst_xg[ 38-1][ 16] = "Brt Slap Sp";	// 100? ???
inst_xg[ 38-1][ 22] = "Wah Slap";	// 100?
inst_xg[ 38-1][ 43] = "Velo Slap";
inst_xg[ 39-1][  0] = "Synth Bass 1";
inst_xg[ 39-1][ 18] = "Syn.Bass 1 Dk";
inst_xg[ 39-1][ 20] = "FastResoBass";
inst_xg[ 39-1][ 21] = "TL66";		// 100?
inst_xg[ 39-1][ 24] = "Acid Bass";
inst_xg[ 39-1][ 27] = "Reso Bass";	// 100?
inst_xg[ 39-1][ 28] = "Muted Pulse Ba";	// 100?
inst_xg[ 39-1][ 29] = "Slow Atack";	// 100?
inst_xg[ 39-1][ 35] = "Clv Bass";
inst_xg[ 39-1][ 40] = "Techno Bass";
inst_xg[ 39-1][ 41] = "Kik'n'Bass";	// 100?
inst_xg[ 39-1][ 42] = "NEP";		// 100?
//inst_xg[ 39-1][ 64] = "Oscar";
inst_xg[ 39-1][ 64] = "Orbiter";	// 100?
inst_xg[ 39-1][ 65] = "Square Bass";
inst_xg[ 39-1][ 66] = "Rubber Bass";
inst_xg[ 39-1][ 67] = "Fish";		// 100?
inst_xg[ 39-1][ 68] = "Hard Reso";	// 100?
inst_xg[ 39-1][ 69] = "Wah Saw";	// 100?
inst_xg[ 39-1][ 70] = "Pluto";		// 100?
inst_xg[ 39-1][ 71] = "Pluto +";	// 100?
inst_xg[ 39-1][ 72] = "Stimuli";	// 100? ???
inst_xg[ 39-1][ 73] = "Run Pulse";	// 100?
inst_xg[ 39-1][ 74] = "Talk Pulse";	// 100?
inst_xg[ 39-1][ 75] = "Node";		// 100?
inst_xg[ 39-1][ 76] = "Stainer";	// 100?
inst_xg[ 39-1][ 77] = "Stain Attack";	// 100?
inst_xg[ 39-1][ 78] = "Sweep Square";	// 100?
inst_xg[ 39-1][ 79] = "Sweep Square +";	// 100?
inst_xg[ 39-1][ 80] = "Stinks";		// 100?
inst_xg[ 39-1][ 81] = "Stinks Reso";	// 100?
inst_xg[ 39-1][ 82] = "Reso Square";	// 100?
inst_xg[ 39-1][ 83] = "Dagger";		// 100?
inst_xg[ 39-1][ 84] = "Zinc";		// 100?
inst_xg[ 39-1][ 85] = "Sweep PWM";	// 100?
inst_xg[ 39-1][ 86] = "Sweep PWM St";	// 100?
inst_xg[ 39-1][ 87] = "Slow Wah";	// 100?
inst_xg[ 39-1][ 88] = "Crook";		// 100?
inst_xg[ 39-1][ 96] = "Hammer";
inst_xg[ 40-1][  0] = "Synth Bass 2";
inst_xg[ 40-1][  6] = "Mellow Syn Ba2";
inst_xg[ 40-1][ 12] = "Seq Bass";
inst_xg[ 40-1][ 18] = "Clk Syn. Bass";
inst_xg[ 40-1][ 19] = "Syn. Bass 2 Dk";
inst_xg[ 40-1][ 22] = "Zealot";		// 100?
//inst_xg[ 40-1][ 32] = "Smooth Bass2";
inst_xg[ 40-1][ 32] = "Smooth Syn Bas";	// 100?
inst_xg[ 40-1][ 40] = "Modular Bass";
inst_xg[ 40-1][ 41] = "DX Bass";
inst_xg[ 40-1][ 42] = "DX Bass Brt";	// 100?
inst_xg[ 40-1][ 64] = "X Wire Bass";
inst_xg[ 40-1][ 65] = "Attack Pulse";	// 100?
inst_xg[ 40-1][ 66] = "CS Light";	// 100?
inst_xg[ 40-1][ 67] = "Metal Bass";	// 100?
inst_xg[ 40-1][ 68] = "Frc Osc Bass";	// 100? ???
inst_xg[ 40-1][ 69] = "Cubit";		// 100?
inst_xg[ 40-1][ 70] = "Cubit +";	// 100?
inst_xg[ 40-1][ 71] = "Keel";		// 100?
inst_xg[ 40-1][ 72] = "Keel Powered";	// 100?
inst_xg[ 40-1][ 73] = "Pln Pulse";	// 100? ???
inst_xg[ 40-1][ 74] = "Powered Pulse";	// 100?
inst_xg[ 40-1][ 75] = "Powerd Pulse B";	// 100? ???
inst_xg[ 40-1][ 76] = "Powered Saw";	// 100?
inst_xg[ 41-1][  0] = "Violin";
//inst_xg[ 41-1][  0] = "Violin #";	// 100
inst_xg[ 41-1][  8] = "Slow Violin";
inst_xg[ 41-1][ 40] = "Unison";		// 100?
inst_xg[ 41-1][ 64] = "Cadenza";	// 100?
inst_xg[ 41-1][ 65] = "Cadenza Dk";	// 100?
inst_xg[ 42-1][  0] = "Viola";
inst_xg[ 42-1][ 40] = "Viola Double";	// 100?
inst_xg[ 42-1][ 64] = "Sonata";		// 100?
inst_xg[ 43-1][  0] = "Cello";
inst_xg[ 44-1][  0] = "Contrabass";
inst_xg[ 45-1][  0] = "Trem.Strings";
//inst_xg[ 45-1][  0] = "Trem.Strings #";	// 100
inst_xg[ 45-1][  8] = "Slow Trem. Str";
inst_xg[ 45-1][ 40] = "Suspense Str";	// ???
inst_xg[ 45-1][ 64] = "Fear";		// 100?
inst_xg[ 45-1][ 65] = "Fear Dtd";	// 100?
inst_xg[ 45-1][ 66] = "Apocalypse";	// 100?
inst_xg[ 46-1][  0] = "PizzicatoStr";
inst_xg[ 46-1][ 35] = "Pizz Oct";	// 100?
inst_xg[ 46-1][ 40] = "Sleep";		// 100?
inst_xg[ 47-1][  0] = "Harp";
inst_xg[ 47-1][ 40] = "Yang Chin";
inst_xg[ 47-1][ 96] = "Vln Harp";	// 100? ???
inst_xg[ 47-1][ 97] = "Vln Harp Dt";	// 100? ???
inst_xg[ 48-1][  0] = "Timpani";
inst_xg[ 48-1][ 43] = "Roll & Hit";	// 100?
inst_xg[ 49-1][  0] = "Strings 1";
//inst_xg[ 49-1][  0] = "Strings 1#";	// 100
inst_xg[ 49-1][  3] = "S. Strings";
inst_xg[ 49-1][  8] = "Slow Strings";
inst_xg[ 49-1][ 24] = "Arco Strings";
inst_xg[ 49-1][ 35] = "60's Strings";
inst_xg[ 49-1][ 40] = "Orchestra";
inst_xg[ 49-1][ 41] = "Orchestra 2";
inst_xg[ 49-1][ 42] = "Tremolo Orch";
inst_xg[ 49-1][ 45] = "Velo Strings";
inst_xg[ 49-1][ 52] = "Lento";		// 100?
inst_xg[ 49-1][ 64] = "Spr Strings";	// 100?
inst_xg[ 49-1][ 65] = "Spr Strings St";	// 100? ???
inst_xg[ 49-1][ 66] = "Triste";		// 100?
inst_xg[ 49-1][ 67] = "Basso";		// 100?
inst_xg[ 50-1][  0] = "Strings 2";
//inst_xg[ 50-1][  0] = "Strings 2#";	// 100
inst_xg[ 50-1][  3] = "S. Slow Str.";
inst_xg[ 50-1][  8] = "Legato Strng";
inst_xg[ 50-1][ 40] = "Warm Strings";
inst_xg[ 50-1][ 41] = "Kingdom";
inst_xg[ 50-1][ 64] = "70's Strings";
inst_xg[ 50-1][ 65] = "Strings 3";
inst_xg[ 51-1][  0] = "Synth Str 1";
inst_xg[ 51-1][  8] = "Memory";		// 100?
inst_xg[ 51-1][ 18] = "Zephyr";		// 100?
inst_xg[ 51-1][ 27] = "Reso Strings";
inst_xg[ 51-1][ 35] = "Syn. Strings 3";	// *
inst_xg[ 51-1][ 39] = "Monarchy";	// 100?
inst_xg[ 51-1][ 40] = "Grand Pad";	// 100?
inst_xg[ 51-1][ 41] = "Sweep Strings";	// 100?
inst_xg[ 51-1][ 42] = "Sweep St Oct";	// 100?
inst_xg[ 51-1][ 64] = "Syn.Strings 4";
//inst_xg[ 51-1][ 65] = "SS Strings";
inst_xg[ 51-1][ 65] = "Syn.Strings 5";	// 100?
inst_xg[ 51-1][ 66] = "Solitude";	// 100?
inst_xg[ 51-1][ 67] = "Fate";		// 100?
inst_xg[ 51-1][ 68] = "Thulium";	// 100?
inst_xg[ 51-1][ 69] = "Brook";		// 100?
inst_xg[ 51-1][ 70] = "Brook St";	// 100?
inst_xg[ 52-1][  0] = "Syn.Strings 2";
inst_xg[ 52-1][ 21] = "Trade Wind";	// 100?
inst_xg[ 52-1][ 39] = "Worm Hole";	// 100?
inst_xg[ 52-1][ 64] = "Hope";		// 100?
inst_xg[ 52-1][ 65] = "Virgo";		// 100?
inst_xg[ 52-1][ 66] = "Platinum";	// 100?
inst_xg[ 52-1][ 67] = "Octave PWM";	// 100?
inst_xg[ 52-1][ 68] = "Taurus";		// 100?
inst_xg[ 52-1][ 69] = "Frost";		// 100?
inst_xg[ 52-1][ 70] = "Leo";		// 100?
inst_xg[ 52-1][ 71] = "Sol Plexs";	// 100? ???
inst_xg[ 53-1][  0] = "Choir Aahs";
inst_xg[ 53-1][  3] = "Stereo Choir";
inst_xg[ 53-1][ 16] = "Choir Aahs 2";
inst_xg[ 53-1][ 32] = "Melodic Choir";
inst_xg[ 53-1][ 39] = "Gasp";		// 100?
inst_xg[ 53-1][ 40] = "Choir Strings";
inst_xg[ 53-1][ 41] = "Dead Sea";	// 100?
inst_xg[ 53-1][ 64] = "Strings Aahs";	// *
inst_xg[ 53-1][ 65] = "Male Aahs";	// *
inst_xg[ 53-1][ 66] = "Scroll";		// 100?
inst_xg[ 53-1][ 67] = "Scroll +";	// 100?
inst_xg[ 54-1][  0] = "Voice Oohs";
inst_xg[ 54-1][ 64] = "Voice Doos";	// *
inst_xg[ 54-1][ 65] = "Hmn";		// 100?
inst_xg[ 54-1][ 66] = "Whirl Choir";	// 100? ???
inst_xg[ 54-1][ 96] = "Voice Hmns";	//
inst_xg[ 55-1][  0] = "Synth Voice";
//inst_xg[ 55-1][ 40] = "Synth Vox 2";
inst_xg[ 55-1][ 40] = "Synth Voice 2";	// 100?
inst_xg[ 55-1][ 41] = "Choral";
inst_xg[ 55-1][ 64] = "Analog Voice";
inst_xg[ 55-1][ 65] = "Aspirate";	// 100?
inst_xg[ 55-1][ 66] = "Aspirate D";	// 100?
inst_xg[ 55-1][ 67] = "Facula";		// 100?
inst_xg[ 56-1][  0] = "Orchestra Hit";
inst_xg[ 56-1][ 12] = "LoFi Hit";	// 100?
inst_xg[ 56-1][ 35] = "Orch. Hit 2";
inst_xg[ 56-1][ 40] = "Throne";		// 100?
//inst_xg[ 56-1][ 64] = "Impact Hit";
inst_xg[ 56-1][ 64] = "Impact";		// 100?
inst_xg[ 56-1][ 65] = "Brass Stab";	// *
inst_xg[ 56-1][ 66] = "Double Hit";	//
inst_xg[ 56-1][ 67] = "Brass Stab 80s";	//
inst_xg[ 56-1][ 68] = "Bass Hit";	// 100?
inst_xg[ 56-1][ 69] = "Bass Hit +";	// 100?
inst_xg[ 56-1][ 70] = "6th Hit";	// 100?
inst_xg[ 56-1][ 71] = "6th Hit +";	// 100?
inst_xg[ 56-1][ 72] = "Euro Hit";	// 100?
inst_xg[ 56-1][ 73] = "Euro Hit +";	// 100?
inst_xg[ 56-1][ 74] = "Blowout";	// 100?
inst_xg[ 57-1][  0] = "Trumpet";
//inst_xg[ 57-1][  0] = "Trumpet #";	// 100
inst_xg[ 57-1][ 16] = "Trumpet 2";
inst_xg[ 57-1][ 17] = "BriteTrumpet";
inst_xg[ 57-1][ 32] = "Warm Trumpet";
inst_xg[ 57-1][ 64] = "Dark Trumpet";	// 100?
inst_xg[ 57-1][ 65] = "Dark Tp Shift";	// 100? ???
inst_xg[ 57-1][ 66] = "Soft Trumpet";	// 100?
inst_xg[ 57-1][ 67] = "Blow";		// 100?
inst_xg[ 57-1][ 68] = "Blow Double";	// 100?
inst_xg[ 57-1][ 96] = "Flugel Horn";
inst_xg[ 57-1][ 97] = "Cornet";		// 100?
inst_xg[ 58-1][  0] = "Trombone";
//inst_xg[ 58-1][  0] = "Trombone #";	// 100
inst_xg[ 58-1][ 18] = "Trombone 2";
inst_xg[ 58-1][ 64] = "Brght Trombone";	// 100?
inst_xg[ 58-1][ 65] = "Mellow Trb";	// 100?
inst_xg[ 58-1][ 66] = "JJJ";		// 100?
inst_xg[ 59-1][  0] = "Tuba";
inst_xg[ 59-1][ 16] = "Tuba 2";
inst_xg[ 60-1][  0] = "Muted Trumpet";
//inst_xg[ 60-1][  0] = "Muted Trumpet #";	// 100
inst_xg[ 60-1][ 40] = "Backyard";	// 100?
inst_xg[ 60-1][ 64] = "Muted Trumpet2";	// *
inst_xg[ 60-1][ 65] = "Backstairs";	// 100?
inst_xg[ 61-1][  0] = "French Horn";
inst_xg[ 61-1][  6] = "Fr. Horn Solo";
inst_xg[ 61-1][ 32] = "Fr. Horn 2";
inst_xg[ 61-1][ 37] = "Horn Orch.";
inst_xg[ 61-1][ 64] = "Synth Horn";	// 100?
inst_xg[ 62-1][  0] = "Brass Section";
//inst_xg[ 62-1][  0] = "Brass Section #";	// 100
inst_xg[ 62-1][  3] = "St Brass Sect";	// 100?
inst_xg[ 62-1][ 14] = "Sforzando Brass";// *
inst_xg[ 62-1][ 18] = "Mild Brass";	// 100?
inst_xg[ 62-1][ 35] = "Tp&Tuba Sect";
inst_xg[ 62-1][ 36] = "Tp&Tuba Sect 2";	// 100?
inst_xg[ 62-1][ 39] = "Brass Fall";	// *
inst_xg[ 62-1][ 40] = "Brass Section 2";
inst_xg[ 62-1][ 41] = "High Brass";
inst_xg[ 62-1][ 42] = "Mellow Brass";
inst_xg[ 62-1][ 52] = "Bund";		// 100?
inst_xg[ 62-1][ 53] = "Fake Horn";	// 100?
inst_xg[ 62-1][ 54] = "Fake Horn Oct";	// 100?
inst_xg[ 62-1][ 64] = "Spruce Brass";	// 100?
inst_xg[ 62-1][ 65] = "Spr Brass Cut";	// 100?
inst_xg[ 62-1][ 66] = "Spr Brass Blow";	// 100?
inst_xg[ 62-1][ 67] = "Pwrd Sforzando";	// 100?
inst_xg[ 62-1][ 68] = "Pwrd Sfz Brass";	// 100?
inst_xg[ 62-1][ 69] = "Alto & Trumpet";	// 100?
inst_xg[ 62-1][ 70] = "Tenor & Trumpet";// 100?
inst_xg[ 62-1][ 71] = "Brass Bros.";	// 100?
inst_xg[ 62-1][ 72] = "Vague Bros.";	// 100?
inst_xg[ 63-1][  0] = "Synth Brass 1";
inst_xg[ 63-1][ 12] = "Quack Brass";
inst_xg[ 63-1][ 20] = "Reso Syn Brass";
inst_xg[ 63-1][ 24] = "Poly Brass";
inst_xg[ 63-1][ 27] = "Synth Brass3";
inst_xg[ 63-1][ 29] = "Analog Sfz.";	// 100?
inst_xg[ 63-1][ 32] = "Jump Brass";
inst_xg[ 63-1][ 40] = "Syn Brass Sub";	// 100?
//inst_xg[ 63-1][ 45] = "Ana Velo Brs";
inst_xg[ 63-1][ 45] = "Analg Vel Brs 1";// 100?
inst_xg[ 63-1][ 64] = "Analog Brass 1";
inst_xg[ 63-1][ 65] = "Synth Thn";	// 100? ???
inst_xg[ 63-1][ 66] = "Sync Brass";	// 100?
inst_xg[ 63-1][ 67] = "Sync Brass St";	// 100?
inst_xg[ 63-1][ 68] = "Analog Horn 1";	// 100?
inst_xg[ 63-1][ 69] = "Analog Horn 2";	// 100?
inst_xg[ 63-1][ 70] = "Analg Horn Oct";	// 100?
inst_xg[ 63-1][ 71] = "Saw Brs Pwrd";	// 100?
inst_xg[ 64-1][  0] = "Synth Brass 2";
inst_xg[ 64-1][ 18] = "Soft Brass";
inst_xg[ 64-1][ 40] = "Synth Brass 4";
inst_xg[ 64-1][ 41] = "Choir Brass";
inst_xg[ 64-1][ 42] = "Ana Horn Rch";	// 100? ???
//inst_xg[ 64-1][ 45] = "Velo Brass 2";
inst_xg[ 64-1][ 45] = "Analg Vel Brs 2";// 100?
inst_xg[ 64-1][ 64] = "Analog Brass 2";
inst_xg[ 64-1][ 65] = "Soft Cut";	// 100?
inst_xg[ 64-1][ 66] = "Analog Horn S";	// 100? ???
inst_xg[ 65-1][  0] = "Soprano Sax";
inst_xg[ 65-1][  8] = "Vg Sporano Sax";	// 100? ???
inst_xg[ 65-1][ 64] = "Meditation";	// 100?
inst_xg[ 65-1][ 65] = "Meditation Res";	// 100?
inst_xg[ 66-1][  0] = "Alto Sax";
//inst_xg[ 66-1][  0] = "Alto Sax #";	// 100
inst_xg[ 66-1][ 18] = "Alto Sax Light";	// 100?
inst_xg[ 66-1][ 40] = "Sax Section";
inst_xg[ 66-1][ 43] = "Hyper Alto";
inst_xg[ 66-1][ 64] = "Alto Sax Powrd";	// 100?
inst_xg[ 66-1][ 65] = "Fake Alto";	// 100?
inst_xg[ 66-1][ 66] = "Fake Alto +";	// 100?
inst_xg[ 66-1][ 67] = "Fake Alto D";	// 100?
inst_xg[ 67-1][  0] = "Tenor Sax";
inst_xg[ 67-1][ 40] = "Breathy Tn Sax";
inst_xg[ 67-1][ 41] = "Soft Tenor";
inst_xg[ 67-1][ 64] = "Tenor Sax 2";
inst_xg[ 67-1][ 65] = "Spruce Tenor";	// 100?
inst_xg[ 67-1][ 66] = "Spruce Tenor +";	// 100?
inst_xg[ 67-1][ 67] = "Spruce Tnr St";	// 100?
inst_xg[ 67-1][ 68] = "Tenor & Alto";	// 100?
inst_xg[ 68-1][  0] = "Baritone Sax";
inst_xg[ 69-1][  0] = "Oboe";
//inst_xg[ 69-1][  0] = "Oboe #";	// 100
inst_xg[ 69-1][ 64] = "Heinz";		// 100?
inst_xg[ 69-1][ 65] = "Heinz Unison";	// 100?
inst_xg[ 70-1][  0] = "English Horn";
inst_xg[ 71-1][  0] = "Bassoon";
inst_xg[ 72-1][  0] = "Clarinet";
inst_xg[ 72-1][ 40] = "Syn & Clr";	// 100? ???
inst_xg[ 72-1][ 96] = "Bass Clarinet";	//
inst_xg[ 73-1][  0] = "Piccolo";
inst_xg[ 74-1][  0] = "Flute";
//inst_xg[ 74-1][  0] = "Flute #";	// 100
inst_xg[ 74-1][ 40] = "Neat Breath";	// 100?
inst_xg[ 74-1][ 64] = "Boehm";		// 100?
inst_xg[ 74-1][ 65] = "Boehm Br";	// 100? ???
inst_xg[ 74-1][ 66] = "Pastoral";	// 100?
inst_xg[ 74-1][ 67] = "Shepherd";	// 100?
inst_xg[ 75-1][  0] = "Recorder";
inst_xg[ 75-1][ 64] = "Piplith";	// 100? ???
inst_xg[ 75-1][ 65] = "Home";		// 100?
inst_xg[ 76-1][  0] = "Pan Flute";
//inst_xg[ 76-1][  0] = "Pan Flute #";	// 100
inst_xg[ 76-1][ 64] = "Pan Flute 2";	// *
inst_xg[ 76-1][ 65] = "Meadow";		// 100?
inst_xg[ 76-1][ 96] = "Kawala";		//
inst_xg[ 77-1][  0] = "Bottle Blow";
inst_xg[ 77-1][ 64] = "Bottle Light";	// 100?
inst_xg[ 78-1][  0] = "Shakuhachi";
inst_xg[ 79-1][  0] = "Whistle";
inst_xg[ 79-1][ 64] = "Reverie";	// 100?
inst_xg[ 80-1][  0] = "Ocarina";
inst_xg[ 80-1][ 64] = "Opalina";	// 100? ???
inst_xg[ 81-1][  0] = "Square Lead";
inst_xg[ 81-1][  6] = "Square Lead2";
inst_xg[ 81-1][  8] = "LM Square";
inst_xg[ 81-1][ 18] = "Hollow";
//inst_xg[ 81-1][ 19] = "Shmoog";
inst_xg[ 81-1][ 19] = "Shroud";		// 100?
inst_xg[ 81-1][ 35] = "2 Osc";		// 100?
inst_xg[ 81-1][ 64] = "Mellow";
inst_xg[ 81-1][ 65] = "Solo Sine";
inst_xg[ 81-1][ 66] = "Sine Lead";
inst_xg[ 81-1][ 67] = "Pulse Lead";	// 100?
inst_xg[ 81-1][ 68] = "Sync Lead";	// 100?
inst_xg[ 81-1][ 69] = "Forced Osc";	// 100?
inst_xg[ 81-1][ 70] = "Accent";		// 100?
inst_xg[ 81-1][ 71] = "Brick";		// 100?
inst_xg[ 81-1][ 72] = "Alum";		// 100?
inst_xg[ 81-1][ 73] = "Query";		// 100?
inst_xg[ 81-1][ 74] = "FM Slow Sweep";	// 100?
inst_xg[ 81-1][ 75] = "Sync Lead Dbl";	// 100?
inst_xg[ 81-1][ 76] = "Curse";		// 100?
inst_xg[ 81-1][ 77] = "Octave Beep";	// 100?
inst_xg[ 82-1][  0] = "Saw Lead";
//inst_xg[ 82-1][  6] = "Saw 2";
inst_xg[ 82-1][  6] = "Saw Lead 2";	// 100?
inst_xg[ 82-1][  8] = "Thick Saw";
inst_xg[ 82-1][ 18] = "Dyna Saw";
inst_xg[ 82-1][ 19] = "Digi Saw";
inst_xg[ 82-1][ 20] = "Big Lead";
inst_xg[ 82-1][ 24] = "Heavy Synth";
inst_xg[ 82-1][ 25] = "Waspy Synth";
inst_xg[ 82-1][ 26] = "Mondo";		// 100?
inst_xg[ 82-1][ 27] = "Rezzy Saw";	// 100? ???
inst_xg[ 82-1][ 32] = "Double Saw";	// 100?
inst_xg[ 82-1][ 35] = "Toy Lead";	// 100?
inst_xg[ 82-1][ 36] = "Dim Saw";	// 100?
inst_xg[ 82-1][ 40] = "Pulse Saw";
inst_xg[ 82-1][ 41] = "Dr. Lead";
inst_xg[ 82-1][ 45] = "Velo Lead";
inst_xg[ 82-1][ 64] = "Digger";		// 100?
inst_xg[ 82-1][ 65] = "Dunce";		// 100?
inst_xg[ 82-1][ 66] = "Brass Saw";	// 100?
inst_xg[ 82-1][ 67] = "Saw River";	// 100?
inst_xg[ 82-1][ 68] = "Br Pulse Dbl";	// 100?
inst_xg[ 82-1][ 69] = "Saw Trumpet";	// 100?
inst_xg[ 82-1][ 70] = "Hue";		// 100?
inst_xg[ 82-1][ 71] = "Straight Saw";	// 100?
inst_xg[ 82-1][ 72] = "Straight Pulse";	// 100?
inst_xg[ 82-1][ 73] = "PWMainia";	// 100?
inst_xg[ 82-1][ 74] = "Mod Saw";	// 100?
inst_xg[ 82-1][ 75] = "Toad";		// 100?
inst_xg[ 82-1][ 76] = "Fat Octave";	// 100?
inst_xg[ 82-1][ 77] = "Overdose";	// 100?
inst_xg[ 82-1][ 78] = "PWM Decay";	// 100?
inst_xg[ 82-1][ 79] = "Saw Decay";	// 100?
inst_xg[ 82-1][ 96] = "Seq Analog";
inst_xg[ 83-1][  0] = "Calliope Lead";
inst_xg[ 83-1][ 40] = "Novice";		// 100?
inst_xg[ 83-1][ 64] = "Vent Synth";	// *
//inst_xg[ 83-1][ 65] = "Pure Pad";
inst_xg[ 83-1][ 65] = "Pure Lead";	// 100?
inst_xg[ 83-1][ 66] = "El. Primitive";	// 100?
inst_xg[ 84-1][  0] = "Chiffer Lead";
inst_xg[ 84-1][ 40] = "Salt Lead";	// 100?
inst_xg[ 84-1][ 64] = "Rubby";
inst_xg[ 84-1][ 65] = "Hard Sync";	// 100?
inst_xg[ 85-1][  0] = "Charang Lead";
inst_xg[ 85-1][ 64] = "Dist. Lead";
inst_xg[ 85-1][ 65] = "Wire Lead";
inst_xg[ 85-1][ 66] = "Synth Pluck";	// 100?
inst_xg[ 86-1][  0] = "Voice Lead";
inst_xg[ 86-1][ 24] = "Synth Aahs";
inst_xg[ 86-1][ 64] = "Vox Lead";
inst_xg[ 86-1][ 65] = "Br. Layer";	// 100? ???
inst_xg[ 86-1][ 66] = "Cypher 1";	// 100?
inst_xg[ 86-1][ 67] = "Cypher 2";	// 100?
inst_xg[ 86-1][ 68] = "Cypher 3";	// 100?
inst_xg[ 86-1][ 69] = "Spruce Cypher";	// 100?
inst_xg[ 87-1][  0] = "Fifth Lead";
inst_xg[ 87-1][  8] = "Fifth Lead S";	// 100?
inst_xg[ 87-1][ 35] = "Big Five";
inst_xg[ 88-1][  0] = "Bass & Lead";
inst_xg[ 88-1][ 16] = "Big & Low";
inst_xg[ 88-1][ 64] = "Fat & Perky";
inst_xg[ 88-1][ 65] = "Soft Wurl";
inst_xg[ 88-1][ 66] = "Cant";		// 100?
inst_xg[ 88-1][ 67] = "Mogul";		// 100?
inst_xg[ 88-1][ 68] = "Distance";	// 100?
inst_xg[ 88-1][ 69] = "Sync B&L";	// 100?
inst_xg[ 89-1][  0] = "New Age Pad";
//inst_xg[ 89-1][ 64] = "Fantasy 2";
inst_xg[ 89-1][ 64] = "Fantasy";	// 100?
inst_xg[ 89-1][ 65] = "Libra";		// 100?
inst_xg[ 90-1][  0] = "Warm Pad";
inst_xg[ 90-1][ 16] = "Thick Pad";
inst_xg[ 90-1][ 17] = "Soft Pad";
inst_xg[ 90-1][ 18] = "Sine Pad";
inst_xg[ 90-1][ 40] = "Vishnu";		// 100?
inst_xg[ 90-1][ 64] = "Horn Pad";
inst_xg[ 90-1][ 65] = "Rotary Str.";
inst_xg[ 91-1][  0] = "Poly Synth Pad";
inst_xg[ 91-1][ 64] = "Poly Pad 80s";
inst_xg[ 91-1][ 65] = "Click Pad";
inst_xg[ 91-1][ 66] = "Analog Pad";
inst_xg[ 91-1][ 67] = "Square Pad";
inst_xg[ 91-1][ 68] = "Snow Pad";	// 100?
inst_xg[ 91-1][ 69] = "Pixie";		// 100?
inst_xg[ 91-1][ 70] = "Pisces";		// 100?
inst_xg[ 91-1][ 71] = "Spiral";		// 100?
inst_xg[ 92-1][  0] = "Choir Pad";
//inst_xg[ 92-1][ 64] = "Heaven 2";
inst_xg[ 92-1][ 64] = "Heaven";		// 100?
inst_xg[ 92-1][ 65] = "Lite Pad";		//
inst_xg[ 92-1][ 66] = "Itopia";
inst_xg[ 92-1][ 67] = "CC Pad";
inst_xg[ 92-1][ 68] = "Cosmic Pad";	// 100?
inst_xg[ 93-1][  0] = "Bowed Pad";
inst_xg[ 93-1][ 64] = "Glacier";
inst_xg[ 93-1][ 65] = "Glass Pad";
inst_xg[ 93-1][ 66] = "Square Twang";	// 100?
inst_xg[ 94-1][  0] = "Metal Pad";
inst_xg[ 94-1][ 64] = "Tine Pad";
inst_xg[ 94-1][ 65] = "Pan Pad";
inst_xg[ 94-1][ 66] = "Queever";	// 100? ???
inst_xg[ 95-1][  0] = "Halo Pad";
inst_xg[ 95-1][ 40] = "Tiu";		// 100?
inst_xg[ 95-1][ 64] = "Aries";		// 100?
inst_xg[ 96-1][  0] = "Sweep Pad";
inst_xg[ 96-1][ 20] = "Shwimmer";
inst_xg[ 96-1][ 27] = "Converge";
inst_xg[ 96-1][ 64] = "Polar Pad";
inst_xg[ 96-1][ 65] = "Sweepy";		//
inst_xg[ 96-1][ 66] = "Celestial";
inst_xg[ 96-1][ 67] = "Monsoon";	// 100?
inst_xg[ 96-1][ 68] = "lo";		// 100?
inst_xg[ 97-1][  0] = "Rain";
inst_xg[ 97-1][ 45] = "Clavi. Pad";
inst_xg[ 97-1][ 64] = "Harmo Rain";
inst_xg[ 97-1][ 65] = "African Wind";
//inst_xg[ 97-1][ 66] = "Caribean";
inst_xg[ 97-1][ 66] = "Carib";		// 100?
//inst_xg[ 98-1][  0] = "Soundtrack";
inst_xg[ 98-1][  0] = "Sound Track";	// 100?
inst_xg[ 98-1][ 27] = "Prologue";
inst_xg[ 98-1][ 64] = "Ancestral";
inst_xg[ 98-1][ 65] = "Rave";
inst_xg[ 98-1][ 66] = "Fairy";		// 100?
inst_xg[ 98-1][ 67] = "Hermit";		// 100?
inst_xg[ 99-1][  0] = "Crystal";
inst_xg[ 99-1][ 12] = "Synth Dr Cmp";	// ???
inst_xg[ 99-1][ 14] = "Popcorn";
inst_xg[ 99-1][ 18] = "Tiny Bells";
inst_xg[ 99-1][ 35] = "Round Glock";
inst_xg[ 99-1][ 40] = "Glocken Chime";
inst_xg[ 99-1][ 41] = "Clear Bells";
inst_xg[ 99-1][ 42] = "Chorus Bells";
inst_xg[ 99-1][ 64] = "Synth Mallet";
inst_xg[ 99-1][ 65] = "Soft Crystal";
inst_xg[ 99-1][ 66] = "Loud Glock";
//inst_xg[ 99-1][ 67] = "Xmas Bells";
inst_xg[ 99-1][ 67] = "Christmas Bells";	// 100?
inst_xg[ 99-1][ 68] = "Vibe Bells";
inst_xg[ 99-1][ 69] = "Digi Bells";
inst_xg[ 99-1][ 70] = "Air Bells";
inst_xg[ 99-1][ 71] = "Bell Harp";
inst_xg[ 99-1][ 72] = "Gamelamba";
inst_xg[ 99-1][ 73] = "Bounce";		// 100?
inst_xg[100-1][  0] = "Atmosphere";
inst_xg[100-1][ 18] = "Warm Atoms";
inst_xg[100-1][ 19] = "Hollow Release";
inst_xg[100-1][ 40] = "Nylon EP";
inst_xg[100-1][ 64] = "Nylon Harp";
inst_xg[100-1][ 65] = "Harp Vox";
inst_xg[100-1][ 66] = "Atmos Pad";
inst_xg[100-1][ 67] = "Planet";
inst_xg[100-1][ 68] = "Lyra";		// 100?
inst_xg[100-1][ 69] = "Akasaka";	// 100?
inst_xg[100-1][ 70] = "Dg Bermda ";	// 100? ???
//inst_xg[101-1][  0] = "Brightness";
inst_xg[101-1][  0] = "Bright";		// 100
inst_xg[101-1][ 64] = "Fantasy Bells";
inst_xg[101-1][ 96] = "Smokey";
inst_xg[102-1][  0] = "Goblins";
inst_xg[102-1][ 64] = "Goblin Synth";
//inst_xg[102-1][ 65] = "50's Sci-Fi";
inst_xg[102-1][ 65] = "Creeper";	// 100?
inst_xg[102-1][ 66] = "Ring Pad";
inst_xg[102-1][ 67] = "Ritual";
inst_xg[102-1][ 68] = "To Heaven";
inst_xg[102-1][ 69] = "Milky Way";	//
inst_xg[102-1][ 70] = "Night";
inst_xg[102-1][ 71] = "Glisten";
inst_xg[102-1][ 72] = "Puffy";		//
inst_xg[102-1][ 73] = "Mimicry";	// 100?
inst_xg[102-1][ 74] = "Parasite";	// 100?
inst_xg[102-1][ 75] = "Cicada";		// 100?
inst_xg[102-1][ 76] = "Beacon";		// 100?
inst_xg[102-1][ 96] = "Bell Choir";
inst_xg[102-1][ 97] = "Dharma";		// 100?
inst_xg[103-1][  0] = "Echoes";
//inst_xg[103-1][  8] = "Echo Pad 2";
inst_xg[103-1][  8] = "Echoes 2";	// 100?
inst_xg[103-1][ 14] = "Echo Pan";
inst_xg[103-1][ 64] = "Echo Bell";
inst_xg[103-1][ 65] = "Big Pan";
inst_xg[103-1][ 66] = "Synth Piano";
inst_xg[103-1][ 67] = "Creation";
//inst_xg[103-1][ 68] = "Stardust";
inst_xg[103-1][ 68] = "Star Dust";	// 100?
//inst_xg[103-1][ 69] = "Reso Pan";
inst_xg[103-1][ 69] = "Reso & Pan";	// 100?
inst_xg[104-1][  0] = "Sci-Fi";
inst_xg[104-1][ 64] = "Starz";
//inst_xg[104-1][ 65] = "Odyssey";
inst_xg[104-1][ 65] = "Odin";		// 100?
inst_xg[105-1][  0] = "Sitar";
inst_xg[105-1][ 32] = "Detuned Sitar";
inst_xg[105-1][ 35] = "Sitar 2";
inst_xg[105-1][ 40] = "Bhuj";		// 100?
inst_xg[105-1][ 64] = "Raga Synth";	// 100?
inst_xg[105-1][ 96] = "Tambra";
inst_xg[105-1][ 97] = "Tamboura";
inst_xg[106-1][  0] = "Banjo";
inst_xg[106-1][ 28] = "Muted Banjo";
inst_xg[106-1][ 64] = "El. Banjo";	// 100?
inst_xg[106-1][ 96] = "Rabab";
inst_xg[106-1][ 97] = "Gopichant";
inst_xg[106-1][ 98] = "Oud";
inst_xg[107-1][  0] = "Shamisen";
inst_xg[107-1][ 96] = "Tsugaru";	//
inst_xg[108-1][  0] = "Koto";
inst_xg[108-1][ 64] = "FM Koto";	// 100?
//inst_xg[108-1][ 96] = "T. Koto";
inst_xg[108-1][ 96] = "Taisho Koto";	// 100?
inst_xg[108-1][ 97] = "Kanoon";
inst_xg[109-1][  0] = "Kalimba";
inst_xg[109-1][ 64] = "Big Kalimba";	// *
//inst_xg[110-1][  0] = "Bag Pipe";
inst_xg[110-1][  0] = "Bagpipe";	// 100?
inst_xg[110-1][ 64] = "Thistle";	// 100?
inst_xg[111-1][  0] = "Fiddle";
inst_xg[112-1][  0] = "Shanai";
inst_xg[112-1][ 64] = "Shanai 2";
inst_xg[112-1][ 96] = "Pungi";
inst_xg[112-1][ 97] = "Hichiriki";
inst_xg[113-1][  0] = "Tinkle Bell";
inst_xg[113-1][ 64] = "Tickle Bell";	// 100? ???
inst_xg[113-1][ 96] = "Bonang";
//inst_xg[113-1][ 97] = "Gender";
inst_xg[113-1][ 97] = "Altair";		// 100?
inst_xg[113-1][ 98] = "Gamelan";
inst_xg[113-1][ 99] = "S. Gamelan";
inst_xg[113-1][100] = "Rama Cymbal";
inst_xg[113-1][101] = "Asian Bells";
inst_xg[114-1][  0] = "Agogo";
inst_xg[114-1][ 96] = "Atarigane";	//
inst_xg[115-1][  0] = "Steel Drums";
inst_xg[115-1][ 96] = "Tablas";		//
inst_xg[115-1][ 97] = "Glass Perc.";
inst_xg[115-1][ 98] = "Thai Bells";
inst_xg[116-1][  0] = "Woodblock";
inst_xg[116-1][ 96] = "Castanet";
inst_xg[117-1][  0] = "Taiko Drum";
inst_xg[117-1][ 96] = "Gr. Cassa";
inst_xg[118-1][  0] = "Melodic Tom";
inst_xg[118-1][ 64] = "Melodic Tom 2";
inst_xg[118-1][ 65] = "Real Tom";
inst_xg[118-1][ 66] = "Rock Tom";
inst_xg[119-1][  0] = "Synth Drum";
inst_xg[119-1][ 64] = "Analog Tom";
inst_xg[119-1][ 65] = "Electric Perc";
inst_xg[120-1][  0] = "Reverse Cymbal";
inst_xg[120-1][ 64] = "Reverse Cym. 2";	// *
inst_xg[120-1][ 96] = "Reverse Snare 1";//
inst_xg[120-1][ 97] = "Reverse Snare 2";//
inst_xg[120-1][ 98] = "Reverse Kick 1";	//
inst_xg[120-1][ 99] = "Rev. Concert BD";//
inst_xg[120-1][100] = "Reverse Tom 1";	//
inst_xg[120-1][101] = "Reverse Tom 2";	//
//inst_xg[121-1][  0] = "Gt.FretNoise";
inst_xg[121-1][  0] = "Fret Noise";	// 100?
inst_xg[122-1][  0] = "Breath Noise";
inst_xg[123-1][  0] = "Seashore";
//inst_xg[124-1][  0] = "Bird Tweet";
inst_xg[124-1][  0] = "Tweet";		// 100?
inst_xg[125-1][  0] = "Telephone";
inst_xg[126-1][  0] = "Helicopter";
inst_xg[127-1][  0] = "Applause";
inst_xg[128-1][  0] = "Gunshot";

// SFX
sfx_xg[  1-1] = "Cutting Noise";
sfx_xg[  2-1] = "Cutting Noise 2";
sfx_xg[  3-1] = "Dist. Cut Noise";	//
sfx_xg[  4-1] = "Str. Slap";
sfx_xg[  5-1] = "Bass Slide";	//
sfx_xg[  6-1] = "Pick Scrape";	//
sfx_xg[ 17-1] = "Fl. Key Click";
//sfx_xg[ 33-1] = "Rain";
sfx_xg[ 33-1] = "Shower";	// 100?
sfx_xg[ 34-1] = "Thunder";
sfx_xg[ 35-1] = "Wind";
sfx_xg[ 36-1] = "Stream";
sfx_xg[ 37-1] = "Bubble";
sfx_xg[ 38-1] = "Feed";		//
sfx_xg[ 39-1] = "Cave";		// 100?
sfx_xg[ 49-1] = "Dog";
sfx_xg[ 50-1] = "Horse";
//sfx_xg[ 51-1] = "Bird 2";
sfx_xg[ 51-1] = "Tweet 2";	// 100?
sfx_xg[ 52-1] = "Kitty";	//
sfx_xg[ 53-1] = "Growl";	//
sfx_xg[ 54-1] = "Haunted";	//
sfx_xg[ 55-1] = "Ghost";
sfx_xg[ 56-1] = "Maou";		//
sfx_xg[ 57-1] = "Insects";	// 100?
sfx_xg[ 58-1] = "Bacteria";	// 100?
//sfx_xg[ 65-1] = "Tel. Dial";
sfx_xg[ 65-1] = "Phone Call";	// 100?
sfx_xg[ 66-1] = "Door Squeak";
sfx_xg[ 67-1] = "Door Slam";
//sfx_xg[ 68-1] = "Scratch";
sfx_xg[ 68-1] = "Scratch C";	// 100?
//sfx_xg[ 69-1] = "Scratch 2";	//
sfx_xg[ 69-1] = "Scratch S";	// 100?
sfx_xg[ 70-1] = "Wind Chime";
sfx_xg[ 71-1] = "Telephone 2";
//sfx_xg[ 81-1] = "Car Engine";
sfx_xg[ 81-1] = "Car Elgnt";	// 100? ???
//sfx_xg[ 82-1] = "Car Stop";
sfx_xg[ 82-1] = "Car TSqel";	// 100? ???
sfx_xg[ 83-1] = "Car Pass";
sfx_xg[ 84-1] = "Car Crash";
sfx_xg[ 85-1] = "Siren";
sfx_xg[ 86-1] = "Train";
//sfx_xg[ 87-1] = "Jetplane";
sfx_xg[ 87-1] = "Jet Plane";	// 100?
sfx_xg[ 88-1] = "Starship";	//
sfx_xg[ 89-1] = "Burst";
sfx_xg[ 90-1] = "Coaster";
sfx_xg[ 91-1] = "Submarine";	//
sfx_xg[ 92-1] = "Connecivity";	// 100?
sfx_xg[ 93-1] = "Mystery";	// 100?
//sfx_xg[ 97-1] = "Laughing";
sfx_xg[ 97-1] = "Laugh";	// 100?
sfx_xg[ 98-1] = "Scream";
sfx_xg[ 99-1] = "Punch";
sfx_xg[100-1] = "Heart";
//sfx_xg[101-1] = "Foot Step";
sfx_xg[101-1] = "Footstep";	// 100?
sfx_xg[102-1] = "Applause 2";		//
sfx_xg[113-1] = "Machine Gun";
sfx_xg[114-1] = "Laser Gun";
sfx_xg[115-1] = "Explosion";
//sfx_xg[116-1] = "Fire Work";
sfx_xg[116-1] = "Firework";	// 100?
sfx_xg[117-1] = "Fireball";	// 100?

// Rhythm Kit SFX
//drum_sfx_xg[ 1-1] = "SFX 1";
drum_sfx_xg[ 1-1] = "SFX Kit 1";	// 100?
//drum_sfx_xg[ 2-1] = "SFX 2";
drum_sfx_xg[ 2-1] = "SFX Kit 2";	// 100?
drum_sfx_xg[17-1] = "Tekno Kit KSP";	// 100?
drum_sfx_xg[18-1] = "Tekno Kit Hi";	// 100?
drum_sfx_xg[19-1] = "Tekno Kit Lo";	// 100?
drum_sfx_xg[33-1] = "Sakura Kit";	// 100?
drum_sfx_xg[34-1] = "SLatin Kit";	// 100?

// Rhythm Kit
drum_xg[ 1-1] = "Standard Kit";
drum_xg[ 2-1] = "Standard 2 Kit";
drum_xg[ 3-1] = "Dry Kit";	// 100?
drum_xg[ 4-1] = "Brite Kit";	// 100?
drum_xg[ 5-1] = "Skim Kit";	// 100?
drum_xg[ 6-1] = "Slim Kit";	// 100?
drum_xg[ 7-1] = "Rogue Kit";	// 100?
drum_xg[ 8-1] = "Hob Kit";	// 100?
drum_xg[ 9-1] = "Room Kit";
drum_xg[10-1] = "Dark R Kit";	// 100?
drum_xg[17-1] = "Rock Kit";
drum_xg[18-1] = "Rock Kit 2";	// 100?
drum_xg[25-1] = "Electro Kit";
drum_xg[26-1] = "Analog Kit";
drum_xg[27-1] = "Analog Kit 2";	// 100?
drum_xg[28-1] = "Dance Kit";	// 90
drum_xg[29-1] = "Hip Hop Kit";	// 100?
drum_xg[30-1] = "Jungle Kit";	// 100?
drum_xg[31-1] = "Apogee Kit";	// 100?
drum_xg[32-1] = "Perigee Kit";	// 100?
drum_xg[33-1] = "Jazz Kit";
drum_xg[34-1] = "Jazz Kit 2";	// 100?
drum_xg[41-1] = "Brush Kit";
drum_xg[42-1] = "Brush Kit 2";	// 100?
//drum_xg[49-1] = "Classic Kit";
drum_xg[49-1] = "Symphonic Kit";	// 100?
drum_xg[65-1] = "Tramp Kit";	// 100?
drum_xg[66-1] = "Amber Kit";	// 100?
drum_xg[67-1] = "Coffin Kit";	// 100?
drum_xg[127-1] = "Standard Kit #";	// 100?

// MU100 Exclusive Voice
inst_mu100[  1-1][  0] = "Muted Clavi";
inst_mu100[  1-1][  8] = "Beeline";
inst_mu100[  1-1][ 16] = "Rage";
inst_mu100[  1-1][ 24] = "Fuss";
inst_mu100[  1-1][ 48] = "Reflex 1";
inst_mu100[  1-1][ 56] = "Insanity";
inst_mu100[  1-1][ 64] = "Distortion Fire";
inst_mu100[  1-1][ 72] = "Lightning";
inst_mu100[  1-1][ 80] = "Zipzap";
inst_mu100[  1-1][ 88] = "Escape";
inst_mu100[  1-1][ 96] = "TinKettle";
inst_mu100[  1-1][104] = "Satya";
inst_mu100[  1-1][120] = "Vodou";
inst_mu100[  2-1][  0] = "Orimba";
inst_mu100[  2-1][  8] = "Beeline Hard";
inst_mu100[  2-1][ 16] = "Tingle Chaos";	// Tangle?
inst_mu100[  2-1][ 24] = "Van Allen";
inst_mu100[  2-1][ 48] = "Reflex 2";
inst_mu100[  2-1][ 56] = "Habakkuk";
inst_mu100[  2-1][ 64] = "Blow Noiz";
inst_mu100[  2-1][ 72] = "Oof";
inst_mu100[  2-1][ 88] = "Zigzag";
inst_mu100[  2-1][ 96] = "K/S Analog";
inst_mu100[  2-1][104] = "Monastery";
inst_mu100[  3-1][  8] = "Dwarf";
inst_mu100[  3-1][ 16] = "Incontinence";	// ?
inst_mu100[  3-1][ 24] = "Divinity";
inst_mu100[  3-1][ 48] = "Prcesion";	// ?
inst_mu100[  3-1][ 64] = "Fall";
inst_mu100[  3-1][ 72] = "Lust";
inst_mu100[  3-1][ 88] = "Scud";
inst_mu100[  3-1][ 96] = "K/S Humd";
inst_mu100[  3-1][104] = "Vinaya";	// ?
inst_mu100[  4-1][  8] = "Byte";
inst_mu100[  4-1][ 16] = "Incnt Clk";	// ?
inst_mu100[  4-1][ 24] = "Paranoia";
inst_mu100[  4-1][ 48] = "Random Walk";
inst_mu100[  4-1][ 64] = "Chaff";
inst_mu100[  4-1][ 72] = "Lust St";
inst_mu100[  4-1][ 88] = "Hinayana";
inst_mu100[  4-1][ 96] = "K/S Slap";
inst_mu100[  4-1][104] = "Prana";	// ?
inst_mu100[  5-1][  8] = "Ping";
inst_mu100[  5-1][ 16] = "Cheap Osc";
inst_mu100[  5-1][ 24] = "Vexation";
inst_mu100[  5-1][ 48] = "Random Run";
inst_mu100[  5-1][ 72] = "Soft Hit +";
inst_mu100[  5-1][ 88] = "Boot";
inst_mu100[  5-1][ 96] = "Rvr / Crash";	// ?
inst_mu100[  5-1][104] = "Delight";
inst_mu100[  6-1][  8] = "Nasty Cut";
inst_mu100[  6-1][ 16] = "Cheap Osc +";
inst_mu100[  6-1][ 24] = "Calc Organ 1";	// ?
inst_mu100[  6-1][ 72] = "Cough +";
inst_mu100[  6-1][ 88] = "Anathema";
inst_mu100[  6-1][104] = "Puja";
inst_mu100[  7-1][  8] = "Nasty Cut St";
inst_mu100[  7-1][ 16] = "Nasty Or Spl";
inst_mu100[  7-1][ 24] = "Calc Organ2";
inst_mu100[  7-1][ 72] = "Ruin";
inst_mu100[  7-1][ 88] = "Germ 1";
inst_mu100[  7-1][104] = "Bent Tom";
inst_mu100[  8-1][  8] = "Xe";
inst_mu100[  8-1][ 16] = "Spruce Click";	// ?
inst_mu100[  8-1][ 24] = "Calc Organ 3";
inst_mu100[  8-1][ 72] = "Ruin St";
inst_mu100[  8-1][ 88] = "Germ 2";
inst_mu100[  9-1][  8] = "Organ Hit";
inst_mu100[  9-1][ 16] = "Boomout";
inst_mu100[  9-1][ 24] = "Cho Calc O";
inst_mu100[  9-1][ 72] = "Vein +";
inst_mu100[  9-1][ 88] = "Malfunction";
inst_mu100[ 10-1][  8] = "Organ Hit +";
inst_mu100[ 10-1][ 16] = "Choir Split";
inst_mu100[ 10-1][ 24] = "Sodium";
inst_mu100[ 10-1][ 72] = "Universe";
inst_mu100[ 11-1][  8] = "Soft Hit";
inst_mu100[ 11-1][ 16] = "Veld";
inst_mu100[ 11-1][ 72] = "Universe Sweep";
inst_mu100[ 12-1][  8] = "Vein";
inst_mu100[ 12-1][ 16] = "Vapor Vox";
inst_mu100[ 12-1][ 72] = "Xe +";
inst_mu100[ 13-1][  8] = "Packet";
inst_mu100[ 13-1][ 16] = "Vox Shoot";
inst_mu100[ 13-1][ 72] = "Daze";
inst_mu100[ 14-1][  8] = "Jolly";
inst_mu100[ 14-1][ 16] = "Semiac Or";	// ?
inst_mu100[ 14-1][ 72] = "Refusal";
inst_mu100[ 15-1][  8] = "Jolly +";
inst_mu100[ 15-1][ 72] = "Refusal +";
inst_mu100[ 16-1][  8] = "Envy";
inst_mu100[ 16-1][ 72] = "Lie";
inst_mu100[ 17-1][  8] = "Envy Short";	// ?
inst_mu100[ 17-1][ 72] = "Malice";
inst_mu100[ 18-1][  8] = "Cough";
inst_mu100[ 18-1][ 72] = "Doubt";
inst_mu100[ 19-1][  8] = "Remark";
inst_mu100[ 19-1][ 72] = "Doubt Double";
inst_mu100[ 20-1][  8] = "Potala";
inst_mu100[ 21-1][  8] = "Fury";
inst_mu100[ 22-1][  8] = "Glocken +";

/*
 * KORG
 */
#if 0
// Bank-A
inst_korg[  0][56] = "Sunrise";
inst_korg[  1][56] = "Piano 16'";
inst_korg[  2][56] = "AltoBreath";
inst_korg[  3][56] = "TinyDancer";
inst_korg[  4][56] = "Spruce Gtr";
inst_korg[  5][56] = "Vibra Bell";
inst_korg[  6][56] = "XFade Bass";
inst_korg[  7][56] = "TheStrings";
inst_korg[  8][56] = "PowerSynth";
inst_korg[  9][56] = "Total Kit";	// *
inst_korg[ 10][56] = "MachineAge";
inst_korg[ 11][56] = "Hot Keys";
inst_korg[ 12][56] = "Brass Band";
inst_korg[ 13][56] = "Maxi Tine";
inst_korg[ 14][56] = "Power Rock";
inst_korg[ 15][56] = "Tabla Talk";
inst_korg[ 16][56] = "FingerBass";
inst_korg[ 17][56] = "LiteVoices";
inst_korg[ 18][56] = "Color Pad";
inst_korg[ 19][56] = "Festival!";
inst_korg[ 20][56] = "GlideSweep";
inst_korg[ 21][56] = "Last Tango";
inst_korg[ 22][56] = "MagicFlute";
inst_korg[ 23][56] = "Operators";
inst_korg[ 24][56] = "E.Guitars";
inst_korg[ 25][56] = "Gamelan";
inst_korg[ 26][56] = "Zap Bass";
inst_korg[ 27][56] = "DigitalAir";
inst_korg[ 28][56] = "Analogist";
inst_korg[ 29][56] = "MandoTrem";
inst_korg[ 30][56] = "Space Wing";
inst_korg[ 31][56] = "Gospel Org";
inst_korg[ 32][56] = "Trumpets";
inst_korg[ 33][56] = "Fresh Air";
inst_korg[ 34][56] = "Rock Mutes";
inst_korg[ 35][56] = "Dustette";
inst_korg[ 36][56] = "PickedBass";
inst_korg[ 37][56] = "ChamberEns";
inst_korg[ 38][56] = "Wire Pad";
inst_korg[ 39][56] = "Industrial";
inst_korg[ 40][56] = "Neutron";
inst_korg[ 41][56] = "PianoHaven";
inst_korg[ 42][56] = "Shaku Bend";
inst_korg[ 43][56] = "BowenWave";
inst_korg[ 44][56] = "Clean Funk";
inst_korg[ 45][56] = "SplitBell";
inst_korg[ 46][56] = "Slap It";
inst_korg[ 47][56] = "AnalogPad";
inst_korg[ 48][56] = "Residue";
inst_korg[ 49][56] = "Orch Perc";
inst_korg[ 50][56] = "DreamWorld";
inst_korg[ 51][56] = "HarpsiFunk";
inst_korg[ 52][56] = "FlugelHorn";
inst_korg[ 53][56] = "Elec. Tap";
inst_korg[ 54][56] = "Harmonics";
inst_korg[ 55][56] = "Africana";
inst_korg[ 56][56] = "TechnoBass";
inst_korg[ 57][56] = "AirWays";
inst_korg[ 58][56] = "Busy Boy";
inst_korg[ 59][56] = "HeartBeat";
inst_korg[ 60][56] = "Spectrum";
inst_korg[ 61][56] = "Full Pipes";
inst_korg[ 62][56] = "Woodwinds";
inst_korg[ 63][56] = "Whirly";
inst_korg[ 64][56] = "LeadGuitar";
inst_korg[ 65][56] = "Isabelle";
inst_korg[ 66][56] = "Fat Fretty";
inst_korg[ 67][56] = "Poppin'Pad";
inst_korg[ 68][56] = "Soft Horns";
inst_korg[ 69][56] = "ProducrKit";	// *
inst_korg[ 70][56] = "InTheTrees";
inst_korg[ 71][56] = "SantaClav";
inst_korg[ 72][56] = "Sfz< Brass";
inst_korg[ 73][56] = "Tiny Pad";
inst_korg[ 74][56] = "PedalSteel";
inst_korg[ 75][56] = "Log Drums";
inst_korg[ 76][56] = "HouseBass1";
inst_korg[ 77][56] = "Ambi.Voice";
inst_korg[ 78][56] = "MonoLead";
inst_korg[ 79][56] = "Hackbrett";
inst_korg[ 80][56] = "Halifax NS";
inst_korg[ 81][56] = "Drawbars";
inst_korg[ 82][56] = "Fanfare";
inst_korg[ 83][56] = "Hard Tines";
inst_korg[ 84][56] = "Dr.Guitar";
inst_korg[ 85][56] = "EtherBells";
inst_korg[ 86][56] = "Bass/Harm";
inst_korg[ 87][56] = "Air Vox";
inst_korg[ 88][56] = "Drum Hit";
inst_korg[ 89][56] = "50's SciFi";
inst_korg[ 90][56] = "SteamCloud";
inst_korg[ 91][56] = "Bouzouki";
inst_korg[ 92][56] = "BriteBrass";
inst_korg[ 93][56] = "DWGS EP";
inst_korg[ 94][56] = "JoyStickUp";
inst_korg[ 95][56] = "WaveCycles";
inst_korg[ 96][56] = "Rap Bass";
inst_korg[ 97][56] = "OoooohPad";
inst_korg[ 98][56] = "Bright Pad";
inst_korg[ 99][56] = "HarpPluck";
inst_korg[100][56] = "Sunrise";
inst_korg[101][56] = "Piano 16'";
inst_korg[102][56] = "AltoBreath";
inst_korg[103][56] = "TinyDancer";
inst_korg[104][56] = "Spruce Gtr";
inst_korg[105][56] = "Vibra Bell";
inst_korg[106][56] = "XFade Bass";
inst_korg[107][56] = "TheStrings";
inst_korg[108][56] = "PowerSynth";
inst_korg[109][56] = "Total Kit";	// *
inst_korg[110][56] = "MachineAge";
inst_korg[111][56] = "Hot Keys";
inst_korg[112][56] = "Brass Band";
inst_korg[113][56] = "Maxi Tine";
inst_korg[114][56] = "Power Rock";
inst_korg[115][56] = "Tabla Talk";
inst_korg[116][56] = "FingerBass";
inst_korg[117][56] = "LiteVoices";
inst_korg[118][56] = "Color Pad";
inst_korg[119][56] = "Festival!";
inst_korg[120][56] = "GlideSweep";
inst_korg[121][56] = "Last Tango";
inst_korg[122][56] = "MagicFlute";
inst_korg[123][56] = "Operators";
inst_korg[124][56] = "E.Guitars";
inst_korg[125][56] = "Gamelan";
inst_korg[126][56] = "Zap Bass";
inst_korg[127][56] = "DigitalAir";

// Bank-G Drum Set
inst_korg[  0][62] = "GM Kit";
inst_korg[ 16][62] = "Power Kit";
inst_korg[ 24][62] = "Dance Kit";
inst_korg[ 25][62] = "Analog Kit";
inst_korg[ 26][62] = "Dance Kit";
inst_korg[ 32][62] = "Jazz Kit";
inst_korg[ 40][62] = "Brush Kit";
inst_korg[ 48][62] = "Orch Kit";
inst_korg[ 64][62] = "Perc Kit";
inst_korg[ 72][62] = "GM Kit";
#endif
}
