/*
 * playlist.h -- play list
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: playlist.h,v 1.2 1998-03-25 08:51:08+09 satoshi Exp $

#ifndef __PLAYLIST_H__
#define __PLAYLIST_H__

#include <list.h>
#include "mlist.h"
#include "fileinfo.h"
#include "server.h"

class Selector;

/*
 * PlayList
 */
class PlayList {
private:
  Server* server;
  Selector* sel;
  Widget parent;
  MList* listW;

  list<FileInfo> fileinfo;
  unsigned long seqid;

public:
  PlayList(Server* server_, Selector* sel_, Widget parent_, const char* name);
  ~PlayList();

  void initialize(void);
  void update(void);
  void sort();
  void setInsertPos();
  void insert(const FileInfo& finfo);

private:
  friend void PlayListAC(Widget, XEvent*, String*, Cardinal*);
  friend void timer(PlayList* self, XtIntervalId* /*id*/);
};

#endif // __PLAYLIST_H__
